/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Function;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.word.WordConvert;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import kd.epm.far.business.fidm.word.poi.VarPoi;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class TablePoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) {
        String displayTextStr;
        WordTextNode textNode;
        String message;
        String moduleId = moduleProperties.getString("id");
        String resultCode = TablePoi.getDataCode(moduleProperties);
        if (!"0000".equals(resultCode) && StringUtils.isNotEmpty((String)(message = TablePoi.getDataMessage(moduleProperties)))) {
            VarPoi.bind(where, LongUtil.toLong((Object)moduleId), message, null);
            return;
        }
        Map dataObject = TablePoi.getData(moduleProperties);
        if (dataObject != null && dataObject.get("displayTextNode") != null && (textNode = DisclosureJsonHelper.convert(displayTextStr = dataObject.get("displayTextNode").toString(), WordTextNode.class)) != null) {
            VarPoi.bind(where, LongUtil.toLong((Object)moduleId), textNode);
            return;
        }
        int alignment = DisclosureJsonHelper.getValue(moduleProperties, "alignment", 2);
        String bookMarkKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", moduleId);
        XWPFDocument document = where.getDocument();
        XWPFParagraph paragraph = where.getParagraph();
        paragraph.setAlignment(ParagraphAlignment.valueOf((int)alignment));
        where.setText("", 0);
        XmlCursor cursor = paragraph.getCTP().newCursor();
        XWPFTable xwpfTable = document.insertNewTbl(cursor);
        xwpfTable.setTableAlignment(PoiHelper.tableAlignment(alignment));
        Function<String, Boolean> callBack = msg -> {
            PoiHelper.removeBookMark(paragraph.getCTP(), new String[]{moduleId, bookMarkKey});
            return true;
        };
        TablePoi.createChart(xwpfTable, moduleProperties, callBack);
    }

    public static void reset(XWPFTable table, JSONObject moduleProperties) {
        String displayTextStr;
        WordTextNode textNode;
        Map dataObject;
        String message;
        boolean needRemove = false;
        String resultCode = TablePoi.getDataCode(moduleProperties);
        if (!"0000".equals(resultCode) && StringUtils.isNotEmpty((String)(message = TablePoi.getDataMessage(moduleProperties)))) {
            needRemove = true;
        }
        if ((dataObject = TablePoi.getData(moduleProperties)) != null && dataObject.get("displayTextNode") != null && (textNode = DisclosureJsonHelper.convert(displayTextStr = dataObject.get("displayTextNode").toString(), WordTextNode.class)) != null) {
            needRemove = true;
        }
        if (needRemove) {
            XmlCursor xmlCursor = table.getCTTbl().newCursor();
            XWPFParagraph paragraph = table.getBody().getXWPFDocument().insertNewParagraph(xmlCursor);
            PoiHelper.deleteTable(table);
            String bookmarkKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", "");
            BigInteger bookmarkId = null;
            if (StringUtils.isNotEmpty((String)bookmarkKey)) {
                bookmarkId = BigInteger.valueOf(GlobalIdUtil.genGlobalLongId());
                CTBookmark newBookMark = paragraph.getCTP().addNewBookmarkStart();
                newBookMark.setName(bookmarkKey);
                newBookMark.setId(bookmarkId);
            }
            XWPFRun where = paragraph.insertNewRun(0);
            TablePoi.bind(where, moduleProperties);
            if (bookmarkId != null) {
                paragraph.getCTP().addNewBookmarkEnd().setId(bookmarkId);
            }
        } else {
            TablePoi.createChart(table, moduleProperties, null);
        }
    }

    public static void createChart(XWPFTable table, JSONObject moduleProperties, Function callBack) {
        String moduleId = moduleProperties.getString("id");
        String bookMarkKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", moduleId);
        String resultCode = TablePoi.getDataCode(moduleProperties);
        if (!"0000".equals(resultCode)) {
            PoiHelper.deleteTable(table);
            String message = TablePoi.getDataMessage(moduleProperties);
            XWPFTableCell targetCell = table.insertNewTableRow(0).addNewTableCell();
            CTTblWidth cellW = targetCell.getCTTc().addNewTcPr().addNewTcW();
            cellW.setType(STTblWidth.AUTO);
            targetCell.getCTTc().getTcPr().addNewVAlign().setVal(STVerticalJc.CENTER);
            ((CTP)targetCell.getCTTc().getPList().get(0)).addNewPPr().addNewJc().setVal(STJc.CENTER);
            targetCell.setText(message);
            String newBookmarkKey = WordBookmarkHelper.createBookmarName(bookMarkKey, 0, 0);
            PoiHelper.insertBookMark((XWPFParagraph)targetCell.getParagraphs().get(0), moduleId, newBookmarkKey);
            return;
        }
        Map dataObject = TablePoi.getData(moduleProperties);
        if (dataObject != null && dataObject.get("tableNode") != null) {
            PoiHelper.deleteTable(table);
            WordTableNode tableNode = (WordTableNode)WordNodeJsonHelper.parseObject(dataObject.get("tableNode").toString());
            if (tableNode != null) {
                tableNode.setId(bookMarkKey);
                tableNode.setDataModeuleId(moduleId);
            }
            new WordConvert().toTableWord(tableNode, table);
        }
    }
}

