/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.module.calculate.VarHelper;
import kd.epm.far.business.fidm.module.calculate.dto.VarResult;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordRepairHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;

public class VarPoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) {
        VarResult varResult = VarPoi.getVar(moduleProperties);
        VarPoi.bind(where, moduleProperties.getLong("id"), varResult.getResult(), varResult.getColor());
    }

    public static VarResult getVar(JSONObject moduleProperties) {
        Map dataObject = VarPoi.getData(moduleProperties);
        return VarHelper.getVar(moduleProperties, dataObject);
    }

    public static void bind(XWPFRun where, Long moduleId, String text, String fontColor) {
        try {
            where.setText("", 0);
            if (StringUtils.isNotEmpty((String)fontColor)) {
                where.setColor(fontColor.replace("#", ""));
            }
            XWPFParagraph paragraph = (XWPFParagraph)where.getParent();
            int index = paragraph.getRuns().indexOf(where);
            XWPFRun run = paragraph.insertNewRun(index);
            CTFldChar fldChar = run.getCTR().addNewFldChar();
            fldChar.setFldCharType(STFldCharType.Enum.forString((String)"begin"));
            String formularStr = VarPoi.getFormularString(moduleId.toString(), text);
            run = paragraph.insertNewRun(++index);
            CTText ctText = run.getCTR().addNewInstrText();
            ctText.setStringValue(formularStr);
            ctText.setSpace(SpaceAttribute.Space.Enum.forString((String)"preserve"));
            VarPoi.setXWPFRunStyle(where, run);
            run = paragraph.insertNewRun(++index);
            fldChar = run.getCTR().addNewFldChar();
            fldChar.setFldCharType(STFldCharType.Enum.forString((String)"separate"));
            run = paragraph.insertNewRun(++index);
            run.setText(text);
            VarPoi.setXWPFRunStyle(where, run);
            run = paragraph.insertNewRun(++index);
            ++index;
            fldChar = run.getCTR().addNewFldChar();
            fldChar.setFldCharType(STFldCharType.Enum.forString((String)"end"));
            WordRepairHelper.repairRun(where);
        }
        catch (Exception ex) {
            logger.error("ModuleGeneral varpoi error info:", (Throwable)ex);
        }
    }

    public static void bind(XWPFRun where, Long moduleId, WordTextNode textNode) {
        try {
            where.setText("", 0);
            XWPFParagraph paragraph = (XWPFParagraph)where.getParent();
            int index = paragraph.getRuns().indexOf(where);
            XWPFRun run = paragraph.insertNewRun(index);
            CTFldChar fldChar = run.getCTR().addNewFldChar();
            fldChar.setFldCharType(STFldCharType.Enum.forString((String)"begin"));
            String formularStr = VarPoi.getFormularString(moduleId.toString(), textNode.getContent());
            run = paragraph.insertNewRun(++index);
            CTText ctText = run.getCTR().addNewInstrText();
            ctText.setStringValue(formularStr);
            ctText.setSpace(SpaceAttribute.Space.Enum.forString((String)"preserve"));
            VarPoi.setXWPFRunStyleByTextNode(where, run, textNode);
            run = paragraph.insertNewRun(++index);
            fldChar = run.getCTR().addNewFldChar();
            fldChar.setFldCharType(STFldCharType.Enum.forString((String)"separate"));
            run = paragraph.insertNewRun(++index);
            run.setText(textNode.getContent());
            VarPoi.setXWPFRunStyleByTextNode(where, run, textNode);
            run = paragraph.insertNewRun(++index);
            ++index;
            fldChar = run.getCTR().addNewFldChar();
            fldChar.setFldCharType(STFldCharType.Enum.forString((String)"end"));
        }
        catch (Exception ex) {
            logger.error("ModuleGeneral varpoi error info:", (Throwable)ex);
        }
    }

    public static String getFormularString(String moduleId, String tips) {
        if (moduleId == null) {
            moduleId = "";
        }
        if (tips == null) {
            tips = "";
        }
        String formularResult = tips.replace("\"", "'");
        String formularStr = " IF " + moduleId + " > 0 \"" + formularResult + "\" \"" + formularResult + "\" ";
        return formularStr;
    }

    public static boolean checkFormularString(String formularStr) {
        if (StringUtils.isEmpty((String)formularStr)) {
            return false;
        }
        return formularStr.startsWith(" IF") || formularStr.startsWith("IF") || formularStr.startsWith("=IF");
    }

    public static String getIdFromFormularString(String instrText) {
        if (StringUtils.isEmpty((String)instrText)) {
            return "";
        }
        if (instrText.indexOf("IF(") >= 0 && instrText.indexOf(">0") > 0 && instrText.split(",").length >= 3) {
            String first = instrText.split(",")[0];
            String id = first.replace("IF(", "").replace(">0", "").trim();
            return id;
        }
        if (instrText.indexOf("IF ") >= 0 && instrText.indexOf("> 0") > 0 && instrText.split("\"").length >= 3) {
            int firstIndex = instrText.indexOf("> 0");
            String id = instrText.substring(0, firstIndex).replace("IF", "").replace(" ", "");
            return id;
        }
        return "";
    }

    private static void setXWPFRunStyleByTextNode(XWPFRun oldWhere, XWPFRun newWhere, WordTextNode textNode) {
        try {
            VarPoi.setXWPFRunStyle(oldWhere, newWhere);
            if (textNode.getFontSize() > 0.0) {
                newWhere.setFontSize(textNode.getFontSize());
            }
            if (!StringUtils.isEmpty((String)textNode.getFontColor())) {
                newWhere.setColor(textNode.getFontColor().replace("#", ""));
            }
            newWhere.setBold(textNode.getBold());
            newWhere.setItalic(textNode.getItalic());
            if (textNode.getUnderline()) {
                newWhere.setUnderline(UnderlinePatterns.SINGLE);
            } else {
                newWhere.setUnderline(UnderlinePatterns.NONE);
            }
            newWhere.setStrikeThrough(textNode.getStrikeThrough());
            newWhere.setVerticalAlignment(textNode.getVerticalAlignment());
        }
        catch (Exception ex) {
            logger.error("dm setXWPFRunStyle error:", (Throwable)ex);
        }
    }

    private static void setXWPFRunStyle(XWPFRun oldWhere, XWPFRun newWhere) {
        try {
            if (oldWhere.getFontSize() > 0) {
                newWhere.setFontSize(oldWhere.getFontSize());
            }
            if (!StringUtils.isEmpty((String)oldWhere.getFontFamily())) {
                newWhere.setFontFamily(oldWhere.getFontFamily());
            }
            if (!StringUtils.isEmpty((String)oldWhere.getColor())) {
                newWhere.setColor(oldWhere.getColor());
            }
            if (!StringUtils.isEmpty((String)oldWhere.getStyle())) {
                newWhere.setStyle(oldWhere.getStyle());
            }
            newWhere.setBold(oldWhere.isBold());
            newWhere.setItalic(oldWhere.isItalic());
            newWhere.setUnderline(oldWhere.getUnderline());
            newWhere.setStrikeThrough(oldWhere.isStrikeThrough());
            newWhere.setVerticalAlignment(oldWhere.getVerticalAlignment().toString());
            if (StringUtils.isNotEmpty((String)oldWhere.getUnderlineColor())) {
                newWhere.setUnderlineColor(oldWhere.getUnderlineColor());
            }
        }
        catch (Exception ex) {
            logger.error("dm setXWPFRunStyle error:", (Throwable)ex);
        }
    }
}

