/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.render.RenderContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.poi.AreaPoi;
import kd.epm.far.business.fidm.word.poi.BarPoi;
import kd.epm.far.business.fidm.word.poi.DoughnutPoi;
import kd.epm.far.business.fidm.word.poi.LineColumnarPoi;
import kd.epm.far.business.fidm.word.poi.LinePoi;
import kd.epm.far.business.fidm.word.poi.PiePoi;
import kd.epm.far.business.fidm.word.poi.ReportSectionPoi;
import kd.epm.far.business.fidm.word.poi.TablePoi;
import kd.epm.far.business.fidm.word.poi.VarPoi;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;

public class WordModuleUtils {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordModuleUtils.class);

    public static void createModule(RenderContext<JSONObject> context) {
        String msg = "";
        JSONObject moduleProperties = (JSONObject)context.getThing();
        if (moduleProperties == null) {
            msg = ResManager.loadKDString((String)"\u6e32\u67d3\u7ec4\u4ef6\u65f6\uff0c\u7ec4\u4ef6\u6570\u636e\u6a21\u578b\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6216\u9884\u89c8\u3002", (String)"FidmCalculate_6", (String)"epm-far-business", (Object[])new Object[0]);
            WordModuleUtils.writeError(context.getRun(), msg);
            return;
        }
        WordModuleUtils.createModule(context.getRun(), moduleProperties);
    }

    public static void createModule(XWPFRun run, JSONObject moduleProperties) {
        String msg = "";
        if (moduleProperties == null) {
            msg = ResManager.loadKDString((String)"\u6e32\u67d3\u7ec4\u4ef6\u65f6\uff0c\u7ec4\u4ef6\u6570\u636e\u6a21\u578b\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u6216\u9884\u89c8\u3002", (String)"FidmCalculate_6", (String)"epm-far-business", (Object[])new Object[0]);
            WordModuleUtils.writeError(run, msg);
            return;
        }
        Long moduleId = moduleProperties.getLong("id");
        String moduleType = moduleProperties.getString("type");
        String moduleName = moduleProperties.getString("name");
        try {
            String code = DisclosureJsonHelper.getValue(moduleProperties, "dataResult", "code", "0000");
            if (!"0000".equals(code)) {
                msg = DisclosureJsonHelper.getValue(moduleProperties, "dataResult", "message", "");
                VarPoi.bind(run, moduleId, msg, null);
                return;
            }
            if (ModuleEnum.TOC.getType().equals(moduleType)) {
                WordModuleUtils.bindToc(run, moduleProperties);
            } else {
                if (ModuleEnum.REPORT_INFO.getType().equals(moduleType)) {
                    WordModuleUtils.bindReportInfo(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.VAR.getType().equals(moduleType)) {
                    VarPoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.PIE.getType().equals(moduleType)) {
                    PiePoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.DOUGHNUT.getType().equals(moduleType)) {
                    DoughnutPoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType)) {
                    BarPoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.LINE.getType().equals(moduleType)) {
                    LinePoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.AREA.getType().equals(moduleType)) {
                    AreaPoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
                    LineColumnarPoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.TABLE.getType().equals(moduleType)) {
                    TablePoi.bind(run, moduleProperties);
                    return;
                }
                if (ModuleEnum.REPORT_SECTION.getType().equals(moduleType) || ModuleEnum.EB_REPORT_SECTION.getType().equals(moduleType)) {
                    ReportSectionPoi.bind(run, moduleProperties);
                    return;
                }
            }
        }
        catch (KDBizException kdEx) {
            VarPoi.bind(run, TypeUtils.convertToLong(moduleId), kdEx.getMessage(), null);
        }
        catch (Exception ex) {
            logger.error("dm ModuleGeneral bind error", (Throwable)ex);
            msg = String.format(ResManager.loadKDString((String)"%s:\u7ec4\u4ef6\u6e32\u67d3\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u683c\u5f0f\u8bbe\u7f6e\u6216\u5f02\u5e38\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"FidmCalculate_9", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
            VarPoi.bind(run, moduleId, msg, null);
        }
    }

    private static void bindToc(XWPFRun where, JSONObject moduleProperties) {
        JSONObject dataObject = DisclosureJsonHelper.getJsonObject(moduleProperties, "dataResult", "data");
        String thing = DisclosureJsonHelper.getValue(dataObject, "labelName", "Table of Contents");
        CTShd ctShd = where.getCTR().addNewRPr().addNewShd();
        ctShd.setFill((Object)"ffff00");
        where.setText(thing, 0);
        where.setBold(true);
        where.setFontSize(16);
        where.setItalic(true);
        where.setUnderline(UnderlinePatterns.SINGLE);
    }

    private static void bindReportInfo(XWPFRun where, JSONObject moduleProperties) {
        Long moduleId = moduleProperties.getLong("id");
        JSONObject dataObject = DisclosureJsonHelper.getJsonObject(moduleProperties, "dataResult", "data");
        String ting = "";
        if (dataObject != null) {
            ting = DisclosureJsonHelper.getValue(dataObject, "text", "");
            VarPoi.bind(where, moduleId, ting, null);
        }
    }

    private static void writeError(XWPFRun where, String msg) {
        try {
            CTShd ctShd = where.getCTR().addNewRPr().addNewShd();
            ctShd.setFill((Object)"ffff00");
            where.setText(msg, 0);
            where.setBold(true);
            where.setFontSize(16);
        }
        catch (Exception ex) {
            logger.error("ModuleGeneral writeError error", (Throwable)ex);
        }
    }
}

