/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.wpsplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.module.calculate.ModuleDataGeneralHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.report.dto.ModuleResetResult;
import kd.epm.far.business.fidm.word.helper.WordFormulaHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeTextHelper;
import kd.epm.far.business.fidm.word.poi.AreaPoi;
import kd.epm.far.business.fidm.word.poi.BarPoi;
import kd.epm.far.business.fidm.word.poi.DoughnutPoi;
import kd.epm.far.business.fidm.word.poi.LineColumnarPoi;
import kd.epm.far.business.fidm.word.poi.LinePoi;
import kd.epm.far.business.fidm.word.poi.PiePoi;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import kd.epm.far.business.fidm.word.poi.ReportSectionPoi;
import kd.epm.far.business.fidm.word.poi.TablePoi;
import kd.epm.far.business.fidm.word.poi.VarPoi;
import kd.epm.far.business.fidm.wpsplugin.WpsPluginServiceHelper;
import kd.epm.far.business.fidm.wpsplugin.dto.FormularCTText;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFPieChartData;
import org.apache.poi.xddf.usermodel.text.XDDFTextParagraph;
import org.apache.poi.xddf.usermodel.text.XDDFTextRun;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.w3c.dom.Node;

public class WpsModuleResetHelper {
    private static final Log log = LogFactory.getLog(WpsModuleResetHelper.class);

    /*
     * Exception decompiling
     */
    public static String replaceData(ModuleResetResult moduleResetResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, JSONObject> filterModule(List<JSONObject> moduleInputList, ModuleEnum moduleEnum) {
        LinkedHashMap<String, JSONObject> moduleList = new LinkedHashMap<String, JSONObject>(100);
        for (JSONObject module : moduleInputList) {
            if (module == null || !moduleEnum.getType().equalsIgnoreCase(module.getString("type"))) continue;
            moduleList.put(module.getString("id"), module);
        }
        return moduleList;
    }

    private static Map<String, JSONObject> filterModule(List<JSONObject> moduleInputList) {
        LinkedHashMap<String, JSONObject> moduleList = new LinkedHashMap<String, JSONObject>(100);
        for (JSONObject module : moduleInputList) {
            if (module == null) continue;
            moduleList.put(module.getString("id"), module);
        }
        return moduleList;
    }

    private static void updateTableData(NiceXWPFDocument newDoc, Long chapterId, List<JSONObject> moduleInputList) {
        List<Map<String, Object>> tableMaps = WpsModuleResetHelper.getTableArrays(newDoc.getXWPFDocument(), moduleInputList);
        if (tableMaps.size() == 0) {
            return;
        }
        List moduleIds = tableMaps.stream().map(m -> m.get("moduleId").toString()).distinct().collect(Collectors.toList());
        for (String moduleId : moduleIds) {
            try {
                List tableMap;
                JSONObject module;
                if (StringUtils.isEmpty((String)moduleId) || (module = (JSONObject)moduleInputList.stream().filter(m -> moduleId.equalsIgnoreCase(m.getString("id"))).findFirst().orElse(null)) == null) continue;
                String moduleType = module.getString("type");
                ModuleEnum moduleEnum = ModuleEnum.getModuleByType(moduleType);
                if (module == null) {
                    log.warn("chapterId=" + chapterId + ",moduleId=" + moduleId + " property is null");
                    continue;
                }
                JSONObject dataResult = ModuleDataGeneralHelper.getDataResultObject(module);
                if (dataResult == null || (tableMap = tableMaps.stream().filter(m -> moduleId.equals(m.get("moduleId").toString())).collect(Collectors.toList())).size() == 0) continue;
                String code = DisclosureJsonHelper.getValue(dataResult, "dataResult", "code", "0000");
                if (!"0000".equals(code)) {
                    String errorStr = DisclosureJsonHelper.getValue(dataResult, "dataResult", "message", "");
                    ArrayList<String[]> errorData = new ArrayList<String[]>(2);
                    errorData.add(new String[]{"error", errorStr});
                    for (Map item : tableMap) {
                        XWPFTable table = (XWPFTable)item.get("table");
                        TablePoi.createChart(table, module, null);
                    }
                    continue;
                }
                for (Map item : tableMap) {
                    XWPFTable table = (XWPFTable)item.get("table");
                    if (moduleEnum == ModuleEnum.TABLE) {
                        TablePoi.reset(table, module);
                        continue;
                    }
                    if (moduleEnum != ModuleEnum.REPORT_SECTION && moduleEnum != ModuleEnum.EB_REPORT_SECTION) continue;
                    ReportSectionPoi.createChart(table, module, null);
                }
            }
            catch (Exception e) {
                log.error("replaceData updateTableData chapterId=" + chapterId + ",moduleId=" + moduleId + ",error", (Throwable)e);
            }
        }
    }

    private static List<Map<String, Object>> getTableArrays(XWPFDocument document, List<JSONObject> moduleInputList) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(2);
        try {
            LinkedHashMap<String, String> tableModuleList = new LinkedHashMap<String, String>(2);
            for (JSONObject module : moduleInputList) {
                String moduleType = module.getString("type");
                String moduleId = module.getString("id");
                String bookMarkKey = DisclosureJsonHelper.getValue(module, "bookmark", "key", moduleId);
                ModuleEnum moduleEnum = ModuleEnum.getModuleByType(moduleType);
                if (moduleEnum != ModuleEnum.TABLE && moduleEnum != ModuleEnum.REPORT_SECTION && moduleEnum != ModuleEnum.EB_REPORT_SECTION) continue;
                tableModuleList.put(moduleId, StringUtils.isEmpty((String)bookMarkKey) ? moduleId : bookMarkKey);
            }
            if (tableModuleList.size() == 0) {
                return result;
            }
            List tableList = document.getTables();
            for (XWPFTable xwpfTable : tableList) {
                Map<String, Object> findKey = WpsModuleResetHelper.getTableKey(xwpfTable, tableModuleList);
                if (findKey == null) continue;
                String moduleId = findKey.get("moduleId").toString();
                HashMap<String, Object> item = new HashMap<String, Object>(2);
                item.put("moduleId", moduleId);
                item.put("bookmarkkStart", findKey.get("bookmarkkStart"));
                item.put("table", xwpfTable);
                result.add(item);
            }
        }
        catch (Exception ex) {
            log.error("replaceData getTableArrays error", (Throwable)ex);
            throw ex;
        }
        return result;
    }

    private static Map<String, Object> getTableKey(XWPFTable xwpfTable, Map<String, String> tableModuleList) {
        for (XWPFTableRow xwpfTableRow : xwpfTable.getRows()) {
            List tableCells = xwpfTableRow.getTableCells();
            for (XWPFTableCell xwpfTableCell : tableCells) {
                List paragraphs = xwpfTableCell.getParagraphs();
                for (XWPFParagraph x : paragraphs) {
                    CTP ctp = x.getCTP();
                    for (Map.Entry<String, String> item : tableModuleList.entrySet()) {
                        CTBookmark bookmark = PoiHelper.findBookMark(ctp, new String[]{item.getKey(), item.getValue()});
                        if (bookmark == null) continue;
                        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
                        result.put("moduleId", item.getKey());
                        result.put("bookmarkkStart", bookmark);
                        return result;
                    }
                }
            }
        }
        return null;
    }

    private static void updateTextData(XWPFDocument document, List<JSONObject> moduleInputList) {
        Map<String, JSONObject> allModuleList = WpsModuleResetHelper.filterModule(moduleInputList);
        if (allModuleList.size() == 0) {
            return;
        }
        List<String> moduleIds = moduleInputList.stream().map(m -> m.getString("id")).collect(Collectors.toList());
        List<FormularCTText> formularReuslt = WordFormulaHelper.getFormulaList(document, moduleIds);
        if (formularReuslt.size() == 0) {
            return;
        }
        for (JSONObject module : moduleInputList) {
            FormularCTText formularCTText;
            JSONObject dataResult;
            String moduleType = module.getString("type");
            String moduleId = module.getString("id");
            String moduleName = module.getString("name");
            if (StringUtils.isEmpty((String)moduleId) || (dataResult = ModuleDataGeneralHelper.getDataResultObject(module)) == null || (formularCTText = WordFormulaHelper.findFormula(formularReuslt, moduleId)) == null) continue;
            String errorStr = "";
            String code = DisclosureJsonHelper.getValue(dataResult, "code", "0000");
            if (!"0000".equals(code)) {
                errorStr = DisclosureJsonHelper.getValue(dataResult, "message", "");
            }
            if (!StringUtils.isEmpty((String)errorStr)) {
                WpsModuleResetHelper.resetVarModule(moduleId, errorStr, formularCTText);
                continue;
            }
            XWPFRun run = null;
            try {
                if (ModuleEnum.PIE.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    PiePoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.STACKED_COLUMNAR.getType().equalsIgnoreCase(moduleType) || ModuleEnum.STACKED_BAR.getType().equalsIgnoreCase(moduleType) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equalsIgnoreCase(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    BarPoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.LINE.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    LinePoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.DOUGHNUT.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    DoughnutPoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.AREA.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    AreaPoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equalsIgnoreCase(moduleType) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    LineColumnarPoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.TABLE.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    TablePoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.REPORT_SECTION.getType().equalsIgnoreCase(moduleType) || ModuleEnum.EB_REPORT_SECTION.getType().equalsIgnoreCase(moduleType)) {
                    run = WordFormulaHelper.removeAndGetContentNode(formularCTText);
                    if (run == null) continue;
                    ReportSectionPoi.bind(run, module);
                    continue;
                }
                if (ModuleEnum.VAR.getType().equalsIgnoreCase(moduleType)) {
                    String varMsg = VarPoi.getVar(module).getResult();
                    WpsModuleResetHelper.resetVarModule(moduleId, varMsg, formularCTText);
                    continue;
                }
                if (ModuleEnum.REPORT_INFO.getType().equalsIgnoreCase(moduleType)) {
                    String reportInfo = DisclosureJsonHelper.getValue(dataResult, "data", "text", "");
                    WpsModuleResetHelper.resetVarModule(moduleId, reportInfo, formularCTText);
                    continue;
                }
                String notFind = ResManager.loadKDString((String)"\u6682\u672a\u5b9e\u73b0\u672c\u7ec4\u4ef6\u7684\u6570\u636e\u66f4\u65b0\u64cd\u4f5c\u3002", (String)"WpsModuleResetHelper_1", (String)"epm-far-business", (Object[])new Object[0]);
                WpsModuleResetHelper.resetVarModule(moduleId, notFind, formularCTText);
            }
            catch (KDBizException kdEx) {
                WpsModuleResetHelper.resetVarModule(moduleId, kdEx.getMessage(), formularCTText);
            }
            catch (Exception ex) {
                String msg = String.format(ResManager.loadKDString((String)"%s:\u7ec4\u4ef6\u6e32\u67d3\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7ec4\u4ef6\u683c\u5f0f\u8bbe\u7f6e\u6216\u5f02\u5e38\u65e5\u5fd7\u4fe1\u606f\u3002", (String)"FidmCalculate_9", (String)"epm-far-business", (Object[])new Object[0]), moduleName);
                log.error("dm updateTextData bind " + msg + " error:", (Throwable)ex);
                WpsModuleResetHelper.resetVarModule(moduleId, msg, formularCTText);
            }
        }
    }

    private static void resetVarModule(String moduleId, String message, FormularCTText formularCTText) {
        if (formularCTText.getPreserve() != null && formularCTText.getPreserve().getCTR() != null && formularCTText.getPreserve().getCTR().getInstrTextArray().length > 0) {
            CTText ctText = formularCTText.getPreserve().getCTR().getInstrTextArray(0);
            String formularStr = VarPoi.getFormularString(moduleId, message);
            ctText.setStringValue(formularStr);
        }
        if (formularCTText.getContents().size() > 0) {
            XWPFRun run = formularCTText.getContents().get(0);
            run.setText(message, 0);
            for (int i = formularCTText.getContents().size() - 1; i > 0; --i) {
                WordNodeTextHelper.removeRun(formularCTText.getContents().get(i));
            }
        }
    }

    private static void updateVarDataByBookmark(XWPFDocument document, List<JSONObject> moduleInputList) {
        Map<String, JSONObject> varModuleList = WpsModuleResetHelper.filterModule(moduleInputList, ModuleEnum.VAR);
        if (varModuleList.size() == 0) {
            return;
        }
        ArrayList<XWPFParagraph> paragraphList = new ArrayList<XWPFParagraph>(2);
        ArrayList<String> bookmarks = new ArrayList<String>(2);
        for (Object xwpfParagraph : document.getParagraphs()) {
            CTP ctp = xwpfParagraph.getCTP();
            for (CTBookmark bookmark : ctp.getBookmarkStartArray()) {
                if (!varModuleList.containsKey(bookmark.getName())) continue;
                bookmarks.add(bookmark.getName());
                paragraphList.add((XWPFParagraph)xwpfParagraph);
            }
        }
        List tableList = document.getTables();
        for (XWPFTable xwpfTable : tableList) {
            List rows = xwpfTable.getRows();
            for (XWPFTableRow xwpfTableRow : rows) {
                List tableCells = xwpfTableRow.getTableCells();
                for (XWPFTableCell xwpfTableCell : tableCells) {
                    List cellParagraphs = xwpfTableCell.getParagraphs();
                    for (XWPFParagraph x : cellParagraphs) {
                        CTP ctp = x.getCTP();
                        for (int dwi = 0; dwi < ctp.sizeOfBookmarkStartArray(); ++dwi) {
                            CTBookmark bookmark = ctp.getBookmarkStartArray(dwi);
                            if (!varModuleList.containsKey(bookmark.getName())) continue;
                            bookmarks.add(bookmark.getName());
                            paragraphList.add(x);
                        }
                    }
                }
            }
        }
        if (bookmarks.size() == 0) {
            return;
        }
        LinkedHashMap<String, String> bookTagMap = new LinkedHashMap<String, String>(2);
        for (Map.Entry<String, JSONObject> varEntity : varModuleList.entrySet()) {
            JSONObject dataResult = ModuleDataGeneralHelper.getDataResultObject(varEntity.getValue());
            if (dataResult == null) continue;
            String errorStr = "";
            String code = DisclosureJsonHelper.getValue(dataResult, "dataResult", "code", "0000");
            if (!"0000".equals(code)) {
                errorStr = DisclosureJsonHelper.getValue(dataResult, "dataResult", "message", "");
            }
            bookTagMap.put(varEntity.getKey(), errorStr);
        }
        WpsModuleResetHelper.replaceBookTag(paragraphList, bookTagMap);
    }

    private static void replaceBookTag(List<XWPFParagraph> paragraphList, Map<String, String> bookTagMap) {
        for (XWPFParagraph xwpfParagraph : paragraphList) {
            CTP ctp = xwpfParagraph.getCTP();
            for (int dwI = 0; dwI < ctp.sizeOfBookmarkStartArray(); ++dwI) {
                String nodeName;
                Node nextNode;
                CTBookmark bookmark = ctp.getBookmarkStartArray(dwI);
                if (!bookTagMap.containsKey(bookmark.getName())) continue;
                XWPFRun run = xwpfParagraph.createRun();
                run.setText(bookTagMap.get(bookmark.getName()));
                Node firstNode = bookmark.getDomNode();
                for (nextNode = firstNode.getNextSibling(); nextNode != null && !(nodeName = nextNode.getNodeName()).equals("w:bookmarkEnd"); nextNode = nextNode.getNextSibling()) {
                    Node delNode = nextNode;
                    ctp.getDomNode().removeChild(delNode);
                }
                if (nextNode == null) {
                    ctp.getDomNode().insertBefore(run.getCTR().getDomNode(), firstNode);
                    continue;
                }
                ctp.getDomNode().insertBefore(run.getCTR().getDomNode(), nextNode);
            }
        }
    }

    private static boolean updateWordChartData(XWPFChart chart, Long chapterId, List<JSONObject> moduleInputList) {
        boolean isNeedRemove;
        block15: {
            String msg = "";
            JSONObject dataResult = null;
            isNeedRemove = false;
            try {
                if (chart.getRelations().size() == 0) {
                    log.warn("replaceData updateWordChartData chapterId=" + chapterId + ",chart.getRelations().size()=0");
                    return isNeedRemove;
                }
                String moduleId = WpsModuleResetHelper.getModuleIdFromChart(chart, "chapterId=" + chapterId);
                if (StringUtils.isEmpty((String)moduleId)) {
                    return isNeedRemove;
                }
                JSONObject module = moduleInputList.stream().filter(m -> moduleId.equalsIgnoreCase(m.getString("id"))).findFirst().orElse(null);
                if (module == null) {
                    log.warn("replaceData updateWordChartData  chapterId=" + chapterId + ",moduleId=" + moduleId + " not moduleList.containsKey(moduleId)");
                    return isNeedRemove;
                }
                String moduleType = module.getString("type");
                ModuleEnum moduleEnum = ModuleEnum.getModuleByType(moduleType);
                dataResult = ModuleDataGeneralHelper.getDataResultObject(module);
                if (dataResult == null) {
                    return isNeedRemove;
                }
                String code = DisclosureJsonHelper.getValue(module, "dataResult", "code", "0000");
                if (!"0000".equals(code)) {
                    msg = DisclosureJsonHelper.getValue(module, "dataResult", "message", "");
                    WpsModuleResetHelper.createChartError(chart, msg);
                    isNeedRemove = true;
                    return isNeedRemove;
                }
                chart.clear();
                switch (moduleEnum) {
                    case PIE: {
                        PiePoi.createChart(chart, module);
                        break;
                    }
                    case STACKED_COLUMNAR: 
                    case STACKED_BAR: 
                    case CLUSTERED_COLUMNAR: 
                    case CLUSTERED_BAR: {
                        BarPoi.createChart(chart, module);
                        break;
                    }
                    case LINE: {
                        LinePoi.createChart(chart, module);
                        break;
                    }
                    case DOUGHNUT: {
                        DoughnutPoi.createChart(chart, module);
                        break;
                    }
                    case AREA: {
                        AreaPoi.createChart(chart, module);
                        break;
                    }
                    case LINE_STACKED_COLUMNAR: 
                    case LINE_CLUSTERED_COLUMNAR: {
                        LineColumnarPoi.createChart(chart, module);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u91cd\u7f6e\u5f02\u5e38\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"ModuleDataGeneralHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
                log.error("replaceData updateWordChartData  chapterId=" + chapterId + "," + msg + ",error", (Throwable)ex);
                if (dataResult == null) break block15;
                WpsModuleResetHelper.createChartError(chart, msg);
                isNeedRemove = true;
                return isNeedRemove;
            }
        }
        return isNeedRemove;
    }

    private static String getModuleIdFromChart(XWPFChart chart, String logTitle) {
        String moduleId = "";
        try {
            if (chart.getRelations().size() == 0) {
                log.warn("replaceData getModuleIdFromChart  logTitle=" + logTitle + ",chart.getRelations().size()=0");
                return moduleId;
            }
            POIXMLDocumentPart xlsPart = (POIXMLDocumentPart)chart.getRelations().get(0);
            InputStream xlsin = xlsPart.getPackagePart().getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(xlsin);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow row = sheet.getRow(0);
            if (row == null) {
                log.warn("replaceData getModuleIdFromChart logTitle=" + logTitle + ",row=null");
                return moduleId;
            }
            XSSFCell cell = row.getCell(0);
            if (cell == null || StringUtils.isEmpty((String)cell.getStringCellValue())) {
                log.warn("replaceData getModuleIdFromChart logTitle=" + logTitle + ",row=null");
                return moduleId;
            }
            moduleId = cell.getStringCellValue();
            workbook.close();
        }
        catch (Exception ex) {
            log.error("replaceData getModuleIdFromChart  logTitle=" + logTitle + ",error", (Throwable)ex);
        }
        return moduleId;
    }

    private static void createChartError(XWPFChart chart, String errorStr) {
        chart.clear();
        chart.setTitleText(errorStr);
        ((XDDFTextRun)((XDDFTextParagraph)chart.getTitle().getBody().getParagraphs().get(0)).getTextRuns().get(0)).setFontSize(new Double(11.0));
        chart.setTitleOverlay(true);
        XDDFPieChartData data = (XDDFPieChartData)chart.createData(ChartTypes.PIE, null, null);
        data.setVaryColors(Boolean.valueOf(true));
        ArrayList<String> bottomData = new ArrayList<String>(2);
        ArrayList<BigDecimal> leftData = new ArrayList<BigDecimal>(2);
        bottomData.add("Error");
        leftData.add(new BigDecimal(1));
        int rownum = bottomData.size();
        XDDFCategoryDataSource bottomDataSource = XDDFDataSourcesFactory.fromArray((String[])bottomData.toArray(new String[0]), (String)PoiHelper.setDataSheetRange(chart, rownum, 0), (int)0);
        XDDFNumericalDataSource leftDataSource = XDDFDataSourcesFactory.fromArray((Number[])leftData.toArray(new BigDecimal[0]), (String)PoiHelper.setDataSheetRange(chart, rownum, 1), (int)1);
        data.addSeries((XDDFDataSource)bottomDataSource, leftDataSource);
        CTPieSer ser = chart.getCTChart().getPlotArea().getPieChartArray(0).getSerArray(0);
        for (int cIndex = 0; cIndex < rownum; ++cIndex) {
            CTDPt dpt = ser.addNewDPt();
            dpt.addNewIdx().setVal((long)cIndex);
            dpt.addNewSpPr().addNewSolidFill().addNewSrgbClr().xsetVal(PoiHelper.getCtdoptColor(cIndex));
        }
        chart.plot((XDDFChartData)data);
    }

    public static JSONObject moduleResetReturn(ModuleResetResult moduleResetResult) {
        Long dmModelId = moduleResetResult.getInput().getDmModelId();
        Long chapterId = moduleResetResult.getInput().getChapterId();
        String url = moduleResetResult.getNewTempWordUrl();
        String fileName = moduleResetResult.getInput().getFileName();
        List<JSONObject> itemList = moduleResetResult.getModuleList();
        JSONObject pageConfig = WpsPluginServiceHelper.getDefaultPageConfig(chapterId, fileName, url, false);
        pageConfig.put("width", (Object)640);
        pageConfig.put("minWidth", (Object)640);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(modelStrategyEx.getDim().getDimList());
        Map<String, Object> dataInit = DisclosureDesignHelper.getDataInit(dmModelId, chapterId, false, new ArrayList<String>(10));
        List realModules = (List)dataInit.get("itemList");
        JSONArray newItemList = new JSONArray();
        for (JSONObject oldItem : realModules) {
            String moduleId = oldItem.getString("id");
            if (StringUtils.isEmpty((String)moduleId)) continue;
            JSONObject find = itemList.stream().filter(m -> moduleId.equalsIgnoreCase(m.getString("id"))).findFirst().orElse(null);
            if (find != null) {
                newItemList.add((Object)find);
                continue;
            }
            newItemList.add((Object)oldItem);
        }
        Map<String, String> report = ReportChapterHelper.getReport(moduleResetResult.getInput().getReportId());
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReportAndPerm(dmModelId, moduleResetResult.getInput().getReportId());
        JSONObject dataVueObj = DisclosureVueHelper.dataChapterPreviewResult(report, chapters, newItemList, DisclosureDesignHelper.convertToBookList(newItemList), pageConfig, null, dimList, DisclosureDesignHelper.getI18n());
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }
}

