/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.wpsplugin;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.expression.base.ExpressionResultTypeEnum;
import kd.epm.far.business.common.expression.base.ExpressionUtils;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSTextHelper;
import kd.epm.far.business.common.expression.dto.ExpressionResult;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.design.dto.PreviewInput;
import kd.epm.far.business.fidm.word.WordConvert;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.dto.expression.CellDataFill;
import kd.epm.far.business.fidm.word.helper.WordCopyHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeTextHelper;
import kd.epm.far.business.fidm.word.helper.WordTableExpressionHelper;
import kd.epm.far.business.fidm.wpsplugin.dto.WpsPluginExpressionResetInput;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;

public class WpsPluginExpressionHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(WpsPluginExpressionHelper.class);

    public static Tuple<WordRootNode, NiceXWPFDocument, String> getWordData(PreviewInput previewInput) {
        WordRootNode root = new WordRootNode(WordConstants.WordContentType.Content.getType());
        if (previewInput == null) {
            return null;
        }
        NiceXWPFDocument document = null;
        try (InputStream in = DisclosureFileHelper.getFileInputStream(previewInput.getDocUrl(), previewInput.getDocUrlIsTempFile());){
            WordConvert convert = new WordConvert();
            Tuple<List<WordRootNode>, NiceXWPFDocument, String> datafromWord = convert.getDatafromWord(in);
            root = ((List)datafromWord.p1).stream().filter(m -> m.getType() == WordConstants.WordContentType.Content.getType()).findFirst().orElse(null);
            document = (NiceXWPFDocument)datafromWord.p2;
            boolean wordChange = false;
            for (WordNode wordNode : root.getChilds()) {
                WordTableExpressionHelper.IOperation operation;
                boolean isChange;
                if (!(wordNode instanceof WordTableNode) || !(isChange = WordTableExpressionHelper.reset((WordTableNode)wordNode, operation = cellDataFillMap -> WpsPluginExpressionHelper.refreshWord(cellDataFillMap)))) continue;
                wordChange = true;
            }
            if (wordChange) {
                // empty if block
            }
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String message = ResManager.loadKDString((String)"\u89e3\u6790Word\u4e2d\u7684\u6570\u636e\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"WpsPluginExpressionHelper_0", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)ex);
            throw new KDBizException(message);
        }
        return new Tuple((Object)root, (Object)document, null);
    }

    private static boolean refreshWord(Map<String, CellDataFill> cellDataFillMap) {
        boolean isChange = false;
        for (Map.Entry<String, CellDataFill> entry : cellDataFillMap.entrySet()) {
            int i;
            int i2;
            CellDataFill cellDataFill = entry.getValue();
            if (!cellDataFill.isChange() || !(cellDataFill.getCell().getUserFlag() instanceof XWPFTableCell)) continue;
            String newText = ExpressionDSTextHelper.getText(cellDataFill.getDs());
            XWPFTableCell cell = (XWPFTableCell)cellDataFill.getCell().getUserFlag();
            XWPFParagraph paragraph = cell.getParagraphs().size() > 0 ? (XWPFParagraph)cell.getParagraphs().get(0) : cell.addParagraph();
            XWPFRun run = paragraph.getRuns().size() > 0 ? (XWPFRun)paragraph.getRuns().get(0) : paragraph.createRun();
            run.setText(newText, 0);
            for (i2 = paragraph.getRuns().size() - 1; i2 > 0; --i2) {
                WordNodeTextHelper.removeRun((XWPFRun)paragraph.getRuns().get(i2));
            }
            for (i2 = cell.getParagraphs().size() - 1; i2 > 0; --i2) {
                cell.removeParagraph(i2);
            }
            WordTableCellNode cellNode = cellDataFill.getCell();
            WordParagraphNode paragraphNode = cellNode.getChilds().size() > 0 ? (WordParagraphNode)cellNode.getChilds().get(0) : new WordParagraphNode();
            WordTextNode textNode = paragraphNode.getChilds().size() > 0 ? (WordTextNode)paragraphNode.getChilds().get(0) : new WordTextNode();
            textNode.setContent(newText);
            for (i = paragraphNode.getChilds().size() - 1; i > 0; --i) {
                paragraphNode.getChilds().remove(paragraphNode.getChilds().get(i));
            }
            for (i = cellNode.getChilds().size() - 1; i > 0; --i) {
                cellNode.getChilds().remove(cellNode.getChilds().get(i));
            }
            isChange = true;
        }
        return isChange;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String resetWordData(WpsPluginExpressionResetInput input) {
        if (input == null) return null;
        if (input.getExpressionMap() == null) return null;
        if (input.getExpressionMap().isEmpty()) {
            return null;
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            NiceXWPFDocument newDoc = input.getWordDocumemnt();
            for (XWPFTable table : newDoc.getTables()) {
                WpsPluginExpressionHelper.updateTable(table, input.getExpressionMap());
            }
            for (XWPFParagraph paragraph : newDoc.getParagraphs()) {
                WpsPluginExpressionHelper.updateParagraph(paragraph, input.getExpressionMap());
            }
            newDoc.write((OutputStream)outputStream);
            byte[] outputStreamByte = outputStream.toByteArray();
            ByteArrayInputStream finalInputStream = new ByteArrayInputStream(outputStreamByte);
            String string = DisclosureFileHelper.uploadTempFile(finalInputStream, input.getFileName(), input.getUrlPrefix());
            return string;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String message = ResManager.loadKDString((String)"\u91cd\u7f6e\u6587\u6863\u4e2d\u7684\u8868\u8fbe\u5f0f\u7ed3\u679c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"WpsPluginExpressionHelper_1", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)ex);
            throw new KDBizException(message);
        }
    }

    private static void updateParagraph(XWPFParagraph paragraph, Map<String, ExpressionResult> expressionMap) {
        FloatCellDataCommon common = new FloatCellDataCommon();
        common.row = null;
        common.rowIndex = -1;
        common.cell = null;
        common.cellIndex = -1;
        common.floatCellDataList = new ArrayList<FloatCellData>(10);
        common.expressionMap = expressionMap;
        boolean isParagraphValiad = false;
        ExpressionResult parentResult = expressionMap.get(paragraph.getText());
        if (parentResult != null && parentResult.isValiad()) {
            isParagraphValiad = true;
        }
        WpsPluginExpressionHelper.updateNode(common, paragraph, isParagraphValiad);
    }

    private static void updateTable(XWPFTable table, Map<String, ExpressionResult> expressionMap) {
        ArrayList<FloatCellData> floatCellDataList = new ArrayList<FloatCellData>(10);
        for (int i = 0; i < table.getRows().size(); ++i) {
            XWPFTableRow row = (XWPFTableRow)table.getRows().get(i);
            for (int j = 0; j < row.getTableCells().size(); ++j) {
                if (row.getTableCells().size() <= j) continue;
                XWPFTableCell cell = (XWPFTableCell)row.getTableCells().get(j);
                FloatCellDataCommon common = new FloatCellDataCommon();
                common.row = row;
                common.rowIndex = i;
                common.cell = cell;
                common.cellIndex = j;
                common.floatCellDataList = floatCellDataList;
                common.expressionMap = expressionMap;
                boolean isCellValiad = false;
                ExpressionResult parentResult = expressionMap.get(cell.getText());
                if (parentResult != null && parentResult.isValiad()) {
                    isCellValiad = true;
                }
                WpsPluginExpressionHelper.updateNode(common, cell, isCellValiad);
            }
        }
        WpsPluginExpressionHelper.updateFloatTable(table, floatCellDataList);
    }

    private static boolean updateNode(FloatCellDataCommon common, Object parent, boolean isCellValiad) {
        String content;
        ExpressionResult expressionResult;
        boolean isSuccess = false;
        Map<String, ExpressionResult> expressionMap = common.expressionMap;
        for (Object node : WordNodeTextHelper.children(parent)) {
            if (!WpsPluginExpressionHelper.updateNode(common, node, isCellValiad)) continue;
            isSuccess = true;
        }
        if (!(isSuccess || (expressionResult = expressionMap.get(content = WordNodeTextHelper.getText(parent))) == null || !expressionResult.isValiad() && isCellValiad)) {
            ExpressionDSEval floatDs = ExpressionUtils.getFloatDs(expressionResult.getRoot());
            if (floatDs != null && ExpressionResultTypeEnum.List.getType().equalsIgnoreCase(floatDs.getResultType())) {
                FloatCellData floatCellData = new FloatCellData();
                floatCellData.row = common.row;
                floatCellData.rowIndex = common.rowIndex;
                floatCellData.cell = common.cell;
                floatCellData.cellIndex = common.cellIndex;
                floatCellData.run = parent;
                floatCellData.expressionResult = expressionResult;
                floatCellData.floatDs = floatDs;
                common.floatCellDataList.add(floatCellData);
            } else {
                WordNodeTextHelper.setText(parent, expressionResult.getResult());
            }
            isSuccess = true;
        }
        return isSuccess;
    }

    private static void updateFloatTable(XWPFTable table, List<FloatCellData> floatCellDataList) {
        int curIncSumRow = 0;
        String tips = "";
        for (FloatCellData floatCell : floatCellDataList) {
            List<Map<String, Object>> cellDatas = floatCell.floatDs.getListResult();
            int rowCount = cellDatas.size();
            int cloumnCount = cellDatas.size() > 0 ? cellDatas.get(0).size() : 0;
            if (WpsPluginExpressionHelper.isMergeRow(floatCell.row, floatCell) || rowCount <= 0 || (cloumnCount += floatCell.cellIndex) <= 0) continue;
            if (cloumnCount > floatCell.row.getTableCells().size()) {
                if (WpsPluginExpressionHelper.isMergeColumn(table, floatCell)) continue;
                WpsPluginExpressionHelper.insertColumn(table, cloumnCount - floatCell.row.getTableCells().size());
            }
            WpsPluginExpressionHelper.setCell(floatCell.row, cellDatas.get(0), floatCell.cellIndex);
            if (rowCount <= 1) continue;
            WpsPluginExpressionHelper.insertRows(table, floatCell.row, curIncSumRow + floatCell.rowIndex, cellDatas, floatCell.cellIndex);
            curIncSumRow = curIncSumRow + rowCount - 1;
        }
    }

    private static void insertColumn(XWPFTable table, int insertColumnCount) {
        for (int i = 0; i < table.getRows().size(); ++i) {
            XWPFTableRow row = (XWPFTableRow)table.getRows().get(i);
            XWPFTableCell lastCell = (XWPFTableCell)row.getTableCells().get(row.getTableCells().size() - 1);
            for (int inc = 0; inc < insertColumnCount; ++inc) {
                XWPFTableCell newCell = row.createCell();
                WordCopyHelper.copyTableCell(lastCell, newCell);
            }
        }
    }

    private static boolean isMergeColumn(XWPFTable table, FloatCellData floatCell) {
        boolean isMerge = false;
        for (int i = 0; i < table.getRows().size(); ++i) {
            XWPFTableRow row = (XWPFTableRow)table.getRows().get(i);
            XWPFTableCell lastCell = (XWPFTableCell)row.getTableCells().get(row.getTableCells().size() - 1);
            if (lastCell.getCTTc() == null || lastCell.getCTTc().getTcPr() == null || lastCell.getCTTc().getTcPr().getGridSpan() == null || lastCell.getCTTc().getTcPr().getGridSpan().getVal() == null) continue;
            isMerge = true;
            break;
        }
        if (isMerge) {
            String tips = ResManager.loadKDString((String)"\u6700\u540e\u4e00\u5217\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c\uff0c\u4e0d\u652f\u6301\u6d6e\u52a8\u7ed1\u5b9a\u516c\u5f0f\u6269\u5145\u5217\u3002", (String)"ExpressionDSHelper_17", (String)"epm-far-business", (Object[])new Object[0]);
            WordNodeTextHelper.setText(floatCell.run, "#" + tips);
        }
        return isMerge;
    }

    private static void setCell(XWPFTableRow row, Map<String, Object> cellData, int cellIndex) {
        int cloumnCount;
        if (cellIndex < 0) {
            cellIndex = 0;
        }
        if ((cloumnCount = cellData.size()) == 0) {
            return;
        }
        ArrayList<String> runData = new ArrayList<String>(cellData.size());
        for (Map.Entry<String, Object> item : cellData.entrySet()) {
            runData.add(item.getValue() == null ? "" : item.getValue().toString());
        }
        for (int j = cellIndex; j < cloumnCount + cellIndex; ++j) {
            int i;
            XWPFTableCell cell = row.getCell(j);
            if (cell == null) continue;
            String val = runData.get(j - cellIndex) == null ? "" : (String)runData.get(j - cellIndex);
            XWPFParagraph paragraph = cell.getParagraphs().size() > 0 ? (XWPFParagraph)cell.getParagraphs().get(0) : cell.addParagraph();
            XWPFRun run = paragraph.getRuns().size() > 0 ? (XWPFRun)paragraph.getRuns().get(0) : paragraph.createRun();
            run.setText(val, 0);
            for (i = paragraph.getRuns().size() - 1; i > 0; --i) {
                WordNodeTextHelper.removeRun((XWPFRun)paragraph.getRuns().get(i));
            }
            for (i = cell.getParagraphs().size() - 1; i > 0; --i) {
                cell.removeParagraph(i);
            }
        }
    }

    private static void insertRows(XWPFTable table, XWPFTableRow sourceRow, int pos, List<Map<String, Object>> cellDatas, int cellIndex) {
        int insertRowCount = cellDatas.size() - 1;
        for (int i = 0; i < insertRowCount; ++i) {
            XmlObject copy = sourceRow.getCtRow().copy();
            XWPFTableRow newCopyRow = new XWPFTableRow((CTRow)copy, table);
            WpsPluginExpressionHelper.setCell(newCopyRow, cellDatas.get(i + 1), cellIndex);
            table.addRow(newCopyRow, pos + i + 1);
        }
    }

    private static boolean isMergeRow(XWPFTableRow sourceRow, FloatCellData floatCell) {
        boolean isMerge = false;
        for (XWPFTableCell cell : sourceRow.getTableCells()) {
            if (cell.getCTTc() != null && cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().getGridSpan() != null && cell.getCTTc().getTcPr().getGridSpan().getVal() != null) {
                isMerge = true;
                break;
            }
            if (cell.getCTTc() == null || cell.getCTTc().getTcPr() == null || cell.getCTTc().getTcPr().getVMerge() == null) continue;
            isMerge = true;
            break;
        }
        if (isMerge) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c\uff0c\u4e0d\u652f\u6301\u6d6e\u52a8\u7ed1\u5b9a\u516c\u5f0f\u3002", (String)"ExpressionDSHelper_16", (String)"epm-far-business", (Object[])new Object[0]);
            WordNodeTextHelper.setText(floatCell.run, "#" + tips);
        }
        return false;
    }

    private static class FloatCellData {
        public XWPFTableRow row;
        public int rowIndex;
        public XWPFTableCell cell;
        public int cellIndex;
        public Object run;
        public ExpressionResult expressionResult;
        public ExpressionDSEval floatDs;

        private FloatCellData() {
        }
    }

    private static class FloatCellDataCommon {
        public XWPFTableRow row;
        public int rowIndex;
        public XWPFTableCell cell;
        public int cellIndex;
        public List<FloatCellData> floatCellDataList;
        public Map<String, ExpressionResult> expressionMap;

        private FloatCellDataCommon() {
        }
    }
}

