/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.wpsplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.base.ISaveOperation;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.html.dto.HtmlPreviewNode;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.web.WebHtmlService;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class WpsPluginServiceHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WpsPluginServiceHelper.class);

    public static JSONObject dataMiddle(String documentFormType, String url) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("type", (Object)OpenWordEnum.WPSPLUGIN.toString().toLowerCase());
        dataObj.put("url", (Object)url);
        dataObj.put("prefixUrl", (Object)DisclosureFileHelper.getUrlPrefix());
        dataObj.put("id", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
        dataObj.put("documentFormType", (Object)documentFormType);
        return DisclosureVueHelper.dataMiddle(dataObj, DisclosureDesignHelper.getI18n());
    }

    public static JSONObject dataInit(Long dmModelId, Long chapterId, boolean isReset, List<String> strTips, Map<Long, String> chapterPermMap) {
        JSONObject dataObj = DisclosureDesignHelper.dataInit(dmModelId, chapterId, isReset, strTips, chapterPermMap);
        DynamicObject chapterDy = DisclosureChapterHelper.getChapter(chapterId);
        List<String> charpterTips = DisclosureDesignHelper.checkChapter(chapterId, OpenWordEnum.WPSPLUGIN.getTypeToInt());
        if (charpterTips.size() > 0) {
            strTips.addAll(charpterTips);
        }
        String fileName = DisclosureFileHelper.getRandFileName(chapterDy.getString("template.name") + "-" + chapterDy.getString("name"), "", true);
        JSONObject pageConfig = WpsPluginServiceHelper.getDefaultPageConfig(chapterId, fileName, chapterDy.getString("url"), true);
        pageConfig.put("width", (Object)960);
        pageConfig.put("minWidth", (Object)650);
        dataObj.put("pageConfig", (Object)pageConfig);
        return dataObj;
    }

    public static JSONObject dataReportPreview(Long reportId, String url, boolean isNeedCreateTempFile) {
        StringBuilder sb = new StringBuilder();
        DynamicObject report = DisclosureReportHelper.getReport(reportId);
        sb.append(report.getString("name"));
        sb.append(".docx");
        String fileName = sb.toString();
        JSONObject pageConfig = WpsPluginServiceHelper.getDefaultPageConfig(0L, fileName, url, isNeedCreateTempFile);
        pageConfig.put("width", (Object)360);
        pageConfig.put("minWidth", (Object)360);
        JSONObject dataVueObj = DisclosureVueHelper.dataPreviewResult(pageConfig, DisclosureDesignHelper.getI18n());
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }

    public static JSONObject dataReportEdit(Long dmModelId, Long reportId, Long chapterId, List<String> strTips, Map<Long, String> chapterPermMap, boolean convertVueToFile) {
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        DynamicObject reportDy = DisclosureReportHelper.getReport(reportId);
        String fileName = DisclosureFileHelper.getRandFileName(reportDy.getString("name") + "-" + chapter.getString("name"), "", true);
        String url = chapter.getString("previewurl");
        JSONObject pageConfig = WpsPluginServiceHelper.getDefaultPageConfig(chapterId, fileName, url, true);
        pageConfig.put("width", (Object)640);
        pageConfig.put("minWidth", (Object)640);
        Map<String, Object> dataInit = DisclosureDesignHelper.getDataInit(dmModelId, chapterId, false, strTips);
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(new ModelStrategyEx(dmModelId).getDim().getDimList());
        List<String> charpterTips = DisclosureDesignHelper.checkChapter(chapterId, OpenWordEnum.WPSPLUGIN.getTypeToInt());
        if (charpterTips.size() > 0) {
            strTips.addAll(charpterTips);
        }
        Map<String, String> report = ReportChapterHelper.getReport(reportId);
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReportAndPerm(reportId, chapterPermMap);
        JSONObject dataVueObj = DisclosureVueHelper.dataChapterPreviewResult(report, chapters, dataInit.get("itemList"), dataInit.get("bookmarkList"), pageConfig, null, dimList, DisclosureDesignHelper.getI18n());
        if (convertVueToFile) {
            return DisclosureDesignHelper.convertVueToFile(dataVueObj);
        }
        return dataVueObj;
    }

    public static JSONObject dataReportEdit(Long dmModelId, Long reportId, List<String> strTips, Map<Long, String> chapterPermMap) {
        DynamicObject reportDy = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (reportId == null) {
            logger.error("report id not exist:" + reportId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6211\u7684\u62a5\u544a\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection entryentitys = reportDy.getDynamicObjectCollection("entryentity");
        List chapterids = entryentitys.stream().map(x -> x.getLong("chapter.id")).collect(Collectors.toList());
        JSONArray allChapterItemList = new JSONArray();
        QFBuilder qf = new QFBuilder("model", "=", (Object)dmModelId);
        qf.add(new QFilter("id", "in", chapterids));
        DynamicObject[] chapterDys = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,previewurl", (QFilter[])qf.toArray(), (String)"sequence");
        WebHtmlService webHtmlService = new WebHtmlService();
        HtmlPreviewNode previewJson = null;
        for (DynamicObject chapter : chapterDys) {
            JSONArray previewItemList;
            Long chapterId = chapter.getLong("id");
            DynamicObject reportJsonDy = webHtmlService.getChapterPreviewJsonObject(reportId, chapterId);
            if (reportJsonDy == null || (previewItemList = (previewJson = (HtmlPreviewNode)JSON.parseObject((String)reportJsonDy.getString("content"), HtmlPreviewNode.class)).getItemList()) == null || previewItemList.size() <= 0) continue;
            allChapterItemList.addAll((Collection)previewItemList);
        }
        String fileName = DisclosureFileHelper.getRandFileName(reportDy.getString("name"), "", true);
        String docUrl = DisclosureReportHelper.mergeReport(reportId, strTips);
        JSONObject pageConfig = WpsPluginServiceHelper.getDefaultPageConfig(0L, fileName, docUrl, true);
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(new ModelStrategyEx(dmModelId).getDim().getDimList());
        Map<String, String> report = ReportChapterHelper.getReport(reportId);
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReportAndPerm(reportId, chapterPermMap);
        JSONObject dataVueObj = DisclosureVueHelper.dataChapterPreviewResult(report, chapters, DisclosureDesignHelper.getItemListByNoDataResult(allChapterItemList), DisclosureDesignHelper.convertToBookList(allChapterItemList), pageConfig, null, dimList, DisclosureDesignHelper.getI18n());
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }

    public static boolean saveTemplateChapter(Long dmModelId, Long chapterId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        String pageConfigId = pageConfig.getString("id");
        if (!chapterId.toString().equalsIgnoreCase(pageConfigId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5185\u5bb9\u4e0d\u662f\u7ae0\u8282\u201c%1$s\u201c\u7684\u5185\u5bb9\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u5f53\u524d\u7ae0\u8282\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"DisclosureServiceHelper_25", (String)"epm-far-business", (Object[])new Object[0]), chapter.getString("name")));
        }
        String docId = pageConfig.getString("docId");
        if (StringUtils.isEmpty((String)docId)) {
            throw new KDBizException("docId not exists");
        }
        String tempUrl = pageConfig.getString("saveUploadUrl");
        if (StringUtils.isEmpty((String)tempUrl)) {
            throw new KDBizException("saveUploadUrl not exists");
        }
        String formId = "fidm_webdesign";
        String fileName = chapter.getString("name");
        ISaveOperation saveOperation = c -> {
            String newFileUrl = DisclosureFileHelper.uploadFile(tempUrl, formId, docId, fileName);
            return newFileUrl;
        };
        Tuple<Boolean, String> result = DisclosureDesignHelper.save(dmModelId, chapterId, saveOperation, eventArgs, OpenWordEnum.WPSPLUGIN.getTypeToInt());
        return (Boolean)result.item1;
    }

    public static void previewByUrl(IFormView view, Long dmModelId, String name, String url) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        String newTempUrl = url;
        IFormView parentView = view.getParentView();
        String formId = "fidm_wpsplugin_middle";
        String pageId = formId + GlobalIdUtil.genGlobalLongId();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("KEY_MODEL_ID", dmModelId);
        customParams.put("name", name);
        customParams.put("url", newTempUrl);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParams(customParams);
        formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
        formShowParameter.setPageId(pageId);
        if (parentView != null) {
            parentView.showForm(formShowParameter);
            view.sendFormAction(parentView);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.ToolTips);
            view.showForm(formShowParameter);
        }
    }

    public static JSONObject getDefaultPageConfig(Long chapterId, String fileName, String docUrl, boolean isNeedCreateTempFile) {
        Long docId = GlobalIdUtil.genGlobalLongId();
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)(chapterId == null || chapterId <= 0L ? String.valueOf(GlobalIdUtil.genStringId()) : chapterId.toString()));
        DisclosureDesignHelper.setPageConfigForChapterInfo(dataObj, chapterId);
        String tempUrl = "";
        tempUrl = isNeedCreateTempFile ? (StringUtils.isEmpty((String)docUrl) ? DisclosureFileHelper.uploadEmptyTempFile(fileName, DisclosureFileHelper.getUrlPrefix(), true) : DisclosureFileHelper.uploadTempFile(docUrl, DisclosureFileHelper.getUrlPrefix(), fileName, true)) : DisclosureFileHelper.addToken(docUrl);
        dataObj.put("docId", (Object)docId.toString());
        dataObj.put("wpsUrl", (Object)tempUrl);
        dataObj.put("prefixUrl", (Object)DisclosureFileHelper.getUrlPrefix());
        dataObj.put("wpsUrlFileName", (Object)fileName);
        dataObj.put("type", (Object)OpenWordEnum.WPSPLUGIN.toString().toLowerCase());
        if (!StringUtils.isEmpty((String)RequestContext.get().getGlobalSessionId())) {
            dataObj.put("token", (Object)RequestContext.get().getGlobalSessionId());
        }
        dataObj.put("appId", (Object)"fidm");
        dataObj.put("formId", (Object)"fidm_wpsplugindesign");
        return dataObj;
    }

    public static boolean saveReportChapter(Long reportId, Long chapterId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (chapter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String pageConfigId = pageConfig.getString("id");
        if (!chapterId.toString().equalsIgnoreCase(pageConfigId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5185\u5bb9\u4e0d\u662f\u7ae0\u8282\u201c%1$s\u201c\u7684\u5185\u5bb9\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u5f53\u524d\u7ae0\u8282\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"DisclosureServiceHelper_25", (String)"epm-far-business", (Object[])new Object[0]), chapter.getString("name")));
        }
        String docId = pageConfig.getString("docId");
        String tempUrl = pageConfig.getString("saveUploadUrl");
        String formId = "fidm_webpreview";
        String fileName = chapter.getString("name");
        ISaveOperation saveOperation = c -> {
            String newFileUrl = DisclosureFileHelper.uploadFile(tempUrl, formId, docId, fileName);
            return newFileUrl;
        };
        Tuple<Boolean, String> result = DisclosureReportHelper.saveReportChapter(reportId, chapterId, saveOperation, eventArgs, OpenWordEnum.WPSPLUGIN.getTypeToInt());
        return (Boolean)result.item1;
    }
}

