/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.service;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.formulaengine.FormulaStrategy;
import kd.epm.far.business.common.dataset.formulaengine.exception.FormulaError;
import kd.epm.far.business.common.dataset.formulaengine.exception.InvalidFormulaException;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.service.FormulaMsService;

public class FormulaMsServiceImp
implements FormulaMsService {
    private final WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());

    public Map<String, Object> getDataSetDto(String paramJson) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> res = new HashMap<String, Object>(12);
        res.put("code", 200);
        res.put("ret", true);
        this.logger.info(String.format("FormulaMsServiceImp.getDataSetDto request param: %s", paramJson));
        try {
            DatasetDto dto = new FormulaStrategy().getStrategy(paramJson).getObject();
            res.put("result", JSON.toJSONString((Object)dto));
        }
        catch (InvalidFormulaException e) {
            this.logger.error(String.format("FormulaMsServiceImp.getDataSetDto-InvalidFormulaException--%s", new Object[]{e}));
            res.put("code", e.getErrorCode());
            res.put("ret", false);
            res.put("msg", e.getMsg());
            return res;
        }
        catch (Exception e) {
            this.logger.error(String.format("FormulaMsServiceImp.getDataSetDto-Exception--%s", e));
            res.put("code", FormulaError.CODE_299.getCode());
            res.put("ret", false);
            res.put("msg", FormulaError.CODE_299.getMsg());
            return res;
        }
        this.logger.info("Far--------FormulaMsServiceImp---getDataSetDto---------costtimes:" + (System.currentTimeMillis() - startTime));
        return res;
    }

    public Map<String, Object> getResult(String paramJson) {
        long startTime = System.currentTimeMillis();
        DatasetDto dto = null;
        HashMap<String, Object> res = new HashMap<String, Object>(12);
        res.put("code", 200);
        res.put("ret", true);
        this.logger.info(String.format("FormulaMsServiceImp.getResult request param: %s", paramJson));
        try {
            dto = new FormulaStrategy().getStrategy(paramJson).getObject();
            res.put("dto", JSON.toJSONString((Object)dto));
            this.logger.info("Far--------FormulaMsServiceImp---getDataSetDto---------costtimes:" + (System.currentTimeMillis() - startTime));
        }
        catch (InvalidFormulaException e) {
            this.logger.error(String.format("FormulaMsServiceImp.getResult-InvalidFormulaException--%s", new Object[]{e}));
            res.put("code", e.getErrorCode());
            res.put("ret", false);
            res.put("msg", e.getMsg());
            return res;
        }
        catch (Exception e) {
            this.logger.error(String.format("FormulaMsServiceImp.getResult-Exception--%s", e));
            res.put("code", FormulaError.CODE_299.getCode());
            res.put("ret", false);
            res.put("msg", FormulaError.CODE_299.getMsg());
            return res;
        }
        try {
            Object result = DatasetUtil.getResult((DatasetDto)dto);
            res.put("result", result);
        }
        catch (Exception e) {
            this.logger.error(String.format("FormulaMsServiceImp.getResult error: %s", e));
            res.put("code", 301);
            res.put("ret", false);
            res.put("msg", StringUtils.isEmpty((CharSequence)e.getMessage()) ? e.toString() : e.getMessage());
            return res;
        }
        this.logger.info("Far--------FormulaMsServiceImp---getResult---------costtimes:" + (System.currentTimeMillis() - startTime));
        return res;
    }

    public List<Map<String, Object>> getBatchDataSetDto(List<String> paramJsons) {
        long startTime = System.currentTimeMillis();
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(paramJsons.size());
        for (String paramJson : paramJsons) {
            res.add(this.getDataSetDto(paramJson));
        }
        this.logger.info("Far--------FormulaMsServiceImp---getBatchDataSetDto---------costtimes:" + (System.currentTimeMillis() - startTime));
        return res;
    }

    public List<Map<String, Object>> getBatchResult(List<String> paramJsons) {
        long startTime = System.currentTimeMillis();
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>(paramJsons.size());
        for (String paramJson : paramJsons) {
            res.add(this.getResult(paramJson));
        }
        this.logger.info("Far--------FormulaMsServiceImp---getBatchResult---------costtimes:" + (System.currentTimeMillis() - startTime));
        return res;
    }

    public Map<String, Map<String, Object>> getBatchDataSetDtoMap(Map<String, String> paramJsons) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(paramJsons.size());
        for (Map.Entry<String, String> entry : paramJsons.entrySet()) {
            res.put(entry.getKey(), this.getDataSetDto(entry.getValue()));
        }
        this.logger.info("Far--------FormulaMsServiceImp---getBatchDataSetDtoMap---------costtimes:" + (System.currentTimeMillis() - startTime));
        return res;
    }

    public Map<String, Map<String, Object>> getBatchResultMap(Map<String, String> paramJsons) {
        long startTime = System.currentTimeMillis();
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>(paramJsons.size());
        for (Map.Entry<String, String> entry : paramJsons.entrySet()) {
            res.put(entry.getKey(), this.getResult(entry.getValue()));
        }
        this.logger.info("Far--------FormulaMsServiceImp---getBatchResultMap---------costtimes:" + (System.currentTimeMillis() - startTime));
        return res;
    }
}

