/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.base;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.PermissionControlType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.export.ExportUtil;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.DownFileUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.common.common.util.ThrowableHelper;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.license.BcmLicenceControl;
import kd.epm.far.formplugin.common.util.BcmBasePluginUtil;
import kd.epm.far.formplugin.common.util.ModelUtil;
import org.apache.commons.collections.CollectionUtils;

public interface BCMBaseFunction {
    public static final WatchLogger watchlogger = BcmLogFactory.getWatchLogInstance((boolean)true, BCMBaseFunction.class);

    public AbstractFormPlugin getPlugin();

    default public void bcmPreOpen(PreOpenFormEventArgs e) {
        FormShowParameter fs = (FormShowParameter)e.getSource();
        fs.setHasRight(true);
        String formId = fs.getFormId();
        String appId = e.getFormShowParameter().getAppId();
        String msg = BcmLicenceControl.checkByVersion(fs);
        if (StringUtils.isNotEmpty((String)msg)) {
            e.setCancel(true);
            e.setCancelMessage(msg);
            return;
        }
        LicenseCheckResult re = null;
        re = BcmLicenceControl.check(appId, formId);
        if (re != null && !re.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(re.getMsg());
        }
    }

    default public long getModelId() {
        Object model = ThreadCache.get((Object)(CacheKey.PrefixString + "getModelId"));
        if (model != null) {
            return LongUtil.toLong((Object)model);
        }
        long modelid = this.loadModelId();
        if (modelid != 0L) {
            ThreadCache.put((Object)(CacheKey.PrefixString + "getModelId"), (Object)modelid);
        }
        return modelid;
    }

    default public Long loadModelId() {
        Object model;
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"model") && (model = this.getPlugin().getView().getModel().getValue("model")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"modelbd") && (model = this.getPlugin().getView().getModel().getValue("modelbd")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        String modelId = this.getPlugin().getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId)) {
            String string = modelId = this.getFormCustomParam("KEY_MODEL_ID") == null ? "" : this.getFormCustomParam("KEY_MODEL_ID").toString();
        }
        if (StringUtils.isEmpty((String)modelId) || "null".equals(modelId)) {
            this.getPlugin().getPageCache().put("KEY_MODEL_ID", "0");
            this.getPlugin().getView().getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)0);
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    default public Long getDMModelId() {
        Long id = this.getDiscModelId();
        return LongUtil.toLong((Object)id);
    }

    default public Long getDiscModelId() {
        Object model = ThreadCache.get((Object)(CacheKey.PrefixString + CacheKey.USERMEMORY_KEY));
        if (model != null) {
            return LongUtil.toLong((Object)model);
        }
        long modelid = this.getUserSelect();
        if (modelid != 0L) {
            ThreadCache.put((Object)(CacheKey.PrefixString + CacheKey.USERMEMORY_KEY), (Object)modelid);
        }
        return modelid;
    }

    default public Long getUserMemoryModelId() {
        ApplicationTypeEnum applicationTypeEnum = this.getApplicationType();
        Long modifier = this.getUserId();
        String appSign = applicationTypeEnum.getOIndex();
        QFilter[] filters = new QFilter[]{new QFilter("modifier", "=", (Object)modifier), new QFilter("appsign", "=", (Object)appSign)};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"far_usermemory", (String)"modelid,modelid.status", (QFilter[])filters);
        Long dmModelId = 0L;
        if (Objects.nonNull(dynamicObject)) {
            String modelStatus = dynamicObject.getString("modelid.status");
            if ("0".equals(modelStatus)) {
                return dmModelId;
            }
            dmModelId = dynamicObject.getLong("modelid");
        }
        return dmModelId;
    }

    default public Long getUserSelect() {
        Object model;
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"model") && (model = this.getPlugin().getView().getModel().getValue("model")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        String modelId = this.getPlugin().getPageCache().get("dmmodelid");
        if (StringUtils.isEmpty((String)modelId)) {
            String string = modelId = this.getFormCustomParam("dmmodelid") == null ? "" : this.getFormCustomParam("dmmodelid").toString();
        }
        if (StringUtils.isNotEmpty((String)modelId) && !"0".equals(modelId)) {
            return LongUtil.toLong((Object)modelId);
        }
        Long dmmodelId = this.getUserMemoryModelId();
        if (0L == dmmodelId) {
            return 0L;
        }
        HasPermDimObjResult permresult = PermissionServiceHelper.getUserHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"fidm_model");
        if (permresult.hasAllDimObjPerm()) {
            return LongUtil.toLong((Object)dmmodelId);
        }
        if (permresult.getHasPermDimObjs().contains(dmmodelId)) {
            return dmmodelId;
        }
        return 0L;
    }

    default public long getUserId() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    default public <T> T deSerializedBytes(String serial) {
        return (T)(serial == null ? null : ObjectSerialUtil.deSerializedBytes((String)serial));
    }

    default public String toByteSerialized(Object t) {
        return ObjectSerialUtil.toByteSerialized((Object)t);
    }

    default public <T> T getFormCustomParam(String key) {
        return (T)this.getPlugin().getView().getFormShowParameter().getCustomParam(key);
    }

    default public void bcmInit() {
        DynamicPage dp;
        Page page;
        if (this instanceof DynamicPage && (page = (dp = (DynamicPage)((Object)this)).getPage(this.getPlugin().getView())) != null) {
            if (page.isChangeable()) {
                this.getPlugin().getView().getModel().getDataEntity();
            }
            ((DynamicPage)((Object)this)).getPage(this.getPlugin().getView()).bindCtrlMapping(this.getPlugin().getView());
        }
    }

    default public void bcmProChange(PropertyChangedArgs e) {
        if (this instanceof DynamicPage) {
            Element ele;
            Page page;
            String propertyName = e.getProperty().getName();
            DynamicPage dp = (DynamicPage)((Object)this);
            if (dp.needCache() && (page = dp.getPage(this.getPlugin().getView())) != null && (ele = page.findElementBySign(propertyName)) != null) {
                ele.setValue(this.getPlugin().getPageCache(), e.getChangeSet()[0].getNewValue());
                dp.setPage(this.getPlugin().getView(), page);
            }
        }
    }

    default public Object getValue(String sign) {
        DynamicPage dp;
        if (this instanceof DynamicPage && (dp = (DynamicPage)((Object)this)).needCache()) {
            Page page = dp.getPage(this.getPlugin().getView());
            if (null == page) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u60c5\u666f", (String)"BCMBaseFunction_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return null;
            }
            Element ele = page.findElementBySign(sign);
            if (ele != null) {
                Object ori = this.getPlugin().getView().getModel().getValue(sign);
                if (ori instanceof DynamicObjectCollection) {
                    List relist = (List)ele.getValue(this.getPlugin().getPageCache());
                    if (relist == null) {
                        return this.getPlugin().getView().getModel().getValue(sign);
                    }
                    DynamicObjectCollection result = (DynamicObjectCollection)ori;
                    result.clear();
                    for (DynamicObject oo : relist) {
                        DynamicObject addnew = result.addNew();
                        addnew.set("fbasedataid", (Object)oo);
                    }
                    return result;
                }
                return ele.getValue(this.getPlugin().getPageCache());
            }
        }
        return this.getPlugin().getView().getModel().getValue(sign);
    }

    default public void setValue(String sign, Object value) {
        this.setValue(sign, value, true);
    }

    default public void setValue(String sign, Object value, boolean cachePage) {
        Page page;
        Element ele;
        DynamicPage dp;
        this.getPlugin().getView().getModel().setValue(sign, value);
        if (this instanceof DynamicPage && (dp = (DynamicPage)((Object)this)).needCache() && (ele = (page = dp.getPage(this.getPlugin().getView())).findElementBySign(sign)) != null) {
            ele.setValue(this.getPlugin().getPageCache(), this.getPlugin().getView().getModel().getValue(sign));
            if (cachePage) {
                dp.setPage(this.getPlugin().getView(), page);
            }
        }
    }

    default public void getBcmEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            try {
                MainEntityType copy = (MainEntityType)e.getOriginalEntityType().clone();
                e.setNewEntityType(copy);
                Page page = ((DynamicPage)((Object)this)).getPage(this.getPlugin().getView());
                if (page != null) {
                    page.cacheMainProp(this.getPlugin().getPageCache(), copy.getProperties());
                }
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    default public void getBcmControl(OnGetControlArgs e) {
        Element ele;
        DynamicPage dp;
        Page page;
        if (this instanceof DynamicPage && (page = (dp = (DynamicPage)((Object)this)).getPage(this.getPlugin().getView())) != null && (ele = page.findElementBySign(e.getKey())) != null) {
            e.setControl(ele.getControl(this.getPlugin().getView()));
        }
    }

    @Deprecated
    default public boolean isEPM() {
        return false;
    }

    default public boolean isFIDM() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FIDM.appnum, appId);
    }

    default public boolean isFAR() {
        String appId = this.getView().getFormShowParameter().getAppId();
        return Objects.equals(ApplicationTypeEnum.FAR.appnum, appId);
    }

    default public boolean isRPT() {
        ApplicationTypeEnum sign = ModelUtil.queryApp(this.getPlugin().getView());
        return ApplicationTypeEnum.RPT == sign;
    }

    default public boolean isCM() {
        ApplicationTypeEnum sign = ModelUtil.queryApp(this.getPlugin().getView());
        return ApplicationTypeEnum.CM == sign;
    }

    default public ApplicationTypeEnum getApplicationType() {
        return ModelUtil.queryApp(this.getPlugin().getView());
    }

    default public IFormView getView() {
        return this.getPlugin().getView();
    }

    default public void doCheckPermission(String entityNum, String permItemId, Long modelId, String curAppId) {
        int is;
        List publishApps;
        PermissionControlType pct = EntityMetadataCache.getPermissionControlType((String)entityNum);
        if (pct != null && (publishApps = pct.getPublishApps()) != null) {
            String appId = BizAppServiceHelp.getAppIdByFormNum((String)entityNum);
            String currAppId = AppMetadataCache.getAppInfo((String)curAppId).getId();
            if (!currAppId.equals(appId) && !publishApps.contains(currAppId)) {
                return;
            }
        }
        if ((is = BcmBasePluginUtil.checkPermission(this.getUserId(), modelId, AppMetadataCache.getAppInfo((String)curAppId).getId(), entityNum, permItemId)) == 0) {
            if (this.isCurModelAdmin(modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    default public boolean isCurModelAdmin(Long modelId) {
        return MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(modelId));
    }

    default public void exportData(String entityName, QFilter[] qFilters, String filename, String templateNumber, String entityNameImp) {
        if (qFilters.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)filename)) {
            filename = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"BCMBaseFunction_7", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((String)entityNameImp)) {
            entityNameImp = entityName;
        }
        QFBuilder filters = new QFBuilder();
        if (StringUtils.isEmpty((String)templateNumber)) {
            filters.add(new QFilter("bizobject.number", "=", (Object)entityNameImp));
        } else {
            filters.add(new QFilter("number", "=", (Object)templateNumber));
        }
        String tempLateType = "templatetype";
        filters.add(new QFilter(tempLateType, "=", (Object)"IMPT").or(new QFilter(tempLateType, "is null", null)));
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters.toArray(), (String)StringUtils.getEmpty(), (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters).values().toArray(new DynamicObject[0]);
            String url = ExportUtil.export((DynamicObject[])this.handleDys(dys), pkIds.get(0), (String)routeAppId, (String)entityNameImp, (String)(filename + ".xlsx"));
            if (StringUtils.isNotEmpty((String)url)) {
                this.authorizedDownLoadFileUrl(url);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
            }
        }
        catch (KDBizException bizException) {
            throw new KDBizException(bizException.getMessage());
        }
        catch (Exception e) {
            watchlogger.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException((Throwable)e, new ErrorCode(StringUtils.getEmpty(), ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"BCMBaseFunction_8", (String)"epm-far-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    default public void authorizedDownLoadFileUrl(String url) {
        try {
            if (this.getView().getFormShowParameter().getCustomParam("authDownloadFileFlag") != null) {
                DownFileUtil.authorizedDownLoadFileUrl4CM((String)url, (String)this.getView().getEntityId());
            }
        }
        catch (Exception e) {
            watchlogger.error(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
        }
    }

    default public void exportData(String entityName, QFilter[] qFilters, String filename) {
        this.exportData(entityName, qFilters, filename, StringUtils.getEmpty(), entityName);
    }

    default public DynamicObject[] handleDys(DynamicObject[] dys) {
        return dys;
    }

    default public void setF7Disable() {
        List f7Keys = (List)this.getPlugin().getView().getFormShowParameter().getCustomParam("f7_disable_list");
        if (CollectionUtils.isNotEmpty((Collection)f7Keys)) {
            for (String f7Key : f7Keys) {
                if (null == this.getPlugin().getView().getControl(f7Key)) continue;
                this.getPlugin().getView().setEnable(Boolean.valueOf(false), new String[]{f7Key});
            }
        }
    }
}

