/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.base.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.adapter.ModelAdapter;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;
import kd.epm.far.formplugin.common.usermemory.UserMemoryUtil;
import kd.epm.far.formplugin.common.util.ModelUtil;
import kd.epm.far.formplugin.common.util.SingleMemberF7Util;

public class AbstractBaseDMFormPlugin
extends AbstractBaseFormPlugin {
    protected static final String REPORTPERM = "reportperm";

    public ModelInfo getDMModel() {
        Long id = this.getDiscModelId();
        if (!LongUtil.isvalidLong((Object)id)) {
            return null;
        }
        return new ModelStrategyEx(id).getModel().getModelInfo();
    }

    public DynamicObject getOriginSourceModel() {
        Long id = this.getDiscModelId();
        DynamicObject dmmodel = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"fidm_model");
        if (Objects.isNull(dmmodel)) {
            return null;
        }
        if (Objects.equals("1", dmmodel.getString("modeltype")) || Objects.equals("3", dmmodel.getString("modeltype"))) {
            if (Objects.isNull(dmmodel.get("model"))) {
                return null;
            }
            DynamicObject bcmmodel = BusinessDataServiceHelper.loadSingle((Object)dmmodel.getLong("model.id"), (String)"bcm_model");
            return bcmmodel;
        }
        if (Objects.equals("2", dmmodel.getString("modeltype"))) {
            if (Objects.isNull(dmmodel.get("model"))) {
                return null;
            }
            DynamicObject epmmodel = BusinessDataServiceHelper.loadSingle((Object)dmmodel.getLong("model.id"), (String)"epm_model");
            return epmmodel;
        }
        return null;
    }

    public Long getSourceModelId() {
        DynamicObject discmodel = this.getOriginSourceModel();
        if (Objects.isNull(discmodel)) {
            return 0L;
        }
        return discmodel.getLong("id");
    }

    @Override
    public Long loadModelId() {
        Object model;
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"model") && (model = this.getPlugin().getView().getModel().getValue("model")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"modelbd") && (model = this.getPlugin().getView().getModel().getValue("modelbd")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        String modelId = this.getPlugin().getPageCache().get("dmmodelid");
        if (StringUtils.isEmpty((String)modelId)) {
            String string = modelId = this.getFormCustomParam("dmmodelid") == null ? "" : this.getFormCustomParam("dmmodelid").toString();
        }
        if (StringUtils.isEmpty((String)modelId) || "0".equals(modelId)) {
            return this.getUserSelect();
        }
        return Long.parseLong(modelId);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long dmModelId = this.getDiscModelId();
        if (LongUtil.isvalidLong((Object)dmModelId)) {
            String modelSign = this.getModelSign();
            if (StringUtils.isNotEmpty((String)modelSign) && this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)modelSign)) {
                this.getModel().setValue(modelSign, (Object)dmModelId);
            }
            this.getPageCache().put("dmmodelid", String.valueOf(dmModelId));
        }
    }

    @Override
    public boolean isFIDM() {
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (Objects.equals(this.getModelSign(), key)) {
            this.propertyChangedModelUse(Collections.emptyList());
        }
    }

    @Override
    public String getCurModelNumber() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return "";
        }
        return new ModelStrategyEx(Long.valueOf(modelId)).getModel().getModelInfo().getNumber();
    }

    @Override
    public void checkPerm(String opkey) {
        String[] perm = this.getPerm(opkey, this.getPermEntityId());
        if (perm == null) {
            return;
        }
        String appType = ApplicationTypeEnum.FIDM.appnum;
        if (this.isFAR()) {
            appType = ApplicationTypeEnum.FAR.appnum;
        }
        this.doCheckPermission(perm[0], perm[1], this.getDiscModelId(), appType);
    }

    @Override
    public boolean isCurModelAdmin(Long modelId) {
        return MemberPermHelper.isFidmModelAdmin((Long)modelId, (String)this.getBizAppId());
    }

    protected String checkModulePerm() {
        String msg = "";
        String isModuleOnlyRead = (String)this.getView().getFormShowParameter().getCustomParam("isModelOnlyRead");
        if ("true".equals(isModuleOnlyRead)) {
            msg = "readonly";
        }
        return msg;
    }

    protected String checkAnalysisTemplatePerm() {
        String perm = (String)this.getView().getFormShowParameter().getCustomParam("template");
        String msg = "";
        if ("true".equals(perm)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u5206\u6790\u770b\u677f\u4e3a\u53ea\u8bfb\u6743\u9650\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"AbstractBaseDMFormPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        return msg;
    }

    @Override
    protected void propertyChangedModelUse(List<String> dimKeys) {
        String dmmodelId = SingleMemberF7Util.getF7SelectId(this.getView(), this.getModelSign());
        if (dmmodelId == null) {
            this.getModel().setValue(this.getModelSign(), (Object)this.getPageCache().get("dmmodelid"));
        } else {
            if (dmmodelId.equals(this.getPageCache().get("dmmodelid"))) {
                return;
            }
            ThreadCache.put((Object)(CacheKey.PrefixString + CacheKey.USERMEMORY_KEY), (Object)LongUtil.toLong((Object)dmmodelId));
            this.getPageCache().put("dmmodelid", dmmodelId);
            Long sourceModelId = this.getSourceModelId();
            if (LongUtil.isvalidLong((Object)sourceModelId)) {
                this.getPageCache().put("KEY_MODEL_ID", sourceModelId.toString());
            }
            this.getPageCache().put("dmmodelid", dmmodelId);
            SingleMemberF7Util.cacheModelPrem(this.getPageCache(), Long.valueOf(dmmodelId), this.getApplicationType());
            ApplicationTypeEnum applicationTypeEnum = this.getApplicationType();
            String appSign = applicationTypeEnum.getOIndex();
            UserMemoryUtil.saveUserMemory(this.getUserId(), LongUtil.toLong((Object)dmmodelId), appSign);
        }
    }

    @Override
    public String getModelSign() {
        return "";
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            String bizAppId;
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            if (StringUtils.isNotEmpty((String)(bizAppId = this.getBizAppId())) && ApplicationTypeEnum.CM == ApplicationTypeEnum.getEnumByNumber((String)bizAppId)) {
                qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
            } else {
                qFilterList.addAll(ModelUtil.getDmModelFilter(this.getView()));
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    protected void writeOpLog(OperationCategory category, OperationName opName, OperationResult result, String formId, Object ... params) {
        try {
            ModelInfo model = ModelAdapter.getModelInfo((Long)this.getDMModelId(), (boolean)false);
            if (Objects.isNull(model)) {
                return;
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber()}).appendFormatParams(params).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            log.error("fidm log error", (Throwable)ex);
        }
    }

    protected void writeOpLog(OperationCategory category, OperationName opName, OperationResult result, String formId, Long modelId, Object ... params) {
        try {
            ModelInfo model = ModelAdapter.getModelInfo((Long)modelId, (boolean)false);
            if (Objects.isNull(model)) {
                return;
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber()}).appendFormatParams(params).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            log.error("fidm log error", (Throwable)ex);
        }
    }

    protected void batchWriteOpLogOrigin(OperationCategory category, OperationName opName, OperationResult result, String formId, List<Object[]> appendParamsList) {
        try {
            ModelInfo model = ModelAdapter.getModelInfo((Long)this.getDMModelId(), (boolean)false);
            if (model == null) {
                return;
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam(appendParamsList.size()).buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildOpResult(result);
            for (Object[] appendParams : appendParamsList) {
                Object[] array = new Object[2 + appendParams.length];
                array[0] = model.getNumber();
                System.arraycopy(appendParams, 0, array, 1, appendParams.length);
                logParam.buildBatchFormatParams(array);
            }
            AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            log.error("fidm log error", (Throwable)ex);
        }
    }
}

