/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.base.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.business.export.ExportUtil;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.adapter.ModelAdapter;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.cache.CacheKey;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ThrowableHelper;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseListPlugin;
import kd.epm.far.formplugin.common.usermemory.UserMemoryUtil;
import kd.epm.far.formplugin.common.util.ModelUtil;
import kd.epm.far.formplugin.common.util.SingleMemberF7Util;

public abstract class AbstractBaseDMListPlugin
extends AbstractBaseListPlugin {
    public ModelInfo getDiscModel() {
        Long id = this.getDiscModelId();
        ModelInfo modelInfo = ModelAdapter.getModelInfo((Long)id, (boolean)false);
        return modelInfo;
    }

    public DisModelTypeEnum getDisModelType() {
        ModelInfo modelInfo = new ModelStrategyEx(this.getDMModelId()).getModel().getModelInfo();
        return DisModelTypeEnum.getEnumByType((String)modelInfo.getModelType());
    }

    @Override
    public Long loadModelId() {
        Object model;
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"model") && (model = this.getPlugin().getView().getModel().getValue("model")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        if (this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)"modelbd") && (model = this.getPlugin().getView().getModel().getValue("modelbd")) instanceof DynamicObject) {
            return ((DynamicObject)model).getLong("id");
        }
        String modelId = this.getPlugin().getPageCache().get("dmmodelid");
        if (StringUtils.isEmpty((String)modelId)) {
            String string = modelId = this.getFormCustomParam("dmmodelid") == null ? "" : this.getFormCustomParam("dmmodelid").toString();
        }
        if (StringUtils.isEmpty((String)modelId) || "0".equals(modelId)) {
            return this.getUserSelect();
        }
        return Long.parseLong(modelId);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long id = this.getDiscModelId();
        if (LongUtil.isvalidLong((Object)id)) {
            String modelSign = this.getModelSign();
            if (StringUtils.isNotEmpty((String)modelSign) && this.getPlugin().getView().getModel().getDataEntityType().getProperties().containsKey((Object)modelSign)) {
                this.getModel().setValue(modelSign, (Object)id);
                ResultInfo resultInfo = new ModelStrategyEx(LongUtil.toLong((Object)id)).getModel().checkModel();
                if (!resultInfo.isSuccess().booleanValue()) {
                    this.getView().showErrorNotification(resultInfo.getMessage());
                }
            }
            this.getPageCache().put("dmmodelid", String.valueOf(this.getDMModelId()));
        }
    }

    @Override
    public String getCurModelNumber() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return "";
        }
        return new ModelStrategyEx(this.getDiscModelId()).getModel().getModelInfo().getNumber();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (Objects.equals(this.getModelSign(), key)) {
            ResultInfo resultInfo;
            DynamicObject modelDy = (DynamicObject)this.getModel().getValue(key);
            if (modelDy != null && !(resultInfo = new ModelStrategyEx(Long.valueOf(modelDy.getLong("id"))).getModel().checkModel()).isSuccess().booleanValue()) {
                this.getView().showErrorNotification(resultInfo.getMessage());
            }
            this.propertyChangedModelUse(Collections.emptyList());
        }
    }

    @Override
    public boolean isFIDM() {
        return true;
    }

    @Override
    public void checkPerm(String opkey) {
        String[] perm = this.getPerm(opkey);
        if (perm == null) {
            return;
        }
        String appType = ApplicationTypeEnum.FIDM.appnum;
        if (this.isFAR()) {
            appType = ApplicationTypeEnum.FAR.appnum;
        }
        this.doCheckPermission(perm[0], perm[1], this.getDiscModelId(), appType);
    }

    @Override
    public boolean isCurModelAdmin(Long modelId) {
        return MemberPermHelper.isFidmModelAdmin((Long)modelId, (String)this.getBizAppId());
    }

    @Override
    public void exportData(String entityName, QFilter[] qFilters, String filename) {
        if (qFilters.length == 0) {
            return;
        }
        if (StringUtils.isEmpty((String)filename)) {
            filename = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e", (String)"AbstractBaseListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]);
        }
        String entityNameImp = entityName + "_FIDM_IMPT";
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)entityNameImp), new QFilter("templatetype", "=", (Object)"IMPT").or(new QFilter("templatetype", "is null", null))};
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters, (String)"", (int)2);
        try {
            FormView formView = (FormView)this.getView();
            String routeAppId = formView.getFormShowParameter().getServiceAppId();
            DynamicObject[] dys = BusinessDataServiceHelper.loadFromCache((String)entityName, (QFilter[])qFilters).values().toArray(new DynamicObject[0]);
            String url = ExportUtil.export((DynamicObject[])dys, pkIds.get(0), (String)routeAppId, (String)entityName, (String)(filename + ".xlsx"));
            if (StringUtils.isNotEmpty((String)url)) {
                this.getClientViewProxy().addAction("download", (Object)url);
            }
        }
        catch (Exception e) {
            AbstractBaseListPlugin.log.info(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6a21\u677f\u662f\u5426\u5b58\u5728\u3002", (String)"AbstractBaseListPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0])), new Object[0]);
        }
    }

    protected void propertyChangedModelUse(List<String> dimKeys) {
        String dmmodelId = SingleMemberF7Util.getF7SelectId(this.getView(), this.getModelSign());
        if (dmmodelId == null) {
            this.getModel().setValue(this.getModelSign(), (Object)this.getPageCache().get("dmmodelid"));
        } else {
            if (dmmodelId.equals(this.getPageCache().get("dmmodelid"))) {
                return;
            }
            ThreadCache.put((Object)(CacheKey.PrefixString + CacheKey.USERMEMORY_KEY), (Object)LongUtil.toLong((Object)dmmodelId));
            this.getPageCache().put("dmmodelid", dmmodelId);
            ModelInfo modelInfo = ModelAdapter.getModelInfo((Long)this.getDiscModelId(), (boolean)false);
            if (modelInfo != null) {
                this.getPageCache().put("KEY_MODEL_ID", modelInfo.getModelId().toString());
            }
            SingleMemberF7Util.cacheModelPrem(this.getPageCache(), Long.valueOf(dmmodelId), this.getApplicationType());
            ApplicationTypeEnum applicationTypeEnum = this.getApplicationType();
            String appSign = applicationTypeEnum.getOIndex();
            UserMemoryUtil.saveUserMemory(this.getUserId(), LongUtil.toLong((Object)dmmodelId), appSign);
        }
    }

    @Override
    public String getModelSign() {
        return "model";
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.addAll(ModelUtil.getDmModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    protected boolean validator() {
        if (this.getDMModelId() <= 0L) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return false;
        }
        return true;
    }

    protected DynamicObjectCollection getTemplateCatalogByIds(List<Long> ids, String formId) {
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)formId, (String)"id,number,name", (QFilter[])new QFilter[]{filter});
        return collection;
    }

    protected void writeOpLog(OperationCategory category, OperationName opName, OperationResult result, String formId, Object ... params) {
        try {
            ModelInfo model = ModelAdapter.getModelInfo((Long)this.getDMModelId(), (boolean)false);
            if (Objects.isNull(model)) {
                return;
            }
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber()}).appendFormatParams(params).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            log.error("fidm log error", (Throwable)ex);
        }
    }

    protected void writeOpLog(OperationCategory category, OperationName opName, OperationResult result, String formId, Long modelId, Object ... params) {
        try {
            ModelInfo model = ModelAdapter.getModelInfo((Long)modelId, (boolean)false);
            AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildFormatParams(new Object[]{model.getNumber()}).appendFormatParams(params).buildOpResult(result);
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
        catch (Exception ex) {
            log.error("fidm log error", (Throwable)ex);
        }
    }

    protected void batchWriteOpLog(OperationCategory category, OperationName opName, OperationResult result, String formId, List<DynamicObject> dynList, String ... selectedField) {
        ModelInfo model = ModelAdapter.getModelInfo((Long)this.getDMModelId(), (boolean)false);
        if (model == null) {
            return;
        }
        AnalysisOpLogParam logParam = new AnalysisOpLogParam(dynList.size()).buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildOpResult(result);
        for (DynamicObject dyn : dynList) {
            if (Objects.isNull(selectedField) || selectedField.length == 0) {
                String dynNumber = dyn.getString("number") != null ? dyn.getString("number") : "";
                logParam.buildBatchFormatParams(new Object[]{model.getNumber(), dynNumber});
                continue;
            }
            Object[] array = new Object[2 + selectedField.length];
            array[0] = model.getNumber();
            array[1] = model.getName();
            for (int i = 0; i < selectedField.length; ++i) {
                String fieldStr = dyn.getString(selectedField[i]);
                array[2 + i] = fieldStr;
            }
            logParam.buildBatchFormatParams(array);
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
    }

    protected void batchWriteOpLogOrigin(OperationCategory category, OperationName opName, OperationResult result, String formId, List<Object[]> appendParamsList) {
        ModelInfo model = ModelAdapter.getModelInfo((Long)this.getDMModelId(), (boolean)false);
        if (model == null) {
            return;
        }
        AnalysisOpLogParam logParam = new AnalysisOpLogParam(appendParamsList.size()).buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildOpResult(result);
        for (Object[] appendParams : appendParamsList) {
            Object[] array = new Object[2 + appendParams.length];
            array[0] = model.getNumber();
            array[1] = model.getName();
            System.arraycopy(appendParams, 0, array, 2, appendParams.length);
            logParam.buildBatchFormatParams(array);
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
    }

    protected void batchWriteOpLogRows(OperationCategory category, OperationName opName, OperationResult result, String formId, ListSelectedRowCollection selectedRows) {
        ModelInfo model = ModelAdapter.getModelInfo((Long)this.getDMModelId(), (boolean)false);
        if (model == null) {
            return;
        }
        AnalysisOpLogParam logParam = new AnalysisOpLogParam(selectedRows.size()).buildOpCategory(category).buildOpName(opName).buildFormNumber(formId).buildAppId(this.getView()).buildOpResult(result);
        for (ListSelectedRow selectedRow : selectedRows) {
            logParam.buildBatchFormatParams(new Object[]{model.getNumber(), selectedRow.getNumber()});
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
    }
}

