/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.base.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.perm.BcmPermSingleModel;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.SingleF7TypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.oplog.IWatchableClickPlugin;
import kd.epm.far.common.common.oplog.IWatchableItemClickPlugin;
import kd.epm.far.common.common.util.ThreadCacheUtil;
import kd.epm.far.formplugin.common.base.BCMBaseFunction;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseListPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.proxy.PluginClickProxy;
import kd.epm.far.formplugin.common.proxy.PluginItemClickProxy;
import kd.epm.far.formplugin.common.util.BcmBasePluginUtil;
import kd.epm.far.formplugin.common.util.ModelUtil;

public abstract class AbstractBaseFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener,
BCMBaseFunction,
IWatchableClickPlugin,
IWatchableItemClickPlugin {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractBaseListPlugin.class);
    protected Map<String, SingleF7TypeEnum> map;

    public void initialize() {
        super.initialize();
        this.bcmInit();
        ThreadCacheUtil.putCurrentAppId((IFormView)this.getView());
        Optional.ofNullable(this.getView()).map(IFormView::getPageCache).ifPresent(pageCache -> pageCache.put("BOS.setRowDataByNumberDisable", "true"));
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(this.getModelSign());
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public String getPermEntityId() {
        return this.getView().getEntityId();
    }

    public void checkPerm(String opkey) {
        String[] perm = this.getPerm(opkey, this.getPermEntityId());
        if (perm == null) {
            return;
        }
        String bizAppId = this.getBizAppId();
        if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
            bizAppId = ApplicationTypeEnum.EB.appnum;
        }
        this.doCheckPermission(perm[0], perm[1], this.getModelId(), bizAppId);
    }

    public void checkPerm(String opkey, String entityId) {
        String[] perm = this.getPerm(opkey, entityId);
        if (perm == null) {
            return;
        }
        String bizAppId = this.getBizAppId();
        if (ApplicationTypeEnum.BGMD.appnum.equalsIgnoreCase(bizAppId)) {
            bizAppId = ApplicationTypeEnum.EB.appnum;
        }
        this.doCheckPermission(perm[0], perm[1], this.getModelId(), bizAppId);
    }

    protected String[] getPerm(String opkey, String entityId) {
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        Map map = (Map)permitem.get(entityId);
        if (map == null || map.get(opkey) == null) {
            return null;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return null;
        }
        return perm;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opkey = evt.getItemKey();
        if (!this.isEPM()) {
            this.checkPerm(opkey);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if (!this.isEPM()) {
            this.checkPerm(opkey);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        int is = BcmBasePluginUtil.checkPermission(this.getUserId(), this.getModelId(), AppMetadataCache.getAppInfo((String)this.getBizAppId()).getId(), this.getView().getEntityId(), "4715a0df000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((long)this.getUserId(), (String)String.valueOf(this.getModelId()))) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\u3002", (String)"AbstractBaseFormPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    public Lang getLang() {
        return RequestContext.get().getLang();
    }

    public <T> T getFormCustomParam(String key, T defaultVal) {
        return (T)(this.getFormCustomParam(key) == null ? defaultVal : this.getFormCustomParam(key));
    }

    public <T> T getFormCustomParam(FormShowParameter parameter, String key) {
        return (T)parameter.getCustomParam(key);
    }

    protected void propertyChangedModelUse(List<String> dimKeys) {
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public String getModelSign() {
        return "model";
    }

    public void returnDataToParent(Object obj) {
        this.getView().returnDataToParent((Object)this.toByteSerialized(obj));
    }

    public Object getReturnData(ClosedCallBackEvent closedCallBackEvent) {
        String seria = (String)closedCallBackEvent.getReturnData();
        Object obj = this.deSerializedBytes(seria);
        return obj;
    }

    protected boolean isGuideMenu() {
        return false;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && !this.isGuideMenu()) {
            if (StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        } else if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("currency")) {
            if (!this.isEntityContainsModel()) {
                return;
            }
            Object model = this.getModel().getValue(this.getModelSign());
            if (model == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb", (String)"AbstractBaseFormPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.add(new QFilter("number", "not in", (Object)new Object[]{"PC", "Currency"}));
                qFilterList.add(new QFilter("model", "=", ((DynamicObject)model).get("id")));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
    }

    private boolean isEntityContainsModel() {
        return this.getModel().getDataEntity(true).getDataEntityType().getProperties().containsKey((Object)this.getModelSign());
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.bcmPreOpen(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.bcmProChange(e);
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            this.getBcmEntityType(e);
        } else {
            super.getEntityType(e);
        }
    }

    public void destory() {
        super.destory();
    }

    public String getCurModelNumber() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return "";
        }
        return BCMMemberReader.findModelNumberById((Object)modelId);
    }

    public String getSourceKey() {
        return this.getBizEntityNumber();
    }

    public void addClickListeners(String ... keys) {
        for (String key : keys) {
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addClickListener((ClickListener)new PluginClickProxy(this));
        }
    }

    public void addItemClickListeners(String ... keys) {
        for (String key : keys) {
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addItemClickListener((ItemClickListener)new PluginItemClickProxy(this));
        }
    }
}

