/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.base.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.common.perm.BcmPermSingleModel;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.oplog.IWatchableClickPlugin;
import kd.epm.far.common.common.oplog.IWatchableItemClickPlugin;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ThreadCacheUtil;
import kd.epm.far.formplugin.common.base.BCMBaseFunction;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.model.DiscModelListPlugin;
import kd.epm.far.formplugin.common.proxy.PluginClickProxy;
import kd.epm.far.formplugin.common.proxy.PluginItemClickProxy;
import kd.epm.far.formplugin.common.util.ModelUtil;

public abstract class AbstractBaseListPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener,
BCMBaseFunction,
IWatchableClickPlugin,
IWatchableItemClickPlugin {
    protected static final String scenario = "scenario";
    protected static final String year = "year";
    protected static final String period = "period";
    protected static final String model = "model";
    protected static final String entity = "entity";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, AbstractBaseListPlugin.class);
    private boolean isPrint = false;

    public void initialize() {
        super.initialize();
        this.bcmInit();
        ThreadCacheUtil.putCurrentAppId((IFormView)this.getView());
        Optional.ofNullable(this.getView()).map(IFormView::getPageCache).ifPresent(pageCache -> pageCache.put("BOS.setRowDataByNumberDisable", "true"));
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LangListDataProvider());
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit;
        super.registerListener(e);
        if (this.getView().getClass().equals(FormView.class)) {
            this.addItemClickListeners("toolbarap");
        }
        if ((basedataEdit = (BasedataEdit)this.getControl(this.getModelSign())) != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.isSingleF7() && this.getControl("currency") instanceof BasedataEdit && (basedataEdit = (BasedataEdit)this.getControl("currency")) != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public boolean isSingleF7() {
        return false;
    }

    public String getModelSign() {
        return model;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setF7Disable();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opKey = evt.getItemKey();
        this.checkPerm(opKey);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        this.checkPerm(opkey);
    }

    public void checkPerm(String opkey) {
        String[] perm = this.getPerm(opkey);
        if (perm == null) {
            return;
        }
        this.doCheckPermission(perm[0], perm[1]);
    }

    protected String[] getPerm(String opkey) {
        Map map;
        opkey = this.getPermOpKey(opkey);
        Map permitem = BcmPermSingleModel.getInstance().getPermitem();
        if (this.getView().getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter parameter = (ListShowParameter)this.getView().getFormShowParameter();
            map = (Map)permitem.get(parameter.getBillFormId());
            if (map == null) {
                map = (Map)permitem.get(this.getPermEntity(this.getView().getEntityId()));
            }
        } else {
            map = (Map)permitem.get(this.getPermEntity(this.getView().getEntityId()));
        }
        if (map == null || map.get(opkey) == null) {
            return null;
        }
        String[] perm = ((String)map.get(opkey)).split("@");
        if (perm.length < 2) {
            return null;
        }
        return perm;
    }

    protected void doCheckPermission(String entityNum, String permItemId) {
        long modelId = this.getModelId();
        if (Objects.equals(modelId, 0L) && !(this instanceof DiscModelListPlugin)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.doCheckPermission(entityNum, permItemId, modelId, this.getBizAppId());
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.doCheckPermission(this.getView().getEntityId(), "4715a0df000000ac");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String entityId = this.getView().getEntityId();
        this.doCheckPermission(entityId, "47150e89000000ac");
    }

    public String getPermOpKey(String opKey) {
        return opKey;
    }

    public String getPermEntity(String entityId) {
        return entityId;
    }

    protected boolean validator() {
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        if (StringUtils.isEmpty((String)modelId) || !LongUtil.isvalidLong((Object)Long.parseLong(modelId))) {
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return false;
        }
        return true;
    }

    public String getBizEntityNumber() {
        return this.getModel().getDataEntityType().getName();
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(this.getModelSign()) && StringUtils.isNotEmpty((String)this.getModelSign()) && this.getControl(this.getModelSign()) != null) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            qFilterList.addAll(ModelUtil.getModelFilter(this.getView()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
        if (this.isSingleF7() && ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals("currency")) {
            Object modelDyn = this.getModel().getValue(this.getModelSign());
            if (modelDyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            if (beforeF7SelectEvent.getFormShowParameter() instanceof ListShowParameter) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(this.getModelSign())).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>();
                }
                qFilterList.add(new QFilter("number", "not in", (Object)new Object[]{"PC", "Currency"}));
                qFilterList.add(new QFilter(model, "=", ((DynamicObject)modelDyn).get("id")));
                showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.bcmPreOpen(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.bcmProChange(e);
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this instanceof DynamicPage) {
            this.getBcmEntityType(e);
        } else {
            super.getEntityType(e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    public void destory() {
        if (this.isPrint) {
            return;
        }
        super.destory();
        this.isPrint = true;
    }

    public String getCurModelNumber() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            return "";
        }
        String modelNumber = BCMMemberReader.findModelNumberById((Object)modelId);
        return StringUtils.isNull((String)modelNumber) ? "" : modelNumber;
    }

    public String getSourceKey() {
        return this.getBizEntityNumber();
    }

    public void addClickListeners(String ... keys) {
        for (String key : keys) {
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addClickListener((ClickListener)new PluginClickProxy(this));
        }
    }

    public void addItemClickListeners(String ... keys) {
        for (String key : keys) {
            Control c = this.getControl(key);
            if (!(c instanceof ISuportClick)) continue;
            ((ISuportClick)c).addItemClickListener((ItemClickListener)new PluginItemClickProxy(this));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
    }

    public static class LangListDataProvider
    extends ListDataProvider {
    }
}

