/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.base.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.far.business.common.control.tree.ITreeNode;
import kd.epm.far.formplugin.common.base.tree.ICEntityTreeNode;

public class ICEntityTreeBuilder {
    public static ICEntityTreeNode getICEntityTreeNode(DynamicObjectCollection rootNodeList) {
        return ICEntityTreeBuilder.getICEntityTreeRoot(rootNodeList);
    }

    private static ICEntityTreeNode getICEntityTreeRoot(DynamicObjectCollection rootNodeList) {
        HashMap<String, List<DynamicObject>> nodeMap = new HashMap<String, List<DynamicObject>>();
        HashSet<String> membIds = new HashSet<String>();
        rootNodeList.forEach(node -> membIds.add(node.getString("id")));
        membIds.add("0");
        for (DynamicObject node2 : rootNodeList) {
            ArrayList<DynamicObject> list;
            String parentId = node2.getString("parent");
            if (!membIds.contains(parentId)) {
                parentId = "-1";
            }
            if ((list = (ArrayList<DynamicObject>)nodeMap.get(parentId)) == null) {
                list = new ArrayList<DynamicObject>();
                nodeMap.put(parentId, list);
            }
            list.add(node2);
        }
        DynamicObject rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (DynamicObject)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null) {
            return null;
        }
        if (nodeMap.containsKey("-1")) {
            if (nodeMap.containsKey(rootNode.getString("id"))) {
                ((List)nodeMap.get(rootNode.getString("id"))).addAll((Collection)nodeMap.get("-1"));
            } else {
                nodeMap.put(rootNode.getString("id"), (List<DynamicObject>)nodeMap.get("-1"));
            }
        }
        return ICEntityTreeBuilder.createNode(rootNode, null, nodeMap);
    }

    private static ICEntityTreeNode createNode(DynamicObject map, ICEntityTreeNode parentNode, Map<String, List<DynamicObject>> nodeMap) {
        String id = map.getString("id");
        String name = map.getString("name");
        String number = map.getString("number");
        String storageType = map.getString("storagetype");
        ICEntityTreeNode curNode = new ICEntityTreeNode(id, name, number, storageType);
        List<DynamicObject> list = nodeMap.get(id);
        curNode.SetIsOpened(true);
        if (parentNode != null) {
            curNode.setParent((ITreeNode)parentNode);
            parentNode.addChild((ITreeNode<Object>)curNode);
        }
        if (list != null) {
            for (DynamicObject dnm : list) {
                ICEntityTreeBuilder.createNode(dnm, curNode, nodeMap);
            }
        }
        curNode.setName(curNode.getName() + "\uff08" + curNode.getNumber() + "\uff09");
        return curNode;
    }
}

