/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.config;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class DMConfigListPlugin
extends AbstractBaseDMFormPlugin
implements TabSelectListener,
RowClickEventListener {
    private static final String DMMODEL = "model";
    private static final String GLOBALPARAMETER = "globalparameter";
    private static final String LOCALPAAPMETER = "localparameter";
    private static final String KEY_PAGENAME = "KEY_PAGENAME";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DMConfigListPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl(DMMODEL);
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tab = (Tab)this.getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners("toolbarap");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{LOCALPAAPMETER});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DMMODEL});
        this.getPageCache().put(KEY_PAGENAME, GLOBALPARAMETER);
        this.refresh();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("close".equals(key)) {
            this.getView().close();
        } else if ("refresh".equals(key)) {
            this.refresh();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject curRow = this.getModel().getEntryRowEntity("entryentity", evt.getRow());
        if (curRow != null) {
            DMConfigServiceHelper.openEidtView((IFormView)this.getView(), (IFormPlugin)this, (Long)this.getSourceModelId(), (String)curRow.getString("number"));
        }
    }

    private void refresh() {
        boolean isAll = this.getPageCache().get(KEY_PAGENAME).equals(GLOBALPARAMETER);
        this.initEntryRows(isAll ? null : this.getOriginSourceModel());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("fidm_configsetting".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DMConfigListPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        this.getPageCache().put(KEY_PAGENAME, tabSelectEvent.getTabKey());
        this.getView().setVisible(Boolean.valueOf(LOCALPAAPMETER.equalsIgnoreCase(tabSelectEvent.getTabKey())), new String[]{DMMODEL});
        this.refresh();
    }

    private void initEntryRows(DynamicObject dmModel) {
        Long modelId = dmModel == null ? 0L : dmModel.getLong("id");
        DMConfigServiceHelper.repair();
        boolean hasPerm = PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)"fidm", (String)"fidm_configsettinglist");
        TableValueSetter ts = null;
        ArrayList list = DMConfigServiceHelper.getList((Long)modelId);
        if (!hasPerm) {
            list = new ArrayList(1);
        }
        if (list.size() > 0) {
            ts = new TableValueSetter(new String[0]);
            int index = 0;
            for (Map item : list) {
                ts.set("number", (Object)item.get("number").toString(), index);
                ts.set("name", (Object)item.get("name").toString(), index);
                ts.set("configname", (Object)item.get("configname").toString(), index);
                ts.set("description", (Object)item.get("description").toString(), index);
                ts.set("creator", (Object)item.get("creator").toString(), index);
                ts.set("createtime", (Object)((Date)item.get("createtime")), index);
                ts.set("modifier", (Object)item.get("modifier").toString(), index);
                ts.set("modifytime", (Object)((Date)item.get("modifytime")), index);
                ++index;
            }
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        if (ts != null) {
            model.batchCreateNewEntryRow("entryentity", ts);
        }
        model.setDataChanged(false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setPageIndex(1);
        entryGrid.clearEntryState();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
    }

    @Override
    public String getModelSign() {
        return DMMODEL;
    }
}

