/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetFilterVo;
import kd.epm.far.business.common.dataset.operatestrategy.IDataSetOperate;
import kd.epm.far.business.common.dataset.operatestrategy.QueryDataSetOperate;
import kd.epm.far.business.common.dataset.util.DatasetCheckUtil;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dataset.DatasetPopEbPlugin;
import kd.epm.far.formplugin.common.dataset.DatasetPopMergePlugin;
import kd.epm.far.formplugin.common.dataset.DatasetPopMetadataPlugin;
import kd.epm.far.formplugin.common.dataset.SEUtils;
import org.apache.commons.collections.CollectionUtils;

public class AbsDatasetPopEditPlugin
extends AbstractBaseDMFormPlugin
implements TreeNodeClickListener {
    protected static final String SOURCE_FROM = "sourcefrom";
    protected static final String MODEL_SELECT = "modelselect";
    protected static final String SHOW_NUMBER = "shownumber";
    protected static final String EXTEND_SELECT = "extendselect";
    protected static final String TEMPLATE_SELECT = "templateselect";
    protected static final String AREA_SELECT = "areaselect";
    protected static final String PAGE_DIM = "pageDim";
    protected static final String HIDE_DIM = "hideDim";
    protected static final String EXTENDS_MAP = "extendsMap";
    protected static final String EXTEND_LIST = "extendsList";
    protected static final String DIMENSION_MAP = "dimensionMap";
    protected static final String TREEVIEW_AP = "treeviewap";
    protected static final String ROOT = "root";
    protected static final String TREE_MAP = "treeMap";
    protected static final String TYPE_SELECT = "typeselect";
    protected static final String SPLITSYMBOL = "@";
    protected static final String MEMBERNAME = "&&membername";
    protected static final String MEMBERNUMBER = "&&membernumber";
    protected static final String EXTEND = "extend";
    protected static final String CUSTOM = "&&custom";
    protected static final String DATASET_DTO = "datasetDto";
    protected static final String PERM_CLASS = "permclass";
    protected static final String PERM_CLASS_ID = "permclass_id";
    protected static final String NUMBER_FIELD = "numberfield";
    protected static final String F7_KEY = "mutiF7";
    protected static final String TYPE_FIELD = "typefield";
    protected static final String NAME_FIELD = "namefield";
    protected static final String SHOW_FIELD = "showfield";
    protected static final String IGNORE_COLUMN = "ignoreColumn";
    protected static final String CONDITION_FIELD = "conditionfield";
    protected static final String PARAM_FIELD = "paramfield";
    protected static final String BTN_PREVIEW = "btnpreview";
    protected static final String BTN_OK = "btnok";
    protected static final String GROUPBY_FIELD = "groupbyfield";
    protected static final String DEF_VALUE_FIELD = "defvaluefield";
    protected static final String PARENT_FIELD = "parentfield";
    protected static final String RETURN_VALUE = "returnvalue";
    protected static final String FMONEY = "FMONEY";
    protected static final String FIDMMODEL = "fidmmodel";
    protected static final String METADATA_TYPE = "metadatatype";
    protected static final String ISC_METADATA = "iscmetadata";
    protected static final String RETURN_VALUES = "returnvalues";
    public static final String NUMTYPE = "kdfont kdfont-zhishitu2";
    public static final String TEXTTYPE = "kdfont kdfont-qushu2";
    public static final String SINGLE_FLEX = "singleflex";
    public static final String MUTI_FLEX = "mutiflex";
    public static List<DimMemberInfo> orgs = new ArrayList<DimMemberInfo>(12);
    protected static final String[] uncommonField = new String[]{"modelselect", "extendselect", "metadatatype", "iscmetadata", "treeviewap", "singleflex", "mutiflex", "groupbyfield", "returnvalue", "templateselect", "areaselect", "typeselect", "returnvalues"};
    protected IDataSetOperate dataSetOperate = new QueryDataSetOperate();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(TREEVIEW_AP);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(CONDITION_FIELD, BTN_PREVIEW, BTN_OK);
        BasedataEdit permclass = (BasedataEdit)this.getView().getControl(PERM_CLASS);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getDMModelId(), (String)FIDMMODEL, (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ISC_METADATA);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    protected boolean isSingle(DatasetDto dto) {
        return Objects.equals(DataSetTypeEnum.SINGLE_VALUED.getType(), dto.getType());
    }

    protected String buildCondition(List<DatasetFilterVo> filters) {
        if (CollectionUtils.isEmpty(filters)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (DatasetFilterVo filter : filters) {
            if (Objects.equals(filter.getCondition(), "in")) {
                sb.append(filter.getValue().replace(";", ",")).append(",");
                continue;
            }
            if (Objects.equals(filter.getCondition(), "like")) {
                sb.append("%").append(filter.getValue()).append(",");
                continue;
            }
            sb.append(filter.getCondition()).append(filter.getValue()).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    protected void setVisibleBySourceFrom() {
    }

    protected void setVisibleBySourceFrom(Set<String> fields) {
        for (String s : uncommonField) {
            if (fields.contains(s)) continue;
            this.getView().setVisible(Boolean.valueOf(false), new String[]{s});
        }
        this.getView().setVisible(Boolean.valueOf(true), fields.toArray(new String[0]));
    }

    protected DatasetDto commonAfterCreate() {
        DatasetDto dto = this.getDto();
        String sourceFrom = dto.getDataSrcType();
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(sourceFrom)) {
            sourceFrom = DataSrcTypeEnum.MERGE_MODEL.getType();
        }
        this.getView().getModel().setValue(SOURCE_FROM, (Object)sourceFrom);
        this.buildSourceComboEdit(dto);
        if (dto.isCm()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SOURCE_FROM, MODEL_SELECT});
        }
        this.paramHandler(DataSrcTypeEnum.getByType((String)dto.getDataSrcType()));
        if (!((Boolean)this.getFormCustomParam("needPermClass")).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PERM_CLASS});
        }
        this.getView().getModel().setValue("number", (Object)dto.getNumber());
        this.getView().getModel().setValue("name", (Object)dto.getNameStr());
        this.getView().getModel().setValue(PERM_CLASS_ID, (Object)dto.getPermClassId());
        if (OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            DynamicObject permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"fidm_dataset", (Long)dto.getId(), (Object)this.getDMModelId(), (String)FIDMMODEL, (String)"");
            if (permClassEntity != null) {
                Long permClassId = permClassEntity.getLong("permclass.id");
                this.getModel().setValue(PERM_CLASS, (Object)permClassId);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        if (Objects.equals(DataSetTypeEnum.SINGLE_VALUED.getType(), dto.getType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SHOW_FIELD});
        }
        return dto;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (!this.isCurPlugin()) {
            return;
        }
        Map treeMap = (Map)JSON.parseObject((String)this.getPageCache().get(TREE_MAP), (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){}, (Feature[])new Feature[0]);
        String number = evt.getNodeId().toString();
        String parentId = evt.getParentNodeId().toString();
        Map map = (Map)treeMap.get(number);
        Map parentMap = (Map)treeMap.get(parentId);
        String defaultParent = ROOT;
        if (Objects.equals(DataSrcTypeEnum.ISC_METADATA.getType(), this.getModel().getValue(SOURCE_FROM))) {
            defaultParent = "metadata";
        }
        if (Objects.nonNull(parentMap)) {
            this.addEntity((String)map.get("number"), (String)map.get("name"), (String)map.get(PARENT_FIELD), (String)parentMap.get("name"), (String)map.get("type"), null, true, null);
            if (Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode() + "", map.get("type"))) {
                this.addEntity((String)parentMap.get("number"), (String)parentMap.get("name"), (String)parentMap.get(PARENT_FIELD), null, (String)parentMap.get("type"), null, true, null);
            }
        } else {
            this.addEntity((String)map.get("number"), (String)map.get("name"), defaultParent, null, (String)map.get("type"), null, true, null);
        }
        this.buildReturnValueCombo();
    }

    protected void buildReturnValueCombo() {
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (!this.isCurPlugin()) {
            return;
        }
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        if (actionId.startsWith("fidm_dataset_pop") && Objects.nonNull(returnData)) {
            int rowIndex = Integer.parseInt(actionId.substring(actionId.lastIndexOf("_") + 1));
            this.getView().getModel().setValue(CONDITION_FIELD, (Object)returnData.toString(), rowIndex);
            this.getView().getModel().setValue(PARAM_FIELD, null, rowIndex);
            return;
        }
        if (actionId.startsWith(F7_KEY) && Objects.nonNull(returnData)) {
            int rowIndex = Integer.parseInt(actionId.substring(actionId.lastIndexOf("_") + 1));
            DynamicObject dataEntity = grid.getEntryData().getDataEntitys()[rowIndex];
            DynamicObjectCollection dys = (DynamicObjectCollection)returnData;
            if (CollectionUtils.isEmpty((Collection)dys)) {
                return;
            }
            int numberIndex = 2;
            int rangeIndex = 5;
            if ("SourceEntity".equals(dataEntity.getString(NUMBER_FIELD))) {
                orgs.clear();
                for (DynamicObject dy : dys) {
                    String number = dy.getString(numberIndex);
                    int range = dy.getInt(rangeIndex);
                    DimMemberInfo dimMemberInfo = new DimMemberInfo();
                    dimMemberInfo.setNumber(number);
                    dimMemberInfo.setRange(range);
                    orgs.add(dimMemberInfo);
                }
            }
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dy : dys) {
                String number = dy.getString(numberIndex);
                sb.append(number);
                int range = dy.getInt(rangeIndex);
                if (RangeEnum.VALUE_10.getValue() != range) {
                    sb.append(".").append(RangeEnum.getRangeByVal((int)range).getNumber());
                }
                sb.append(",");
            }
            if (sb.length() > 0) {
                this.getView().getModel().setValue(CONDITION_FIELD, (Object)sb.substring(0, sb.length() - 1), rowIndex);
                this.getView().getModel().setValue(PARAM_FIELD, null, rowIndex);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (!this.isCurPlugin()) {
            return;
        }
        super.beforeDeleteRow(e);
        if (e.getRowIndexs().length == 0) {
            return;
        }
        int index = e.getRowIndexs()[0];
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
        DynamicObject dataEntity = dataEntitys[index];
        if (Objects.equals(dataEntity.getString(NUMBER_FIELD), this.getModel().getValue(RETURN_VALUE))) {
            this.getModel().setValue(RETURN_VALUE, null);
        }
        if (!Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), dataEntity.getInt(TYPE_FIELD))) {
            return;
        }
        if (Arrays.stream(dataEntitys).anyMatch(t -> Objects.equals(t.get(PARENT_FIELD), dataEntity.get(NUMBER_FIELD)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u79fb\u9664\u4e3b\u5b9e\u4f53\u4e4b\u524d\u8bf7\u5148\u79fb\u9664\u4e0b\u65b9\u5b50\u8282\u70b9\u3002", (String)"DatasetConditionPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    protected List<DimensionInfo> getDimList(Long modelId) {
        return null;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        if (!this.isCurPlugin()) {
            return;
        }
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "conditionfield": {
                EntryGrid grid = (EntryGrid)this.getControl("entryentity");
                int index = grid.getSelectRows()[0];
                DynamicObject dataEntity = grid.getEntryData().getDataEntitys()[index];
                if (this.isDim(dataEntity.getInt(TYPE_FIELD), dataEntity.getString(PARENT_FIELD))) {
                    List<DimensionInfo> dimList = this.getDimList(LongUtil.toLong((Object)this.getModel().getValue(MODEL_SELECT)));
                    if ("SourceEntity".equals(dataEntity.getString(NUMBER_FIELD))) {
                        Optional<DimensionInfo> first = dimList.stream().filter(t -> StringUtils.equals((CharSequence)"Entity", (CharSequence)t.getNumber())).findFirst();
                        if (first.isPresent()) {
                            DimensionInfo dim = first.get();
                            this.openMutiF7(this.buildF7Member(dataEntity.getString(CONDITION_FIELD)), dim, index);
                            break;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u7ef4\u5ea6\u3002", (String)"AbsDatasetPopEditPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    }
                    Optional<DimensionInfo> first = dimList.stream().filter(t -> StringUtils.equals((CharSequence)dataEntity.getString(NUMBER_FIELD), (CharSequence)t.getNumber())).findFirst();
                    if (first.isPresent()) {
                        DimensionInfo dim = first.get();
                        this.openMutiF7(this.buildF7Member(dataEntity.getString(CONDITION_FIELD)), dim, index);
                        break;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8be5\u7ef4\u5ea6\u3002", (String)"AbsDatasetPopEditPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                Object value = this.getModel().getValue(CONDITION_FIELD, index);
                this.openConditionForm(index, dataEntity.getString(NAME_FIELD), value.toString());
                break;
            }
            case "btnpreview": {
                DatasetServiceHelper.openPreviewPage((IFormView)this.getView(), (IFormPlugin)this, (DatasetDto)this.buildDatasetDto());
                break;
            }
            case "btnok": {
                DatasetDto dto = this.buildDatasetDto();
                if (!dto.isSave()) {
                    this.getView().setReturnData((Object)SerializationUtils.toJsonString((Object)dto));
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)dto));
                    this.getView().close();
                    break;
                }
                DatasetUtil.checkCondition((DatasetDto)dto);
                DatasetCheckUtil.valid((DatasetDto)dto, (boolean)LongUtil.isValidLong((Object)dto.getExtendsModelId()));
                OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
                if (OperationStatus.EDIT.equals((Object)operationStatus)) {
                    DatasetServiceHelper.editDataset((DatasetDto)dto, (IDataModel)this.getModel());
                } else {
                    DatasetServiceHelper.checkDatasetNumber((String)dto.getNumber(), (long)this.getDMModelId(), (long)0L);
                    DatasetServiceHelper.addDataset((DatasetDto)dto, (IDataModel)this.getModel());
                }
                this.getView().close();
                break;
            }
        }
    }

    protected boolean isDim(Object type, String parent) {
        return Boolean.FALSE;
    }

    private List<Map<String, String>> buildF7Member(String condition) {
        String[] split;
        if (StringUtils.isBlank((CharSequence)condition)) {
            return Collections.emptyList();
        }
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)16);
        for (String s : split = condition.split(",")) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            if (s.contains(".")) {
                int i = s.lastIndexOf(".");
                String member = s.substring(0, i);
                String range = s.substring(i + 1);
                if (DatasetExpressionHelper.RANGE_NUMBER_SET.contains(range)) {
                    map.put("number", member);
                    RangeEnum rangeByNumber = RangeEnum.getRangeByNumber((String)range);
                    if (Objects.nonNull(rangeByNumber)) {
                        map.put("range", rangeByNumber.getValue() + "");
                    }
                } else {
                    map.put("number", s);
                    map.put("range", RangeEnum.VALUE_10.getValue() + "");
                }
            } else {
                map.put("number", s);
                map.put("range", RangeEnum.VALUE_10.getValue() + "");
            }
            returnList.add(map);
        }
        return returnList;
    }

    protected void openMutiF7(List<Map<String, String>> memberNumbers, DimensionInfo dim, Integer index) {
    }

    private String getValueWithOutCondition(String s, String qcp) {
        if (s.length() <= qcp.length()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"'%s'\u6761\u4ef6\u8bf7\u8bbe\u7f6e\u5177\u4f53\u503c\u3002", (String)"DatasetConditionPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), s));
        }
        return s.substring(qcp.length());
    }

    protected List<DatasetFilterVo> buildFilter(String condition) {
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)16);
        String[] split = condition.split(",");
        StringBuilder inBuilder = new StringBuilder();
        for (String s : split) {
            String value;
            if (s.startsWith("=")) {
                value = this.getValueWithOutCondition(s, "=");
                returnList.add(new DatasetFilterVo("=", value));
                continue;
            }
            if (s.startsWith(">=")) {
                value = this.getValueWithOutCondition(s, ">=");
                returnList.add(new DatasetFilterVo(">=", value));
                continue;
            }
            if (s.startsWith("<=")) {
                value = this.getValueWithOutCondition(s, "<=");
                returnList.add(new DatasetFilterVo("<=", value));
                continue;
            }
            if (s.startsWith(">")) {
                value = this.getValueWithOutCondition(s, ">");
                returnList.add(new DatasetFilterVo(">", value));
                continue;
            }
            if (s.startsWith("<")) {
                value = this.getValueWithOutCondition(s, "<");
                returnList.add(new DatasetFilterVo("<", value));
                continue;
            }
            if (s.startsWith("%")) {
                value = this.getValueWithOutCondition(s, "%");
                returnList.add(new DatasetFilterVo("like", value));
                continue;
            }
            inBuilder.append(s).append(";");
        }
        if (StringUtils.isNotBlank((CharSequence)inBuilder)) {
            returnList.add(new DatasetFilterVo("in", inBuilder.substring(0, inBuilder.length() - 1)));
        }
        return returnList;
    }

    private DatasetDto buildDatasetDto() {
        DatasetDto dto = this.getDto();
        IDataModel model = this.getModel();
        dto.setName(model.getValue("name"));
        dto.setNumber((String)model.getValue("number"));
        dto.setPermClassId(LongUtil.toLong((Object)model.getValue(PERM_CLASS_ID)));
        dto.setDataSrcType((String)model.getValue(SOURCE_FROM));
        if (Objects.nonNull(model.getValue("name"))) {
            dto.setNameStr(model.getValue("name").toString());
        }
        if (this.isSingle(dto)) {
            dto.setDefValue((String)model.getValue(DEF_VALUE_FIELD));
            dto.setValue((String)model.getValue(RETURN_VALUE));
            dto.setType(DataSetTypeEnum.SINGLE_VALUED.getType());
        }
        this.buildDatasetDto(dto);
        return dto;
    }

    protected void buildDatasetDto(DatasetDto dto) {
    }

    protected DatasetDto getDto() {
        DatasetDataVo datasetDataVo;
        String formCustomParam = (String)this.getFormCustomParam(DATASET_DTO);
        DatasetDto dto = (DatasetDto)SerializationUtils.fromJsonString((String)formCustomParam, DatasetDto.class);
        if (StringUtils.isNotEmpty((CharSequence)dto.getData()) && Objects.nonNull((datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0])).getTemplate())) {
            dto.setTemplateId(datasetDataVo.getTemplate().getTemplateId());
            dto.setArea(datasetDataVo.getTemplate().getArea());
        }
        return dto;
    }

    protected void initTypeComboEdit(String datasetSrcType) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(TYPE_SELECT);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)3);
        items.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.DEFAULT.getName()), DatasetModelTypeEnum.DEFAULT.getIndex()));
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(datasetSrcType) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(datasetSrcType)) {
            items.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.EXTEND.getName()), DatasetModelTypeEnum.EXTEND.getIndex()));
            if (!this.isSingle(this.getDto())) {
                items.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.TEMPLATE.getName()), DatasetModelTypeEnum.TEMPLATE.getIndex()));
            }
        }
        comboEdit.setComboItems((List)items);
    }

    private void buildSourceComboEdit(DatasetDto dto) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(SOURCE_FROM);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.MERGE_MODEL.getName()), DataSrcTypeEnum.MERGE_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.RPT_MODEL.getName()), DataSrcTypeEnum.RPT_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.ISC_METADATA.getName()), DataSrcTypeEnum.ISC_METADATA.getType()));
        comboEdit.setComboItems(items);
    }

    protected void buildModelComboEdit(List<DynamicObject> models) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(MODEL_SELECT);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)models.size());
        if (CollectionUtils.isEmpty(models)) {
            comboEdit.setComboItems((List)items);
            return;
        }
        models.forEach(dynamicObject -> items.add(new ComboItem(new LocaleString(dynamicObject.getString(SHOW_NUMBER) + " " + dynamicObject.getString("name")), dynamicObject.getString("id"))));
        comboEdit.setComboItems((List)items);
    }

    protected List<TreeNode> initTreeNode(List<DimensionInfo> dimInfoList, List<Tuple<String, String, String>> extendsList, List<DynamicObject> propertyDys) {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId(ROOT);
        root.isDisabled();
        tree.addNode(root);
        ArrayList allTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        HashMap treeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DimensionInfo dimInfo : dimInfoList) {
            List<TreeNode> treeNodeList = this.createDimensionNode(dimInfo, propertyDys, root, treeMap);
            allTreeNodeList.addAll(treeNodeList);
        }
        if (CollectionUtils.isNotEmpty(extendsList)) {
            DimensionInfo seDimensionInfo = SEUtils.getSEDimensionInfo();
            List<TreeNode> dimensionNode = this.createDimensionNode(seDimensionInfo, (List<DynamicObject>)new DynamicObjectCollection(), root, treeMap);
            allTreeNodeList.addAll(dimensionNode);
            List<TreeNode> extendNode = this.createExtendNode(extendsList, root, treeMap);
            allTreeNodeList.addAll(extendNode);
        }
        tree.addNode(root);
        tree.updateNode(root);
        tree.expand(ROOT);
        this.getPageCache().put(TREE_MAP, JSON.toJSONString((Object)treeMap));
        return allTreeNodeList;
    }

    private List<TreeNode> createExtendNode(List<Tuple<String, String, String>> extendsList, TreeNode root, Map<String, Map<String, String>> treeMap) {
        ArrayList treeNodeList = Lists.newArrayListWithExpectedSize((int)extendsList.size());
        extendsList.forEach(tuple -> {
            String number = (String)tuple.p1;
            String name = (String)tuple.p2;
            String type = (String)tuple.p3;
            String coin = NUMTYPE;
            if ("text".equals(type)) {
                coin = TEXTTYPE;
            }
            TreeNode extendChildNode = new TreeNode();
            extendChildNode.setId(number);
            extendChildNode.setText(name);
            extendChildNode.setIcon(coin);
            extendChildNode.setParentid(EXTEND);
            treeMap.put(number, this.buildTreeMap(number, name, ColumnTypeEnum.MEASURE.getCode(), ROOT));
            treeNodeList.add(extendChildNode);
            root.addChild(extendChildNode);
        });
        return treeNodeList;
    }

    private List<TreeNode> createDimensionNode(DimensionInfo dimInfo, List<DynamicObject> memberProperties, TreeNode root, Map<String, Map<String, String>> treeMap) {
        String dimName = dimInfo.getName();
        String dimShortNumber = dimInfo.getShortNumber();
        ArrayList treeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        TreeNode dimensionNode = BCMTreeUtils.createTreeNode((String)dimInfo.getNumber(), (String)dimName, (String)dimShortNumber, (String)ROOT);
        treeMap.put(dimInfo.getNumber(), this.buildTreeMap(dimInfo.getNumber(), dimName, ColumnTypeEnum.FIXED_COLUMN.getCode(), ROOT));
        dimensionNode.setIcon(TEXTTYPE);
        treeNodeList.add(dimensionNode);
        String localName = ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataSetDisplayPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]);
        String dimNumber = dimInfo.getNumber();
        String nameId = this.generateCustomTreeNodeId("name", dimNumber, ColumnTypeEnum.FIXED_COLUMN.getCode());
        TreeNode dimensionChildNmaeNode = BCMTreeUtils.createTreeNode((String)nameId, (String)localName, (String)(dimShortNumber + MEMBERNAME), (String)dimNumber);
        treeMap.put(nameId, this.buildTreeMap("name", localName, ColumnTypeEnum.FIXED_COLUMN.getCode(), dimInfo.getNumber()));
        dimensionChildNmaeNode.setIcon(TEXTTYPE);
        treeNodeList.add(dimensionChildNmaeNode);
        dimensionNode.addChild(dimensionChildNmaeNode);
        String localNumber = ResManager.loadKDString((String)"\u7f16\u7801", (String)"DataSetDisplayPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]);
        String numberId = this.generateCustomTreeNodeId("number", dimNumber, ColumnTypeEnum.FIXED_COLUMN.getCode());
        TreeNode dimensionChildNumberNode = BCMTreeUtils.createTreeNode((String)numberId, (String)localNumber, (String)(dimShortNumber + MEMBERNUMBER), (String)dimNumber);
        treeMap.put(numberId, this.buildTreeMap("number", localNumber, ColumnTypeEnum.FIXED_COLUMN.getCode(), dimInfo.getNumber()));
        dimensionChildNumberNode.setIcon(TEXTTYPE);
        treeNodeList.add(dimensionChildNumberNode);
        dimensionNode.addChild(dimensionChildNumberNode);
        memberProperties.forEach(memberProperty -> {
            String curDimNumber = memberProperty.getString("dimension.number");
            if (curDimNumber.equals(dimNumber)) {
                String name = memberProperty.getString("name");
                String number = memberProperty.getString("number");
                String customId = this.generateCustomTreeNodeId(number, dimNumber, ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode());
                TreeNode memberPropertyNode = BCMTreeUtils.createTreeNode((String)customId, (String)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027 - %s", (String)"DataSetDisplayPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[]{name}), (String)(dimShortNumber + CUSTOM), (String)dimNumber);
                memberPropertyNode.setIcon(TEXTTYPE);
                treeMap.put(customId, this.buildTreeMap(customId, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5c5e\u6027 - %s", (String)"DataSetDisplayPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[]{name}), ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode(), dimInfo.getNumber()));
                treeNodeList.add(memberPropertyNode);
                dimensionNode.addChild(memberPropertyNode);
            }
        });
        root.addChild(dimensionNode);
        return treeNodeList;
    }

    protected Map<String, String> buildTreeMap(String number, String name, int type, String parent) {
        return this.buildTreeMap(number, name, type + "", parent);
    }

    protected Map<String, String> buildTreeMap(String number, String name, String type, String parent) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("number", number);
        map.put("name", name);
        map.put("type", type);
        map.put(PARENT_FIELD, parent);
        return map;
    }

    protected void clearEntity() {
        this.getModel().deleteEntryData("entryentity");
    }

    protected void clearTree() {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEW_AP);
        tree.deleteAllNodes();
    }

    protected void clearValue(String ... params) {
        for (String param : params) {
            this.getModel().setValue(param, null);
        }
    }

    protected void addEntity(String number, String name, String parent, String parentName, String columnType, String condition, boolean showColumn, String param) {
        this.addEntity(number, name, parent, parentName, columnType, condition, showColumn, param, true);
    }

    protected void addEntity(String number, String name, String parent, String parentName, String columnType, String condition, boolean showColumn, String param, boolean isEnable) {
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] dataEntitys = entryEntity.getEntryData().getDataEntitys();
        if (Arrays.stream(dataEntitys).anyMatch(t -> Objects.equals(t.getString(NUMBER_FIELD), number) && Objects.equals(t.getString(PARENT_FIELD), parent))) {
            return;
        }
        this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue(NUMBER_FIELD, (Object)number, dataEntitys.length);
        if (StringUtils.isNotBlank((CharSequence)parentName)) {
            String curName = parentName + "-" + name;
            this.getModel().setValue(NAME_FIELD, (Object)curName, dataEntitys.length);
        } else {
            this.getModel().setValue(NAME_FIELD, (Object)name, dataEntitys.length);
        }
        this.getModel().setValue(PARENT_FIELD, (Object)parent, dataEntitys.length);
        this.getModel().setValue(TYPE_FIELD, (Object)columnType, dataEntitys.length);
        this.getModel().setValue(CONDITION_FIELD, (Object)condition, dataEntitys.length);
        this.getModel().setValue(SHOW_FIELD, (Object)showColumn, dataEntitys.length);
        this.getModel().setValue(PARAM_FIELD, (Object)param, dataEntitys.length);
        if (!this.isDim(columnType, parent) || "SourceEntity".equals(number)) {
            this.getView().setEnable(Boolean.valueOf(false), dataEntitys.length, new String[]{PARAM_FIELD});
        }
        if (!isEnable) {
            this.getView().setEnable(Boolean.valueOf(false), dataEntitys.length, new String[]{PARAM_FIELD});
            this.getView().setEnable(Boolean.valueOf(false), dataEntitys.length, new String[]{CONDITION_FIELD});
        }
    }

    protected void openConditionForm(Integer index, String name, String condition) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_dataset_condition");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(CONDITION_FIELD, (Object)condition);
        fsp.setCustomParam("name", (Object)name);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fidm_dataset_pop_" + index));
        this.getView().showForm(fsp);
    }

    protected String generateCustomTreeNodeId(String number, String source, Integer type) {
        StringBuilder generateRule = new StringBuilder();
        generateRule.append(number);
        generateRule.append(SPLITSYMBOL);
        generateRule.append(source);
        generateRule.append(SPLITSYMBOL);
        generateRule.append(type);
        return generateRule.toString();
    }

    protected void paramHandler(DataSrcTypeEnum typeEnum) {
        if (DataSrcTypeEnum.ISC_METADATA == typeEnum) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PARAM_FIELD});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PARAM_FIELD});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.isCurPlugin()) {
            return;
        }
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        switch (propertyName) {
            case "sourcefrom": {
                this.clearEntity();
                this.clearTree();
                break;
            }
            case "paramfield": {
                if (StringUtils.isBlank((Object)value)) break;
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int index = entryGrid.getSelectRows()[0];
                this.getModel().setValue(CONDITION_FIELD, null, index);
            }
        }
    }

    protected boolean isCurPlugin() {
        String value = (String)this.getModel().getValue(SOURCE_FROM);
        if (this instanceof DatasetPopMergePlugin) {
            return DataSrcTypeEnum.MERGE_MODEL.getType().equals(value) || DataSrcTypeEnum.RPT_MODEL.getType().equals(value) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(value);
        }
        if (this instanceof DatasetPopMetadataPlugin) {
            return DataSrcTypeEnum.ISC_METADATA.getType().equals(value);
        }
        if (this instanceof DatasetPopEbPlugin) {
            return DataSrcTypeEnum.EB_MODEL.getType().equals(value);
        }
        return false;
    }
}

