/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.common.dataset.dto.CheckTreeNodeInfo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DimInfo;
import kd.epm.far.business.common.dataset.operatestrategy.IDataSetOperate;
import kd.epm.far.business.common.dataset.operatestrategy.QueryDataSetOperate;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dataset.DataSetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.SEUtils;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;
import org.apache.commons.collections.CollectionUtils;

public class AbstractDatasetDisplayPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage,
TreeNodeCheckListener,
IConfirmCallBack {
    public static final String CTL_CUSTOMCONTROLAP = "customcontrolap";
    public static final String MONEY = "FMONEY";
    public static final String MODELSELECT = "modelselect";
    public static final String TYPE_SELECT = "typeselect";
    public static final String EXTENDMODELSELECT = "extendmodelselect";
    public static final String BCMISCDATA = "bcmiscdata";
    public static final String SINGLEVALUE = "singlevalue";
    public static final String MULVALUE = "mulvalue";
    public static final String SINGLEVALSELECT = "singlevalselect";
    public static final String DIMDEFAULTVALUE = "dimdefaultvalue";
    public static final String EBDATASET = "ebdataset";
    public static final String ORDERFIELD = "orderfield";
    public static final String GROUPBY = "groupby";
    public static final String ORDERBY = "orderby";
    public static final String TOPFIELD = "topfield";
    public static final String DETAILFIELD = "detailfield";
    public static final String TEXTAREAFIELD = "textareafield";
    public static final String METADATATYPE = "metadatatype";
    public static final String TEMPLATE = "template";
    public static final String AREA = "area";
    public static final String SINGLEEXTENDVAL = "singleextendval";
    public static final String ISCMETADATA = "iscmetadata";
    public static final String ISCMETADATA_ID = "iscmetadata_id";
    public static final String CATEGORYID = "categoryid";
    public static final String VOUCHER = "voucher";
    public static final String VOUCHER_TYPE = "vouchertype";
    public static final String ISCOPY = "isCopy";
    public static final String LIMITCOUNT = "limitCount";
    public static final String[] FUNCTIONVISIBLE = new String[]{"groupby", "orderfield", "orderby", "topfield"};
    public static final String[] OPERATEFROM = new String[]{"propertychanged", "treenodecheck"};
    public static final String MODELSELECTCALLBACK = "modelselectcallback";
    public static final String RESETCONFIRM = "resetconfirm";
    public static final String ATTRTREEPANEL = "attrtreepanel";
    public static final String FIELDPANELAP = "fieldpanelap";
    public IDataSetOperate dataSetOperate = new QueryDataSetOperate();
    public DatasetDimService fidmDimService = new DatasetDimService();
    public DatasetDto dataSetDtoAfterNew = new DatasetDto();
    public static final String INITDIMINFOCACHE = "diminfocache";
    public static final String RESETSTATUS = "resetstatus";
    public static final String EXISTEXTEDNMODELITEMCACHE = "existextednmodelitem";
    public static final String EXTENDNUMTYPE = "extendnumbertype";
    public static final String METANUMTYPE = "metanumtype";
    public static final String RESULT = "result";
    public static final String INIT = "init";
    public static final String PROPERTYCHANGED = "propertychanged";
    public static final String DATASETTABLEFLEXPANELAP = "datasettableflexpanelap";
    public static final String TREEVIEWAP = "treeviewap";
    public static final String ROOTNODECACHE = "rootnode";
    public static final String EXTENDS_MAP = "extendsMap";
    public static final String DIMENSION_MAP = "dimensionMap";
    public static final String SAVEDATASET = "savedataset";
    public static final String QUERYBUTTON = "querybutton";
    public static final String GLOBALVARSELECT = "globalvarselect";
    public static final String SORTEDDIMID = "sorteddimid";
    public static final String IS_CHECKED = "isChecked";
    public static final String CHECKED_NODES = "checkedNodes";
    public static final String CLICK_NODE_ID = "clickNodeId";
    public static final String PROP_ENTRYENTITY = "prop_entryentity";
    public static final String PROP_NAME = "prop_name";
    public static final String PROP_LABEL = "prop_label";
    public static final String DATA_TYPE = "data_type";
    public static final String DATA_SCHEMA = "data_schema";
    public static final String PAGE_DIM = "pageDim";
    public static final String HIDE_DIM = "hideDim";
    public static final String VAR_SELECT = "VAR_SELECT";
    public static final String TEMPLATE_DIMS_CACHE = "TEMPLATE_DIMS_CACHE";
    public static WatchLogger LOGGER = BcmLogFactory.getWatchLogInstance(DataSetDisplayPlugin.class);
    public Map<String, String> extSelects = null;
    public static final Set<String> METADATANUMTYPE = Sets.newHashSet((Object[])new String[]{"decimal", "integer"});
    public static final Set<String> TABLENUMTYPE = Sets.newHashSet((Object[])new String[]{"bigint", "int", "decimal"});
    public static final Set<String> VOUCHER_MEASURE_TYPE_SET = Sets.newHashSet((Object[])new String[]{"int", "bigint", "long", "integer", "decimal"});
    public static final String DECIMAL = "decimal";
    public static final String NUMTYPE = "kdfont kdfont-zhishitu2";
    public static final String F7_KEY = "f7_key";
    public static final String[] visibleFields = new String[]{"singlevalselect", "modelselect", "extendmodelselect", "ebdataset", "metadatatype", "iscmetadata", "template", "area", "groupby", "orderfield", "orderby", "topfield", "singlevalue", "dimdefaultvalue", "attrtreepanel", "mulvalue", "singleextendval", "typeselect", "vouchertype", "voucher", "bcmiscdata"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners("buttontoolbarap", "toolbarap", "advcontoolbarap");
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterBindData(EventObject e) {
        this.setVisibleWithSource();
        if (LongUtil.isvalidLong((Object)this.getModel().getValue(TEMPLATE))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TEMPLATE, AREA});
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    protected void setVisibleWithSource() {
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        if (Objects.equals(dataSrcType, DataSrcTypeEnum.MERGE_MODEL.getType()) && DatasetModelTypeEnum.TEMPLATE.getIndex().equals(this.getModel().getValue(TYPE_SELECT))) {
            dataSrcType = DataSrcTypeEnum.CM_TEMPLATE.getType();
        }
        DataSrcTypeEnum type = DataSrcTypeEnum.getByType((String)dataSrcType);
        String dataSetType = (String)this.getFormCustomParam("dataset_type");
        this.getView().setVisible(Boolean.FALSE, visibleFields);
        switch (type) {
            case MERGE_MODEL: {
                Object extendModelSelect;
                this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, MODELSELECT, TYPE_SELECT});
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    if (!DatasetModelTypeEnum.INTEGRATION.getIndex().equals(this.getModel().getValue(TYPE_SELECT))) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{DIMDEFAULTVALUE});
                    }
                    if (Objects.isNull(extendModelSelect = this.getModel().getValue(EXTENDMODELSELECT)) || StringUtils.isBlank((Object)extendModelSelect)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEVALUE});
                    } else {
                        this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEEXTENDVAL});
                    }
                } else if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, FUNCTIONVISIBLE);
                    extendModelSelect = this.getModel().getValue(EXTENDMODELSELECT);
                    if (Objects.isNull(extendModelSelect) || StringUtils.isBlank((Object)extendModelSelect)) {
                        this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEVALUE});
                    }
                }
                if (!Objects.nonNull(this.getModel().getValue(TYPE_SELECT))) break;
                String typeSelect = (String)this.getModel().getValue(TYPE_SELECT);
                if (DatasetModelTypeEnum.EXTEND.getIndex().equals(typeSelect)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{EXTENDMODELSELECT});
                }
                if (!DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{SINGLEVALUE});
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEVALSELECT});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, MULVALUE, GROUPBY, ORDERFIELD, ORDERBY, TOPFIELD});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{BCMISCDATA});
                break;
            }
            case RPT_MODEL: {
                this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, MODELSELECT, SINGLEVALUE});
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{DIMDEFAULTVALUE});
                    break;
                }
                if (!DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) break;
                this.getView().setVisible(Boolean.TRUE, FUNCTIONVISIBLE);
                break;
            }
            case EB_MODEL: {
                this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, MODELSELECT, EBDATASET, SINGLEVALUE});
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{DIMDEFAULTVALUE});
                    break;
                }
                if (!DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) break;
                this.getView().setVisible(Boolean.TRUE, FUNCTIONVISIBLE);
                break;
            }
            case ISC_METADATA: {
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEVALSELECT});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, METADATATYPE, ISCMETADATA, MULVALUE, GROUPBY, ORDERFIELD, ORDERBY, TOPFIELD});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, METADATATYPE, ISCMETADATA});
                break;
            }
            case EPM_VOUCHER: {
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEVALSELECT});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, VOUCHER_TYPE, VOUCHER, MULVALUE, GROUPBY, ORDERFIELD, ORDERBY, TOPFIELD});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, VOUCHER_TYPE, VOUCHER});
                break;
            }
            case CM_TEMPLATE: {
                this.getView().setVisible(Boolean.TRUE, new String[]{MODELSELECT, TEMPLATE, AREA, TYPE_SELECT});
                break;
            }
            case BCM_ISC_METADATA: {
                this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, MODELSELECT, TYPE_SELECT});
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{SINGLEVALSELECT});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{ATTRTREEPANEL, MULVALUE, GROUPBY, ORDERFIELD, ORDERBY, TOPFIELD});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{BCMISCDATA});
            }
        }
    }

    protected void changeModelSelectCaption(String sourceFrom) {
        ComboEdit dataSrcIdComboEdit = (ComboEdit)this.getControl(MODELSELECT);
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType((String)sourceFrom);
        if (Objects.isNull(typeEnum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u6e90\u7c7b\u578b,\u6682\u4e0d\u652f\u6301\u3002", (String)"DatasetSingleNewPlugin_56", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        switch (typeEnum) {
            case MERGE_MODEL: 
            case CM_TEMPLATE: {
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u5e76\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0])));
                break;
            }
            case RPT_MODEL: {
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_58", (String)"epm-far-formplugin", (Object[])new Object[0])));
                break;
            }
            case EB_MODEL: {
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_55", (String)"epm-far-formplugin", (Object[])new Object[0])));
                break;
            }
        }
    }

    protected void setModelValueNull() {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        tree.deleteAllNodes();
        this.getModel().setValue(MODELSELECT, null);
        this.getModel().setValue(TEXTAREAFIELD, null);
        this.getModel().setValue(METADATATYPE, null);
        this.getModel().setValue(TEMPLATE, null);
        this.getModel().setValue(AREA, null);
        BasedataEdit iscMetadata = (BasedataEdit)this.getControl(ISCMETADATA);
        if (Objects.nonNull(iscMetadata)) {
            this.getModel().setValue(ISCMETADATA, null);
            this.getModel().setValue(SINGLEVALSELECT, null);
        }
        if (Objects.nonNull(this.getModel().getValue(EXTENDMODELSELECT))) {
            this.getModel().setValue(EXTENDMODELSELECT, null);
        }
        if (Objects.nonNull(this.getModel().getValue(MULVALUE))) {
            this.getModel().setValue(MULVALUE, null);
        }
        if (Objects.nonNull(this.getModel().getValue(GROUPBY))) {
            this.getModel().setValue(GROUPBY, null);
        }
        if (Objects.nonNull(this.getModel().getValue(ORDERBY))) {
            this.getModel().setValue(ORDERBY, null);
        }
        if (Objects.nonNull(this.getModel().getValue(TOPFIELD))) {
            this.getModel().setValue(TOPFIELD, null);
        }
        if (Objects.nonNull(this.getModel().getValue(SINGLEEXTENDVAL))) {
            this.getModel().setValue(SINGLEEXTENDVAL, null);
        }
    }

    protected DatasetDto createDataSetDao(String eventArgs) {
        String varSelect;
        DatasetDto datasetDto = new DatasetDto();
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
            Long iscMetadataId = (Long)this.getModel().getValue(ISCMETADATA_ID);
            datasetDto.setMetadataId(iscMetadataId);
            String metadataType = (String)this.getModel().getValue(METADATATYPE);
            datasetDto.setMetadataType(metadataType);
        }
        if (DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) {
            DynamicObject voucher = (DynamicObject)this.getModel().getValue(VOUCHER);
            datasetDto.setVoucherId(Long.valueOf(voucher.getLong("id")));
            String voucherNumber = voucher.getString("number");
            datasetDto.setVoucherNumber(voucherNumber);
            String index = (String)this.getModel().getValue(VOUCHER_TYPE);
            datasetDto.setVoucherType(index);
            datasetDto.setDataSrcId(Long.valueOf(voucher.getLong("id")));
        }
        if (Objects.nonNull(this.getModel().getValue(TYPE_SELECT))) {
            String typeSelect = (String)this.getModel().getValue(TYPE_SELECT);
            if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
                if (Objects.nonNull(this.getModel().getValue(BCMISCDATA))) {
                    DynamicObject bcmISCData = (DynamicObject)this.getModel().getValue(BCMISCDATA);
                    Long id = bcmISCData.getLong("id");
                    datasetDto.setMetadataId(id);
                    String type = bcmISCData.getString("type");
                    datasetDto.setMetadataType(type);
                } else {
                    datasetDto.setMetadataType("0");
                }
            }
        }
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(sourceFrom) && DatasetModelTypeEnum.TEMPLATE.getIndex().equals(this.getModel().getValue(TYPE_SELECT))) {
            Long templateId = LongUtil.toLong((Object)this.getModel().getValue(TEMPLATE));
            datasetDto.setTemplateId(templateId);
            String area = (String)this.getModel().getValue(AREA);
            datasetDto.setArea(area);
            if (!Objects.equals(area, "hasDim")) {
                Map<String, String> extendMap = this.getExtendMap(sourceFrom, LongUtil.toLong((Object)this.getModel().getValue(MODELSELECT)));
                for (Map.Entry entry : extendMap.entrySet()) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)area)) continue;
                    datasetDto.setExtendsModelId(LongUtil.toLong(entry.getKey()));
                    datasetDto.setExtendsModelNumber(area);
                }
                Map extendsMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(EXTENDS_MAP), Map.class);
                datasetDto.setValue(Joiner.on((String)",").join((Iterable)extendsMap.get(area)));
            } else {
                datasetDto.setValue(MONEY);
            }
        }
        if (Objects.nonNull(varSelect = this.getPageCache().get(VAR_SELECT))) {
            datasetDto.setVarMap((Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(VAR_SELECT), Map.class));
        }
        DataSetDisplayUtil.setDataVo(datasetDto, eventArgs);
        this.setDataSetDto(datasetDto, eventArgs);
        return datasetDto;
    }

    private void setDataSetDto(DatasetDto datasetDto, String eventArgs) {
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        Boolean isCopy = (Boolean)this.getFormCustomParam(ISCOPY);
        if (Objects.nonNull(this.getFormCustomParam("dataset_id"))) {
            DynamicObject dataSet;
            long datasetId = (Long)this.getFormCustomParam("dataset_id");
            if (!isCopy.booleanValue()) {
                datasetDto.setId(Long.valueOf(datasetId));
                dataSet = DatasetDataReader.getDataSet((Long)datasetId);
                datasetDto.setNumber(dataSet.getString("number"));
            } else {
                dataSet = DatasetDataReader.getDataSet((Long)datasetId);
                datasetDto.setNumber(dataSet.getString("number") + "_copy");
            }
        }
        datasetDto.setDiscmodelId((Long)this.getView().getFormShowParameter().getCustomParam("dmmodel_id"));
        datasetDto.setEventParams(eventArgs);
        datasetDto.setType(dataSetType);
        String expression = (String)this.getModel().getValue(TEXTAREAFIELD);
        datasetDto.setTempExpression(expression);
        if (Objects.nonNull(this.getModel().getValue(MODELSELECT))) {
            Long modelSelectId = Long.valueOf((String)this.getModel().getValue(MODELSELECT));
            datasetDto.setDataSrcId(modelSelectId);
        }
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
            String iscExpression;
            DynamicObject dynamicObject;
            Long iscMetadataId = (Long)this.getModel().getValue(ISCMETADATA_ID);
            datasetDto.setDataSrcId(iscMetadataId);
            Object datasetId = this.getFormCustomParam("dataset_id");
            if (LongUtil.isValidLong((Object)datasetId) && Objects.nonNull(dynamicObject = DatasetDataReader.getSingleDS((Long)LongUtil.toLong((Object)datasetId))) && StringUtils.isNotBlank((CharSequence)(iscExpression = dynamicObject.getString("expression")))) {
                datasetDto.setTempExpression(iscExpression);
            }
        }
        if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(this.getModel().getValue(TYPE_SELECT))) {
            sourceFrom = DataSrcTypeEnum.CM_TEMPLATE.getType();
        }
        if (Objects.nonNull(this.getModel().getValue(TYPE_SELECT))) {
            String typeSelect = (String)this.getModel().getValue(TYPE_SELECT);
            if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
                datasetDto.setDataSrcType(DataSrcTypeEnum.BCM_ISC_METADATA.getType());
            } else {
                datasetDto.setDataSrcType(sourceFrom);
            }
        } else {
            datasetDto.setDataSrcType(sourceFrom);
        }
        String groupBy = TypeConversionUtil.getStringValue((String)GROUPBY, (IDataModel)this.getModel());
        datasetDto.setGroupBy(groupBy);
        String order = TypeConversionUtil.getStringValue((String)ORDERFIELD, (IDataModel)this.getModel());
        String orderby = TypeConversionUtil.getStringValue((String)ORDERBY, (IDataModel)this.getModel());
        datasetDto.setOrderBy(order);
        datasetDto.setAsc(orderby);
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        Boolean limitCount = jsonObject.getBoolean(LIMITCOUNT);
        Integer top = TypeConversionUtil.getIntValue((String)TOPFIELD, (IDataModel)this.getModel());
        if (Objects.nonNull(limitCount) && limitCount.booleanValue() && (Objects.isNull(top) || top > 100 || top < 1)) {
            top = 100;
        }
        datasetDto.setTop(top);
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType) && Objects.nonNull(this.getModel().getValue(DIMDEFAULTVALUE))) {
            String defValue = (String)this.getModel().getValue(DIMDEFAULTVALUE);
            datasetDto.setDefValue(defValue);
        }
        String ebDataSet = (String)this.getModel().getValue(EBDATASET);
        datasetDto.setEbDataset(ebDataSet);
        Object extendIdStr = this.getModel().getValue(EXTENDMODELSELECT);
        if (Objects.nonNull(extendIdStr)) {
            Long extendId = LongUtil.toLong((Object)extendIdStr.toString());
            datasetDto.setExtendsModelId(extendId);
            Map<String, String> extendMap = this.getExtendMap(datasetDto.getDataSrcType(), datasetDto.getDataSrcId());
            datasetDto.setExtendsModelNumber(extendMap.get(extendIdStr.toString()));
        }
        datasetDto.setStyle(DatasetStyleEnum.QUERY.getType());
        this.setDataSetDaoValue(datasetDto, dataSetType);
    }

    protected Map<String, String> getExtendMap(String datasrcType, Long modelId) {
        List data = this.fidmDimService.getExtendsModel(datasrcType, modelId);
        return data.stream().collect(Collectors.toMap(t -> (String)t.p3, t -> (String)t.p1));
    }

    private void setDataSetDaoValue(DatasetDto datasetDto, String dataSetType) {
        String sourceFrom = datasetDto.getDataSrcType();
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) {
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                String singleValSelect = (String)this.getModel().getValue(SINGLEVALSELECT);
                datasetDto.setValue(singleValSelect);
            } else {
                String mulValue = (String)this.getModel().getValue(MULVALUE);
                datasetDto.setValue(mulValue);
            }
            return;
        }
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(sourceFrom)) {
            return;
        }
        if (Objects.nonNull(this.getModel().getValue(TYPE_SELECT))) {
            String typeSelect = (String)this.getModel().getValue(TYPE_SELECT);
            if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    String singleValSelect = (String)this.getModel().getValue(SINGLEVALSELECT);
                    datasetDto.setValue(singleValSelect);
                } else {
                    String mulValue = (String)this.getModel().getValue(MULVALUE);
                    datasetDto.setValue(mulValue);
                }
                return;
            }
        }
        if (Objects.nonNull(this.getModel().getValue(SINGLEVALUE))) {
            String signleValue = (String)this.getModel().getValue(SINGLEVALUE);
            datasetDto.setValue(signleValue);
        }
        if (Objects.nonNull(this.getModel().getValue(EXTENDMODELSELECT))) {
            TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
            List selectNodes = treeView.getTreeState().getSelectedNodes();
            StringBuilder stringBuilder = new StringBuilder();
            selectNodes.forEach(treeNode -> {
                String parentNode = (String)treeNode.get("parentid");
                if ("extend".equals(parentNode)) {
                    String nodeId = (String)treeNode.get("id");
                    stringBuilder.append(nodeId);
                    stringBuilder.append(",");
                }
            });
            String datasetType = datasetDto.getType();
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(datasetType)) {
                String singleExtendValue = (String)this.getModel().getValue(SINGLEEXTENDVAL);
                datasetDto.setValue(singleExtendValue);
            } else if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(datasetType) && stringBuilder.length() > 0) {
                stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                datasetDto.setValue(stringBuilder.toString());
            }
        }
    }

    public DatasetDto buildDataSetDto(DatasetDto dataSetDto) {
        Boolean isCopy;
        long datasetId;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.nonNull(this.getFormCustomParam("dataset_id")) && !DataSetDisplayUtil.isMetadtaSrcType(dataSetDto = this.dataSetOperate.buildDataSetDto(dataSetDto, status, datasetId = ((Long)this.getFormCustomParam("dataset_id")).longValue(), isCopy = (Boolean)this.getFormCustomParam(ISCOPY))).booleanValue()) {
            String expression = dataSetDto.getExpression();
            Set varNums = DatasetServiceHelper.extractVariables((DatasetDto)dataSetDto);
            String tempExpression = DatasetServiceHelper.variableResolveOf((String)expression, (Long)datasetId);
            dataSetDto.setVarNums(varNums);
            dataSetDto.setTempExpression(tempExpression);
        }
        return dataSetDto;
    }

    protected void getMemberData(String eventArgs) {
        JSONObject dataObj = new JSONObject();
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        Long modelId = Long.valueOf((String)this.getModel().getValue(MODELSELECT));
        Object dataSet = this.getModel().getValue(EBDATASET);
        String ebDataset = Objects.nonNull(dataSet) ? dataSet.toString() : "";
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        Long dimId = jsonObject.getLong("id");
        String number = jsonObject.getString("number");
        String search = jsonObject.getString("search");
        String entityName = jsonObject.getString("memberModel");
        int page = jsonObject.getInteger("page");
        int pageSize = jsonObject.getInteger("size");
        List<Map<String, Object>> memberList = DataSetDisplayUtil.getMemberData(this.getView(), dataSrcType, modelId, dimId, ebDataset, number, entityName, search, page, pageSize);
        dataObj.put("member", memberList);
        dataObj.put("range", (Object)DataSetDisplayUtil.getRangeData(dataSrcType));
        dataObj.put("dataType", (Object)PropsDataType.CASCADER_DATA_MEMBER.toString());
        dataObj.put("t", (Object)TimeServiceHelper.now());
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        DataSetDisplayUtil.sendToVue(dataObj, custom);
    }

    protected Map<String, List<Map<String, Object>>> conversionData(List<CheckTreeNodeInfo> select) {
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        Long modelId = Long.valueOf((String)this.getModel().getValue(MODELSELECT));
        String dataSet = this.getModel().getValue(EBDATASET) == null ? "" : this.getModel().getValue(EBDATASET).toString();
        Map<String, List<Map<String, Object>>> result = DataSetDisplayUtil.conversionTreeData(select);
        List<Map<String, Object>> dimList = result.get("dimList");
        HashMap dimDefaultMap = Maps.newHashMapWithExpectedSize((int)11);
        dimList.forEach(dim -> {
            String dimId = dim.get("dimId").toString();
            if ("extend".equals(dimId)) {
                DimInfo dimInfo = new DimInfo();
                dimInfo.setNumber("extend");
                dimInfo.setName(ResManager.loadKDString((String)"\u62d3\u5c55\u7ef4", (String)"DataSetDisplayPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                dim.put("dimInfo", dimInfo);
                return;
            }
            List<DimInfo> dimInfo1 = this.getDimInfo();
            dimInfo1.add(SEUtils.getSEDimInfo());
            List collect = dimInfo1.stream().filter(v -> v.getDimId().equals(dimId)).collect(Collectors.toList());
            DimInfo dimInfo = null;
            if (!collect.isEmpty()) {
                dimInfo = (DimInfo)collect.get(0);
            }
            dim.put("dimInfo", dimInfo);
            List<Map<String, Object>> memberData = DataSetDisplayUtil.getMemberData(this.getView(), dataSrcType, modelId, Long.parseLong(dimId), dataSet, dimInfo.getNumber(), dimInfo.getMemberModel(), "", 0, 100);
            dim.put("member", memberData);
            dim.put("range", DataSetDisplayUtil.getRangeData(dataSrcType));
            dim.put("default", dimDefaultMap.get(dimId));
        });
        return result;
    }

    protected List<DimInfo> getDimInfo() {
        Object datasrcid = this.getModel().getValue(MODELSELECT);
        Long modelSelectId = LongUtil.toLong((Object)datasrcid);
        String dataSrcType = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        if (DataSetDisplayUtil.isCMTemplate(this.getModel())) {
            sourceFrom = DataSrcTypeEnum.CM_TEMPLATE.getType();
        }
        String pageDimStr = this.getPageCache().get(PAGE_DIM);
        String extendModelValue = TypeConversionUtil.getStringValue((String)EXTENDMODELSELECT, (IDataModel)this.getModel());
        IDataModel dataModel = this.getModel();
        String dataSetNumber = this.dataSetOperate.getStringValue(EBDATASET, dataModel);
        String hiddenDimStr = this.getPageCache().get(HIDE_DIM);
        String dimensionMap = this.getPageCache().get(DIMENSION_MAP);
        List<DimInfo> dimInfo = DataSetDisplayUtil.getDimInfo(modelSelectId, dataSrcType, dataSetNumber, sourceFrom, pageDimStr, hiddenDimStr, dimensionMap, extendModelValue);
        return dimInfo;
    }

    protected void buildComboEdit(List<String> dims, String comboEditKey) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboEditKey);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)12);
        if (dims == null || dims.size() <= 0) {
            comboEdit.setComboItems((List)items);
            return;
        }
        String extend = this.getPageCache().get(EXISTEXTEDNMODELITEMCACHE);
        Object extendModel = this.getModel().getValue(EXTENDMODELSELECT);
        Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue(MODELSELECT));
        String dataSrcType = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        String type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId).getType();
        List dimList = new ModelStrategyEx(modelSelectId, type).getDim().getDimList();
        Map<String, String> shortNumberMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, DimensionInfo::getName));
        if (!DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            shortNumberMap.put("SE", ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]));
        }
        for (String dim : dims) {
            items.add(new ComboItem(new LocaleString(shortNumberMap.get(dim)), dim));
        }
        if (ORDERFIELD.equals(comboEditKey)) {
            if (Objects.isNull(extendModel) || "".equals(extendModel)) {
                items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"DatasetMultiLineShowPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0])), MONEY));
                dims.add(MONEY);
            } else if (Objects.nonNull(extend) && Objects.nonNull(extendModel)) {
                TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
                List selectNodes = treeView.getTreeState().getSelectedNodes();
                List<Map> extendNodes = selectNodes.stream().filter(a -> "extend".equals(a.get("parentid"))).collect(Collectors.toList());
                extendNodes.forEach(extendNode -> {
                    String nodeId = (String)extendNode.get("id");
                    dims.add(nodeId);
                    String nodeText = (String)extendNode.get("text");
                    items.add(new ComboItem(new LocaleString(nodeText), nodeId));
                });
            }
        }
        comboEdit.setComboItems((List)items);
    }

    protected void clearValue(String ... params) {
        for (String param : params) {
            this.getModel().setValue(param, null);
        }
    }

    protected void clearComboEdit(String ... params) {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        for (String param : params) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(param);
            comboEdit.setComboItems((List)items);
            this.getModel().setValue(param, null);
        }
    }

    protected void setSourceFromPropertyChanged() {
        ComboEdit singlevalselectComboEdit;
        ComboEdit singleExtenddCcomboEdit;
        ComboEdit mulFieldCcomboEdit;
        ComboEdit orderfieldCcomboEdit;
        ComboEdit groupbyComboEdit;
        ComboEdit ebdatasetModel;
        ComboEdit extendmodelselectComboEdit = (ComboEdit)this.getControl(EXTENDMODELSELECT);
        if (Objects.nonNull(extendmodelselectComboEdit)) {
            extendmodelselectComboEdit.setComboItems(null);
        }
        if (Objects.nonNull(ebdatasetModel = (ComboEdit)this.getControl(EBDATASET))) {
            ebdatasetModel.setComboItems(null);
            Object ebdataSetValue = this.getModel().getValue(EBDATASET);
            if (Objects.nonNull(ebdataSetValue)) {
                this.getModel().setValue(EBDATASET, null);
            }
        }
        if (Objects.nonNull(groupbyComboEdit = (ComboEdit)this.getControl(GROUPBY))) {
            groupbyComboEdit.setComboItems(null);
        }
        if (Objects.nonNull(orderfieldCcomboEdit = (ComboEdit)this.getControl(ORDERFIELD))) {
            orderfieldCcomboEdit.setComboItems(null);
        }
        if (Objects.nonNull(mulFieldCcomboEdit = (ComboEdit)this.getControl(MULVALUE))) {
            mulFieldCcomboEdit.setComboItems(null);
        }
        if (Objects.nonNull(singleExtenddCcomboEdit = (ComboEdit)this.getControl(SINGLEEXTENDVAL))) {
            singleExtenddCcomboEdit.setComboItems(null);
        }
        if (Objects.nonNull(singlevalselectComboEdit = (ComboEdit)this.getControl(SINGLEVALSELECT))) {
            singlevalselectComboEdit.setComboItems(null);
        }
    }

    protected List<TreeNode> initTreeNode(List<DimInfo> dimInfoList, String operate) {
        List<TreeNode> treeNodeList;
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        List selectedNodeId = ((TreeView)this.getView().getControl(TREEVIEWAP)).getTreeState().getSelectedNodeId();
        tree.uncheckNodes(selectedNodeId);
        TreeNode root = new TreeNode();
        root.setId("root");
        tree.addNode(root);
        ArrayList allTreeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        DynamicObjectCollection memberProperties = this.getCustomMemberProperties(dimInfoList);
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        for (DimInfo dimInfo : dimInfoList) {
            List<TreeNode> treeNodeList2 = DataSetDisplayUtil.createDimensionNode(dimInfo, memberProperties, root, DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType));
            allTreeNodeList.addAll(treeNodeList2);
        }
        String existExtendModel = this.getPageCache().get(EXISTEXTEDNMODELITEMCACHE);
        if (Objects.nonNull(existExtendModel) && (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType)) && (treeNodeList = this.createExtendNode(root, operate)).size() > 0) {
            allTreeNodeList.addAll(treeNodeList);
        }
        tree.addNode(root);
        tree.updateNode(root);
        tree.expand("root");
        this.getPageCache().put(ROOTNODECACHE, SerializationUtils.toJsonString((Object)root));
        return allTreeNodeList;
    }

    private List<TreeNode> createExtendNode(TreeNode root, String operate) {
        ArrayList treeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        Object extendModel = this.getModel().getValue(EXTENDMODELSELECT);
        if (extendModel != null && extendModel != "" && INIT.equals(operate)) {
            treeNodeList.addAll(SEUtils.getSETreeNodes(root));
            List<TreeNode> secondNodeList = this.createExtendModelNode(root);
            treeNodeList.addAll(secondNodeList);
        }
        return treeNodeList;
    }

    private List<TreeNode> createExtendModelNode(TreeNode extendNode) {
        IDataModel dataModel = this.getModel();
        long dataSrcId = this.dataSetOperate.getLongValue(MODELSELECT, dataModel);
        String dataSrcType = this.dataSetOperate.getStringValue("sourcefrom", dataModel);
        Long extendModelSelect = Long.parseLong((String)this.getModel().getValue(EXTENDMODELSELECT));
        this.extSelects = this.fidmDimService.getExtendsFields(dataSrcType, Long.valueOf(dataSrcId), extendModelSelect, "");
        List tuples = this.fidmDimService.getExtendsFieldstTuple(dataSrcType, Long.valueOf(dataSrcId), extendModelSelect);
        ArrayList treeNodeList = Lists.newArrayListWithExpectedSize((int)10);
        HashSet extendNumType = Sets.newHashSetWithExpectedSize((int)tuples.size());
        tuples.forEach(tuple -> {
            String number = (String)tuple.p1;
            String name = (String)tuple.p2;
            String type = (String)tuple.p3;
            String coin = NUMTYPE;
            if ("text".equals(type)) {
                coin = "kdfont kdfont-qushu2";
            }
            if (NUMTYPE.equals(coin)) {
                extendNumType.add(number);
            }
            TreeNode extendChildNode = new TreeNode();
            extendChildNode.setId(number);
            extendChildNode.setText(name);
            extendChildNode.setIcon(coin);
            extendChildNode.setParentid("extend");
            treeNodeList.add(extendChildNode);
            extendNode.addChild(extendChildNode);
        });
        this.getPageCache().put(EXTENDNUMTYPE, SerializationUtils.toJsonString((Object)extendNumType));
        return treeNodeList;
    }

    protected DynamicObjectCollection getCustomMemberProperties(List<DimInfo> dimInfoList) {
        HashSet dimIds = Sets.newHashSetWithExpectedSize((int)dimInfoList.size());
        dimInfoList.forEach(dim -> {
            Long dimId = dim.getId();
            dimIds.add(dimId);
        });
        QFilter dimFilter = new QFilter("dimension", "in", (Object)dimIds);
        QFilter levelFilter = new QFilter("level", "=", (Object)0);
        DynamicObjectCollection memberProperties = QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,name,number,dimension", (QFilter[])new QFilter[]{dimFilter, levelFilter});
        return memberProperties;
    }

    protected String getExtendColumn(DatasetDto dataSetDto) {
        String extendCustom;
        Boolean isSingleExtend = this.isSingleExtend(dataSetDto);
        String extendValue = dataSetDto.getValue();
        if (isSingleExtend.booleanValue() && kd.bos.util.StringUtils.isNotEmpty((String)(extendCustom = DataSetDisplayUtil.getExtendData(dataSetDto)))) {
            extendValue = extendCustom;
        }
        return extendValue;
    }

    protected Boolean isSingleExtend(DatasetDto dataSetDto) {
        Long extendModelSelectId;
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType) && Objects.nonNull(extendModelSelectId = dataSetDto.getExtendsModelId()) && extendModelSelectId != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void setFormShowCustomParam(String result) {
        FormShowParameter formShowParameter = this.setFormShowParameter();
        formShowParameter.setCustomParam(RESULT, (Object)result);
        this.getView().showForm(formShowParameter);
    }

    protected FormShowParameter setFormShowParameter() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(DATASETTABLEFLEXPANELAP);
        String formId = "fidm_preview_multi_line";
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        IDataModel dataModel = this.getModel();
        Long modelId = this.dataSetOperate.getLongValue(MODELSELECT, dataModel);
        formShowParameter.setCustomParam("dmmodelid", (Object)("" + modelId));
        return formShowParameter;
    }

    protected Boolean queryMetaResultCheck() {
        if (Objects.isNull(this.getModel().getValue(ISCMETADATA)) && Objects.isNull(this.getModel().getValue(VOUCHER))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u3002", (String)"DataSetDisplayPlugin_36", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Boolean commonCheck() {
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if ((DataSrcTypeEnum.MERGE_MODEL.getType().equals(sourceFrom) || DataSrcTypeEnum.RPT_MODEL.getType().equals(sourceFrom)) && LongUtil.isvalidLong((Object)this.getModel().getValue(EXTENDMODELSELECT))) {
            Object signleExtendVal;
            String modelSelectValue = (String)this.getModel().getValue(EXTENDMODELSELECT);
            if ("".equals(modelSelectValue)) {
                return Boolean.TRUE;
            }
            String dataSetType = (String)this.getFormCustomParam("dataset_type");
            List selectNodeList = ((TreeView)this.getView().getControl(TREEVIEWAP)).getTreeState().getSelectedNodes();
            List collect = selectNodeList.stream().filter(a -> "extend".equals(a.get("parentid"))).collect(Collectors.toList());
            if (collect.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ea6\u91cf\u503c\u3002", (String)"DataSetDisplayPlugin_38", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType) && Objects.isNull(signleExtendVal = this.getModel().getValue(SINGLEEXTENDVAL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fd4\u56de\u503c\u3002", (String)"DataSetDisplayPlugin_37", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    protected void reset() {
        this.getModel().setValue(TEXTAREAFIELD, null);
        this.getModel().setValue(DETAILFIELD, null);
        this.getModel().setValue(GROUPBY, null);
        this.getModel().setValue(ORDERFIELD, null);
        this.getModel().setValue(TOPFIELD, null);
        this.getModel().setValue(SINGLEEXTENDVAL, null);
        this.getModel().setValue(MULVALUE, null);
        this.getModel().setValue(SINGLEVALSELECT, null);
        CustomControl custom = (CustomControl)this.getView().getControl(CTL_CUSTOMCONTROLAP);
        DataSetDisplayUtil.sendToVue(PropsDataType.CASCADER_DATA_RESET.toString(), custom);
    }

    protected Boolean beforeSave() {
        TreeView tree = (TreeView)this.getView().getControl(TREEVIEWAP);
        if (CollectionUtils.isEmpty((Collection)tree.getTreeState().getSelectedNodeId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5b57\u6bb5\u4e0e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DataSetDisplayPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void checkExist() {
        String typeSelect;
        this.checkNotBlank("sourcefrom");
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        if (!Objects.equals(DataSrcTypeEnum.ISC_METADATA.getType(), sourceFrom) && !Objects.equals(DataSrcTypeEnum.EPM_VOUCHER.getType(), sourceFrom)) {
            this.checkHasLongValue(MODELSELECT);
        }
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(this.getFormCustomParam("dataset_type")) && (Objects.equals(DataSrcTypeEnum.ISC_METADATA.getType(), sourceFrom) || Objects.equals(DataSrcTypeEnum.EPM_VOUCHER.getType(), sourceFrom))) {
            this.checkNotBlank(SINGLEVALSELECT);
        }
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(this.getFormCustomParam("dataset_type")) && Objects.nonNull(this.getModel().getValue(TYPE_SELECT))) {
            typeSelect = (String)this.getModel().getValue(TYPE_SELECT);
            if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
                this.checkNotBlank(SINGLEVALSELECT);
            }
        }
        if (Objects.equals(DataSrcTypeEnum.MERGE_MODEL.getType(), sourceFrom)) {
            typeSelect = (String)this.getModel().getValue(TYPE_SELECT);
            if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(typeSelect)) {
                this.checkHasLongValue(TEMPLATE);
                this.checkNotBlank(AREA);
            }
            if (DatasetModelTypeEnum.EXTEND.getIndex().equals(typeSelect)) {
                this.checkHasLongValue(EXTENDMODELSELECT);
            }
        }
        if (Objects.equals(DataSrcTypeEnum.EB_MODEL.getType(), sourceFrom)) {
            this.checkHasLongValue(MODELSELECT);
            this.checkNotBlank(EBDATASET);
        }
        if (Objects.equals(DataSrcTypeEnum.MERGE_MODEL.getType(), sourceFrom) || Objects.equals(DataSrcTypeEnum.RPT_MODEL.getType(), sourceFrom)) {
            this.checkHasLongValue(MODELSELECT);
        }
    }

    private void checkNotBlank(String ... params) {
        for (String param : params) {
            if (!StringUtils.isBlank((CharSequence)TypeConversionUtil.getStringValue((String)param, (IDataModel)this.getModel()))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"DataSetDisplayPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkHasLongValue(String ... params) {
        for (String param : params) {
            Object value = this.getModel().getValue(param);
            if (LongUtil.isvalidLong((Object)value)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"DataSetDisplayPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    static class MemberInfo
    implements Serializable {
        public Long id;
        public String name;
        public String number;
        public String dimension;
        public String label;
        public String dseq;
        public String range;

        MemberInfo() {
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDseq() {
            return this.dseq;
        }

        public void setDseq(String dseq) {
            this.dseq = dseq;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static enum PropsDataType {
        CASCADER_DATA_INIT,
        CASCADER_TREENODE_CHECK,
        CASCADER_DATA_MEMBER,
        CASCADER_DATA_DIM,
        METADATA_DATA_INIT,
        CASCADER_DATA_RANGE,
        CASCADER_DATA_RESET,
        CASCADER_DATA_SAVEDATASET,
        CASCADER_DATA_QUERY,
        CASCADER_GETDATA,
        METADATA_TREENODE_CHECK,
        CASCADER_DATA_CLEAR,
        CASCADER_VAR_SELECT,
        CASCADER_ISCVAR_SELECT,
        CASCADER_DATA_MEMBER_F7;

    }

    public static enum CallBackType {
        CASCADER_EVENT_DIM,
        EVENT_CASCADER_EVENT_MEMBER,
        CASCADER_EVENT_RANGE,
        EVENT_CASCADER_GETDATA,
        EVENT_CASCADER_DATA_QUERY,
        EVENT_CASCADER_DATA_SAVEDATASET,
        EVENT_CASCADER_MULTI_MEMBER_F7;

    }
}

