/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.IntegrationProperty;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.util.ComboEditUtil;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.dataset.AbstractDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.DataSetDisplayPlugin;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;

public class BCMISCDataDatasetPlugin
extends DataSetDisplayPlugin {
    private static final String ISMEASURECACHE = "ismeasure";
    private static final String BCMISCDATA = "bcmiscdata";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(BCMISCDATA);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (BCMISCDATA.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(BCMISCDATA)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            if (Objects.nonNull(this.getModel().getValue("modelselect"))) {
                Object modelSelectId = this.getModel().getValue("modelselect");
                if (LongUtil.isValidLong((Object)modelSelectId)) {
                    Long modelId = LongUtil.toLong((Object)modelSelectId);
                    qFilterList.add(new QFilter("model", "=", (Object)modelId));
                    showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f53\u7cfb\u3002", (String)"BCMISCDataDatasetPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(sourceFrom) && OperationStatus.EDIT.equals((Object)operationStatus)) {
            this.afterCreateNewDataEdit(e);
        }
    }

    public void afterCreateNewDataEdit(EventObject e) {
        this.dataSetDtoAfterNew = this.buildDataSetDto(this.dataSetDtoAfterNew);
        if (this.dataSetDtoAfterNew != null && DataSetDisplayUtil.isBCMMetadtaSrcType(this.dataSetDtoAfterNew).booleanValue()) {
            this.setBCMInitSourceFrom();
            List<DynamicObject> dynamicObjectCollection = this.buildModelComboEdit();
            this.setModelSelectInitValue(this.dataSetDtoAfterNew, dynamicObjectCollection);
            this.buildTypeComboEdit(this.dataSetDtoAfterNew.getDataSrcType());
            this.getModel().setValue("typeselect", (Object)DatasetModelTypeEnum.INTEGRATION.getIndex());
            this.setBcmiscdataVal(dynamicObjectCollection);
            DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)this.dataSetDtoAfterNew.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            List propertyVo = datasetDataVo.getColumns();
            if (propertyVo.size() > 0) {
                List<String> selectNumbers = propertyVo.stream().map(DatasetPropertyVo::getNumber).collect(Collectors.toList());
                Long bcmISCDataId = this.dataSetDtoAfterNew.getMetadataId();
                DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bcmISCDataId, (String)"bcm_isdatasource");
                String metadataType = integrateObject.getString("type");
                List<IntegrationProperty> integrationPropertyList = this.getBCMMetadataProperty(integrateObject, metadataType);
                this.initAndSelectMetadataTree(selectNumbers, integrationPropertyList, metadataType);
                this.setOtherMetadataCombo(propertyVo, this.dataSetDtoAfterNew);
                this.initEditMetadataCustomEvent(propertyVo);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u96c6\u6210\u5bf9\u8c61\u6570\u636e", (String)"DataSetDisplayPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setBcmiscdataVal(List<DynamicObject> dynamicObjectCollection) {
        Boolean setModelVal = Boolean.FALSE;
        Object modelSelect = this.getModel().getValue("modelselect");
        if (Objects.nonNull(modelSelect)) {
            String modelIdVal = (String)modelSelect;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String modelSelectId = dynamicObject.getString("id");
                if (!modelIdVal.equals(modelSelectId)) continue;
                setModelVal = Boolean.TRUE;
                break;
            }
        }
        if (setModelVal.booleanValue()) {
            this.getModel().setValue(BCMISCDATA, (Object)this.dataSetDtoAfterNew.getMetadataId());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        switch (propertyName) {
            case "bcmiscdata": {
                if (!DatasetModelTypeEnum.INTEGRATION.getIndex().equals(this.getModel().getValue("typeselect"))) break;
                Object value = this.getModel().getValue(propertyName);
                if (Objects.isNull(value)) {
                    this.metadataIsNull(custom, sourceFrom);
                    return;
                }
                this.setSourceFromPropertyChanged();
                this.setCurrentModelValueNull();
                this.getPageCache().remove("diminfocache");
                this.setVisibleWithSource();
                this.setFormShowCustomParam("");
                this.reset();
                Long bcmISCDataId = (Long)this.getModel().getValue("bcmiscdata_id");
                DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)bcmISCDataId, (String)"bcm_isdatasource");
                String metadataType = integrateObject.getString("type");
                List<IntegrationProperty> integrationPropertyList = this.getBCMMetadataProperty(integrateObject, metadataType);
                this.initAndSelectMetadataTree(Collections.EMPTY_LIST, integrationPropertyList, metadataType);
                DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
                break;
            }
        }
    }

    private void metadataIsNull(CustomControl custom, String sourceFrom) {
        this.setSourceFromPropertyChanged();
        this.reset();
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
        this.setFormShowCustomParam("");
    }

    private void setOtherMetadataCombo(List<DatasetPropertyVo> propertyVo, DatasetDto dataSetDto) {
        String orderBy;
        Map selectCombos = propertyVo.stream().collect(Collectors.toMap(DatasetPropertyVo::getNumber, DatasetPropertyVo::getName, (k1, k2) -> k1, LinkedHashMap::new));
        String groupBy = dataSetDto.getGroupBy();
        if (kd.bos.util.StringUtils.isEmpty((String)groupBy)) {
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"groupby", (IFormView)this.getView());
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"orderfield", (IFormView)this.getView());
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"mulvalue", (IFormView)this.getView());
            orderBy = dataSetDto.getOrderBy();
            if (kd.bos.util.StringUtils.isNotEmpty((String)orderBy)) {
                this.getModel().setValue("orderfield", (Object)orderBy);
            }
        } else {
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"groupby", (IFormView)this.getView());
            this.getModel().setValue("groupby", (Object)groupBy);
            orderBy = dataSetDto.getOrderBy();
            List selectGroupList = Arrays.stream(groupBy.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            Map orderComboEdits = selectCombos.entrySet().stream().filter(entry -> selectGroupList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k1, LinkedHashMap::new));
            ComboEditUtil.buildComboEdit((Map)orderComboEdits, (String)"orderfield", (IFormView)this.getView());
            if (kd.bos.util.StringUtils.isNotEmpty((String)orderBy)) {
                this.getModel().setValue("orderfield", (Object)orderBy);
            }
        }
        String datasetType = (String)this.getFormCustomParam("dataset_type");
        String value = dataSetDto.getValue();
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(datasetType)) {
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"singlevalselect", (IFormView)this.getView());
            this.getModel().setValue("singlevalselect", (Object)value);
        } else {
            this.setMultiValueAfterCreate(dataSetDto, selectCombos, propertyVo);
            String asc = dataSetDto.getAsc();
            this.setOrderValue(asc);
        }
    }

    private void setMultiValueAfterCreate(DatasetDto dataSetDto, Map<String, String> selectCombos, List<DatasetPropertyVo> propertyVo) {
        Set metaNumSet;
        String value = dataSetDto.getValue();
        String metaNumType = this.getPageCache().get("metanumtype");
        Map valueCombos = selectCombos;
        if (Objects.nonNull(metaNumType) && (metaNumSet = (Set)SerializationUtils.fromJsonString((String)metaNumType, Set.class)).size() > 0) {
            valueCombos = propertyVo.stream().filter(property -> metaNumSet.contains(property.getNumber())).collect(Collectors.toMap(DatasetPropertyVo::getNumber, DatasetPropertyVo::getName, (k1, k2) -> k1, LinkedHashMap::new));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
            ComboEditUtil.buildComboEdit(valueCombos, (String)"mulvalue", (IFormView)this.getView());
            this.getModel().setValue("mulvalue", (Object)value);
        } else {
            ComboEditUtil.buildComboEdit(valueCombos, (String)"mulvalue", (IFormView)this.getView());
        }
        Integer top = dataSetDto.getTop();
        if (top != null && top > 0) {
            this.getModel().setValue("topfield", (Object)top);
        }
    }

    private void initEditMetadataCustomEvent(List<DatasetPropertyVo> propertyVo) {
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)11);
        HashMap input = Maps.newHashMapWithExpectedSize((int)6);
        input.put("input", propertyVo);
        dimList.add(input);
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendDataInitVue(dimList, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
    }

    private void setBCMInitSourceFrom() {
        this.getModel().setValue("sourcefrom", (Object)DataSrcTypeEnum.MERGE_MODEL.getType());
    }

    protected void setCurrentModelValueNull() {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        this.getModel().setValue("textareafield", null);
        this.getModel().setValue("metadatatype", null);
        this.getModel().setValue("template", null);
        this.getModel().setValue("area", null);
        BasedataEdit iscMetadata = (BasedataEdit)this.getControl("iscmetadata");
        if (Objects.nonNull(iscMetadata)) {
            this.getModel().setValue("iscmetadata", null);
            this.getModel().setValue("singlevalselect", null);
        }
        if (Objects.nonNull(this.getModel().getValue("extendmodelselect"))) {
            this.getModel().setValue("extendmodelselect", null);
        }
        if (Objects.nonNull(this.getModel().getValue("mulvalue"))) {
            this.getModel().setValue("mulvalue", null);
        }
        if (Objects.nonNull(this.getModel().getValue("groupby"))) {
            this.getModel().setValue("groupby", null);
        }
        if (Objects.nonNull(this.getModel().getValue("orderby"))) {
            this.getModel().setValue("orderby", null);
        }
        if (Objects.nonNull(this.getModel().getValue("topfield"))) {
            this.getModel().setValue("topfield", null);
        }
        if (Objects.nonNull(this.getModel().getValue("singleextendval"))) {
            this.getModel().setValue("singleextendval", null);
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        String typeSelect = (String)this.getModel().getValue("typeselect");
        if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
            this.bcmMetadataTreeNodeCheck(treeNodeCheckEvent);
        }
    }

    private void bcmMetadataTreeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        JSONObject dataObj = new JSONObject();
        Boolean checked = treeNodeCheckEvent.getChecked();
        dataObj.put("isChecked", (Object)checked);
        List selectNodeList = ((TreeView)treeNodeCheckEvent.getSource()).getTreeState().getSelectedNodes();
        Map treeNodeInfo = selectNodeList.stream().collect(Collectors.toMap(selectNode -> (String)selectNode.get("id"), selectNode -> (String)selectNode.get("text"), (k1, k2) -> k1, LinkedHashMap::new));
        if (treeNodeInfo.size() > 0) {
            String metaNumType = this.getPageCache().get("metanumtype");
            String dataSetType = (String)this.getFormCustomParam("dataset_type");
            String FMoney = this.getPageCache().get(ISMEASURECACHE);
            if (Objects.nonNull(metaNumType)) {
                Set metaNumSet = (Set)SerializationUtils.fromJsonString((String)metaNumType, Set.class);
                if (kd.bos.util.StringUtils.isNotEmpty((String)FMoney)) {
                    Set fmoneySet = (Set)SerializationUtils.fromJsonString((String)FMoney, Set.class);
                    Map filterTreeNodeInfo = selectNodeList.stream().filter(node -> metaNumSet.contains((String)node.get("id")) && fmoneySet.contains((String)node.get("id"))).collect(Collectors.toMap(selectNode -> (String)selectNode.get("id"), selectNode -> (String)selectNode.get("text"), (k1, k2) -> k1, LinkedHashMap::new));
                    if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                        ComboEditUtil.buildComboEdit((Map)filterTreeNodeInfo, (String)"singlevalselect", (IFormView)this.getView());
                    } else {
                        ComboEditUtil.buildComboEdit((Map)filterTreeNodeInfo, (String)"mulvalue", (IFormView)this.getView());
                    }
                }
            }
            if (!DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                ComboEditUtil.buildComboEdit((Map)treeNodeInfo, (String)"orderfield", (IFormView)this.getView());
                ComboEditUtil.buildComboEdit((Map)treeNodeInfo, (String)"groupby", (IFormView)this.getView());
            }
            String currentNodeId = (String)treeNodeCheckEvent.getNodeId();
            if (!checked.booleanValue()) {
                this.setMetadtaComboValue(currentNodeId);
            }
        }
        dataObj.put("checkedNodes", (Object)selectNodeList);
        String nodeId = String.valueOf(treeNodeCheckEvent.getNodeId());
        dataObj.put("clickNodeId", (Object)nodeId);
        dataObj.put("filters", DataSetDisplayUtil.filters);
        dataObj.put("dataType", (Object)AbstractDatasetDisplayPlugin.PropsDataType.METADATA_TREENODE_CHECK.toString());
        dataObj.put("t", (Object)TimeServiceHelper.now());
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendToVue(dataObj, custom);
    }

    private void setMetadtaComboValue(String currentNodeId) {
        String orderField;
        String groupBy;
        String mulValue = (String)this.getModel().getValue("mulvalue");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mulValue)) {
            List strings = Arrays.stream(mulValue.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            strings.remove(currentNodeId);
            ComboEditUtil.buildComboEditValue(strings, (String)"mulvalue", (IDataModel)this.getModel());
        }
        if (currentNodeId.equals(this.getModel().getValue("singlevalselect"))) {
            this.getModel().setValue("singlevalselect", null);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(groupBy = (String)this.getModel().getValue("groupby")))) {
            List strings = Arrays.stream(groupBy.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            strings.remove(currentNodeId);
            ComboEditUtil.buildComboEditValue(strings, (String)"groupby", (IDataModel)this.getModel());
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(orderField = (String)this.getModel().getValue("orderfield")))) {
            List strings = Arrays.stream(orderField.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            strings.remove(currentNodeId);
            ComboEditUtil.buildComboEditValue(strings, (String)"orderfield", (IDataModel)this.getModel());
        }
    }

    private List<IntegrationProperty> getBCMMetadataProperty(DynamicObject integrateObject, String metadataType) {
        Long bcmISCDataId = (Long)this.getModel().getValue("bcmiscdata_id");
        DynamicObjectCollection entryentityCollection = integrateObject.getDynamicObjectCollection("entryentity");
        ArrayList integrationPropertyList = Lists.newArrayListWithExpectedSize((int)entryentityCollection.size());
        ArrayList nodeExistFields = Lists.newArrayListWithExpectedSize((int)5);
        HashMap propNameMaps = Maps.newHashMapWithExpectedSize((int)entryentityCollection.size());
        IntegrationProperty integrationProperty = null;
        HashSet measureCache = Sets.newHashSetWithExpectedSize((int)integrationPropertyList.size());
        for (DynamicObject propEntryEntity : entryentityCollection) {
            String propName = propEntryEntity.getString("field");
            String propLabel = propEntryEntity.getString("itemname");
            String propDataType = propEntryEntity.getString("datatype");
            String propDataSchema = propEntryEntity.getString("subitem");
            Boolean isMeasure = propEntryEntity.getBoolean("measure");
            if (isMeasure.booleanValue()) {
                measureCache.add(propName);
            }
            propNameMaps.put(propName, propLabel);
            if ("REF".equals(propDataType) && "1".equals(metadataType)) {
                DynamicObject childIntegrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_isdatasource", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)propDataSchema)});
                if (childIntegrateObject != null) {
                    DynamicObjectCollection childEntryentityCollection = childIntegrateObject.getDynamicObjectCollection("entryentity");
                    ArrayList childIntegrationPropertyList = Lists.newArrayListWithExpectedSize((int)childEntryentityCollection.size());
                    childEntryentityCollection.forEach(childPropEntryEntity -> {
                        String childPropName = childPropEntryEntity.getString("field");
                        String childPropLabel = childPropEntryEntity.getString("itemname");
                        String childPropDataType = childPropEntryEntity.getString("datatype");
                        String childdPropDataSchema = childPropEntryEntity.getString("subitem");
                        String childField = propName + "." + childPropName;
                        propNameMaps.put(childField, childPropLabel);
                        if (isMeasure.booleanValue()) {
                            measureCache.add(propName);
                        }
                        IntegrationProperty childIntegrationProperty = new IntegrationProperty(childField, childPropLabel, childPropDataType, childdPropDataSchema, null);
                        childIntegrationPropertyList.add(childIntegrationProperty);
                    });
                    integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, (List)childIntegrationPropertyList);
                } else {
                    nodeExistFields.add(propLabel);
                    integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, null);
                }
            } else {
                integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, null);
            }
            integrationPropertyList.add(integrationProperty);
        }
        this.getPageCache().put(ISMEASURECACHE, SerializationUtils.toJsonString((Object)measureCache));
        this.getPageCache().put(bcmISCDataId + "name", SerializationUtils.toJsonString((Object)propNameMaps));
        if (nodeExistFields.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"DatasetSingleNewPlugin_62", (String)"epm-far-formplugin", (Object[])new Object[]{((Object)nodeExistFields).toString()}));
        }
        return integrationPropertyList;
    }

    private void initAndSelectMetadataTree(List<String> selectNumbers, List<IntegrationProperty> integrationPropertyList, String metadataType) {
        ArrayList selectTreeNodeList = Lists.newArrayListWithExpectedSize((int)selectNumbers.size());
        if (integrationPropertyList.size() > 0) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.deleteAllNodes();
            TreeNode root = new TreeNode();
            root.setId("root");
            HashSet numCache = Sets.newHashSetWithExpectedSize((int)integrationPropertyList.size());
            integrationPropertyList.forEach(integrationproperty -> {
                String propNumber = integrationproperty.getPropNumber();
                String propLabel = integrationproperty.getPropLabel();
                String dataType = integrationproperty.getDataType();
                TreeNode firstMetadataNode = BCMTreeUtils.createTreeNode((String)propNumber, (String)propLabel, (String)dataType, (String)"root");
                if ("1".equals(metadataType)) {
                    List childPropertyList;
                    if (METADATANUMTYPE.contains(dataType)) {
                        firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                        numCache.add(propNumber);
                    } else {
                        firstMetadataNode.setIcon("kdfont kdfont-qushu2");
                    }
                    if (selectNumbers.contains(propNumber)) {
                        selectTreeNodeList.add(firstMetadataNode);
                    }
                    if ((childPropertyList = integrationproperty.getChildPropertyList()) != null && childPropertyList.size() > 0) {
                        childPropertyList.forEach(childproperty -> {
                            String childPropNumber = childproperty.getPropNumber();
                            String childPropLabel = childproperty.getPropLabel();
                            String childDataType = childproperty.getDataType();
                            TreeNode childMetadataNode = BCMTreeUtils.createTreeNode((String)childPropNumber, (String)(propLabel + "_" + childPropLabel), (String)childDataType, (String)propNumber);
                            if (METADATANUMTYPE.contains(childDataType)) {
                                childMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                                numCache.add(childPropNumber);
                            } else {
                                childMetadataNode.setIcon("kdfont kdfont-qushu2");
                            }
                            if (selectNumbers.contains(childPropNumber)) {
                                selectTreeNodeList.add(childMetadataNode);
                            }
                            firstMetadataNode.addChild(childMetadataNode);
                        });
                    }
                } else if ("2".equals(metadataType)) {
                    if (TABLENUMTYPE.contains(dataType)) {
                        firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                        numCache.add(propNumber);
                    } else if (dataType.startsWith("decimal")) {
                        firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                        numCache.add(propNumber);
                    } else {
                        firstMetadataNode.setIcon("kdfont kdfont-qushu2");
                    }
                    if (selectNumbers.contains(propNumber)) {
                        selectTreeNodeList.add(firstMetadataNode);
                    }
                }
                root.addChild(firstMetadataNode);
            });
            tree.addNode(root);
            if (numCache.size() > 0) {
                this.getPageCache().put("metanumtype", SerializationUtils.toJsonString((Object)numCache));
            }
            if (selectTreeNodeList.size() > 0) {
                tree.checkNodes((List)selectTreeNodeList);
            }
            tree.expand("root");
        } else if (integrationPropertyList.size() == 0) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.deleteAllNodes();
            this.getPageCache().remove("metanumtype");
        }
    }
}

