/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class CommonDataSetDimGuidePlugin
extends AbstractBaseDMFormPlugin
implements TabSelectListener,
TreeNodeClickListener {
    protected static final String treeviewap = "treeviewap";
    protected static final String MEMBERLIST = "memberlist";
    protected static final String VARIABLELIST = "variablelist";
    protected static final String MEMBER_TREEAP = "membertreeap";
    protected static final String VARIABLE_TREEAP = "variabletreeap";
    protected static final String DIM_NUMBER = "number";
    protected static final String TREE_NODE_ID = "tree_node_id";
    protected static final String DIM_NUMBER_MAP = "number_short_number_map";
    protected static final String DIM_TREE_NODE = "dimTreeNode";
    protected static final String entryentity = "entryentity";
    protected static final String SPLIT_CODE = "#";
    protected static final String DIM_SHORT_NUMBER = "dimshortnumber";
    protected static final String TAB = "tabap";
    protected static final String CUR_TAB = "curtab";
    protected static final String VALUE_COMBO = "valuecombo";
    protected static final String RANGE_COMBO = "viewcombo";
    protected static final String DIM_EXPRESSSION = "dimexpresssion";
    protected static final String EMPTY_STRING = "";
    protected static final String ALL_SELECTED_MEMBER = "all_selected_member";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners("addoneb", "addallb", "deloneb", "delallb", "btnok");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection doc = model.getEntryEntity(entryentity);
        switch (key) {
            case "addoneb": {
                List<String> ids = this.getSelectedIds();
                if (CollectionUtils.isEmpty(ids)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"DataSetDimGuidePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.moveMember(model, doc, ids);
                this.getModel().setValue(DIM_EXPRESSSION, (Object)this.buildExpression());
                break;
            }
            case "addallb": {
                this.moveMember(model, doc, null);
                this.getModel().setValue(DIM_EXPRESSSION, (Object)this.buildExpression());
                break;
            }
            case "deloneb": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                int[] selectedRows = eg.getEntryState().getSelectedRows();
                if (selectedRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c\u3002", (String)"DataSetDimGuidePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.deletePageCache(doc, selectedRows);
                model.deleteEntryRows(entryentity, selectedRows);
                this.getModel().setValue(DIM_EXPRESSSION, (Object)this.buildExpression());
                break;
            }
            case "delallb": {
                this.deletePageCache(doc, null);
                model.deleteEntryData(entryentity);
                this.getModel().setValue(DIM_EXPRESSSION, (Object)this.buildExpression());
                break;
            }
            case "btnok": {
                String currentNode = (String)this.getView().getFormShowParameter().getCustomParam("currentnode");
                if (Objects.nonNull(currentNode)) {
                    this.getModel().updateCache();
                    String memberCache = this.getPageCache().get(ALL_SELECTED_MEMBER);
                    this.getView().returnDataToParent((Object)memberCache);
                } else {
                    this.getView().returnDataToParent((Object)this.buildExpression());
                }
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkHasAll(List<Map<String, String>> newMemberList, Map<String, String> rangeMap) {
        if (StringUtils.isEmpty((CharSequence)rangeMap.get("range"))) {
            return false;
        }
        return newMemberList.stream().anyMatch(t -> DatasetSpecialVarHelper.isEqualsAllVar((String)((String)t.get(DIM_NUMBER))));
    }

    protected boolean isAccount() {
        String dimNumber = this.getPageCache().get(DIM_NUMBER);
        return DimTypesEnum.ACCOUNT.getNumber().equals(dimNumber);
    }

    private void buildModelEntryRow(IDataModel model, Map<String, String> rangeMap, String shortNumber, List<Map<String, String>> newMemberList) {
        int[] rows = model.batchCreateNewEntryRow(entryentity, newMemberList.size());
        int index = 0;
        boolean account = this.isAccount();
        for (Map<String, String> member : newMemberList) {
            member.put("shortNumber", shortNumber);
            model.setValue(DIM_SHORT_NUMBER, (Object)shortNumber, rows[index]);
            model.setValue(DIM_NUMBER, (Object)member.get(DIM_NUMBER), rows[index]);
            if (account) {
                String[] split = member.get("name").split(" ");
                model.setValue("name", (Object)split[split.length - 1], rows[index]);
                member.put("name", split[split.length - 1]);
            } else {
                model.setValue("name", (Object)member.get("name"), rows[index]);
            }
            if (CollectionUtils.isEmpty(rangeMap)) {
                model.setValue("range", (Object)member.get("range"), rows[index]);
                model.setValue("rangename", (Object)member.get("rangename"), rows[index]);
            } else {
                model.setValue("range", (Object)rangeMap.get("range"), rows[index]);
                model.setValue("rangename", (Object)rangeMap.get("rangename"), rows[index]);
                member.put("range", rangeMap.get("range"));
                member.put("rangename", rangeMap.get("rangename"));
            }
            ++index;
        }
    }

    protected void move2right(List<Map<String, String>> memberList, List<DynamicObject> doc, IDataModel model, Map<String, String> rangeMap) {
        Set keys = doc.stream().map(t -> t.getString(DIM_SHORT_NUMBER) + SPLIT_CODE + t.getString(DIM_NUMBER) + SPLIT_CODE + t.getString("range")).collect(Collectors.toSet());
        boolean rangeFromEditPage = CollectionUtils.isEmpty(rangeMap);
        String shortNumber = this.getPageCache().get(DIM_SHORT_NUMBER);
        List<Map<String, String>> newMemberList = memberList.stream().filter(t -> !keys.contains(shortNumber + SPLIT_CODE + (String)t.get(DIM_NUMBER) + SPLIT_CODE + (rangeFromEditPage ? (String)t.get("range") : (String)rangeMap.get("range")))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newMemberList)) {
            return;
        }
        if (this.checkHasAll(newMemberList, rangeMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"$All\u4e0d\u7b26\u5408\u516c\u5f0f\u89c4\u8303,\u8bf7\u68c0\u67e5\u3002", (String)"DataSetDimGuidePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.buildModelEntryRow(model, rangeMap, shortNumber, newMemberList);
        String s = this.getPageCache().get(ALL_SELECTED_MEMBER);
        if (StringUtils.isEmpty((CharSequence)s)) {
            this.getPageCache().put(ALL_SELECTED_MEMBER, JSON.toJSONString(newMemberList));
        } else {
            List members = (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
            members.addAll(newMemberList);
            this.getPageCache().put(ALL_SELECTED_MEMBER, JSON.toJSONString(members.stream().distinct().collect(Collectors.toList())));
        }
    }

    private void deletePageCache(DynamicObjectCollection doc, int[] selectedRows) {
        List newPageCache;
        String s = this.getPageCache().get(ALL_SELECTED_MEMBER);
        if (StringUtils.isEmpty((CharSequence)s) || CollectionUtils.isEmpty((Collection)doc)) {
            return;
        }
        String shortNumber = this.getPageCache().get(DIM_SHORT_NUMBER);
        List members = (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        if (selectedRows == null) {
            newPageCache = members.stream().filter(t -> !shortNumber.equals(t.get("shortNumber"))).collect(Collectors.toList());
        } else {
            HashSet deleteKey = Sets.newHashSetWithExpectedSize((int)selectedRows.length);
            for (int selectedRow : selectedRows) {
                DynamicObject dy = (DynamicObject)doc.get(selectedRow);
                deleteKey.add(dy.getString(DIM_SHORT_NUMBER) + SPLIT_CODE + dy.getString(DIM_NUMBER) + SPLIT_CODE + dy.getString("range"));
            }
            newPageCache = members.stream().filter(t -> {
                StringBuilder sb = new StringBuilder();
                sb.append((String)t.get("shortNumber")).append(SPLIT_CODE).append((String)t.get(DIM_NUMBER)).append(SPLIT_CODE);
                if (t.get("range") != null) {
                    sb.append((String)t.get("range"));
                }
                return !deleteKey.contains(sb.toString());
            }).collect(Collectors.toList());
        }
        this.getPageCache().put(ALL_SELECTED_MEMBER, JSON.toJSONString(newPageCache));
    }

    private void moveMember(IDataModel model, DynamicObjectCollection doc, List<String> ids) {
        String curTab = this.getPageCache().get(CUR_TAB);
        List memberList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(MEMBERLIST), List.class);
        if (Objects.equals(curTab, "variabletab")) {
            memberList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(VARIABLELIST), List.class);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            memberList = memberList.stream().filter(t -> ids.contains(t.get("id"))).collect(Collectors.toList());
        }
        this.move2right(memberList, (List<DynamicObject>)doc, model, this.getRange());
    }

    private Map<String, String> getRange() {
        String curTab = this.getPageCache().get(CUR_TAB);
        HashMap returnMap = Maps.newHashMap();
        returnMap.put("range", EMPTY_STRING);
        returnMap.put("rangename", EMPTY_STRING);
        if (Objects.equals(curTab, "membertab")) {
            String range = (String)this.getModel().getValue(RANGE_COMBO);
            RangeEnum rangeEnum = RangeEnum.getRangeByNumberOrName((String)range);
            returnMap.put("rangename", rangeEnum.getName());
            if (!Objects.equals(rangeEnum, RangeEnum.VALUE_10)) {
                returnMap.put("range", rangeEnum.getNumber());
            }
            return returnMap;
        }
        String range = EMPTY_STRING;
        String dimNumber = this.getPageCache().get(DIM_NUMBER);
        if (!DimTypesEnum.YEAR.getNumber().equals(dimNumber) && !DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
            return returnMap;
        }
        Object value = this.getModel().getValue(VALUE_COMBO);
        if (StringUtils.isEmpty((CharSequence)((String)value))) {
            return returnMap;
        }
        int val = Integer.parseInt(value.toString());
        if (val == 0) {
            return returnMap;
        }
        range = val > 0 ? range + "+" : range;
        returnMap.put("range", range + LongUtil.toLong((Object)value));
        returnMap.put("rangename", range + LongUtil.toLong((Object)value));
        return returnMap;
    }

    private String buildExpression() {
        this.getModel().updateCache();
        String s = this.getPageCache().get(ALL_SELECTED_MEMBER);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return EMPTY_STRING;
        }
        List members = (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        if (CollectionUtils.isEmpty((Collection)members)) {
            return EMPTY_STRING;
        }
        StringBuilder ex = new StringBuilder();
        Map<String, List<Map>> map = members.stream().collect(Collectors.groupingBy(t -> (String)t.get("shortNumber")));
        for (Map.Entry<String, List<Map>> entry : map.entrySet()) {
            String key = entry.getKey();
            ex.append(key);
            List<Map> value = entry.getValue();
            if (value.size() == 1 && StringUtils.isEmpty((CharSequence)((CharSequence)value.get(0).get("range")))) {
                ex.append(".").append((String)value.get(0).get(DIM_NUMBER));
            } else {
                ex.append(".").append("{");
                for (Map dy : value) {
                    ex.append((String)dy.get(DIM_NUMBER));
                    if (StringUtils.isNotEmpty((CharSequence)((CharSequence)dy.get("range")))) {
                        if (!((String)dy.get(DIM_NUMBER)).contains("$")) {
                            ex.append(".");
                        }
                        ex.append((String)dy.get("range"));
                    }
                    ex.append(";");
                }
                ex.deleteCharAt(ex.length() - 1);
                ex.append("}");
            }
            ex.append(",");
        }
        ex.deleteCharAt(ex.length() - 1);
        return ex.toString();
    }

    private List<String> getSelectedIds() {
        List ids;
        String curTab = this.getPageCache().get(CUR_TAB);
        if (Objects.equals(curTab, "variabletab")) {
            TreeView tree = (TreeView)this.getControl(VARIABLE_TREEAP);
            ids = tree.getTreeState().getSelectedNodeId();
        } else {
            TreeView tree = (TreeView)this.getControl(MEMBER_TREEAP);
            ids = tree.getTreeState().getSelectedNodeId();
        }
        return ids;
    }

    protected TreeNode initTreeViewAp() {
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeNode treeNode = this.initTreeViewAp();
        this.initMemberTreeViewAp(treeNode.getId());
        this.initVariableViewAp();
        this.setVisible4variable();
        this.setSelectedMember();
        this.getPageCache().put(CUR_TAB, "membertab");
        this.getPageCache().put(TREE_NODE_ID, treeNode.getId());
    }

    protected boolean isCurrentApp() {
        return (Boolean)this.getFormCustomParam("isCurrentApp");
    }

    protected void checkExpression(String expression) {
        if (this.isCurrentApp()) {
            return;
        }
        if (DatasetSpecialVarHelper.isContain((String)expression)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u4f53\u7cfb\u76f8\u540c\u6570\u636e\u6765\u6e90\u5e94\u7528\uff0c\u4e0d\u652f\u6301\u7ef4\u5ea6\u53d8\u91cf\u3002", (String)"DataSetDimGuidePlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    protected void initMemberTreeViewAp(String id) {
    }

    protected void initVariableViewAp() {
    }

    protected void setVisible4variable() {
    }

    protected void setSelectedMember() {
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if (Objects.equals(tabKey, "membertab")) {
            String nodeId = this.getPageCache().get(TREE_NODE_ID);
            this.initMemberTreeViewAp(nodeId);
        } else {
            this.initVariableViewAp();
        }
        this.getPageCache().put(CUR_TAB, tabKey);
    }
}

