/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.util.DatasetCheckUtil;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogUtil;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class CommonDatasetEdit
extends AbstractBaseDMFormPlugin {
    protected static final String OPERATION_LOG_NAME = "operation_log_name";
    protected static final String FIDMMODEL = "fidmmodel";
    protected static final String btn_ok = "btn_ok";
    protected static final String BTNOK = "btnok";
    protected static final String MONEY = "FMONEY";
    protected static final String PERMCLASS = "permclass";
    protected static final String CATEGORY = "category";

    private void checkNotBlank(String s, String msg) {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new KDBizException(msg);
        }
    }

    protected void validDtoBaseInfo(DatasetDto dto) {
        this.checkNotBlank(dto.getType(), ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.checkNotBlank(dto.getNumber(), ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u7f16\u7801\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (dto.getNumber().length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u7f16\u7801\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"DatasetSingleNewPlugin_60", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (dto.getName() == null || StringUtils.isBlank((Object)dto.getName()) || StringUtils.isBlank((CharSequence)dto.getName().toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.checkNotBlank(dto.getDataSrcType(), ResManager.loadKDString((String)"\u201c\u6570\u636e\u6765\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (dto.getDataSrcId() == null || dto.getDataSrcId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u53d6\u6570\u6765\u6e90\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (dto.getGroupBy().length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5206\u7ec4\u5b57\u6bb5\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"DatasetSingleNewPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (dto.getOrderBy().length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6392\u5e8f\u5b57\u6bb5\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"DatasetSingleNewPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    protected void validDto(DatasetDto dto, boolean showExtends, boolean checkMemberNum) {
        String expression = dto.getExpression();
        String type = dto.getType();
        this.validDtoBaseInfo(dto);
        this.checkNotBlank(expression, ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if ("1".equals(type)) {
            this.checkNotBlank(dto.getDefValue(), ResManager.loadKDString((String)"\u201c\u7f3a\u7701\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (dto.getTop() != null && dto.getTop() < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u524d\u51e0\u6570\u636e\u201d\u5fc5\u987b\u662f\u6b63\u6574\u6570\u3002", (String)"DatasetSingleNewPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.checkNotBlank(dto.getValue(), ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_27", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if (showExtends && (dto.getExtendsModelId() == null || dto.getExtendsModelId() == 0L)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d3\u5c55\u6a21\u578b\u201d\u3002", (String)"DatasetSingleNewPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!showExtends && !MONEY.equals(dto.getValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u5fc5\u987b\u662fFMONEY\u3002", (String)"DatasetSingleNewPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if ("1".equals(type) && dto.getValue().contains(",")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u53ea\u80fd\u6709\u4e00\u4e2a\u503c\u3002", (String)"DatasetSingleNewPlugin_29", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (expression.length() > 2000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc72000\u3002", (String)"DatasetSingleNewPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (dto.getValue().length() > 1000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5ea6\u91cf\u503c\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"DatasetSingleNewPlugin_21", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (!checkMemberNum) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u7ef4\u6210\u5458\u3002", (String)"DatasetSingleEditPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (Objects.equals(DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId()), DisModelTypeEnum.EB) && StringUtils.isBlank((CharSequence)dto.getEbDataset())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9884\u7b97\u6570\u636e\u96c6\u3002", (String)"DatasetSingleEditPlugin_55", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        ModelInfo fidmmodel = new ModelStrategyEx(dto.getDiscmodelId()).getModel().getModelInfo();
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
        boolean isCurrentApp = Objects.equals(fidmmodel.getModelType(), modelType.getType());
        if (!isCurrentApp && DatasetSpecialVarHelper.isContain((String)expression)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u4f53\u7cfb\u76f8\u540c\u6570\u636e\u6765\u6e90\u5e94\u7528\uff0c\u4e0d\u652f\u6301\u7ef4\u5ea6\u53d8\u91cf\u3002", (String)"DatasetSingleEditPlugin_56", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        try {
            DatasetCheckUtil.valid((DatasetDto)dto, (boolean)showExtends);
        }
        catch (KDBizException kdEx) {
            if ("tips".equals(kdEx.getErrorCode().getCode())) {
                this.getView().showTipNotification(kdEx.getMessage());
            }
            throw kdEx;
        }
        if (showExtends) {
            List dims = DatasetExpressionHelper.getExpressionDimList((String)expression, (Long)dto.getDiscmodelId(), (Long)((Long)this.getFormCustomParam("chapterid")));
            Set extendsDims = DatasetCheckUtil.getExtendsDims((Long)dto.getExtendsModelId());
            if (!extendsDims.containsAll(dims)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u5f53\u524d\u62d3\u5c55\u7ef4\u6a21\u578b\u7684\u7ef4\u5ea6\u3002", (String)"DatasetSingleEditPlugin_57", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void initDataset(DatasetDto dto) {
        long datasetId;
        try {
            datasetId = DatasetServiceHelper.addDataset((DatasetDto)dto, (IDataModel)this.getModel());
        }
        catch (KDBizException e) {
            this.writeLog(OperationResult.FAILURE);
            throw e;
        }
        dto.setId(Long.valueOf(datasetId));
        this.writeLog(OperationResult.SUCCESS);
    }

    protected void editDataset(DatasetDto dto) {
        this.editDataset(dto, false);
    }

    protected void editDataset(DatasetDto dto, boolean isFromInfo) {
        String id = (String)this.getFormCustomParam("dataset_id");
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject dataSet = BusinessDataServiceHelper.loadSingle((Object)id, (String)"fidm_dataset", (String)"id,scope,name,number,modifier,modifytime,currentstyle,datasrctype,category");
                QFilter qFilter = new QFilter("dataset", "=", (Object)Long.valueOf(id));
                DynamicObject entry = BusinessDataServiceHelper.loadSingle((String)"fidm_dataset_single", (String)"dataset,datasrctype,datasrcid,extendsmodelid,extendsmodelnumber,expression,value,defvalue,groupby,orderby,asc,top,dimnum,component.id,membernum,ebdataset,data", (QFilter[])qFilter.toArray());
                if (dataSet != null && entry != null) {
                    dataSet.set("number", (Object)dto.getNumber());
                    if (dto.getName() != null && !kd.bos.util.StringUtils.isEmpty((String)dto.getName().toString())) {
                        dataSet.set("name", dto.getName());
                    }
                    String dataSrcType = dto.getDataSrcType();
                    dataSet.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
                    dataSet.set("modifytime", (Object)TimeServiceHelper.now());
                    dataSet.set("currentstyle", (Object)dto.getStyle());
                    dataSet.set("datasrctype", (Object)dataSrcType);
                    dataSet.set(CATEGORY, (Object)dto.getCategoryId());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataSet});
                    PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)"fidm_dataset", (Long)dataSet.getLong("id"), (Object)this.getDMModelId(), (OperationStatus)OperationStatus.EDIT, (String)FIDMMODEL, (String)"");
                    entry.set("datasrctype", (Object)dataSrcType);
                    entry.set("datasrcid", (Object)dto.getDataSrcId());
                    entry.set("extendsmodelid", (Object)dto.getExtendsModelId());
                    entry.set("component", (Object)dto.getComponentId());
                    if (isFromInfo) {
                        entry.set("dimnum", (Object)entry.getString("dimnum"));
                        entry.set("membernum", (Object)entry.getString("membernum"));
                    } else {
                        entry.set("dimnum", (Object)dto.getDimNum());
                        entry.set("membernum", (Object)dto.getMemberNum());
                    }
                    entry.set("ebdataset", (Object)dto.getEbDataset());
                    if (StringUtils.isNotBlank((CharSequence)dto.getData())) {
                        String data = dto.getData();
                        if (Objects.nonNull(data)) {
                            String expression;
                            List columns;
                            DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
                            Boolean existDataSetVo = DatasetUtil.checkDataSetVoExist((DatasetDataVo)vo);
                            if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType) && (columns = vo.getColumns()).size() > 0 && kd.bos.util.StringUtils.isNotEmpty((String)(expression = dto.getExpression()))) {
                                List<Object> iscNums = Lists.newArrayListWithExpectedSize((int)10);
                                if (expression.contains(",")) {
                                    String[] iscSplits = expression.split(",");
                                    iscNums = Arrays.asList(iscSplits);
                                } else {
                                    iscNums.add(expression);
                                }
                                for (DatasetPropertyVo datasetPropertyVo : columns) {
                                    String fieldNum = datasetPropertyVo.getNumber();
                                    if (!iscNums.contains(fieldNum + ".$Cur") && !iscNums.contains(fieldNum + ".$cur") && !iscNums.contains(fieldNum + ".$Curs") && !iscNums.contains(fieldNum + ".$curs")) continue;
                                    datasetPropertyVo.getFilters().clear();
                                }
                                data = SerializationUtils.toJsonString((Object)vo);
                            }
                            if (existDataSetVo.booleanValue()) {
                                entry.set("data", (Object)data);
                            } else {
                                entry.set("data", null);
                            }
                        } else {
                            entry.set("data", null);
                        }
                    }
                    if (LongUtil.isvalidLong((Object)dto.getExtendsModelId())) {
                        entry.set("extendsmodelnumber", (Object)dto.getExtendsModelNumber());
                    } else {
                        entry.set("extendsmodelnumber", (Object)"");
                    }
                    entry.set("expression", (Object)dto.getExpression());
                    entry.set("value", (Object)dto.getValue());
                    if ("1".equals(dto.getType())) {
                        entry.set("defvalue", (Object)dto.getDefValue());
                    } else {
                        entry.set("groupby", (Object)this.formatMultiSelectStr(dto.getGroupBy()));
                        entry.set("orderby", (Object)this.formatMultiSelectStr(dto.getOrderBy()));
                        entry.set("top", (Object)dto.getTop());
                        entry.set("asc", (Object)dto.getAsc());
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entry});
                    DeleteServiceHelper.delete((String)"fidm_dataset_variable", (QFilter[])new QFilter[]{new QFilter("dataset", "=", (Object)Long.valueOf(id))});
                    Long metadataId = dto.getMetadataId();
                    if (!LongUtil.isvalidLong((Object)metadataId)) {
                        dto.setScope(dataSet.getString("scope"));
                        DatasetServiceHelper.addDatasetVar((DatasetDto)dto, (long)Long.parseLong(id), null);
                        this.writeLog(OperationResult.SUCCESS);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                this.writeLog(OperationResult.FAILURE);
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private String formatMultiSelectStr(String by) {
        String[] a;
        if (StringUtils.isEmpty((CharSequence)by)) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(8);
        for (String one : a = by.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)one)) continue;
            list.add(one);
        }
        return String.join((CharSequence)",", list);
    }

    protected void writeLog(OperationResult result) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        if (Objects.nonNull(model)) {
            String datasetName;
            String datasetNum = this.getModel().getValue("number").toString();
            String string = datasetName = Objects.isNull(this.getModel().getValue("name")) ? "" : this.getModel().getValue("name").toString();
            if (Objects.nonNull(this.getPageCache().get(OPERATION_LOG_NAME))) {
                OperationName operation = AnalysisOpLogUtil.getOpNameByString((String)this.getPageCache().get(OPERATION_LOG_NAME));
                AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildAppId(this.getView()).buildOpName(operation).buildOpCategory(OperationCategory.DATASET).buildOpResult(result).buildFormNumber("fidm_dataset").buildFormatParams(new Object[]{model.getString("number"), datasetNum});
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        }
    }
}

