/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class DataSetCategoryMovePlugin
extends AbstractBaseDMFormPlugin {
    protected static final String TREEROOT = "treeroot";
    protected static final String ROWLIST = "rowlist";
    protected static final String FOCUS = "focus";
    protected static final String TREEVIEWAP = "treeviewap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("confirm", "searchbefore", "searchnext");
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    DataSetCategoryMovePlugin.this.searchMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
                } else {
                    DataSetCategoryMovePlugin.this.getPageCache().put(DataSetCategoryMovePlugin.ROWLIST, null);
                    DataSetCategoryMovePlugin.this.getView().showTipNotification(MessageConstant.getName_NOINPUT());
                }
            }
        });
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getDMModelId();
        this.initTree(modelId);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "confirm": {
                this.moveCategory();
                break;
            }
            case "searchbefore": {
                this.searchOperate(key);
                break;
            }
            case "searchnext": {
                this.searchOperate(key);
                break;
            }
        }
    }

    private void searchOperate(String key) {
        TreeNode old;
        String rowcache = this.getPageCache().get(ROWLIST);
        if (rowcache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u9700\u8981\u641c\u7d22\u7684\u5185\u5bb9\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"DiscTemplateCatalogSelectPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode[] rowList = (TreeNode[])SerializationUtils.fromJsonString((String)rowcache, TreeNode[].class);
        int rowCount = Integer.parseInt(this.getPageCache().get(FOCUS));
        if ("searchbefore".equals(key)) {
            if (0 == rowCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DiscTemplateCatalogSelectPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            --rowCount;
        } else {
            if (rowList.length - 1 == rowCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DiscTemplateCatalogSelectPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            ++rowCount;
        }
        this.getPageCache().put(FOCUS, String.valueOf(rowCount));
        TreeNode focusNode = rowList[rowCount];
        TreeView treeView = (TreeView)this.getControl(TREEVIEWAP);
        String oldnode = this.getPageCache().get("oldnode");
        TreeNode treeNode = old = oldnode == null ? null : (TreeNode)SerializationUtils.deSerializeFromBase64((String)oldnode);
        if (old != null) {
            old.setColor("");
            treeView.updateNode(old);
        }
        treeView.updateNode(focusNode);
        treeView.focusNode(focusNode);
        this.getPageCache().put("oldnode", SerializationUtils.serializeToBase64((Object)focusNode));
    }

    private void moveCategory() {
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        Map map = tree.getTreeState().getFocusNode();
        String newnodeId = (String)map.get("id");
        this.getView().returnDataToParent((Object)newnodeId);
        this.getView().close();
    }

    private void initTree(Long modelId) {
        QFilter numberFilter = new QFilter("number", "=", (Object)"root");
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{numberFilter, modelFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"far_datasetcategory", (String)"id", (QFilter[])filters);
        String rootNodeId = dynamicObject.getString("id");
        TreeNode root = new TreeNode();
        root.setId(rootNodeId);
        root.setParentid("");
        root.setIcon("kdfont kdfont-wenjianjia");
        root.setText(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5206\u7c7b", (String)"DatasetListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        List<Map<String, String>> treeList = this.buildTreeList(rootNodeId, modelId);
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        BCMTreeUtils.setEntryNodeDm((TreeNode)root, treeList, (String)rootNodeId);
        BCMTreeUtils.spreadAllNode((TreeNode)root);
        TreeView tree = (TreeView)this.getControl(TREEVIEWAP);
        tree.addNode(root);
        tree.focusNode(root);
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)root));
    }

    private List<Map<String, String>> buildTreeList(String rootNodeId, Long modelId) {
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(8);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter((long)modelId, (String)"far_datasetcategory");
        qFilters.add(permqFilter);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"far_datasetcategory", (String)"id,name,number,parent,parent.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long nodeId = dynamicObject.getLong("id");
            String nodeName = dynamicObject.getString("name");
            String nodeNumber = dynamicObject.getString("number");
            Long parentNodeId = dynamicObject.getLong("parent.id");
            HashMap<String, String> nodeMap = new HashMap<String, String>(4);
            nodeMap.put("id", String.valueOf(nodeId));
            nodeMap.put("name", nodeName);
            nodeMap.put("number", nodeNumber);
            nodeMap.put("parentid", String.valueOf(parentNodeId));
            nodeMap.put("type", "catalog");
            treeList.add(nodeMap);
        }
        return treeList;
    }

    private void searchMember(String text) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        TreeView mTree = (TreeView)this.getControl(TREEVIEWAP);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>();
        treeNodes = this.getTreeNodeListByText(root, treeNodes, text);
        List<TreeNode> alltreeNodes = new ArrayList<TreeNode>();
        alltreeNodes = this.getTreeNodeListByText(root, alltreeNodes, "");
        for (TreeNode treeNode : alltreeNodes) {
            treeNode.setIsOpened(true);
        }
        mTree.updateNodes(alltreeNodes);
        if (!treeNodes.isEmpty()) {
            this.getPageCache().put(ROWLIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
            TreeNode asd = treeNodes.get(0);
            this.getPageCache().put(FOCUS, "0");
            mTree.updateNode(asd);
            mTree.focusNode(asd);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"DiscTemplateCatalogSelectPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }
}

