/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDim;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.enums.dimension.SystemVarsEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.CommonDataSetDimGuidePlugin;

public class DataSetDimGuideEBPlugin
extends CommonDataSetDimGuidePlugin
implements TreeNodeQueryListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DataSetDimGuideEBPlugin.this.treeOnClick(evt);
            }
        });
        TreeView memberTree = (TreeView)this.getView().getControl("membertreeap");
        memberTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
    }

    @Override
    protected boolean isAccount() {
        return false;
    }

    private void buildModelEntryRow(IDataModel model, Map<String, String> rangeMap, String shortNumber, List<Map<String, String>> newMemberList) {
        int[] rows = model.batchCreateNewEntryRow("entryentity", newMemberList.size());
        int index = 0;
        for (Map<String, String> member : newMemberList) {
            member.put("shortNumber", shortNumber);
            model.setValue("dimshortnumber", (Object)shortNumber, rows[index]);
            model.setValue("number", (Object)member.get("number"), rows[index]);
            model.setValue("name", (Object)member.get("name"), rows[index]);
            if (CollectionUtils.isEmpty(rangeMap)) {
                model.setValue("range", (Object)member.get("range"), rows[index]);
                model.setValue("rangename", (Object)member.get("rangename"), rows[index]);
            } else {
                model.setValue("range", (Object)rangeMap.get("range"), rows[index]);
                model.setValue("rangename", (Object)rangeMap.get("rangename"), rows[index]);
                member.put("range", rangeMap.get("range"));
                member.put("rangename", rangeMap.get("rangename"));
            }
            ++index;
        }
    }

    private void treeOnClick(TreeNodeEvent tree) {
        TreeView mTree = (TreeView)this.getControl("membertreeap");
        mTree.deleteAllNodes();
        Map dimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("dimTreeNode"), Map.class);
        String nodeId = (String)tree.getNodeId();
        this.getPageCache().put("tree_node_id", nodeId);
        this.getPageCache().put("number", (String)((List)dimMap.get(nodeId)).get(0));
        this.getPageCache().put("dimshortnumber", this.getShortNumber((String)((List)dimMap.get(nodeId)).get(0)));
        this.initEntryentity(this.getShortNumber((String)((List)dimMap.get(nodeId)).get(0)));
        this.initMemberTreeViewAp(nodeId);
        this.initVariableViewAp();
        this.setVisible4variable();
    }

    private void initEntryentity(String shortNumber) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        String s = this.getPageCache().get("all_selected_member");
        if (StringUtils.isEmpty((CharSequence)s)) {
            return;
        }
        List members = (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List<Map<String, String>> newMemberList = members.stream().filter(t -> shortNumber.equals(t.get("shortNumber"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newMemberList)) {
            return;
        }
        this.buildModelEntryRow(model, null, shortNumber, newMemberList);
    }

    private String getShortNumber(String number) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number,name,shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)this.getFormCustomParam("modelId")))});
        List dim = EbServiceHelper.getDim((String)model.getString("shownumber"), (String)this.getFormCustomParam("dataSetNumber").toString());
        for (EbDim ebDim : dim) {
            if (!Objects.equals(number, ebDim.getNumber())) continue;
            return ebDim.getShortNumber();
        }
        return null;
    }

    @Override
    protected void setSelectedMember() {
        String[] split;
        this.getPageCache().put("dimshortnumber", "E");
        String expression = (String)this.getFormCustomParam("expression");
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return;
        }
        this.checkExpression(expression);
        this.getModel().setValue("dimexpresssion", (Object)expression);
        ArrayList memberList = Lists.newArrayList();
        Map shortNumberMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("number_short_number_map"), Map.class);
        for (String s : split = expression.split(",")) {
            String[] split1;
            if (s.contains("{")) {
                String[] split2;
                split1 = s.split("\\{");
                String members = split1[1];
                members = members.substring(0, members.length() - 1);
                String shortNumber = split1[0].substring(0, split1[0].length() - 1);
                for (String member : split2 = members.split(";")) {
                    HashMap map = Maps.newHashMap();
                    this.buildMemberMap(shortNumber, member, map, (String)shortNumberMap.get(shortNumber));
                    memberList.add(map);
                }
                continue;
            }
            split1 = s.split("\\.");
            if (split1.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            HashMap map = Maps.newHashMap();
            this.buildMemberMap(split1[0], s.substring(split1[0].length() + 1), map, (String)shortNumberMap.get(split1[0]));
            memberList.add(map);
        }
        this.getPageCache().put("all_selected_member", JSON.toJSONString((Object)memberList));
        List<Map<String, String>> entityList = memberList.stream().filter(t -> "E".equals(t.get("shortNumber"))).collect(Collectors.toList());
        this.move2right(entityList, Collections.emptyList(), this.getModel(), Collections.emptyMap());
    }

    private void buildMemberMap(String shortNumber, String member, Map<String, String> map, String dimNum) {
        map.put("shortNumber", shortNumber);
        map.put("range", "");
        map.put("rangename", "");
        if (member.contains("$")) {
            if (member.endsWith("$")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (member.equalsIgnoreCase("$cur")) {
                map.put("name", ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458", (String)"DataSetDimGuidePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else if (member.equalsIgnoreCase("$all")) {
                map.put("name", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (member.length() > 4) {
                map.put("number", member.substring(0, 4));
                map.put("range", member.substring(4));
                map.put("rangename", member.substring(4));
            } else {
                map.put("number", member);
            }
        } else {
            map.put("number", member);
            try {
                String modelNumber = (String)this.getFormCustomParam("modelNumber");
                String dataSetNumber = (String)this.getFormCustomParam("dataSetNumber");
                List memberList = EbServiceHelper.getMember((String)modelNumber, (String)dataSetNumber, (String)dimNum, (String)member, (RangeEnum)RangeEnum.VALUE_10);
                map.put("name", ((EbMember)memberList.get(0)).getName());
                map.put("rangename", RangeEnum.VALUE_10.getName());
            }
            catch (Exception ex) {
                map.put("name", member);
                map.put("rangename", RangeEnum.VALUE_10.getName());
            }
        }
    }

    @Override
    protected void initVariableViewAp() {
        if (!this.isCurrentApp()) {
            return;
        }
        TreeView mTree = (TreeView)this.getControl("variabletreeap");
        mTree.deleteAllNodes();
        TreeNode membertree = new TreeNode();
        membertree.setId("0");
        membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        ArrayList<Map<String, String>> memberList = new ArrayList<Map<String, String>>(8);
        HashMap<String, String> cur = new HashMap<String, String>(8);
        cur.put("id", SystemVarsEnum.CURRENT.getId());
        cur.put("number", SystemVarsEnum.CURRENT.getNumber());
        cur.put("name", ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458", (String)"DataSetDimGuidePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        cur.put("parentid", "0");
        memberList.add(cur);
        this.getPageCache().put("variablelist", SerializationUtils.toJsonString(memberList));
        this.setEntryNode(membertree, memberList, "0");
        mTree.addNode(membertree);
        BCMTreeUtils.spreadAllNode((TreeNode)membertree);
    }

    @Override
    protected void setVisible4variable() {
        String dimNumber = this.getPageCache().get("number");
        if (DimTypesEnum.YEAR.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"addradio", "deleteradio", "valuecombo"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"addradio", "deleteradio", "valuecombo"});
    }

    @Override
    protected void initMemberTreeViewAp(String nodeId) {
        TreeView treeView = (TreeView)this.getView().getControl("membertreeap");
        treeView.setMulti(true);
        treeView.deleteAllNodes();
        TreeNode root = new TreeNode("", nodeId, nodeId);
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        ArrayList memberList = Lists.newArrayList();
        HashMap<String, String> rootMember = new HashMap<String, String>();
        rootMember.put("id", nodeId);
        rootMember.put("number", nodeId);
        rootMember.put("name", nodeId);
        memberList.add(rootMember);
        this.getPageCache().put("memberlist", SerializationUtils.toJsonString((Object)memberList));
    }

    private void setEntryNode(TreeNode membertree, List<Map<String, String>> menberList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> node : menberList) {
            String parentId = node.get("parentid");
            List nodeList = nodeMap.computeIfAbsent(parentId, k -> new ArrayList());
            nodeList.add(node);
        }
        DataSetDimGuideEBPlugin.createNode(membertree, nodeMap, headId);
    }

    private static void createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            int i = 0;
            int maxCount = BCMTreeUtils.getMaxCount((long)0L);
            for (Map<String, String> map : list) {
                if (maxCount > 0 && ++i > maxCount) {
                    return;
                }
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get("number") + " " + map.get("name"));
                String entryHeadId = map.get("id");
                DataSetDimGuideEBPlugin.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
    }

    @Override
    protected TreeNode initTreeViewAp() {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        TreeNode root = new TreeNode();
        root.setId("root");
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"id,number,name,shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong((Object)this.getFormCustomParam("modelId")))});
        List dim = EbServiceHelper.getDim((String)model.getString("shownumber"), (String)this.getFormCustomParam("dataSetNumber").toString());
        HashMap map = Maps.newHashMapWithExpectedSize((int)dim.size());
        HashMap numberShortNumberMap = Maps.newHashMapWithExpectedSize((int)dim.size());
        String currentNode = (String)this.getView().getFormShowParameter().getCustomParam("currentnode");
        for (EbDim task : dim) {
            String taskNum = task.getNumber();
            if (!Objects.isNull(currentNode) && !currentNode.equalsIgnoreCase(taskNum)) continue;
            TreeNode dimensionNode = new TreeNode();
            String id = task.getNumber();
            dimensionNode.setId(id);
            dimensionNode.setText(String.format("%s(%s)", task.getNumber(), task.getName()));
            dimensionNode.setData((Object)task);
            root.addChild(dimensionNode);
            map.put(id, Lists.newArrayList((Object[])new String[]{task.getNumber(), ""}));
            numberShortNumberMap.put(task.getShortNumber(), task.getNumber());
        }
        if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25,\u8bf7\u68c0\u67e5\u6e90\u4f53\u7cfb\u662f\u5426\u5b58\u5728\u3002", (String)"DataSetDimGuidePlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        TreeNode curNode = (TreeNode)root.getChildren().get(0);
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.focusNode(curNode);
        tree.expand("root");
        this.getPageCache().put("dimTreeNode", SerializationUtils.toJsonString((Object)map));
        this.getPageCache().put("number", ((EbDim)curNode.getData()).getNumber());
        this.getPageCache().put("number_short_number_map", SerializationUtils.toJsonString((Object)numberShortNumberMap));
        return curNode;
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String nodeId = (String)treeNodeEvent.getNodeId();
        List<TreeNode> childNodes = this.loadChildNode(nodeId);
        TreeView treeView = (TreeView)this.getView().getControl("membertreeap");
        treeView.addNodes(childNodes);
    }

    private List<TreeNode> loadChildNode(String parentId) {
        String dimNumber = this.getPageCache().get("number");
        String dataSetNumber = (String)this.getFormCustomParam("dataSetNumber");
        String modelNumber = (String)this.getFormCustomParam("modelNumber");
        List member = EbServiceHelper.getMember((String)modelNumber, (String)dataSetNumber, (String)dimNumber, (String)parentId, (RangeEnum)RangeEnum.VALUE_20);
        ArrayList childNodes = Lists.newArrayListWithExpectedSize((int)member.size());
        List memberList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("memberlist"), List.class);
        for (EbMember ebMember : member) {
            TreeNode node = new TreeNode(parentId, ebMember.getNumber(), ebMember.getName());
            if (!ebMember.isLeaf()) {
                node.setChildren(new ArrayList());
            }
            childNodes.add(node);
            HashMap memberMap = Maps.newHashMap();
            memberMap.put("id", ebMember.getNumber());
            memberMap.put("number", ebMember.getNumber());
            memberMap.put("name", ebMember.getName());
            memberList.add(memberMap);
        }
        this.getPageCache().put("memberlist", SerializationUtils.toJsonString((Object)memberList));
        return childNodes;
    }
}

