/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BcmPermService;
import kd.epm.far.business.bcm.exchangeRate.ExchageRateServiceHelper;
import kd.epm.far.business.common.AppUtil;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.control.tree.ITreeNode;
import kd.epm.far.business.common.control.tree.TreeModel;
import kd.epm.far.business.common.control.tree.virtualload.SearchCursor;
import kd.epm.far.business.common.control.tree.virtualload.SimpleTreeNode;
import kd.epm.far.business.common.dataset.util.DatasetCheckUtil;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.MessageConstant;
import kd.epm.far.common.common.PresetConstant;
import kd.epm.far.common.common.cache.GlobalCacheServiceHelper;
import kd.epm.far.common.common.cache.IDNumberTreeNode;
import kd.epm.far.common.common.cache.MemberReader;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.dimension.OrgStoreStatusEnum;
import kd.epm.far.common.common.enums.dimension.SystemVarsEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.ObjectSerialUtil;
import kd.epm.far.formplugin.common.dataset.CommonDataSetDimGuidePlugin;
import kd.epm.far.formplugin.common.util.DimensionUtil;
import kd.epm.far.formplugin.common.util.ModelUtil;
import org.apache.commons.lang3.tuple.Pair;

public class DataSetDimGuidePlugin
extends CommonDataSetDimGuidePlugin {
    private static final String treeviewap = "treeviewap";
    private static final String MEMBERLIST = "memberlist";
    private static final String VARIABLELIST = "variablelist";
    private static final String MEMBER_TREEAP = "membertreeap";
    private static final String VARIABLE_TREEAP = "variabletreeap";
    private static final String TREEROOT = "treeroot";
    private static final String DIM_ENTITY_NAME = "membermodel";
    private static final String DIM_NUMBER = "number";
    private static final String TREE_NODE_ID = "tree_node_id";
    private static final String DIM_NUMBER_MAP = "number_short_number_map";
    private static final String CURRENTDIMNUMBER = "currentDimNumber";
    private static final String DIM_TREE_NODE = "dimTreeNode";
    private static final String entryentity = "entryentity";
    private static final String DIM_SHORT_NUMBER = "dimshortnumber";
    private static final String TAB = "tabap";
    private static final String CUR_TAB = "curtab";
    private static final String DIM_EXPRESSSION = "dimexpresssion";
    private static final String SEARCHAP = "searchap";
    private static final String SEARCH_CURSOR = "Search_Cursor";
    private static final String COLOR = "#fc8055";
    private static final String FOCUS = "focus";
    private static final String ROW_LIST = "rowlist";
    private static final String OPENED_NODE_IDS = "Opened_Node_Ids";
    private static final String EMPTY_STRING = "";
    private static final String ALL_SELECTED_MEMBER = "all_selected_member";

    private static void createNode(TreeNode root, Map<String, List<Map<String, String>>> nodeMap, String headId) {
        List<Map<String, String>> list = nodeMap.get(headId);
        if (list != null) {
            ArrayList<TreeNode> children = root.getChildren();
            if (children == null) {
                children = new ArrayList<TreeNode>(list.size());
                root.setChildren(children);
            }
            int i = 0;
            int maxCount = BCMTreeUtils.getMaxCount((long)0L);
            for (Map<String, String> map : list) {
                if (maxCount > 0 && ++i > maxCount) {
                    return;
                }
                TreeNode entry = new TreeNode();
                entry.setParentid(headId);
                entry.setId(map.get("id"));
                entry.setText(map.get(DIM_NUMBER) + " " + map.get("name"));
                String entryHeadId = map.get("id");
                DataSetDimGuidePlugin.createNode(entry, nodeMap, entryHeadId);
                children.add(entry);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getControl(TAB);
        tab.addTabSelectListener((TabSelectListener)this);
        TreeView tree = (TreeView)this.getView().getControl(treeviewap);
        tree.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                DataSetDimGuidePlugin.this.treeOnClick(evt);
            }
        });
        TreeView memberTree = (TreeView)this.getControl(MEMBER_TREEAP);
        memberTree.addTreeNodeQueryListener(arg0 -> {
            String dimNumber = this.getPageCache().get(DIM_NUMBER);
            if (DimTypesEnum.ACCOUNT.getNumber().equals(dimNumber)) {
                this.loadTreeNode4Virtrual(memberTree, (String)arg0.getNodeId());
                memberTree.expand((String)arg0.getNodeId());
            }
        });
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener(var1 -> {
            if (var1.getText() != null && !EMPTY_STRING.equals(var1.getText())) {
                if (this.isAccount()) {
                    this.searchMember4Virtrual(var1.getText().toLowerCase(Locale.ENGLISH).trim());
                } else {
                    this.searchMember(var1.getText().toLowerCase(Locale.ENGLISH).trim());
                }
            } else {
                this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            }
        });
        this.addClickListeners("imageup", "imagedown");
    }

    private TreeNode clearColor() {
        String serial = this.getPageCache().get(FOCUS);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        if (StringUtils.isEmpty((CharSequence)serial)) {
            return root;
        }
        int oldfocus = (Integer)ObjectSerialUtil.deSerializedBytes((String)serial);
        TreeNode[] list = (TreeNode[])SerializationUtils.fromJsonString((String)this.getPageCache().get(ROW_LIST), TreeNode[].class);
        TreeNode oldnode = list[oldfocus];
        TreeView mTree = (TreeView)this.getControl(MEMBER_TREEAP);
        oldnode.setColor(EMPTY_STRING);
        List ids = mTree.getTreeState().getCheckedNodeIds();
        mTree.updateNodes((List)Lists.newArrayList((Object[])new TreeNode[]{oldnode}));
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (String l : ids) {
            TreeNode node = root.getTreeNode(l, 10);
            nodes.add(node);
        }
        mTree.checkNodesWithoutChild(nodes);
        return root;
    }

    private void searchMember(String text) {
        TreeNode root = this.clearColor();
        TreeView mTree = (TreeView)this.getControl(MEMBER_TREEAP);
        List<TreeNode> treeNodes = new ArrayList<TreeNode>();
        if (!(treeNodes = this.getTreeNodeListByText(root, treeNodes, text)).isEmpty()) {
            this.expandTreeViewFocusNode(mTree, root, treeNodes.get(0));
            this.getPageCache().put(ROW_LIST, SerializationUtils.toJsonString((Object)treeNodes.toArray()));
            TreeNode asd = treeNodes.get(0);
            this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)0));
            asd.setColor(COLOR);
            mTree.updateNodes((List)Lists.newArrayList((Object[])new TreeNode[]{asd}));
            mTree.focusNode(asd);
            this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)root));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"MultipleMemberF7BasePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        List ids = mTree.getTreeState().getCheckedNodeIds();
        if (ids != null && !ids.isEmpty()) {
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(ids.size());
            for (String l : ids) {
                TreeNode node = root.getTreeNode(l, 10);
                nodes.add(node);
            }
            mTree.checkNodesWithoutChild(nodes);
        }
    }

    private void expandTreeViewFocusNode(TreeView treeView, TreeNode root, TreeNode focusNode) {
        Stack<TreeNode> focusNodePathStack = this.getFocusNodePathStack(root, focusNode);
        while (!focusNodePathStack.isEmpty()) {
            TreeNode popTreeNode = focusNodePathStack.pop();
            popTreeNode.setIsOpened(true);
            treeView.expand(popTreeNode.getId());
        }
    }

    private Stack<TreeNode> getFocusNodePathStack(TreeNode root, TreeNode focusNode) {
        int level = root.getNodeLevel(focusNode.getId(), 0);
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>(16);
        this.getTreeNodeByLevel(root, level, map);
        Stack<TreeNode> stack = new Stack<TreeNode>();
        String id = focusNode.getParentid();
        while (map.containsKey(id)) {
            stack.push((TreeNode)map.get(id));
            id = ((TreeNode)map.get(id)).getParentid();
        }
        return stack;
    }

    public void getTreeNodeByLevel(TreeNode root, int maxLevel, Map<String, TreeNode> levelAllMap) {
        List children;
        int level = root.getNodeLevel(root.getId(), 1);
        levelAllMap.put(root.getId(), root);
        if (level < maxLevel && (children = root.getChildren()) != null && !children.isEmpty()) {
            for (TreeNode child : children) {
                this.getTreeNodeByLevel(child, maxLevel, levelAllMap);
            }
        }
    }

    private List<TreeNode> getTreeNodeListByText(TreeNode node, List<TreeNode> treeNodes, String text) {
        if (node.getText().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))) {
            treeNodes.add(node);
        }
        if (node.getChildren() != null) {
            for (TreeNode child : node.getChildren()) {
                this.getTreeNodeListByText(child, treeNodes, text);
            }
        }
        return treeNodes;
    }

    @Override
    protected boolean isAccount() {
        String dimNumber = this.getPageCache().get(DIM_NUMBER);
        return DimTypesEnum.ACCOUNT.getNumber().equals(dimNumber);
    }

    private void searchMember4Virtrual(String text) {
        List searchList = this.getAccountTreeModel().seekAllChildrenIf("0", p -> p.getName().toLowerCase(Locale.ENGLISH).contains(text));
        SearchCursor cursor = new SearchCursor();
        searchList.forEach(s -> cursor.addSearchItem(s.getId()));
        if (searchList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"MultipleMemberF7BasePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            this.next4Virtrual(cursor);
        }
        this.getPageCache().put(SEARCH_CURSOR, ObjectSerialUtil.toByteSerialized((Object)cursor));
    }

    private void next4Virtrual(SearchCursor scursor) {
        if (scursor == null && this.getPageCache().get(SEARCH_CURSOR) == null) {
            this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            return;
        }
        SearchCursor cursor = scursor != null ? scursor : (SearchCursor)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SEARCH_CURSOR));
        String next = cursor.next();
        this.colorTreeNode4Search(next, cursor.getPrevNodeId());
        this.getPageCache().put(SEARCH_CURSOR, ObjectSerialUtil.toByteSerialized((Object)cursor));
    }

    private void colorTreeNode4Search(String nodeId, String prevNodeId) {
        TreeView mTree = (TreeView)this.getControl(MEMBER_TREEAP);
        ITreeNode node = (ITreeNode)this.getAccountTreeModel().getDict().get(nodeId);
        if (node == null) {
            return;
        }
        Set opendNodeIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(OPENED_NODE_IDS), Set.class);
        TreeNode root = null;
        if (!(node.getParent() != null && opendNodeIds.contains(node.getParent().getId()) || opendNodeIds.contains(node.getId()))) {
            root = this.loadTreeNode4Virtrual(mTree, nodeId);
            opendNodeIds = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(OPENED_NODE_IDS), Set.class);
        } else {
            root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
        }
        ArrayList<TreeNode> colorList = new ArrayList<TreeNode>(2);
        if (StringUtils.isNotEmpty((CharSequence)prevNodeId)) {
            TreeNode preTreeNode;
            ITreeNode preNode = (ITreeNode)this.getAccountTreeModel().getDict().get(prevNodeId);
            TreeNode preN = new TreeNode(preNode.getParent().getId(), preNode.getId(), preNode.getName());
            preN.setColor(EMPTY_STRING);
            if (!preNode.isLeaf() && (preTreeNode = root.getTreeNode(prevNodeId, 10)) != null) {
                preN.setChildren(preTreeNode.getChildren());
            }
            colorList.add(preN);
        }
        TreeNode asd = new TreeNode(node.getParent().getId(), node.getId(), node.getName());
        asd.setColor(COLOR);
        colorList.add(asd);
        TreeNode currNode = root.getTreeNode(nodeId, 10);
        if (!node.isLeaf() && currNode != null) {
            asd.setChildren(currNode.getChildren());
        }
        mTree.updateNodes(colorList);
        mTree.focusNode(asd);
        opendNodeIds.forEach(arg_0 -> ((TreeView)mTree).expand(arg_0));
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection doc = (DynamicObjectCollection)model.getEntryEntity(entryentity).clone();
        switch (key) {
            case "imageup": 
            case "imagedown": {
                int newfocus;
                if (this.isAccount()) {
                    if (key.equals("imageup")) {
                        this.prev4Virtrual();
                    } else {
                        this.next4Virtrual(null);
                    }
                    return;
                }
                String serial = this.getPageCache().get(ROW_LIST);
                if (StringUtils.isEmpty((CharSequence)serial)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                TreeNode[] list = (TreeNode[])SerializationUtils.fromJsonString((String)serial, TreeNode[].class);
                if (list == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                serial = this.getPageCache().get(FOCUS);
                int oldfocus = (Integer)ObjectSerialUtil.deSerializedBytes((String)serial);
                TreeNode oldnode = list[oldfocus];
                if (key.equals("imageup")) {
                    if (0 == oldfocus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    newfocus = oldfocus - 1;
                } else {
                    if (list.length - 1 == oldfocus) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"MultipleMemberF7BasePlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    newfocus = oldfocus + 1;
                }
                TreeNode newnode = list[newfocus];
                this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)newfocus));
                TreeView mTree = (TreeView)this.getControl(MEMBER_TREEAP);
                newnode.setColor(COLOR);
                oldnode.setColor(EMPTY_STRING);
                List checkIds = mTree.getTreeState().getCheckedNodeIds();
                mTree.updateNodes((List)Lists.newArrayList((Object[])new TreeNode[]{oldnode, newnode}));
                ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
                TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOT), TreeNode.class);
                this.expandTreeViewFocusNode(mTree, root, newnode);
                for (String l : checkIds) {
                    TreeNode node = root.getTreeNode(l, 10);
                    nodes.add(node);
                }
                mTree.focusNode(newnode);
                mTree.checkNodesWithoutChild(nodes);
                this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)root));
                break;
            }
        }
    }

    private void prev4Virtrual() {
        if (this.getPageCache().get(SEARCH_CURSOR) == null) {
            this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
            return;
        }
        SearchCursor cursor = (SearchCursor)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(SEARCH_CURSOR));
        String prev = cursor.prev();
        this.colorTreeNode4Search(prev, cursor.getPrevNodeId());
        this.getPageCache().put(SEARCH_CURSOR, ObjectSerialUtil.toByteSerialized((Object)cursor));
    }

    private void buildModelEntryRow(IDataModel model, Map<String, String> rangeMap, String shortNumber, List<Map<String, String>> newMemberList) {
        int[] rows = model.batchCreateNewEntryRow(entryentity, newMemberList.size());
        int index = 0;
        boolean account = this.isAccount();
        for (Map<String, String> member : newMemberList) {
            member.put("shortNumber", shortNumber);
            model.setValue(DIM_SHORT_NUMBER, (Object)shortNumber, rows[index]);
            model.setValue(DIM_NUMBER, (Object)member.get(DIM_NUMBER), rows[index]);
            if (account) {
                String[] split = member.get("name").split(" ");
                model.setValue("name", (Object)split[split.length - 1], rows[index]);
                member.put("name", split[split.length - 1]);
            } else {
                model.setValue("name", (Object)member.get("name"), rows[index]);
            }
            if (CollectionUtils.isEmpty(rangeMap)) {
                model.setValue("range", (Object)member.get("range"), rows[index]);
                model.setValue("rangename", (Object)member.get("rangename"), rows[index]);
            } else {
                model.setValue("range", (Object)rangeMap.get("range"), rows[index]);
                model.setValue("rangename", (Object)rangeMap.get("rangename"), rows[index]);
                member.put("range", rangeMap.get("range"));
                member.put("rangename", rangeMap.get("rangename"));
            }
            ++index;
        }
    }

    private void treeOnClick(TreeNodeEvent tree) {
        TreeView mTree = (TreeView)this.getControl(MEMBER_TREEAP);
        mTree.deleteAllNodes();
        Map dimMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(DIM_TREE_NODE), Map.class);
        String nodeId = (String)tree.getNodeId();
        this.getPageCache().put(TREE_NODE_ID, nodeId);
        this.getPageCache().put(DIM_NUMBER, (String)((List)dimMap.get(nodeId)).get(0));
        this.getPageCache().put(DIM_ENTITY_NAME, (String)((List)dimMap.get(nodeId)).get(1));
        this.getPageCache().put(DIM_SHORT_NUMBER, this.getShortNumber((String)((List)dimMap.get(nodeId)).get(0)));
        this.initEntryentity(this.getShortNumber((String)((List)dimMap.get(nodeId)).get(0)));
        this.initMemberTreeViewAp(LongUtil.toLong((Object)nodeId));
        this.initVariableViewAp();
        this.setVisible4variable();
        Search search = (Search)this.getControl(SEARCHAP);
        search.setSearchKey(EMPTY_STRING);
    }

    private void initEntryentity(String shortNumber) {
        IDataModel model = this.getModel();
        model.deleteEntryData(entryentity);
        String s = this.getPageCache().get(ALL_SELECTED_MEMBER);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return;
        }
        List members = (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List<Map<String, String>> newMemberList = members.stream().filter(t -> shortNumber.equals(t.get("shortNumber"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newMemberList)) {
            return;
        }
        this.buildModelEntryRow(model, null, shortNumber, newMemberList);
    }

    private String getShortNumber(String number) {
        Long modelId = (Long)this.getFormCustomParam("modelId");
        Map shortNumberMap = BCMMemberReader.getDimensionShortNumber2NumberMap((String)BCMMemberReader.findModelNumberById((Object)modelId));
        for (Map.Entry entry : shortNumberMap.entrySet()) {
            if (!Objects.equals(number, entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeNode treeNode = this.initTreeViewAp();
        this.initMemberTreeViewAp(LongUtil.toLong((Object)treeNode.getId()));
        this.initVariableViewAp();
        this.setVisible4variable();
        String currentNode = (String)this.getView().getFormShowParameter().getCustomParam("currentnode");
        if (Objects.nonNull(currentNode)) {
            String shortNumber = DimTypesEnum.getShortNumberByNumber((String)currentNode);
            this.getPageCache().put(DIM_SHORT_NUMBER, shortNumber);
        } else {
            this.getPageCache().put(DIM_SHORT_NUMBER, DimTypesEnum.ENTITY.getShortNumber());
        }
        this.getPageCache().put(CUR_TAB, "membertab");
        this.getPageCache().put(TREE_NODE_ID, treeNode.getId());
    }

    @Override
    protected void setSelectedMember() {
        String[] split;
        this.getPageCache().put(DIM_SHORT_NUMBER, DimTypesEnum.ENTITY.getShortNumber());
        String expression = (String)this.getFormCustomParam("expression");
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return;
        }
        this.checkExpression(expression);
        this.getModel().setValue(DIM_EXPRESSSION, (Object)expression);
        ArrayList memberList = Lists.newArrayList();
        String modelNum = BCMMemberReader.findModelNumberById((Object)this.getFormCustomParam("modelId"));
        Map shortNumberMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(DIM_NUMBER_MAP), Map.class);
        for (String s : split = expression.split(",")) {
            if (s.contains("{")) {
                String[] split2;
                String[] split1 = s.split("\\{");
                String members = split1[1];
                members = members.substring(0, members.length() - 1);
                String shortNumber = split1[0].substring(0, split1[0].length() - 1);
                for (String member : split2 = members.split(";")) {
                    HashMap map = Maps.newHashMap();
                    DatasetExpressionHelper.buildMemberMap((String)shortNumber, (String)member, (Map)map, (String)modelNum, (String)((String)shortNumberMap.get(shortNumber)), (String)DatasetExpressionHelper.ExpressoinPurpose.DATASETFORMULA.toString());
                    memberList.add(map);
                }
                continue;
            }
            String[] splitCheck = s.split("\\.");
            if (splitCheck.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String[] split1 = DatasetExpressionHelper.splitDimAndMemb((String)s);
            if (split1.length < 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u65e0\u6cd5\u89e3\u6790\u7684\u7ef4\u5ea6\u6210\u5458", (String)"DataSetDimGuidePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            HashMap map = Maps.newHashMap();
            DatasetExpressionHelper.buildMemberMap((String)split1[0], (String)split1[1], (Map)map, (String)modelNum, (String)((String)shortNumberMap.get(split1[0])), (String)DatasetExpressionHelper.ExpressoinPurpose.DATASETFORMULA.toString());
            memberList.add(map);
        }
        this.getPageCache().put(ALL_SELECTED_MEMBER, JSON.toJSONString((Object)memberList));
        List<Map<String, String>> entityList = memberList.stream().filter(t -> DimTypesEnum.ENTITY.getShortNumber().equals(t.get("shortNumber"))).collect(Collectors.toList());
        this.move2right(entityList, Collections.emptyList(), this.getModel(), Collections.emptyMap());
    }

    @Override
    protected void initVariableViewAp() {
        if (!this.isCurrentApp()) {
            return;
        }
        TreeView mTree = (TreeView)this.getControl(VARIABLE_TREEAP);
        mTree.deleteAllNodes();
        TreeNode membertree = new TreeNode();
        membertree.setId("0");
        membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        ArrayList<Map<String, String>> memberList = new ArrayList<Map<String, String>>(8);
        HashMap<String, String> cur = new HashMap<String, String>(8);
        cur.put("id", SystemVarsEnum.CURRENT.getId());
        cur.put(DIM_NUMBER, "$Cur");
        cur.put("name", ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458", (String)"DataSetDimGuidePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        cur.put("parentid", "0");
        memberList.add(cur);
        HashMap<String, String> all = new HashMap<String, String>(8);
        all.put("id", "20");
        all.put(DIM_NUMBER, "$All");
        all.put("name", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
        all.put("parentid", "0");
        memberList.add(all);
        this.getPageCache().put(VARIABLELIST, SerializationUtils.toJsonString(memberList));
        this.setEntryNode(membertree, memberList, "0");
        mTree.addNode(membertree);
        BCMTreeUtils.spreadAllNode((TreeNode)membertree);
    }

    @Override
    protected void setVisible4variable() {
        String dimNumber = this.getPageCache().get(DIM_NUMBER);
        if (DimTypesEnum.YEAR.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"addradio", "deleteradio", "valuecombo"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"addradio", "deleteradio", "valuecombo"});
    }

    private void initMemberTreeViewAp(Long nodeId) {
        TreeView mTree = (TreeView)this.getControl(MEMBER_TREEAP);
        mTree.deleteAllNodes();
        Long modelId = (Long)this.getFormCustomParam("modelId");
        DynamicObjectCollection dcs = null;
        TreeNode membertree = new TreeNode();
        String dimNumber = this.getPageCache().get(DIM_NUMBER);
        if (DimTypesEnum.ACCOUNT.getNumber().equals(dimNumber)) {
            String modelNumber = BCMMemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode accountMember = MemberReader.findMemberByNumberEx((String)modelNumber, (String)PresetConstant.ACCOUNT_DIM, (String)PresetConstant.ACCOUNT_DIM);
            membertree = this.loadTreeNode4Virtrual(mTree, EMPTY_STRING + accountMember.getId());
        } else {
            dcs = this.getPresetMemberDoc(nodeId);
            List<Map<String, String>> memberList = this.getMemberList(dcs, null);
            Map<Long, List<Long>> relationMap = this.buildRelation(dcs);
            this.delNoPermMember(memberList, relationMap);
            membertree.setId("0");
            membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            String headId = memberList.isEmpty() ? "0" : memberList.get(0).get("parentid");
            this.setEntryNode(membertree, memberList, String.valueOf(headId));
            mTree.addNode(membertree);
            String entityName = this.getPageCache().get(DIM_ENTITY_NAME);
            if (DimensionUtil.isExpand2SecondLevel4MultiMemberF7(entityName)) {
                mTree.expand(membertree.getId());
                if (membertree.getChildren() != null) {
                    membertree.getChildren().forEach(c -> mTree.expand(c.getId()));
                }
            } else {
                BCMTreeUtils.spreadAllNode((TreeNode)membertree);
            }
            this.getPageCache().put(MEMBERLIST, SerializationUtils.toJsonString(memberList));
        }
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)membertree));
    }

    private Map<Long, List<Long>> buildRelation(DynamicObjectCollection doc) {
        HashMap<Long, List<Long>> relationMap = new HashMap<Long, List<Long>>();
        doc.forEach(p -> {
            long parentId;
            long id = p.getLong("id");
            long l = parentId = p.get("parent") instanceof DynamicObject ? p.getLong("parent_id") : p.getLong("parent");
            if (relationMap.get(parentId) != null) {
                ((List)relationMap.get(parentId)).add(id);
            } else {
                ArrayList<Long> children = new ArrayList<Long>();
                children.add(id);
                relationMap.put(parentId, children);
            }
        });
        return relationMap;
    }

    private void delNoPermMember(List<Map<String, String>> memberList, Map<Long, List<Long>> relationMap) {
        Long modelId = (Long)this.getFormCustomParam("modelId");
        if (MemberPermHelper.isModelAdmin((Long)LongUtil.toLong((Object)modelId))) {
            return;
        }
        String dimNumber = this.getPageCache().get(DIM_NUMBER);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType());
        List dimensionInfos = modelStrategyEx.getDim().getDimList();
        DimensionInfo dimension = DimensionUtils.getDimByNumber((List)dimensionInfos, (String)dimNumber);
        Long dimId = 0L;
        if (dimension != null) {
            dimId = dimension.getId();
        }
        BcmPermService bcmPermService = new BcmPermService(modelId, dimId);
        Iterator<Map<String, String>> permIt = memberList.iterator();
        while (permIt.hasNext()) {
            Map<String, String> map = permIt.next();
            if (this.memberCanShow(LongUtil.toLong((Object)map.get("id")), bcmPermService, relationMap, dimId)) continue;
            permIt.remove();
        }
    }

    private boolean memberCanShow(Long memberId, BcmPermService bcmPermService, Map<Long, List<Long>> relationMap, Long dimId) {
        if (bcmPermService.hasPerm(memberId)) {
            return true;
        }
        if (relationMap.get(memberId) != null) {
            for (long id : relationMap.get(memberId)) {
                if (!this.memberCanShow(id, bcmPermService, relationMap, dimId)) continue;
                return true;
            }
        }
        return false;
    }

    private void setEntryNode(TreeNode membertree, List<Map<String, String>> menberList, String headId) {
        HashMap<String, List<Map<String, String>>> nodeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> node : menberList) {
            String parentId = node.get("parentid");
            List nodeList = nodeMap.computeIfAbsent(parentId, k -> new ArrayList());
            nodeList.add(node);
        }
        DataSetDimGuidePlugin.createNode(membertree, nodeMap, headId);
    }

    protected List<Map<String, String>> getMemberList(DynamicObjectCollection dcs, String property) {
        if (dcs == null || dcs.isEmpty()) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> menberList = new ArrayList<Map<String, String>>(8);
        for (DynamicObject task : dcs) {
            HashMap<String, String> memberMap = new HashMap<String, String>(8);
            memberMap.put("id", task.get("id").toString());
            memberMap.put(DIM_NUMBER, task.getString(DIM_NUMBER));
            memberMap.put("name", task.getString("name"));
            memberMap.put("parentid", task.getString("parent"));
            memberMap.put("level", task.getString("level"));
            memberMap.put("dseq", task.getString("dseq"));
            memberMap.put("dimnumber", this.getPageCache().get(CURRENTDIMNUMBER));
            memberMap.put("propertyid", property == null ? null : task.getString(property));
            menberList.add(memberMap);
        }
        return menberList;
    }

    protected DynamicObjectCollection getPresetMemberDoc(Long nodeId) {
        String parentFormId;
        String entityName = this.getPageCache().get(DIM_ENTITY_NAME);
        String selectFields = "id,name,number,parent,storagetype,longnumber,isleaf,level,dseq";
        QFilter filter1 = new QFilter("dimension", "=", (Object)nodeId);
        filter1.and("status", "!=", (Object)OrgStoreStatusEnum.DISABLE.getValue());
        if (this.isBcm() && !"bcm_isschemeassign".equals(parentFormId = this.getView().getParentView().getFormShowParameter().getFormId())) {
            ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)filter1, (String)entityName);
        }
        this.filterFyAndPeriod(filter1, entityName);
        if ("bcm_audittrialmembertree".equals(entityName) && AppUtil.isEpmAppId((String)ModelUtil.queryApp(this.getView()).getAppnum())) {
            filter1.and(new QFilter(DIM_NUMBER, "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal")));
        }
        QFilter[] filters = new QFilter[]{filter1};
        String orderBys = this.getPresetMemberOrder();
        if ("bcm_entitymembertree".equals(entityName)) {
            if (AppUtil.isEpmAppId((String)this.getView().getFormShowParameter().getAppId())) {
                selectFields = selectFields + ",entitypart.isoffsetentry";
                DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
                query.removeIf(dy -> dy.getBoolean("entitypart.isoffsetentry"));
                return query;
            }
            return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        }
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    protected String getPresetMemberOrder() {
        return "level asc,dseq asc";
    }

    protected void filterFyAndPeriod(QFilter filter, String membermodel) {
        if ("bcm_fymembertree".equals(membermodel)) {
            filter.and(new QFilter(DIM_NUMBER, "not in", (Object)new String[]{"LastYear", "CurrentYear"}));
        }
        if ("bcm_periodmembertree".equals(membermodel)) {
            filter.and(new QFilter(DIM_NUMBER, "not in", (Object)new String[]{"CurrentPeriod", "LastPeriod", "LastPeriodX"}));
        }
    }

    public boolean isBcm() {
        String entityNumber = this.getView().getFormShowParameter().getParentFormId();
        return StringUtils.isNotEmpty((CharSequence)entityNumber) && entityNumber.startsWith("bcm_");
    }

    private TreeNode loadTreeNode4Virtrual(TreeView mTree, String pNodeId) {
        TreeModel<SimpleTreeNode> treeModel = this.getAccountTreeModel();
        Pair nodePair = treeModel.loadtoNode(mTree, pNodeId);
        ArrayList memberList = Lists.newArrayList();
        ((TreeNode)nodePair.getLeft()).iterate(9999, n -> {
            if (!"0".equals(n.getId())) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                SimpleTreeNode node = (SimpleTreeNode)this.getAccountTreeModel().getDict().get(n.getId());
                map.put("id", node.getId());
                map.put(DIM_NUMBER, node.getNumber());
                map.put("name", node.getName());
                map.put("parentid", node.getParent() != null ? node.getParent().getId() : "0");
                map.put("storagetype", node.getStoragetype() == null ? null : node.getStoragetype());
                memberList.add(map);
            }
        });
        this.getPageCache().put(MEMBERLIST, SerializationUtils.toJsonString((Object)memberList));
        this.getPageCache().put(OPENED_NODE_IDS, SerializationUtils.toJsonString((Object)nodePair.getRight()));
        this.getPageCache().put(TREEROOT, SerializationUtils.toJsonString((Object)nodePair.getLeft()));
        return (TreeNode)nodePair.getLeft();
    }

    private TreeModel<SimpleTreeNode> getAccountTreeModel() {
        String modelNumber = BCMMemberReader.findModelNumberById((Object)this.getFormCustomParam("modelId"));
        String cacheKey = modelNumber + "|" + "bcm_accountmembertree" + "|multiSelAccount";
        TreeModel treeModel = (TreeModel)GlobalCacheServiceHelper.getDimMemberCache().getOrLoad(cacheKey, () -> {
            IDNumberTreeNode root = MemberReader.findMemberByNumberEx((String)modelNumber, (String)PresetConstant.ACCOUNT_DIM, (String)PresetConstant.ACCOUNT_DIM);
            SimpleTreeNode virturlNode = new SimpleTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"DataSetDimGuidePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            TreeModel rootModel = new TreeModel((ITreeNode)virturlNode);
            this.buildTreeModel(root, virturlNode);
            return rootModel;
        });
        this.sortNode((SimpleTreeNode)treeModel.getRoot());
        return treeModel;
    }

    private void sortNode(SimpleTreeNode node) {
        if (!node.isLeaf()) {
            Collections.sort(node.getChildren(), Comparator.comparingInt(c -> (Integer)((SimpleTreeNode)c).getDetailData().get("dseq")));
            for (ITreeNode child : node.getChildren()) {
                this.sortNode((SimpleTreeNode)child);
            }
        }
    }

    private void buildTreeModel(IDNumberTreeNode currNode, SimpleTreeNode rootNode) {
        SimpleTreeNode simpleChildNode = this.constructSimpleTreeNode(currNode);
        rootNode.addChild((ITreeNode)simpleChildNode);
        currNode.getChildren().forEach(c -> this.buildTreeModel((IDNumberTreeNode)c, simpleChildNode));
    }

    private SimpleTreeNode constructSimpleTreeNode(IDNumberTreeNode node) {
        SimpleTreeNode snode = new SimpleTreeNode(EMPTY_STRING + node.getId(), node.getNumber() + " " + node.getName());
        snode.setNumber(node.getNumber());
        snode.setStoragetype(node.getStorageType().index);
        snode.getDetailData().put("dseq", node.getdSeq());
        return snode;
    }

    @Override
    protected TreeNode initTreeViewAp() {
        TreeView tree = (TreeView)this.getView().getControl(treeviewap);
        TreeNode root = new TreeNode();
        root.setId("root");
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,dseq";
        QFilter fmodelid = new QFilter("model", "=", this.getFormCustomParam("modelId"));
        QFilter[] filters = new QFilter[]{fmodelid};
        String orderBys = "dseq";
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"bcm_dimension", (String)selectFields, (QFilter[])filters, (String)orderBys);
        HashMap map = Maps.newHashMapWithExpectedSize((int)dcs.size());
        HashMap numberShortNumberMap = Maps.newHashMapWithExpectedSize((int)dcs.size());
        String currentNode = (String)this.getView().getFormShowParameter().getCustomParam("currentnode");
        boolean isRPT = this.isRPT(this.getFormCustomParam("modelId"));
        String extendModelId = (String)this.getFormCustomParam("extendId");
        Set extendsDims = null;
        if (StringUtils.isNotBlank((CharSequence)extendModelId) && LongUtil.isvalidLong((Object)extendModelId)) {
            extendsDims = DatasetCheckUtil.getExtendsDims((Long)Long.valueOf(extendModelId));
        }
        for (DynamicObject task : dcs) {
            String dimNumber = task.getString(DIM_NUMBER);
            if (isRPT && DmDimMemberEntityEnum.BCM_PROCESS.getNumber().equals(dimNumber)) continue;
            String shortnumber = task.getString("shortnumber");
            if (extendsDims != null && !extendsDims.contains(shortnumber) || !Objects.isNull(currentNode) && !currentNode.equalsIgnoreCase(dimNumber)) continue;
            TreeNode dimensionNode = new TreeNode();
            String id = task.getString("id");
            dimensionNode.setId(id);
            dimensionNode.setText(String.format("%s(%s)", task.getString("name"), task.getString("shortnumber")));
            dimensionNode.setData((Object)task);
            root.addChild(dimensionNode);
            map.put(id, Lists.newArrayList((Object[])new String[]{dimNumber, task.getString(DIM_ENTITY_NAME)}));
            numberShortNumberMap.put(shortnumber, dimNumber);
        }
        if (CollectionUtils.isEmpty((Collection)root.getChildren())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25,\u8bf7\u68c0\u67e5\u6e90\u4f53\u7cfb\u662f\u5426\u5b58\u5728\u3002", (String)"DataSetDimGuidePlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        TreeNode curNode = (TreeNode)root.getChildren().get(0);
        tree.deleteAllNodes();
        tree.addNode(root);
        tree.focusNode(curNode);
        tree.expand("root");
        this.getPageCache().put(DIM_TREE_NODE, SerializationUtils.toJsonString((Object)map));
        this.getPageCache().put(DIM_ENTITY_NAME, ((DynamicObject)curNode.getData()).getString(DIM_ENTITY_NAME));
        this.getPageCache().put(DIM_NUMBER, ((DynamicObject)curNode.getData()).getString(DIM_NUMBER));
        this.getPageCache().put(DIM_NUMBER_MAP, SerializationUtils.toJsonString((Object)numberShortNumberMap));
        return curNode;
    }

    private boolean isRPT(Object modelId) {
        DynamicObject bcmmodel = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model");
        String type = bcmmodel.getString("reporttype");
        return ApplicationTypeEnum.RPT.getOIndex().equals(type) || ApplicationTypeEnum.PUB.getOIndex().equals(type);
    }
}

