/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.common.dataset.dto.CheckTreeNodeInfo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DimInfo;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.common.util.ComboEditUtil;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDataset;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.business.far.enums.ModelSourceEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.dataset.AbstractDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.SEUtils;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;
import org.apache.commons.collections.CollectionUtils;

public class DataSetDisplayPlugin
extends AbstractDatasetDisplayPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        this.buildSourceComboEdit();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            this.afterCreateNewDataNew();
        } else if (OperationStatus.EDIT.equals((Object)operationStatus)) {
            this.afterCreateNewDataEdit();
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        if (StringUtils.isEmpty((CharSequence)eventName)) {
            log.info("customEvent eventName is empty");
            return;
        }
        String eventArgs = evt.getEventArgs();
        if (eventName.equals(AbstractDatasetDisplayPlugin.CallBackType.EVENT_CASCADER_EVENT_MEMBER.toString())) {
            this.getMemberData(eventArgs);
        } else if (eventName.equals(AbstractDatasetDisplayPlugin.CallBackType.EVENT_CASCADER_MULTI_MEMBER_F7.toString())) {
            if (!this.getPlugin().getPluginName().equals(DataSetDisplayPlugin.class.getCanonicalName())) {
                return;
            }
            this.openMultiMemberF7(eventArgs);
        }
    }

    private void openMultiMemberF7(String eventArgs) {
        MulBasedataEdit mulF7;
        DynamicObject[] dynamicObjects;
        Long modelSelectId;
        JSONObject joEventArgs = JSONObject.parseObject((String)eventArgs);
        DimensionInfo dimensionInfo = (DimensionInfo)JSONObject.parseObject((String)joEventArgs.getString("dimensionInfo"), DimensionInfo.class);
        JSONArray jaSelectedMembers = joEventArgs.getJSONArray("selectedMembers");
        Object[] array = joEventArgs.getJSONArray("selectedMemberNumbers").toArray();
        String entityName = dimensionInfo.getEntityName();
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)(modelSelectId = Long.valueOf((String)this.getModel().getValue("modelselect"))));
        boolean isEb = modelType == DisModelTypeEnum.EB;
        ArrayList ebIdMapList = new ArrayList(10);
        if (isEb && (dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"number, id", (QFilter[])new QFilter("number", "in", (Object)array).toArray())) != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("number", dynamicObject.getString("number"));
                map.put("id", dynamicObject.getLong("id"));
                ebIdMapList.add(map);
            }
        }
        ArrayList dimMemberInfos = new ArrayList();
        jaSelectedMembers.forEach(a -> {
            if (!(a instanceof JSONObject)) {
                return;
            }
            JSONObject joa = (JSONObject)a;
            joa.put("range", (Object)(Objects.requireNonNull(RangeEnum.getRangeByNumber((String)joa.getString("range"))).getValue() + ""));
            if (isEb) {
                for (Map ebIdMap : ebIdMapList) {
                    DimMemberInfo dimMemberInfo = new DimMemberInfo();
                    if (ebIdMap.get("id") == null || !ebIdMap.get("number").equals(joa.getString("number"))) continue;
                    dimMemberInfo.setId((Long)ebIdMap.get("id"));
                    dimMemberInfo.setName(joa.getString("name"));
                    dimMemberInfo.setNumber(joa.getString("number"));
                    dimMemberInfo.setRange(joa.getInteger("range").intValue());
                    dimMemberInfos.add(dimMemberInfo);
                }
            } else {
                DimMemberInfo dimMemberInfo = new DimMemberInfo();
                dimMemberInfo.setId(null);
                dimMemberInfo.setName(joa.getString("name"));
                dimMemberInfo.setNumber(joa.getString("number"));
                dimMemberInfo.setRange(joa.getInteger("range").intValue());
                dimMemberInfos.add(dimMemberInfo);
            }
        });
        if ("SourceEntity".equals(dimensionInfo.getNumber()) && "SE".equals(dimensionInfo.getShortNumber())) {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelSelectId, modelType.getType());
            List dimList = modelStrategyEx.getDim().getDimList();
            for (DimensionInfo info : dimList) {
                if (!"Entity".equals(info.getNumber()) || !"E".equals(info.getShortNumber())) continue;
                dimensionInfo.setEntityName(info.getEntityName());
                dimensionInfo.setShortNumber(info.getShortNumber());
                dimensionInfo.setNumber(info.getNumber());
                dimensionInfo.setId(info.getId());
                break;
            }
        }
        if ((mulF7 = new ModelStrategyEx(modelSelectId, modelType.getType()).getDimensionF7().openComMutilF7(this.getView(), dimMemberInfos, dimensionInfo, isEb ? "default" : null, (BeforeF7SelectListener)this, "f7_key", this.getPluginName(), true)) != null) {
            mulF7.click();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (actionId.startsWith("f7_key") && Objects.nonNull(evt.getReturnData())) {
            Long modelSelectId;
            ArrayList mapList = new ArrayList(10);
            String dataSrcType = (String)this.getModel().getValue("sourcefrom");
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)(modelSelectId = Long.valueOf((String)this.getModel().getValue("modelselect"))));
            if (modelType == DisModelTypeEnum.EB) {
                ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)evt.getReturnData();
                if (listSelectedRows.size() > 0) {
                    for (ListSelectedRow listSelectedRow : listSelectedRows) {
                        Map dataMap = listSelectedRow.getDataMap();
                        listSelectedRow.getName();
                        HashMap<String, String> map = new HashMap<String, String>(10);
                        map.put("name", listSelectedRow.getName());
                        map.put("id", listSelectedRow.getNumber());
                        map.put("number", listSelectedRow.getNumber());
                        map.put("range", Objects.requireNonNull(RangeEnum.getRangeByVal((int)Integer.parseInt(dataMap.get("scope").toString()))).getNumber());
                        mapList.add(map);
                    }
                }
            } else {
                DynamicObjectCollection dys = (DynamicObjectCollection)evt.getReturnData();
                if (CollectionUtils.isNotEmpty((Collection)dys)) {
                    dys.forEach(a -> {
                        if (a == null) {
                            return;
                        }
                        HashMap<String, String> map = new HashMap<String, String>(10);
                        map.put("name", a.getString("mname1"));
                        map.put("number", a.getString("mnum1"));
                        map.put("id", a.getString("mid1"));
                        map.put("range", Objects.requireNonNull(RangeEnum.getRangeByVal((int)a.getInt("filltypevalue1"))).getNumber());
                        mapList.add(map);
                    });
                }
            }
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            JSONObject dataObj = new JSONObject();
            dataObj.put("members", mapList);
            dataObj.put("dataType", (Object)AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_MEMBER_F7.toString());
            dataObj.put("t", (Object)TimeServiceHelper.now());
            DataSetDisplayUtil.sendToVue(dataObj, custom);
        }
    }

    private void buildSourceComboEdit() {
        ComboEdit comboEdit = (ComboEdit)this.getControl("sourcefrom");
        DataSetDisplayUtil.buildSourceComboEdit(comboEdit);
    }

    private void afterCreateNewDataNew() {
        Long currentModelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodel_id");
        String dataSrcType = DataSetDisplayUtil.getSrcType(currentModelId);
        this.getModel().setValue("sourcefrom", (Object)dataSrcType);
        this.buildTypeComboEdit(dataSrcType);
        this.getModel().setValue("typeselect", (Object)DatasetModelTypeEnum.DEFAULT.getIndex());
        String dataSetType = (String)this.getFormCustomParam("dataset_type");
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
            this.dataSetDtoAfterNew.setDefValue("3");
        }
        List<DynamicObject> dynamicObjectList = this.buildModelComboEdit();
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)currentModelId);
        List useModels = ModelStrategy.getStrategy((DisModelTypeEnum)modelType).getUseModels();
        if (CollectionUtils.isEmpty((Collection)useModels) || useModels.stream().noneMatch(t -> currentModelId.equals(t.getLong("id")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u4f53\u7cfb\u4f7f\u7528\u6743\u9650\u3002", (String)"DatasetSingleEditPlugin_58", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.dataSetDtoAfterNew.setDataSrcId(currentModelId);
        this.setModelSelectInitValue(this.dataSetDtoAfterNew, dynamicObjectList);
        this.setExtendsModelSelectComboEdit();
        this.buildEBDataSetCombo();
        String ebDataSetId = this.dataSetDtoAfterNew.getEbDataset();
        if (Objects.nonNull(ebDataSetId) && StringUtils.isNotBlank((CharSequence)ebDataSetId)) {
            this.getModel().setValue("ebdataset", (Object)ebDataSetId);
        }
        this.buildOtherBasicComboEdit(this.dataSetDtoAfterNew);
        this.setOtherBasicInitValue(this.dataSetDtoAfterNew);
        this.initFieldAndFilterArea(currentModelId);
    }

    protected void buildTypeComboEdit(String dataSrcType) {
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"typeselect"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"typeselect"});
        ComboEdit comboEdit = (ComboEdit)this.getControl("typeselect");
        ArrayList itemList = Lists.newArrayListWithExpectedSize((int)5);
        itemList.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.DEFAULT.getName()), DatasetModelTypeEnum.DEFAULT.getIndex()));
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType) || DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dataSrcType)) {
            itemList.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.EXTEND.getName()), DatasetModelTypeEnum.EXTEND.getIndex()));
            String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
            if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
                itemList.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.TEMPLATE.getName()), DatasetModelTypeEnum.TEMPLATE.getIndex()));
            }
            itemList.add(new ComboItem(new LocaleString(DatasetModelTypeEnum.INTEGRATION.getName()), DatasetModelTypeEnum.INTEGRATION.getIndex()));
        }
        comboEdit.setComboItems((List)itemList);
    }

    private void initFieldAndFilterArea(Long currentModelId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(currentModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        String modelType = modelInfo.getModelType();
        if (ModelSourceEnum.RPT.getType().equals(modelType) || ModelSourceEnum.CM.getType().equals(modelType)) {
            List<DimInfo> dimInfoList = this.getDimInfo();
            List<TreeNode> treeNodeList = this.initTreeNode(dimInfoList, "init");
            Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.initDimAndMember(modelStrategyEx, dimInfoList, modelType);
            ArrayList selectCustomDataList = Lists.newArrayListWithExpectedSize((int)1);
            String extendValue = this.dataSetDtoAfterNew.getValue();
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            DataSetDisplayUtil.checkedTreeNode(treeNodeList, dimAndMember, selectCustomDataList, extendValue, tree);
            List<DimInfo> selectDimInfoList = dimInfoList.stream().filter(dim -> dimAndMember.containsKey(dim.getShortNumber())).collect(Collectors.toList());
            this.initCustomControl(selectDimInfoList, this.dataSetDtoAfterNew, dimAndMember);
            List<String> collect = selectDimInfoList.stream().map(DimInfo::getShortNumber).collect(Collectors.toList());
            this.buildComboEdit(collect, "groupby");
            this.buildComboEdit(collect, "orderfield");
        } else if (ModelSourceEnum.EB.getType().equals(modelType)) {
            String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
        }
    }

    private void afterCreateNewDataEdit() {
        this.dataSetDtoAfterNew = this.buildDataSetDto(this.dataSetDtoAfterNew);
        if (this.dataSetDtoAfterNew != null) {
            this.setInitSourceFrom(this.dataSetDtoAfterNew);
            if (!(DataSetDisplayUtil.isTemplate(this.dataSetDtoAfterNew).booleanValue() || DataSetDisplayUtil.isMetadtaSrcType(this.dataSetDtoAfterNew).booleanValue() || DataSetDisplayUtil.isBCMMetadtaSrcType(this.dataSetDtoAfterNew).booleanValue())) {
                List<DynamicObject> dynamicObjectList = this.buildModelComboEdit();
                this.buildTypeComboEdit(this.dataSetDtoAfterNew.getDataSrcType());
                String defaultIndex = DatasetModelTypeEnum.DEFAULT.getIndex();
                if (LongUtil.isvalidLong((Object)this.dataSetDtoAfterNew.getExtendsModelId())) {
                    defaultIndex = DatasetModelTypeEnum.EXTEND.getIndex();
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"extendmodelselect"});
                }
                this.getModel().setValue("typeselect", (Object)defaultIndex);
                this.setModelSelectInitValue(this.dataSetDtoAfterNew, dynamicObjectList);
                this.setExtendsModelSelectComboEdit();
                this.buildEBDataSetCombo();
                String ebDataSetId = this.dataSetDtoAfterNew.getEbDataset();
                if (Objects.nonNull(ebDataSetId) && StringUtils.isNotBlank((CharSequence)ebDataSetId)) {
                    this.getModel().setValue("ebdataset", (Object)ebDataSetId);
                }
                List<DimInfo> dimInfoList = this.getDimInfo();
                List<TreeNode> treeNodeList = this.initTreeNode(dimInfoList, "init");
                Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.getExpressionDimInfo(this.dataSetDtoAfterNew);
                List<String> selectCustomDataList = DataSetDisplayUtil.getData(this.dataSetDtoAfterNew);
                String extendValue = this.getExtendColumn(this.dataSetDtoAfterNew);
                TreeView tree = (TreeView)this.getView().getControl("treeviewap");
                DataSetDisplayUtil.checkedTreeNode(treeNodeList, dimAndMember, selectCustomDataList, extendValue, tree);
                this.setReturnValComboAndVal(this.dataSetDtoAfterNew, treeNodeList, extendValue);
                this.buildOtherBasicComboEdit(this.dataSetDtoAfterNew);
                this.setOtherBasicInitValue(this.dataSetDtoAfterNew);
                List<DimInfo> selectDimInfoList = dimInfoList.stream().filter(dim -> dimAndMember.containsKey(dim.getShortNumber())).collect(Collectors.toList());
                if (SEUtils.hasOrg(this.dataSetDtoAfterNew.getData())) {
                    selectDimInfoList.add(SEUtils.getSEDimInfo());
                }
                this.initCustomControl(selectDimInfoList, this.dataSetDtoAfterNew, dimAndMember);
                this.setErpressionField(this.dataSetDtoAfterNew);
            }
        }
    }

    private void setReturnValComboAndVal(DatasetDto dataSetDto, List<TreeNode> treeNodeList, String extendValue) {
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType) && DataSetDisplayUtil.isBCMSrcType(dataSetDto).booleanValue()) {
            String fMoney;
            String extendNumTypeCache = this.getPageCache().get("extendnumbertype");
            if (Objects.nonNull(extendNumTypeCache)) {
                Set extendNumType = (Set)SerializationUtils.fromJsonString((String)extendNumTypeCache, Set.class);
                Map<String, String> singleExtendInfo = treeNodeList.stream().filter(treenode -> "extend".equals(treenode.getParentid()) && extendNumType.contains(treenode.getId())).collect(Collectors.toMap(t -> t.getId(), t -> t.getText()));
                ComboEdit singleExtenddCcomboEdit = (ComboEdit)this.getControl("singleextendval");
                if (Objects.nonNull(singleExtenddCcomboEdit)) {
                    singleExtenddCcomboEdit.setComboItems(null);
                }
                if (StringUtils.isNotEmpty((CharSequence)extendValue)) {
                    String[] extendValues = extendValue.split(",");
                    if (extendValues.length > 0) {
                        List<String> extendList;
                        List<String> finalExtendList = extendList = Arrays.asList(extendValues);
                        singleExtendInfo = treeNodeList.stream().filter(treenode -> "extend".equals(treenode.getParentid()) && extendNumType.contains(treenode.getId()) && finalExtendList.contains(treenode.getId())).collect(Collectors.toMap(t -> t.getId(), t -> t.getText()));
                    }
                    ComboEditUtil.buildComboEdit(singleExtendInfo, (String)"singleextendval", (IFormView)this.getView());
                }
            }
            if (Objects.nonNull(fMoney = dataSetDto.getValue()) && StringUtils.isNotBlank((CharSequence)fMoney)) {
                this.getModel().setValue("singleextendval", (Object)fMoney);
            }
        }
    }

    private void setErpressionField(DatasetDto dataSetDto) {
        DatasetUtil.buildDetails((DatasetDto)dataSetDto);
        this.getModel().setValue("detailfield", (Object)dataSetDto.getDetails());
    }

    protected void initCustomControl(List<DimInfo> selectDimInfoList, DatasetDto dataSetDto, Map<String, List<Map<String, String>>> dimAndMember) {
        String ebDataSet;
        String string = ebDataSet = this.getModel().getValue("ebdataset") == null ? "" : this.getModel().getValue("ebdataset").toString();
        if (this.getModel().getValue("modelselect") == null) {
            return;
        }
        Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
        String dataSrcType = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        if (StringUtils.isEmpty((CharSequence)dataSrcType)) {
            return;
        }
        List<Map<String, Object>> dimList = DataSetDisplayUtil.setDataInit(this.getView(), this.extSelects, selectDimInfoList, modelSelectId, ebDataSet, dataSrcType, dimAndMember, dataSetDto);
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        String typeSelect = TypeConversionUtil.getStringValue((String)"typeselect", (IDataModel)this.getModel());
        if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(typeSelect)) {
            sourceFrom = DataSrcTypeEnum.CM_TEMPLATE.getType();
        }
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendDataInitVue(dimList, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
    }

    protected Set<String> getAllNumType() {
        String extendNumType = this.getPageCache().get("extendnumbertype");
        String metaNumType = this.getPageCache().get("metanumtype");
        HashSet<String> resSet = new HashSet<String>(10);
        if (Objects.nonNull(extendNumType)) {
            resSet.addAll((Collection)SerializationUtils.fromJsonString((String)extendNumType, Set.class));
        }
        if (Objects.nonNull(metaNumType)) {
            resSet.addAll((Collection)SerializationUtils.fromJsonString((String)metaNumType, Set.class));
        }
        return resSet;
    }

    @Override
    public void click(EventObject evt) {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
    }

    private void setInitSourceFrom(DatasetDto dataSetDto) {
        String dataSrcType = dataSetDto.getDataSrcType();
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType((String)dataSrcType);
        if (Objects.isNull(typeEnum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u6e90\u7c7b\u578b,\u6682\u4e0d\u652f\u6301\u3002", (String)"DatasetSingleNewPlugin_56", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("sourcefrom", (Object)dataSrcType);
    }

    public void setModelSelectInitValue(DatasetDto dataSetDto, List<DynamicObject> dynamicObjectCollection) {
        Long extendModelSelectId;
        Long modelSelectId = dataSetDto.getDataSrcId();
        if (Objects.nonNull(modelSelectId) && modelSelectId != 0L) {
            Boolean existModel = Boolean.FALSE;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (!modelSelectId.equals(dynamicObject.getLong("id"))) continue;
                existModel = Boolean.TRUE;
                break;
            }
            if (existModel.booleanValue()) {
                this.getModel().setValue("modelselect", (Object)modelSelectId);
            }
        }
        if (Objects.nonNull(extendModelSelectId = dataSetDto.getExtendsModelId()) && extendModelSelectId != 0L) {
            this.getModel().setValue("extendmodelselect", (Object)extendModelSelectId);
        }
    }

    private void setOtherBasicInitValue(DatasetDto dataSetDto) {
        String dataSourceType = dataSetDto.getDataSrcType();
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSourceType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(dataSourceType) || DataSrcTypeEnum.EB_MODEL.getType().equals(dataSourceType)) {
            String groupBy = dataSetDto.getGroupBy();
            this.setGroupByValue(groupBy);
            String asc = dataSetDto.getAsc();
            this.setOrderValue(asc);
            Integer top = dataSetDto.getTop();
            if (top != null && top > 0) {
                this.getModel().setValue("topfield", (Object)top);
            }
        }
        this.getModel().setValue("dimdefaultvalue", (Object)dataSetDto.getDefValue());
        this.getModel().setValue("textareafield", (Object)dataSetDto.getTempExpression());
    }

    protected void setOrderValue(String asc) {
        if (Objects.nonNull(asc)) {
            this.getModel().setValue("orderby", (Object)asc);
        }
    }

    private void setGroupByValue(String groupBy) {
        if (!StringUtils.isEmpty((CharSequence)groupBy)) {
            String[] all = groupBy.split(",");
            String newvalue = Arrays.stream(all).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.joining(","));
            IDataModel dataModel = this.getModel();
            dataModel.setValue("groupby", (Object)newvalue);
        }
    }

    private void setFixFieldFlexPanelapComboEdit(String expression, String groupBy, String orderBy, String ebDataset, String data) {
        List<String> dims = Lists.newArrayListWithExpectedSize((int)11);
        if (Objects.nonNull(expression)) {
            dims = DatasetExpressionHelper.getExpressionDimList((String)expression, (Long)this.getDMModelId(), null);
            if (SEUtils.hasOrg(data)) {
                dims.add("SE");
            }
        }
        this.setGroupComboEdit(dims);
        this.setOrderComboEdit(dims, orderBy, groupBy);
    }

    private void setOrderComboEdit(List<String> dims, String orderBy, String groupby) {
        if (StringUtils.isEmpty((CharSequence)groupby) || Arrays.stream(groupby.split(",")).allMatch(s -> StringUtils.isEmpty((CharSequence)s) || StringUtils.isEmpty((CharSequence)s.trim()))) {
            this.buildComboEdit(dims, "orderfield");
        } else {
            String[] scope = groupby.split(",");
            dims = Arrays.stream(scope).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.toList());
            this.buildComboEdit(dims, "orderfield");
        }
        if (!StringUtils.isEmpty((CharSequence)orderBy)) {
            String[] all = orderBy.split(",");
            List<String> finalDims = dims;
            String newvalue = Arrays.stream(all).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && finalDims.contains(s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.joining(","));
            this.getModel().setValue("orderfield", (Object)newvalue);
        }
    }

    private void setGroupComboEdit(List<String> dims) {
        this.buildComboEdit(dims, "groupby");
    }

    private void buildEBDataSetCombo() {
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            if (Objects.nonNull(this.getModel().getValue("modelselect"))) {
                Long dataSrcId = Long.parseLong((String)this.getModel().getValue("modelselect"));
                this.setEBDataSetComboEdit(dataSrcId);
            } else {
                this.setEBDataSetComboEdit(null);
            }
            this.getPageCache().remove("existextednmodelitem");
        }
    }

    private void buildOtherBasicComboEdit(DatasetDto dataSetDto) {
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType)) {
            return;
        }
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        if (Objects.nonNull(dataSetDto) && DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
            this.setFixFieldFlexPanelapComboEdit(dataSetDto.getTempExpression(), dataSetDto.getGroupBy(), dataSetDto.getOrderBy(), dataSetDto.getEbDataset(), dataSetDto.getData());
        }
    }

    public List<DynamicObject> buildModelComboEdit() {
        IModel sourceModelType = DataSetDisplayUtil.getSourceModelType(this.getModel(), this.dataSetOperate);
        List dynamicObjectCollection = sourceModelType.getUseModels();
        ComboEdit comboEdit = (ComboEdit)this.getControl("modelselect");
        DataSetDisplayUtil.buildDataSrcIdComboEdit(comboEdit, dynamicObjectCollection);
        return dynamicObjectCollection;
    }

    protected void sourceFromChanged(String sourceFrom) {
        this.changeModelSelectCaption(sourceFrom);
        this.buildModelComboEdit();
        this.setSourceFromPropertyChanged();
        this.setModelValueNull();
        this.clearVarPanel();
        this.setVisibleWithSource();
    }

    protected void modelSelectChanged(DatasetDto dataSetDto) {
        this.setSourceFromPropertyChanged();
        this.setExtendsModelSelectComboEdit();
        this.buildEBDataSetCombo();
        String ebDataSetId = dataSetDto.getEbDataset();
        if (Objects.nonNull(ebDataSetId) && StringUtils.isNotBlank((CharSequence)ebDataSetId)) {
            this.getModel().setValue("ebdataset", (Object)ebDataSetId);
        }
        this.buildOtherBasicComboEdit(dataSetDto);
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        this.getModel().setValue("extendmodelselect", null);
        tree.deleteAllNodes();
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dataSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(dataSrcType)) {
            Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
            List<DimInfo> getDimInfo = this.getDimInfo();
            List<TreeNode> treeNodes = this.initTreeNode(getDimInfo, "propertychanged");
            String type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId).getType();
            Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.initDimAndMember(new ModelStrategyEx(modelSelectId, type), getDimInfo, type);
            DataSetDisplayUtil.checkedTreeNode(treeNodes, dimAndMember, Collections.emptyList(), "", tree);
            this.initCustomControl(getDimInfo, dataSetDto, dimAndMember);
            this.setExtendFiledValue();
            this.getModel().setValue("singlevalue", (Object)"FMONEY");
        } else if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            this.getModel().setValue("singlevalue", (Object)"FMONEY");
        } else {
            this.clearVarPanel();
        }
    }

    protected void buildTemplateCombo() {
        Object datasrcid = this.getModel().getValue("modelselect");
        Long modelSelectId = LongUtil.toLong((Object)datasrcid);
        Map template = BCMMsServiceHelper.getTemplate((Long)modelSelectId);
        ComboEdit comboEdit = (ComboEdit)this.getControl("template");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)12);
        if (Objects.isNull(template) || template.isEmpty()) {
            comboEdit.setComboItems((List)items);
            return;
        }
        for (Map.Entry entry : template.entrySet()) {
            items.add(new ComboItem(new LocaleString((String)entry.getValue()), ((Long)entry.getKey()).toString()));
        }
        comboEdit.setComboItems((List)items);
    }

    private void clearVarPanel() {
        this.getPageCache().remove("diminfocache");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        DatasetDto dataSetDto = new DatasetDto();
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        this.getPageCache().put("isChanged", "true");
        switch (propertyName) {
            case "sourcefrom": {
                if (StringUtils.isEmpty((CharSequence)sourceFrom)) {
                    return;
                }
                this.clearComboEdit("typeselect", "template", "area");
                this.sourceFromChanged(sourceFrom);
                this.removePageCache();
                this.setFormShowCustomParam("");
                this.getView().setVisible(Boolean.TRUE, new String[]{"bcmiscdata", "template", "area", "extendmodelselect", "globalvarselect", "dimdefaultvalue", "fieldpanelap"});
                this.setVisibleWithSource();
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                this.getView().setVisible(Boolean.FALSE, new String[]{"datasettableflexpanelap"});
                this.getModel().setValue("detailfield", null);
                this.getModel().setValue("typeselect", null);
                break;
            }
            case "modelselect": {
                if (!LongUtil.isvalidLong((Object)value)) {
                    return;
                }
                this.buildTypeComboEdit(sourceFrom);
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                this.modelSelectChanged(dataSetDto);
                this.propertyChangedCombo(true);
                this.setVisibleWithSource();
                this.setFormShowCustomParam("");
                this.getModel().setValue("detailfield", null);
                if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
                    this.getModel().setValue("typeselect", null);
                    break;
                }
                this.getModel().setValue("typeselect", (Object)DatasetModelTypeEnum.DEFAULT.getIndex());
                break;
            }
            case "typeselect": {
                if (Objects.isNull(value)) {
                    return;
                }
                String typeSelect = value.toString();
                this.setFormShowCustomParam("");
                if (DatasetModelTypeEnum.DEFAULT.getIndex().equals(value.toString())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"extendmodelselect", "template", "area", "bcmiscdata"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"attrtreepanel", "fieldpanelap", "globalvarselect"});
                    this.clearValue("extendmodelselect", "template", "area", "bcmiscdata");
                    Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
                    List<DimInfo> getDimInfo = this.getDimInfo();
                    List<TreeNode> treeNodes = this.initTreeNode(getDimInfo, "propertychanged");
                    String dataSrcType = (String)this.getModel().getValue("sourcefrom");
                    String type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId).getType();
                    Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.initDimAndMember(new ModelStrategyEx(modelSelectId, type), getDimInfo, type);
                    DataSetDisplayUtil.checkedTreeNode(treeNodes, dimAndMember, Collections.emptyList(), "", tree);
                    this.initCustomControl(getDimInfo, dataSetDto, dimAndMember);
                    this.setExtendFiledValue();
                    this.getModel().setValue("singlevalue", (Object)"FMONEY");
                    break;
                }
                if (DatasetModelTypeEnum.EXTEND.getIndex().equals(value.toString())) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"template", "area", "bcmiscdata", "globalvarselect"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"extendmodelselect", "attrtreepanel", "fieldpanelap"});
                    this.clearValue("template", "area", "bcmiscdata", "extendmodelselect");
                    Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
                    List<DimInfo> getDimInfo = this.getDimInfo();
                    List<TreeNode> treeNodes = this.initTreeNode(getDimInfo, "propertychanged");
                    String dataSrcType = (String)this.getModel().getValue("sourcefrom");
                    String type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId).getType();
                    Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.initDimAndMember(new ModelStrategyEx(modelSelectId, type), getDimInfo, type);
                    DataSetDisplayUtil.checkedTreeNode(treeNodes, dimAndMember, Collections.emptyList(), "", tree);
                    this.initCustomControl(getDimInfo, dataSetDto, dimAndMember);
                    this.setExtendFiledValue();
                    break;
                }
                if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(value.toString())) {
                    this.buildTemplateCombo();
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"template", "area"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"extendmodelselect", "attrtreepanel", "fieldpanelap", "bcmiscdata", "globalvarselect"});
                    DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                    this.clearValue("extendmodelselect", "bcmiscdata", "groupby", "orderby", "orderfield");
                    break;
                }
                if (!DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) break;
                TreeView currentTree = (TreeView)this.getView().getControl("treeviewap");
                currentTree.deleteAllNodes();
                this.clearValue("extendmodelselect", "template", "area");
                this.setExtendFiledValue();
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                this.getView().setVisible(Boolean.FALSE, new String[]{"template", "area", "extendmodelselect", "globalvarselect", "dimdefaultvalue"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bcmiscdata"});
                break;
            }
            case "ebdataset": {
                Object ebDatasetVal = this.getModel().getValue("ebdataset");
                if (!Objects.nonNull(ebDatasetVal)) {
                    return;
                }
                this.ebDataSetChanged();
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                this.setFormShowCustomParam("");
                this.propertyChangedCombo(false);
                break;
            }
            case "extendmodelselect": {
                Boolean existExtendModel = Boolean.TRUE;
                if ("".equals(value)) {
                    existExtendModel = Boolean.FALSE;
                    this.getPageCache().remove("existextednmodelitem");
                } else if (!LongUtil.isvalidLong((Object)value)) {
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"globalvarselect"});
                this.getPageCache().put("existextednmodelitem", "true");
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                List<DimInfo> dimInfo = this.getDimInfo();
                ModelStrategyEx modelStrategyEx = new ModelStrategyEx(LongUtil.toLong((Object)this.getModel().getValue("modelselect")), DisModelTypeEnum.CM.getType());
                Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.initDimAndMember(modelStrategyEx, dimInfo, ModelSourceEnum.CM.getType());
                this.setFmoneyFiledWhenExtendChanged(existExtendModel, dataSetDto, value);
                ArrayList selectCustomDataList = Lists.newArrayListWithExpectedSize((int)1);
                List<TreeNode> treeNodes = this.initTreeNode(dimInfo, "init");
                DataSetDisplayUtil.checkedTreeNode(treeNodes, dimAndMember, selectCustomDataList, "", tree);
                this.initCustomControl(dimInfo, dataSetDto, dimAndMember);
                this.propertyChangedCombo(false);
                dataSetDto.setDataSrcType(sourceFrom);
                this.setReturnValComboAndVal(dataSetDto, treeNodes, "");
                this.setFormShowCustomParam("");
                this.getModel().setValue("detailfield", null);
                break;
            }
            case "groupby": {
                String dataSrcType = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
                String selectType = TypeConversionUtil.getStringValue((String)"typeselect", (IDataModel)this.getModel());
                if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSrcType) || DataSrcTypeEnum.INTEGRATED_DATA_SOURCE.getType().equals(selectType)) break;
                String stringValue = TypeConversionUtil.getStringValue((String)"groupby", (IDataModel)this.getModel());
                if (StringUtils.isNotBlank((CharSequence)stringValue)) {
                    List<String> strings = Arrays.stream(stringValue.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
                    this.buildComboEdit(strings, "orderfield");
                    ComboEditUtil.buildComboEditValue(strings, (String)"orderfield", (IDataModel)this.getModel());
                    break;
                }
                List selectNodes = tree.getTreeState().getSelectedNodes();
                List<String> groupByList = this.getTreeList(selectNodes, OPERATEFROM[0]);
                this.buildComboEdit(groupByList, "orderfield");
                break;
            }
        }
    }

    private void propertyChangedCombo(boolean isModelSelect) {
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
            String modelDataSrcType = (String)this.getModel().getValue("sourcefrom");
            if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(modelDataSrcType) || DataSrcTypeEnum.RPT_MODEL.getType().equals(modelDataSrcType) || DataSrcTypeEnum.EB_MODEL.getType().equals(modelDataSrcType) && !isModelSelect) {
                List<DimInfo> getDimInfo = this.getDimInfo();
                Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
                String type = DisModelTypeEnum.getModelType((String)modelDataSrcType, (Long)modelSelectId).getType();
                Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.initDimAndMember(new ModelStrategyEx(modelSelectId, type), getDimInfo, type);
                List selectDimInfoList = getDimInfo.stream().filter(dim -> dimAndMember.containsKey(dim.getShortNumber())).collect(Collectors.toList());
                List<String> collect = selectDimInfoList.stream().map(DimInfo::getShortNumber).collect(Collectors.toList());
                this.buildComboEdit(collect, "groupby");
                this.buildComboEdit(collect, "orderfield");
            }
        }
    }

    private void setFmoneyFiledWhenExtendChanged(Boolean existExtendModel, DatasetDto dto, Object value) {
        this.setExtendFiledValue();
        if (!existExtendModel.booleanValue()) {
            this.getModel().setValue("singlevalue", (Object)"FMONEY");
        } else {
            dto.setExtendsModelId(LongUtil.toLong((Object)value));
        }
        this.setExtendsModelAndMoneyVisible(existExtendModel);
    }

    private void setExtendFiledValue() {
        if (Objects.nonNull(this.getModel().getValue("singlevalue"))) {
            this.getModel().setValue("singlevalue", null);
        }
        if (Objects.nonNull(this.getModel().getValue("groupby"))) {
            this.getModel().setValue("groupby", null);
        }
        if (Objects.nonNull(this.getModel().getValue("orderfield"))) {
            this.getModel().setValue("orderfield", null);
        }
        if (Objects.nonNull(this.getModel().getValue("topfield"))) {
            this.getModel().setValue("topfield", null);
        }
        if (Objects.nonNull(this.getModel().getValue("singleextendval"))) {
            this.getModel().setValue("singleextendval", null);
        }
    }

    private List<String> getTreeList(List<Map<String, Object>> selectNodes, String sourceFrom) {
        Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
        String dataSrcType = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        String type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId).getType();
        List dimList = new ModelStrategyEx(modelSelectId, type).getDim().getDimList();
        dimList.add(SEUtils.getSEDimensionInfo());
        Map<Long, Pair> idMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getId, t -> new Pair((Object)t.getShortNumber(), (Object)t.getName())));
        Set<Object> dimIds = Sets.newHashSetWithExpectedSize((int)selectNodes.size());
        dimIds = "treenodecheck".equals(sourceFrom) ? selectNodes.stream().filter(t -> !t.get("id").equals("extend") && !t.get("parentid").equals("extend") && (Objects.nonNull(t.get("isParent")) && Boolean.parseBoolean(t.get("isParent").toString()) || Objects.nonNull(t.get("parentid")) && t.get("parentid").equals("root"))).map(t -> LongUtil.toLong(t.get("id"))).collect(Collectors.toSet()) : selectNodes.stream().filter(t -> !((String)t.get("id")).startsWith("extend") && t.get("parentid").equals("root")).map(t -> LongUtil.toLong(t.get("id"))).collect(Collectors.toSet());
        List<String> groupByList = dimIds.stream().map(t -> (String)((Pair)idMap.get((Object)t)).p1).collect(Collectors.toList());
        return groupByList;
    }

    private void setExtendsModelAndMoneyVisible(Boolean existExtendModel) {
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
            this.getView().setVisible(Boolean.valueOf(existExtendModel == false), new String[]{"singlevalue"});
            this.getView().setVisible(existExtendModel, new String[]{"singleextendval"});
        } else if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
            this.getView().setVisible(Boolean.valueOf(existExtendModel == false), new String[]{"singlevalue"});
        }
    }

    private void removePageCache() {
        this.getView().getPageCache().remove("rootnode");
    }

    private void ebDataSetChanged() {
        List<DimInfo> dimInfoList = this.getDimInfo();
        this.initTreeNode(dimInfoList, "propertychanged");
    }

    private void setExtendsModelSelectComboEdit() {
        IDataModel dataModel = this.getModel();
        Long modelId = this.dataSetOperate.getLongValue("modelselect", dataModel);
        if (modelId == 0L) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("extendmodelselect");
            comboEdit.setComboItems(null);
        } else {
            String dataSrcType = (String)dataModel.getValue("sourcefrom");
            List data = this.fidmDimService.getExtendsModel(dataSrcType, modelId);
            if (data.size() > 0) {
                this.getPageCache().put("existextednmodelitem", "true");
            } else {
                this.getPageCache().remove("existextednmodelitem");
            }
            this.dataSetOperate.buildComboEditForTuple(this.getView(), data, "extendmodelselect");
        }
    }

    private void setEBDataSetComboEdit(Long dataSrcId) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("ebdataset");
        if (LongUtil.isvalidLong((Object)dataSrcId)) {
            DynamicObject model = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB).getModel(dataSrcId);
            List datasets = EbServiceHelper.getDataset((String)model.getString("shownumber"));
            ArrayList items = Lists.newArrayListWithExpectedSize((int)datasets.size());
            if (CollectionUtils.isEmpty((Collection)datasets)) {
                comboEdit.setComboItems((List)items);
                return;
            }
            for (EbDataset data : datasets) {
                items.add(new ComboItem(new LocaleString(data.getName()), data.getNumber()));
            }
            comboEdit.setComboItems((List)items);
        } else {
            comboEdit.setComboItems(null);
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        if (Objects.nonNull(this.getModel().getValue("typeselect"))) {
            String typeSelect = (String)this.getModel().getValue("typeselect");
            if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
                return;
            }
        }
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(sourceFrom) || DataSrcTypeEnum.RPT_MODEL.getType().equals(sourceFrom) || DataSrcTypeEnum.EB_MODEL.getType().equals(sourceFrom)) {
            this.dimTreeNodeCheck(treeNodeCheckEvent);
        }
    }

    private void dimTreeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        List<Map<String, Object>> selectNodeList = ((TreeView)treeNodeCheckEvent.getSource()).getTreeState().getSelectedNodes();
        String dataSrcType = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
            selectNodeList = selectNodeList.stream().peek(node -> node.put("isParent", true)).collect(Collectors.toList());
        }
        String nodeId = String.valueOf(treeNodeCheckEvent.getNodeId());
        String parentNodeId = String.valueOf(treeNodeCheckEvent.getParentNodeId());
        Boolean checked = treeNodeCheckEvent.getChecked();
        Map<String, List<Map<String, Object>>> dimResult = null;
        if (!("extend".equals(parentNodeId) || "extend".equals(nodeId) || "fmoney".equals(nodeId))) {
            this.buildGroupAndOrderAfterTreeClick(selectNodeList);
        }
        if ("extend".equals(parentNodeId)) {
            String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                this.setSingleExtend(selectNodeList, checked, nodeId);
            } else {
                List<String> groupByList = this.getTreeList(selectNodeList, OPERATEFROM[1]);
                String stringValue = TypeConversionUtil.getStringValue((String)"groupby", (IDataModel)this.getModel());
                this.buildOrderComboAfterTreeClick(selectNodeList, groupByList, stringValue);
            }
        }
        if (!CollectionUtils.isEmpty(selectNodeList)) {
            if (checked.booleanValue()) {
                dimResult = this.getDimResult(selectNodeList, nodeId, parentNodeId, dimResult);
            }
            JSONObject dataObj = new JSONObject();
            dataObj.put("dim", dimResult);
            List<String> firstNodeList = this.getSortedFirstNodeIds();
            dataObj.put("sorteddimid", firstNodeList);
            dataObj.put("isChecked", (Object)checked);
            dataObj.put("checkedNodes", selectNodeList);
            dataObj.put("clickNodeId", (Object)nodeId);
            dataObj.put("sourcefrom", (Object)TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel()));
            dataObj.put("dataType", (Object)AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_TREENODE_CHECK.toString());
            dataObj.put("t", (Object)TimeServiceHelper.now());
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            DataSetDisplayUtil.sendToVue(dataObj, custom);
        } else {
            String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
        }
    }

    private void setSingleExtend(List<Map<String, Object>> selectNodeList, Boolean checked, String nodeId) {
        String extendNumTypeCache = this.getPageCache().get("extendnumbertype");
        if (Objects.nonNull(extendNumTypeCache)) {
            Set extendNumType = (Set)SerializationUtils.fromJsonString((String)extendNumTypeCache, Set.class);
            Map<String, String> singleExtendInfo = selectNodeList.stream().filter(a -> "extend".equals(a.get("parentid")) && extendNumType.contains(a.get("id"))).collect(Collectors.toMap(t -> (String)t.get("id"), t -> (String)t.get("text")));
            ComboEditUtil.buildComboEdit(singleExtendInfo, (String)"singleextendval", (IFormView)this.getView());
            String currentSingleExtendVal = (String)this.getModel().getValue("singleextendval");
            if (!checked.booleanValue() && Objects.equals(currentSingleExtendVal, nodeId)) {
                this.getModel().setValue("singleextendval", null);
            }
        }
    }

    private Map<String, List<Map<String, Object>>> getDimResult(List<Map<String, Object>> selectNodeList, String nodeId, String parentNodeId, Map<String, List<Map<String, Object>>> dimResult) {
        List collect = selectNodeList.stream().filter(a -> nodeId.equals(a.get("id"))).collect(Collectors.toList());
        Optional<Map> optional = selectNodeList.stream().filter(c -> String.valueOf(c.get("id")).equals(parentNodeId)).findAny();
        if (Optional.empty().equals(optional) && !"root".equals(parentNodeId) && !"extend".equals(parentNodeId)) {
            this.addParentTreeNode(parentNodeId, selectNodeList);
        }
        if (!"extend".equals(nodeId)) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll(collect);
            List list = jsonArray.toJavaList(CheckTreeNodeInfo.class);
            dimResult = this.conversionData(list);
        }
        return dimResult;
    }

    private void buildGroupAndOrderAfterTreeClick(List<Map<String, Object>> selectNodeList) {
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        if (!DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
            return;
        }
        if (CollectionUtils.isEmpty(selectNodeList)) {
            this.clearComboEdit("groupby", "orderfield");
            return;
        }
        List<String> groupByList = this.getTreeList(selectNodeList, OPERATEFROM[1]);
        this.buildComboEdit(groupByList, "groupby");
        ComboEditUtil.buildComboEditValue(groupByList, (String)"groupby", (IDataModel)this.getModel());
        String stringValue = TypeConversionUtil.getStringValue((String)"groupby", (IDataModel)this.getModel());
        this.buildOrderComboAfterTreeClick(selectNodeList, groupByList, stringValue);
    }

    private void buildOrderComboAfterTreeClick(List<Map<String, Object>> selectNodeList, List<String> groupByList, String stringValue) {
        if (CollectionUtils.isEmpty(selectNodeList)) {
            this.clearComboEdit("orderfield");
            return;
        }
        ArrayList orderByList = Lists.newArrayListWithExpectedSize((int)selectNodeList.size());
        if (StringUtils.isNotBlank((CharSequence)stringValue)) {
            orderByList.addAll(Arrays.asList(stringValue.split(",")).stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty((Collection)orderByList)) {
            orderByList.addAll(groupByList);
        }
        this.buildComboEdit(orderByList, "orderfield");
        ComboEditUtil.buildComboEditValue((List)orderByList, (String)"orderfield", (IDataModel)this.getModel());
    }

    private List<String> getSortedFirstNodeIds() {
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("rootnode"), TreeNode.class);
        List childrenList = rootNode.getChildren();
        ArrayList firstNodeList = Lists.newArrayListWithExpectedSize((int)11);
        childrenList.forEach(child -> {
            String childNodeId = child.getId();
            if (!"extend".equals(childNodeId)) {
                firstNodeList.add(childNodeId);
            }
        });
        return firstNodeList;
    }

    private List<Map<String, Object>> addParentTreeNode(String parentNodeId, List<Map<String, Object>> selectNodeList) {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("rootnode"), TreeNode.class);
        TreeNode parentNode = rootNode.getTreeNode(parentNodeId);
        if (Objects.nonNull(parentNode)) {
            String selectParentNodeId = parentNode.getId();
            String selectParentNodeText = parentNode.getText();
            String selectGrandpaNodeId = parentNode.getParentid();
            HashMap selectParentNodeInfo = Maps.newHashMapWithExpectedSize((int)4);
            selectParentNodeInfo.put("id", selectParentNodeId);
            selectParentNodeInfo.put("isParent", Boolean.TRUE);
            selectParentNodeInfo.put("parentid", selectGrandpaNodeId);
            selectParentNodeInfo.put("text", selectParentNodeText);
            tree.checkNode(parentNode);
            selectNodeList.add(selectParentNodeInfo);
        }
        return selectNodeList;
    }
}

