/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetmMultiDto;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetMutilExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.helper.ImportHelper;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import kd.epm.far.formplugin.common.imp.ImportOperateType;

public class DataSetImportMultiPlugin
extends AbsCommonImport {
    private DynamicObject model;
    private Map<String, DynamicObject> recordMap;
    private Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private Long userId = RequestContext.get().getCurrUserId();

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.model = DatasetDataReader.getModel((Long)LongUtil.toLong(ctx.getOption().get("BcmModelId")));
        this.entityName = "fidm_dataset_multivalue";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData(billdatas);
    }

    private void initData(List<ImportBillData> billData) {
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)billData.size());
        for (ImportBillData billDatum : billData) {
            String number = ImportHelper.getImportBillProp(billDatum, "number").toString();
            numbers.add(number);
        }
        QFilter modelFilter = new QFilter("dataset.discmodel", "=", this.ctx.getOption().get("BcmModelId"));
        QFilter numberFilter = new QFilter("dataset.number", "in", (Object)numbers);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)this.entityName).getAllFields().keySet()), (QFilter[])new QFilter[]{modelFilter, numberFilter});
        this.recordMap = Arrays.stream(load).collect(Collectors.toMap(dy -> dy.getString("dataset.number"), Function.identity(), (k1, k2) -> k1));
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        DatasetmMultiDto datasetDto = new DatasetmMultiDto();
        try {
            this.buildDataSet(bill, null, datasetDto);
            ImportOperateType importType = ImportHelper.getImportType(this.ctx);
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (dbOld.isPresent() && Objects.equals((Object)importType, (Object)ImportOperateType.NEW)) {
                return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DataAuthMainImport_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (dbOld.isPresent() && !Objects.equals((Object)importType, (Object)ImportOperateType.NEW) && !Objects.equals(dbOld.get().getString("dataset.name"), datasetDto.getName().toString())) {
                return Optional.of(ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"DataSetImportPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDBizException e) {
            return Optional.of(e.getMessage());
        }
        if (!this.repeatKeys.add(datasetDto.getNumber())) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"DataAuthMainImport_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void buildDataSet(ImportBillData bill, Long id, DatasetmMultiDto dto) {
        if (id != null) {
            dto.setId(id);
        }
        dto.setDiscmodelId(Long.valueOf(this.model.getLong("id")));
        dto.setNumber(ImportHelper.getImportBillProp(bill, "number").toString());
        DatasetServiceHelper.checkDatasetNumberFormat((String)dto.getNumber());
        Object name = ImportHelper.getImportBillProp(bill, "name");
        String curName = null;
        if (name instanceof Map) {
            curName = LocaleString.fromMap((Map)((Map)name)).getLocaleValue();
            dto.setName((Object)LocaleString.fromMap((Map)((Map)name)));
        } else {
            curName = name.toString();
            dto.setName((Object)name.toString());
        }
        String mulNumAndName = this.checkMulNumAndName(dto.getNumber(), curName);
        if (Objects.nonNull(mulNumAndName)) {
            throw new KDBizException(mulNumAndName);
        }
        Object entryentity = ImportHelper.getImportBillProp(bill, "entryentity");
        if (((JSONArray)entryentity).isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u5355\u636e\u4f53\u4fe1\u606f\u3002", (String)"DataSetImportPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        JSONArray entryentityJsonArr = (JSONArray)entryentity;
        HashSet currentNames = Sets.newHashSetWithExpectedSize((int)16);
        Set singleDatasetNum = entryentityJsonArr.stream().filter(c -> Objects.equals("1", ((JSONObject)c).getString("formulatype"))).map(c -> ((JSONObject)c).getString("formulatext")).collect(Collectors.toCollection(HashSet::new));
        HashSet currentNumbers = new HashSet(12);
        entryentityJsonArr.forEach(c -> {
            JSONObject rowJSONObject = (JSONObject)c;
            String msg = this.checkEntryFieldsLength(rowJSONObject);
            if (Objects.nonNull(msg)) {
                throw new KDBizException(msg);
            }
            String formulanumber = rowJSONObject.getString("formulanumber");
            String formulatype = rowJSONObject.getString("formulatype");
            String formulaText = rowJSONObject.getString("formulatext");
            String formulaname = rowJSONObject.getString("formulaname");
            if (currentNumbers.contains(formulanumber)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801 %s \u5b58\u5728\u91cd\u590d\u3002", (String)"DateSetMultiValueEditPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), formulanumber));
            }
            currentNumbers.add(formulanumber);
            if (!"1".equals(formulatype) && "2".equals(formulatype)) {
                if (formulaText.contains("\uff08") || formulaText.contains("\uff09")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u4e2d\u5305\u542b\u4e2d\u6587\u62ec\u53f7,\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002", (String)"DateSetMultiValueNewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                DatasetMutilExpressionHelper.checkExpression((Long)dto.getDiscmodelId(), (String)formulaText, (Set)singleDatasetNum);
            }
            if (currentNames.contains(formulaname)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540d\u79f0\"%s\"\u4e0d\u80fd\u91cd\u590d\u3002", (String)"DatasetExpressionHelper_3", (String)"epm-far-formplugin", (Object[])new Object[0]), formulaname));
            }
            currentNames.add(formulaname);
        });
    }

    public DynamicObject getDataSet(Long discmodel, String formulaText) {
        QFilter qFilter = new QFilter("dataset.discmodel", "=", (Object)discmodel);
        qFilter.and("dataset.scope", "=", (Object)"1");
        qFilter.and("dataset.type", "=", (Object)"1");
        qFilter.and("dataset.number", "=", (Object)formulaText);
        DynamicObject dataSet = QueryServiceHelper.queryOne((String)"fidm_dataset_single", (String)"id,datasrcid,datasrctype,dataset.status", (QFilter[])qFilter.toArray());
        if (Objects.isNull(dataSet)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\"%s\"\u5355\u503c\u6570\u636e\u96c6,\u5bfc\u5165\u5931\u8d25\u3002", (String)"DataSetImportPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]), formulaText));
        }
        String status = dataSet.getString("dataset.status");
        if (!"1".equals(status)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\"%s\"\u5355\u503c\u6570\u636e\u96c6\u672a\u542f\u7528,\u5bfc\u5165\u5931\u8d25\u3002", (String)"DataSetImportPlugin_10", (String)"epm-far-formplugin", (Object[])new Object[0]), formulaText));
        }
        return dataSet;
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String number = ImportHelper.getImportBillProp(rowData, "number").toString();
        DynamicObject dynamicObject = this.recordMap.get(number);
        return Optional.ofNullable(dynamicObject);
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        return new DynamicObject[0];
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        for (ImportBillData bill : billDataList) {
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (!dbOld.isPresent()) continue;
            DynamicObject dataSet = dbOld.get();
            this.buildDatasetDsDym(dys, bill, dataSet, dataSet.getLong("dataset.id"));
        }
        return dys.toArray(new DynamicObject[0]);
    }

    private void buildDatasetDsDym(List<DynamicObject> dys, ImportBillData bill, DynamicObject singleDyn, Long datasetId) {
        Object entryentity = ImportHelper.getImportBillProp(bill, "entryentity");
        JSONArray entryentityJsonArr = (JSONArray)entryentity;
        for (int i = 0; i < entryentityJsonArr.size(); ++i) {
            JSONObject obj = (JSONObject)entryentityJsonArr.get(i);
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset_multivalue");
            String formulanumber = obj.getString("formulanumber");
            String formulatype = obj.getString("formulatype");
            String formulatext = obj.getString("formulatext");
            dyn.set("dataset", (Object)datasetId);
            dyn.set("number", (Object)formulanumber);
            dyn.set("name", obj.get((Object)"formulaname"));
            dyn.set("formulatype", (Object)formulatype);
            dyn.set("formulatext", (Object)formulatext);
            dyn.set("desq", (Object)(i + 1));
            if ("1".equals(formulatype)) {
                DynamicObject dataSet = this.getDataSet(this.model.getLong("id"), formulatext);
                dyn.set("single", (Object)dataSet.getLong("id"));
            }
            dys.add(dyn);
        }
    }

    @Override
    protected void batchInsertDBOpt(List<ImportBillData> billDataList) {
        long[] longs = DBServiceHelper.genLongIds((String)"fidm_dataset", (int)billDataList.size());
        ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        ArrayList dataSetEntries = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        for (int i = 0; i < billDataList.size(); ++i) {
            ImportBillData bill = billDataList.get(i);
            DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset");
            Object name = ImportHelper.getImportBillProp(bill, "name");
            if (name instanceof Map) {
                dataSet.set("name", (Object)LocaleString.fromMap((Map)((Map)name)));
            } else {
                dataSet.set("name", (Object)name.toString());
            }
            dataSet.set("id", (Object)longs[i]);
            dataSet.set("discmodel", (Object)this.model.getLong("id"));
            dataSet.set("type", (Object)DataSetTypeEnum.MULTIPLE_VALUED.getType());
            dataSet.set("number", (Object)ImportHelper.getImportBillProp(bill, "number").toString());
            dataSet.set("status", (Object)"1");
            dataSet.set("creator", (Object)this.userId);
            dataSet.set("createtime", (Object)TimeServiceHelper.now());
            dataSet.set("modifier", (Object)this.userId);
            dataSet.set("modifytime", (Object)TimeServiceHelper.now());
            dataSet.set("scope", (Object)1);
            dataSet.set("chapterid", (Object)0);
            dataSets.add(dataSet);
            this.buildDatasetDsDym(dataSetEntries, bill, null, dataSet.getLong("id"));
            Set dataset = dataSetEntries.stream().map(dy -> dy.getLong("dataset")).collect(Collectors.toSet());
            QFilter[] qFilters = new QFBuilder("dataset", "in", dataset).toArray();
            DeleteServiceHelper.delete((String)"fidm_dataset_multivalue", (QFilter[])qFilters);
        }
        SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dataSetEntries.toArray(new DynamicObject[0]));
    }

    @Override
    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildUpdateDynamicObject(billDataList);
        Set dataset = Arrays.stream(dys).map(dy -> dy.getLong("dataset")).collect(Collectors.toSet());
        QFilter[] qFilters = new QFBuilder("dataset", "in", dataset).toArray();
        DeleteServiceHelper.delete((String)"fidm_dataset_multivalue", (QFilter[])qFilters);
        SaveServiceHelper.save((DynamicObject[])dys);
        DynamicObject[] datasets = BusinessDataServiceHelper.load((String)"fidm_dataset", (String)"id,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", dataset)});
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject dy2 : datasets) {
            dy2.set("modifier", (Object)currUserId);
            dy2.set("modifytime", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])datasets);
    }

    private String checkMulNumAndName(String number, String name) {
        if (Objects.nonNull(number) && number.length() > 50) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7f16\u7801number\uff1a %s \u8d85\u8fc7\u6700\u592750\u4e2a\u5b57\u7b26\u3002", (String)"DataSetImportPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]), number);
        }
        if (Objects.nonNull(name) && name.length() > 50) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u540d\u79f0name\uff1a %s \u8d85\u8fc7\u6700\u592750\u4e2a\u5b57\u7b26\u3002", (String)"DataSetImportPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), name);
        }
        return null;
    }

    private String checkEntryFieldsLength(JSONObject rowJSONObject) {
        if (Objects.isNull(rowJSONObject)) {
            return null;
        }
        String formulanumber = rowJSONObject.getString("formulanumber");
        String formulaText = rowJSONObject.getString("formulatext");
        String formulaname = rowJSONObject.getString("formulaname");
        if (Objects.nonNull(formulanumber) && formulanumber.length() > 50) {
            return String.format(ResManager.loadKDString((String)"\u7f16\u7801formulanumber\uff1a %s \u8d85\u8fc7\u6700\u592750\u4e2a\u5b57\u7b26\u3002", (String)"DataSetImportPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]), formulanumber);
        }
        if (Objects.nonNull(formulaname) && formulaname.length() > 50) {
            return String.format(ResManager.loadKDString((String)"\u540d\u79f0formulaname\uff1a %s \u8d85\u8fc7\u6700\u592750\u4e2a\u5b57\u7b26\u3002", (String)"DataSetImportPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]), formulaname);
        }
        if (Objects.nonNull(formulaText) && formulaText.length() > 300) {
            return String.format(ResManager.loadKDString((String)"\u53d6\u6570\u516c\u5f0fformulatext\uff1a %s \u8d85\u8fc7\u6700\u5927300\u4e2a\u5b57\u7b26\u3002", (String)"DataSetImportPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]), formulaText);
        }
        return null;
    }
}

