/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.business.serviceHelper.MemberPermHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetCheckUtil;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.far.calculate.CalculateHelper;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.helper.ImportHelper;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;
import kd.epm.far.formplugin.common.imp.ImportOperateType;
import org.apache.commons.lang.StringUtils;

public class DataSetImportPlugin
extends AbsCommonImport {
    private DynamicObject model;
    private Map<String, Pair<Long, String>> bcmModelMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<String, DynamicObject> recordMap;
    private Set<String> repeatKeys = Sets.newHashSetWithExpectedSize((int)16);
    private Set<Long> bcmAdminModels = Sets.newHashSetWithExpectedSize((int)16);
    private Map<Long, List<Tuple<String, String, String>>> extendsModel = Maps.newHashMapWithExpectedSize((int)16);
    private DatasetDimService fidmDimService = new DatasetDimService();
    private Long userId = RequestContext.get().getCurrUserId();

    @Override
    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        super.setContext(rc, ctx, startArgs);
        this.model = DatasetDataReader.getModel((Long)LongUtil.toLong(ctx.getOption().get("BcmModelId")));
        this.entityName = "fidm_dataset_single";
        return this;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.initData(billdatas);
    }

    private void initData(List<ImportBillData> billData) {
        this.bcmAdminModels = MemberPermHelper.getUserModelListByUser((String)"");
        if (Objects.equals("bcm_model", this.model.getString("modelsourcetype"))) {
            String type = DataSrcTypeEnum.MERGE_MODEL.getType();
            if (Objects.equals(this.model.getString("modeltype"), DisModelTypeEnum.RPT.getType())) {
                type = DataSrcTypeEnum.RPT_MODEL.getType();
            }
            this.bcmModelMap.put(this.model.getString("number"), (Pair<Long, String>)new Pair((Object)this.model.getLong("id"), (Object)type));
        }
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)billData.size());
        for (ImportBillData billDatum : billData) {
            DynamicObject dy2;
            String dataSrcType = ImportHelper.getImportBillProp(billDatum, "datasrctype").toString();
            String dataSrcNumber = ImportHelper.getImportBillProp(billDatum, "datasrcnumber").toString();
            String number = ImportHelper.getImportBillProp(billDatum, "dataset.number").toString();
            numbers.add(number);
            if (!Objects.equals(DataSrcTypeEnum.MERGE_MODEL.getType(), dataSrcType) && !Objects.equals(DataSrcTypeEnum.RPT_MODEL.getType(), dataSrcType) || this.bcmModelMap.containsKey(dataSrcNumber) || !Objects.nonNull(dy2 = QueryServiceHelper.queryOne((String)"bcm_model", (String)"id,reporttype", (QFilter[])new QFilter[]{new QFilter("shownumber", "=", (Object)dataSrcNumber)}))) continue;
            String reporttype = dy2.getString("reporttype");
            String type = ApplicationTypeEnum.CM.getOIndex().equals(reporttype) ? DataSrcTypeEnum.MERGE_MODEL.getType() : DataSrcTypeEnum.RPT_MODEL.getType();
            this.bcmModelMap.put(dataSrcNumber, (Pair<Long, String>)new Pair((Object)dy2.getLong("id"), (Object)type));
        }
        QFilter modelFilter = new QFilter("dataset.discmodel", "=", this.ctx.getOption().get("BcmModelId"));
        QFilter numberFilter = new QFilter("dataset.number", "in", (Object)numbers);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)this.entityName).getAllFields().keySet()), (QFilter[])new QFilter[]{modelFilter, numberFilter});
        this.recordMap = Arrays.stream(load).collect(Collectors.toMap(dy -> dy.getString("dataset.number"), Function.identity(), (k1, k2) -> k1));
    }

    @Override
    protected Optional<String> validateBillData(ImportBillData bill) {
        DatasetDto datasetDto = new DatasetDto();
        try {
            this.buildDataSet(bill, null, datasetDto, false);
            ImportOperateType importType = ImportHelper.getImportType(this.ctx);
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (dbOld.isPresent() && Objects.equals((Object)importType, (Object)ImportOperateType.NEW)) {
                return Optional.of(ResManager.loadKDString((String)"\u672c\u6761\u6570\u636e\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DataAuthMainImport_13", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            DatasetCheckUtil.valid((DatasetDto)datasetDto, (!StringUtils.isBlank((String)datasetDto.getExtendsModelNumber()) ? 1 : 0) != 0);
            if (dbOld.isPresent() && !Objects.equals((Object)importType, (Object)ImportOperateType.NEW) && !Objects.equals(dbOld.get().getString("dataset.name"), datasetDto.getName())) {
                return Optional.of(ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u5339\u914d\u3002", (String)"DataSetImportPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        catch (KDBizException e) {
            return Optional.of(e.getMessage());
        }
        if (!this.repeatKeys.add(datasetDto.getNumber())) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u8bb0\u5f55\u5728\u6587\u4ef6\u4e2d\u91cd\u590d\u3002", (String)"DataAuthMainImport_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void buildDataSet(ImportBillData bill, Long id, DatasetDto dto, boolean ignoreType) {
        if (id != null) {
            dto.setId(id);
        }
        dto.setDiscmodelId(Long.valueOf(this.model.getLong("id")));
        dto.setNumber(ImportHelper.getImportBillProp(bill, "dataset.number").toString());
        DatasetServiceHelper.checkDatasetNumberFormat((String)dto.getNumber());
        String srcType = DataSetTypeEnum.getTypeByName((String)ImportHelper.getImportBillProp(bill, "dataset.type").toString());
        dto.setType(srcType);
        DynamicObject dynamicObject = this.recordMap.get(dto.getNumber());
        if (Objects.nonNull(dynamicObject) && !ignoreType && !Objects.equals(dynamicObject.getString("dataset.type"), dto.getType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7c7b\u578b\u66f4\u65b0\u5931\u8d25\u3002", (String)"DataSetImportPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        dto.setName(ImportHelper.getImportBillProp(bill, "dataset.name"));
        dto.setDataSrcType(ImportHelper.getImportBillProp(bill, "datasrctype").toString());
        dto.setDataSrcNumber(ImportHelper.getImportBillProp(bill, "datasrcnumber").toString());
        if (Objects.equals(DataSrcTypeEnum.CURRENT_MODEL.getType(), dto.getDataSrcType())) {
            if (!Objects.equals(this.model.getString("number"), dto.getDataSrcNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u7f16\u7801\u548c\u6570\u636e\u6765\u6e90\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"DataSetImportPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            dto.setDataSrcId(Long.valueOf(this.model.getLong("id")));
        }
        Pair<Long, String> pair = this.bcmModelMap.get(dto.getDataSrcNumber());
        if (DataSrcTypeEnum.getBcmModelType().contains(dto.getDataSrcType())) {
            String type;
            if (Objects.isNull(pair)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\"%s\"\u4f53\u7cfb\u3002", (String)"DataSetImportPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), dto.getDataSrcNumber()));
            }
            String string = type = Objects.equals(dto.getDataSrcType(), DataSrcTypeEnum.COMPONENT.getType()) ? DataSrcTypeEnum.MERGE_MODEL.getType() : dto.getDataSrcType();
            if (!((String)pair.p2).equals(type)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u7f16\u7801\u548c\u6570\u636e\u6765\u6e90\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"DataSetImportPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        if (!this.bcmAdminModels.contains(pair.p1)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\"%s\"\u4f53\u7cfb\u4f7f\u7528\u6743\u5bfc\u5165\u5931\u8d25\u3002", (String)"DataSetImportPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]), dto.getDataSrcNumber()));
        }
        dto.setDataSrcId((Long)pair.p1);
        String extendsmodelnumber = ImportHelper.getImportBillProp(bill, "extendsmodelnumber").toString();
        if (StringUtils.isNotBlank((String)extendsmodelnumber)) {
            List tuples;
            dto.setExtendsModelNumber(extendsmodelnumber);
            if (this.extendsModel.containsKey(dto.getDataSrcId())) {
                tuples = this.extendsModel.get(dto.getDataSrcId());
            } else {
                tuples = this.fidmDimService.getExtendsModel(dto.getDataSrcType(), dto.getDataSrcId());
                this.extendsModel.put(dto.getDataSrcId(), tuples);
            }
            Optional<Tuple> any = tuples.stream().filter(t -> Objects.equals(t.p1, extendsmodelnumber)).findAny();
            any.ifPresent(stringStringStringTuple -> dto.setExtendsModelId(Long.valueOf((String)stringStringStringTuple.p3)));
        }
        dto.setExpression(ImportHelper.getImportBillProp(bill, "expression").toString());
        dto.setValue(ImportHelper.getImportBillProp(bill, "value").toString());
        if (Objects.nonNull(dto.getExtendsModelId())) {
            Map extSelects = this.fidmDimService.getExtendsFields(dto.getDataSrcType(), dto.getDataSrcId(), dto.getExtendsModelId(), "");
            String[] split = dto.getValue().split(",");
            if (!extSelects.keySet().containsAll(Arrays.stream(split).collect(Collectors.toSet()))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u5fc5\u987b\u4e3a\u5f53\u524d\u62d3\u5c55\u6a21\u578b\u4e0b\u7684\u6210\u5458\u3002", (String)"DataSetImportPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        }
        dto.setDefValue(ImportHelper.getImportBillProp(bill, "defvalue").toString());
        dto.setGroupBy(ImportHelper.getImportBillProp(bill, "groupby").toString());
        dto.setOrderBy(ImportHelper.getImportBillProp(bill, "orderby").toString());
        dto.setAsc(ImportHelper.getImportBillProp(bill, "asc").toString());
        String top = ImportHelper.getImportBillProp(bill, "top").toString();
        if (StringUtils.isBlank((String)top)) {
            dto.setTop(Integer.valueOf(0));
        } else if (!CalculateHelper.isPositiveInteger((String)top, (boolean)true)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u524d\u51e0\u6570\u636e\u201d\u5fc5\u987b\u662f\u6b63\u6574\u6570\u3002", (String)"DataSetImportPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        dto.setDimNum(ImportHelper.getImportBillProp(bill, "dimnum").toString());
        String membernum = ImportHelper.getImportBillProp(bill, "membernum").toString();
        if (StringUtils.isNotBlank((String)membernum)) {
            dto.setMemberNum(membernum);
        }
        dto.setStyle(DatasetStyleEnum.QUERY.getType());
    }

    @Override
    protected Optional<DynamicObject> getDbOld(ImportBillData rowData) {
        String number = ImportHelper.getImportBillProp(rowData, "dataset.number").toString();
        DynamicObject dynamicObject = this.recordMap.get(number);
        return Optional.ofNullable(dynamicObject);
    }

    @Override
    protected DynamicObject[] buildInsertDynamicObject(List<ImportBillData> billDataList) {
        return new DynamicObject[0];
    }

    @Override
    protected DynamicObject[] buildUpdateDynamicObject(List<ImportBillData> billDataList) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        for (ImportBillData bill : billDataList) {
            Optional<DynamicObject> dbOld = this.getDbOld(bill);
            if (!dbOld.isPresent()) continue;
            DynamicObject dataSet = dbOld.get();
            this.buildDatasetDsDym(dys, bill, dataSet, dataSet.getLong("dataset.id"), dataSet.getString("dataset.type"));
            long datasetId = dataSet.getLong("dataset");
            DeleteServiceHelper.delete((String)"fidm_dataset_variable", (QFilter[])new QFilter[]{new QFilter("dataset", "=", (Object)datasetId)});
            DatasetDto datasetDto = new DatasetDto();
            this.buildDataSet(bill, ((DynamicObject)dys.get(dys.size() - 1)).getLong("id"), datasetDto, true);
            datasetDto.setScope("1");
            DatasetServiceHelper.addDatasetVar((DatasetDto)datasetDto, (long)datasetId, null);
        }
        return dys.toArray(new DynamicObject[0]);
    }

    private void buildDatasetDsDym(List<DynamicObject> dys, ImportBillData bill, DynamicObject singleDyn, Long datasetId, String type) {
        if (Objects.isNull(singleDyn)) {
            singleDyn = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset_single");
        }
        singleDyn.set("dataset", (Object)datasetId);
        singleDyn.set("datasrctype", (Object)ImportHelper.getImportBillProp(bill, "datasrctype").toString());
        singleDyn.set("datasrcnumber", (Object)ImportHelper.getImportBillProp(bill, "datasrcnumber").toString());
        Pair<Long, String> pair = this.bcmModelMap.get(singleDyn.getString("datasrcnumber"));
        singleDyn.set("datasrcid", pair.p1);
        String extendsmodelnumber = ImportHelper.getImportBillProp(bill, "extendsmodelnumber").toString();
        if (StringUtils.isNotBlank((String)extendsmodelnumber)) {
            List<Tuple<String, String, String>> tuples = this.extendsModel.get(singleDyn.getLong("datasrcid"));
            singleDyn.set("extendsmodelnumber", (Object)extendsmodelnumber);
            Optional<Tuple> any = tuples.stream().filter(t -> Objects.equals(t.p1, extendsmodelnumber)).findAny();
            if (any.isPresent()) {
                singleDyn.set("extendsmodelid", (Object)Long.valueOf((String)any.get().p3));
            }
        } else {
            singleDyn.set("extendsmodelnumber", (Object)"");
            singleDyn.set("extendsmodelid", (Object)"0");
        }
        singleDyn.set("expression", (Object)ImportHelper.getImportBillProp(bill, "expression").toString());
        singleDyn.set("value", (Object)ImportHelper.getImportBillProp(bill, "value").toString());
        if (Objects.equals(DataSetTypeEnum.SINGLE_VALUED.getType(), type)) {
            singleDyn.set("defvalue", (Object)ImportHelper.getImportBillProp(bill, "defvalue").toString());
            dys.add(singleDyn);
            return;
        }
        singleDyn.set("dimnum", (Object)ImportHelper.getImportBillProp(bill, "dimnum").toString());
        String membernum = ImportHelper.getImportBillProp(bill, "membernum").toString();
        if (StringUtils.isNotBlank((String)membernum)) {
            singleDyn.set("membernum", (Object)membernum);
        }
        singleDyn.set("groupby", (Object)ImportHelper.getImportBillProp(bill, "groupby").toString());
        singleDyn.set("orderby", (Object)ImportHelper.getImportBillProp(bill, "orderby").toString());
        String top = ImportHelper.getImportBillProp(bill, "top").toString();
        singleDyn.set("top", (Object)(StringUtils.isBlank((String)top) ? 0 : Integer.parseInt(top)));
        singleDyn.set("asc", (Object)ImportHelper.getImportBillProp(bill, "asc").toString());
        dys.add(singleDyn);
    }

    @Override
    protected void batchInsertDBOpt(List<ImportBillData> billDataList) {
        long[] longs = DBServiceHelper.genLongIds((String)"fidm_dataset", (int)billDataList.size());
        ArrayList dataSets = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        ArrayList dataSetEntries = Lists.newArrayListWithExpectedSize((int)billDataList.size());
        for (int i = 0; i < billDataList.size(); ++i) {
            ImportBillData bill = billDataList.get(i);
            String defvalue = ImportHelper.getImportBillProp(bill, "defvalue").toString();
            DynamicObject dataSet = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset");
            dataSet.set("id", (Object)longs[i]);
            dataSet.set("discmodel", (Object)this.model.getLong("id"));
            String type = StringUtils.isBlank((String)defvalue) ? DataSetTypeEnum.MULTIPLE_ROW.getType() : DataSetTypeEnum.SINGLE_VALUED.getType();
            dataSet.set("type", (Object)type);
            dataSet.set("number", (Object)ImportHelper.getImportBillProp(bill, "dataset.number").toString());
            dataSet.set("name", (Object)ImportHelper.getImportBillProp(bill, "dataset.name").toString());
            dataSet.set("status", (Object)"1");
            dataSet.set("creator", (Object)this.userId);
            dataSet.set("createtime", (Object)TimeServiceHelper.now());
            dataSet.set("modifier", (Object)this.userId);
            dataSet.set("modifytime", (Object)TimeServiceHelper.now());
            dataSet.set("scope", (Object)1);
            dataSet.set("chapterid", (Object)0);
            dataSet.set("currentstyle", (Object)DatasetStyleEnum.QUERY.getType());
            dataSets.add(dataSet);
            this.buildDatasetDsDym(dataSetEntries, bill, null, dataSet.getLong("id"), type);
            DatasetDto datasetDto = new DatasetDto();
            datasetDto.setScope(dataSet.getString("scope"));
            this.buildDataSet(bill, null, datasetDto, true);
            DatasetServiceHelper.addDatasetVar((DatasetDto)datasetDto, (long)longs[i], null);
        }
        SaveServiceHelper.save((DynamicObject[])dataSets.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])dataSetEntries.toArray(new DynamicObject[0]));
    }

    @Override
    protected void batchUpdateDBOpt(List<ImportBillData> billDataList) {
        DynamicObject[] dys = this.buildUpdateDynamicObject(billDataList);
        SaveServiceHelper.save((DynamicObject[])dys);
        Set dataset = Arrays.stream(dys).map(dy -> dy.getLong("dataset")).collect(Collectors.toSet());
        DynamicObject[] datasets = BusinessDataServiceHelper.load((String)"fidm_dataset", (String)"id,modifier,modifytime,currentstyle", (QFilter[])new QFilter[]{new QFilter("id", "in", dataset)});
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject dy2 : datasets) {
            dy2.set("modifier", (Object)currUserId);
            dy2.set("modifytime", (Object)date);
            dy2.set("currentstyle", (Object)DatasetStyleEnum.QUERY.getType());
        }
        SaveServiceHelper.save((DynamicObject[])datasets);
    }
}

