/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.epm.far.business.bcm.dimension.RPTDimType;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.variable.VariableService;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.CommonDatasetEdit;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisCommonOperateHelper;
import org.apache.commons.lang.StringUtils;

public class DataSetInfoPlugin
extends CommonDatasetEdit
implements DynamicPage {
    private static final String VAR_SELECT = "varselect";
    private static final String CUR = "cur";
    private static final String CURS = "curs";
    private Map<String, Pair<Boolean, String>> curMap;
    private static final String ENTRYENTITY = "entryentity";
    private static final String DIMNUMBER = "dimNumber";
    private static final String DETAILS = "details";
    private static final String DIM = "dim";
    private DatasetDto dto;
    private Set<String> hiddenDim;
    private Set<String> rowColDim;
    private static final Set<String> DEFAULT_CUR_MAP = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getShortNumber(), DimTypesEnum.YEAR.getShortNumber(), DimTypesEnum.PERIOD.getShortNumber()});

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        BasedataEdit permclass = (BasedataEdit)this.getView().getControl("permclass");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getDMModelId(), (String)"fidmmodel", (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl("category");
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("dmmodelid", this.getView().getFormShowParameter().getCustomParam("dmmodel_id").toString());
        DatasetDto dto = this.getDto();
        this.buildBase(dto);
        this.buildVariable(dto);
        this.buildParams(dto, false);
        String sourceFrom = dto.getDataSrcType();
        if (!DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
            if (Objects.nonNull(this.getCurMap())) {
                String tempExpression = dto.getTempExpression();
                StringBuilder sb = new StringBuilder();
                sb.append(tempExpression);
                for (Map.Entry<String, Pair<Boolean, String>> entry : this.curMap.entrySet()) {
                    if (DEFAULT_CUR_MAP.contains(entry.getKey())) {
                        sb.append(",").append(entry.getKey()).append(".").append("$Cur");
                        continue;
                    }
                    sb.append(",").append(entry.getKey()).append(".").append("$All");
                }
                dto.setTempExpression(sb.toString());
            }
            this.buildDetails(dto);
        }
        if (DataSrcTypeEnum.EB_MODEL.getType().equals(dto.getDataSrcType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CURS});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        DatasetDto dto = this.getDto();
        String sourceFrom = dto.getDataSrcType();
        if (StringUtils.equals((String)CUR, (String)propName)) {
            if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
                this.isISCCurOrCursSelect(true, (Boolean)e.getChangeSet()[0].getOldValue());
            } else {
                this.singleSelect(true, (Boolean)e.getChangeSet()[0].getOldValue());
                String expression = this.getExpression(dto, e);
                dto.setTempExpression(expression);
                this.buildDetails(dto);
            }
        } else if (StringUtils.equals((String)CURS, (String)propName)) {
            if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
                this.isISCCurOrCursSelect(false, (Boolean)e.getChangeSet()[0].getOldValue());
            } else {
                this.singleSelect(false, (Boolean)e.getChangeSet()[0].getOldValue());
                String expression = this.getExpression(dto, e);
                dto.setTempExpression(expression);
                this.buildDetails(dto);
            }
        } else if (StringUtils.equals((String)VAR_SELECT, (String)propName) && !DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
            this.buildParams(dto, true);
            String expression = this.getExpression(dto, null);
            dto.setTempExpression(expression);
            this.buildDetails(dto);
        }
    }

    private void singleSelect(boolean isCur, Boolean oldValue) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectedRows = entryGrid.getSelectRows();
        if (selectedRows.length == 0) {
            return;
        }
        int rowIndex = selectedRows[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        for (int i = 0; i < entryEntities.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntities.get(i);
            this.setOneRowSelectEnable(entry.getString("dimnumber"), entryGrid, i);
        }
        DynamicObject rowDy = (DynamicObject)entryEntities.get(rowIndex);
        this.changeCurOrCursState(rowDy, isCur, oldValue);
    }

    private void isISCCurOrCursSelect(boolean isCur, boolean oldValue) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectedRows = entryGrid.getSelectRows();
        if (selectedRows.length == 0) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        int rowIndex = selectedRows[0];
        DynamicObject rowDy = (DynamicObject)entryEntities.get(rowIndex);
        this.changeCurOrCursState(rowDy, isCur, oldValue);
    }

    private void changeCurOrCursState(DynamicObject rowDy, boolean isCur, Boolean oldValue) {
        if (rowDy.getBoolean(CUR) && rowDy.getBoolean(CURS)) {
            if (isCur) {
                rowDy.set(CURS, (Object)false);
            } else {
                rowDy.set(CUR, (Object)false);
            }
        } else if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(this.dto.getDataSrcType()) && Objects.nonNull(oldValue) && oldValue.booleanValue() && this.getCurMap().containsKey("E")) {
            if (isCur) {
                rowDy.set(CURS, (Object)true);
            } else {
                rowDy.set(CUR, (Object)true);
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private String getExpression(DatasetDto dto, PropertyChangedArgs e) {
        Map<String, Set<String>> allCurKeys = this.getAllCurKeys();
        String s = this.buildExpression(dto, allCurKeys);
        if (Objects.nonNull(this.getCurMap())) {
            StringBuilder sb = new StringBuilder();
            sb.append(s);
            Set<String> curKey = allCurKeys.get(CUR);
            Set<String> cursKey = allCurKeys.get(CURS);
            for (Map.Entry<String, Pair<Boolean, String>> entry : this.curMap.entrySet()) {
                if (curKey.contains(entry.getKey()) || cursKey.contains(entry.getKey())) {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    if (curKey.contains(entry.getKey())) {
                        sb.append(entry.getKey()).append(".").append("$Cur");
                        continue;
                    }
                    sb.append(entry.getKey()).append(".").append("$Curs");
                    continue;
                }
                if (sb.length() != 0) {
                    sb.append(",");
                }
                sb.append(entry.getKey()).append(".").append("$All");
            }
            s = sb.toString();
        }
        return s;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("category".equals(key)) {
            Long modelId = LongUtil.toLong((Object)this.getModelId());
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
            filterList.add(new QFilter("model", "=", (Object)this.getDMModelId()));
            QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter((long)modelId, (String)"far_datasetcategory");
            filterList.add(permqFilter);
            evt.setCustomQFilters(filterList);
            ArrayList<QFilter> filterList2 = new ArrayList<QFilter>(2);
            filterList2.add(new QFilter("model", "=", (Object)this.getDMModelId()));
            filterList2.add(permqFilter);
            ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
            fsp.getTreeFilterParameter().setQFilters(filterList2);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (this.getPage(this.getView()) != null) {
            Element c = this.getPage(this.getView()).findElementBySign(e.getKey());
            if (Objects.isNull(c)) {
                return;
            }
            Long dmModelId = this.getDMModelId();
            AnalysisCommonOperateHelper.getControl(e, c, dmModelId, this.getView(), this.getModel(), this.getPageCache(), this, (ClickListener)this, null);
        }
    }

    private DatasetDto getDto() {
        if (Objects.nonNull(this.dto)) {
            return this.dto;
        }
        this.dto = (DatasetDto)JSON.parseObject((String)this.getFormCustomParam("data").toString(), (TypeReference)new TypeReference<DatasetDto>(){}, (Feature[])new Feature[0]);
        JSONObject jsonObject = JSON.parseObject((String)this.dto.getEventParams());
        List members = (List)JSON.parseObject((String)jsonObject.getString(DIM), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        this.hiddenDim = Sets.newHashSetWithExpectedSize((int)8);
        this.rowColDim = Sets.newHashSetWithExpectedSize((int)8);
        if (Objects.nonNull(members)) {
            members.forEach(member -> {
                if (RPTDimType.HIDDEN.getValue().equals(member.get("rptDimType"))) {
                    this.hiddenDim.add((String)member.get("shortNumber"));
                } else if (RPTDimType.ROWCOL.getValue().equals(member.get("rptDimType"))) {
                    this.rowColDim.add((String)member.get("shortNumber"));
                }
            });
        }
        return this.dto;
    }

    private void buildParams(DatasetDto dto, boolean saveOldStatus) {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.clearEntryState();
        DynamicObject dataEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        Map<String, Boolean> shortNumToOldStatus = entryEntities.stream().collect(Collectors.toMap(entry -> (String)entry.get(DIMNUMBER), entry -> (Boolean)entry.get(CUR), (k1, k2) -> k1));
        entryEntities.clear();
        String sourceFrom = dto.getDataSrcType();
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom)) {
            this.setICSParam(entryEntities, saveOldStatus, shortNumToOldStatus);
        } else {
            this.setDIMParam(entryentity, entryEntities, saveOldStatus, shortNumToOldStatus, sourceFrom);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void setICSParam(DynamicObjectCollection entryEntities, boolean saveOldStatus, Map<String, Boolean> shortNumToOldStatus) {
        String eventParams = this.dto.getEventParams();
        JSONObject jsonObject = JSON.parseObject((String)eventParams);
        List datas = (List)JSON.parseObject((String)jsonObject.getString("custom"), (TypeReference)new TypeReference<List<DatasetPropertyVo>>(){}, (Feature[])new Feature[0]);
        int index = 0;
        String expression = this.dto.getTempExpression();
        List<Object> iscNums = Lists.newArrayListWithExpectedSize((int)10);
        if (kd.bos.util.StringUtils.isNotEmpty((String)expression)) {
            if (expression.contains(",")) {
                String[] iscSplits = expression.split(",");
                iscNums = Arrays.asList(iscSplits);
            } else {
                iscNums.add(expression);
            }
        }
        for (DatasetPropertyVo datasetPropertyVo : datas) {
            DynamicObject entryEntity = entryEntities.addNew();
            String name = datasetPropertyVo.getName();
            String number = datasetPropertyVo.getNumber();
            List filters = datasetPropertyVo.getFilters();
            entryEntity.set(DIM, (Object)name);
            entryEntity.set(DIMNUMBER, (Object)number);
            if (filters.size() > 0) {
                entryEntity.set(CUR, (Object)false);
            } else if (iscNums.contains(number + ".$Cur") || iscNums.contains(number + ".$cur") || iscNums.contains(number + ".$Curs") || iscNums.contains(number + ".$curs")) {
                entryEntity.set(CUR, (Object)true);
            } else {
                boolean status = saveOldStatus && shortNumToOldStatus.containsKey(number) ? shortNumToOldStatus.get(number) : false;
                entryEntity.set(CUR, (Object)status);
            }
            ++index;
        }
    }

    private void setDIMParam(EntryGrid entryentity, DynamicObjectCollection entryEntities, boolean saveOldStatus, Map<String, Boolean> shortNumToOldStatus, String sourceFrom) {
        String eventParams = this.dto.getEventParams();
        Map<String, Pair<Boolean, String>> curMap = this.getCurMap();
        JSONObject jsonObject = JSON.parseObject((String)eventParams);
        List sm = (List)JSON.parseObject((String)jsonObject.getString(DIM), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List dimNumbers = sm.stream().filter(v -> !"SourceEntity".equals(v.get(DIMNUMBER)) && !this.rowColDim.contains(v.get("shortNumber"))).collect(Collectors.toList());
        Map<String, List<Map>> map = dimNumbers.stream().collect(Collectors.groupingBy(t -> (String)t.get("shortNumber")));
        Set<String> deficiency = this.getSelectVarDims(this.dto);
        int index = 0;
        for (List<Map> list : map.values()) {
            String name = (String)list.get(0).get("dimName");
            String sign = (String)list.get(0).get("shortNumber");
            if (deficiency.contains(sign)) continue;
            DynamicObject entryEntity = entryEntities.addNew();
            entryEntity.set(DIM, (Object)name);
            entryEntity.set(DIMNUMBER, (Object)sign);
            boolean status = saveOldStatus && shortNumToOldStatus.containsKey(sign) ? shortNumToOldStatus.get(sign) : false;
            entryEntity.set(CUR, (Object)status);
            this.setOneRowSelectEnable(sign, entryentity, index);
            ++index;
        }
        for (Map.Entry entry : curMap.entrySet()) {
            boolean status;
            if (deficiency.contains(entry.getKey())) continue;
            DynamicObject entryEntity = entryEntities.addNew();
            entryEntity.set(DIM, ((Pair)entry.getValue()).p2);
            entryEntity.set(DIMNUMBER, entry.getKey());
            boolean bl = status = saveOldStatus && shortNumToOldStatus.containsKey(entry.getKey()) ? shortNumToOldStatus.get(entry.getKey()) : true;
            if (!DataSrcTypeEnum.CM_TEMPLATE.getType().equals(sourceFrom) && status && !DEFAULT_CUR_MAP.contains(entry.getKey())) {
                status = false;
            }
            entryEntity.set(CUR, (Object)status);
            if (((Boolean)((Pair)entry.getValue()).p1).booleanValue()) {
                this.setOneRowSelectEnable((String)entry.getKey(), entryentity, index);
            }
            ++index;
        }
    }

    private void setOneRowSelectEnable(String dimShortNum, EntryGrid entryentity, int index) {
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(this.dto.getDataSrcType())) {
            if (!"E".equals(dimShortNum)) {
                entryentity.getView().setEnable(Boolean.valueOf(false), index, new String[]{CURS});
                if (this.getCurMap().containsKey(dimShortNum)) {
                    entryentity.getView().setEnable(Boolean.valueOf(false), index, new String[]{CUR});
                }
                if (this.hiddenDim.contains(dimShortNum)) {
                    entryentity.getView().setEnable(Boolean.valueOf(false), index, new String[]{CUR});
                }
            }
        } else if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(this.dto.getDataSrcType()) && LongUtil.isvalidLong((Object)this.dto.getExtendsModelId()) && ("AT".equals(dimShortNum) || "BP".equals(dimShortNum))) {
            entryentity.getView().setEnable(Boolean.valueOf(false), index, new String[]{CURS});
        }
    }

    private Set<String> getSelectVarDims(DatasetDto dto) {
        return this.getSelectVar(dto, "dimShortNum");
    }

    private Set<String> getSelectVarNums(DatasetDto dto) {
        return this.getSelectVar(dto, "number");
    }

    private Set<String> getSelectVar(DatasetDto dto, String filedName) {
        String[] ids;
        Map varMap = dto.getVarMap();
        Object selectIds = this.getModel().getValue(VAR_SELECT);
        if (Objects.isNull(varMap) || varMap.isEmpty() || Objects.isNull(selectIds)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet varDims = Sets.newHashSetWithExpectedSize((int)varMap.size());
        for (String id : ids = ((String)selectIds).split(",")) {
            if (StringUtils.isEmpty((String)id)) continue;
            String oneVarString = (String)varMap.get(id);
            JSON.parseArray((String)String.valueOf(oneVarString)).forEach(oneVar -> varDims.add(((JSONObject)oneVar).getString(filedName)));
        }
        return varDims;
    }

    private String buildExpression(DatasetDto dto, Map<String, Set<String>> allCurKeys) {
        JSONObject jsonObject = JSON.parseObject((String)dto.getEventParams());
        List sm = (List)JSON.parseObject((String)jsonObject.getString(DIM), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List dimNumbers = sm.stream().filter(v -> !"SourceEntity".equals(v.get(DIMNUMBER))).collect(Collectors.toList());
        Set<String> selectDimsInVar = this.getSelectVarDims(dto);
        Map<String, List<Map>> map = dimNumbers.stream().filter(t -> !selectDimsInVar.contains(t.get("shortNumber")) && !RPTDimType.ROWCOL.getValue().equals(t.get("rptDimType"))).collect(Collectors.groupingBy(t -> (String)t.get("shortNumber")));
        String expression = DatasetUtil.buildExpression(map, allCurKeys, (boolean)true);
        StringBuilder sb = new StringBuilder(expression);
        if (StringUtils.isNotBlank((String)expression)) {
            sb.append(",");
        }
        this.getSelectVarNums(dto).forEach(num -> {
            sb.append("$");
            sb.append((String)num);
            sb.append("$");
            sb.append(",");
        });
        if (sb.length() != 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String operateName = this.getView().getFormShowParameter().getStatus().name();
        this.getPageCache().put("operation_log_name", operateName);
        DatasetDto dto = this.buildDto();
        dto.setScope("1");
        DatasetUtil.checkCondition((DatasetDto)dto);
        if (!DataSetDisplayUtil.isMetadtaSrcType(dto).booleanValue()) {
            this.validDto(dto, StringUtils.isNotEmpty((String)dto.getExtendsModelNumber()), this.checkMemberNum(dto));
        }
        if (Objects.isNull(dto.getId()) || ((Boolean)this.getFormCustomParam("isCopy")).booleanValue()) {
            String datasetId = (String)this.getFormCustomParam("dataset_id");
            if (((Boolean)this.getFormCustomParam("isCopy")).booleanValue()) {
                DatasetUtil.buildManageVo((DatasetDto)dto, (Long)LongUtil.toLong((Object)datasetId));
                datasetId = "0";
            }
            DatasetServiceHelper.checkDatasetNumber((String)dto.getNumber(), (long)this.getDMModelId(), (long)(Objects.equals("null", datasetId) ? 0L : LongUtil.toLong((Object)datasetId)));
            this.initDataset(dto);
        } else {
            this.editDataset(dto, true);
        }
        IFormView view = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DatasetSingleNewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(view);
        this.getView().close();
    }

    private boolean checkMemberNum(DatasetDto dto) {
        if (StringUtils.isBlank((String)dto.getDimNum())) {
            return true;
        }
        return !StringUtils.isBlank((String)dto.getMemberNum());
    }

    private Map<String, Pair<Boolean, String>> getCurMap() {
        if (Objects.isNull(this.curMap)) {
            this.curMap = (Map)JSON.parseObject((String)this.getFormCustomParam("curMap").toString(), (TypeReference)new TypeReference<Map<String, Pair<Boolean, String>>>(){}, (Feature[])new Feature[0]);
            return this.curMap;
        }
        return this.curMap;
    }

    private DatasetDto buildDto() {
        DatasetDto dto = this.getDto();
        dto.setNumber((String)this.getModel().getValue("number"));
        dto.setName(this.getModel().getValue("name"));
        if (DataSetDisplayUtil.isMetadtaSrcType(dto).booleanValue()) {
            String expression = this.getICSExpression();
            dto.setExpression(expression);
        } else {
            String expression = this.getExpression(dto, null);
            dto.setExpression(expression);
        }
        dto.setCategoryId((Long)this.getModel().getValue("category_id"));
        return dto;
    }

    private String getICSExpression() {
        Map<String, Set<String>> allCurKeys = this.getAllCurKeys();
        Set<String> curKey = allCurKeys.get(CUR);
        Set<String> cursKey = allCurKeys.get(CURS);
        ArrayList curList = Lists.newArrayListWithExpectedSize((int)curKey.size());
        String data = this.dto.getData();
        JSONObject customInfo = JSONObject.parseObject((String)data);
        JSONArray columns = customInfo.getJSONArray("columns");
        columns.forEach(column -> {
            String number = ((JSONObject)column).getString("number");
            if (curKey.contains(number)) {
                curList.add(number + ".$Cur");
                ((JSONObject)column).remove((Object)"filters");
            }
            if (cursKey.contains(number)) {
                curList.add(number + ".$Curs");
            }
        });
        String expression = String.join((CharSequence)",", curList);
        return expression;
    }

    private Map<String, Set<String>> getAllCurKeys() {
        DynamicObject[] dataEntities;
        HashMap allCurKeys = Maps.newHashMapWithExpectedSize((int)2);
        HashSet curKey = Sets.newHashSetWithExpectedSize((int)16);
        HashSet cursKey = Sets.newHashSetWithExpectedSize((int)16);
        allCurKeys.put(CUR, curKey);
        allCurKeys.put(CURS, cursKey);
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRYENTITY);
        for (DynamicObject dataEntity : dataEntities = entryEntity.getEntryData().getDataEntitys()) {
            if (dataEntity.getBoolean(CUR)) {
                curKey.add(dataEntity.getString(DIMNUMBER));
                continue;
            }
            if (!dataEntity.getBoolean(CURS)) continue;
            cursKey.add(dataEntity.getString(DIMNUMBER));
        }
        return allCurKeys;
    }

    private void buildDetails(DatasetDto dto) {
        DatasetUtil.buildDetails((DatasetDto)dto);
        this.setValue(DETAILS, dto.getDetails());
        this.getView().setEnable(Boolean.valueOf(false), new String[]{DETAILS});
    }

    private void buildBase(DatasetDto dto) {
        DynamicObject permClassEntity;
        Long categoryId;
        this.setValue("datasettype", dto.getType());
        Boolean isCopy = (Boolean)this.getFormCustomParam("isCopy");
        if (Objects.nonNull(dto.getId()) || isCopy.booleanValue()) {
            DynamicObject dataSet;
            this.setValue("number", dto.getNumber());
            if (!isCopy.booleanValue()) {
                dataSet = DatasetDataReader.getDataSet((Long)dto.getId());
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                this.setValue("name", dataSet.get("name"));
            } else {
                dataSet = DatasetDataReader.getDataSet((Long)LongUtil.toLong((Object)this.getFormCustomParam("dataset_id")));
                this.setValue("name", dataSet.get("name") + "_copy");
            }
            categoryId = dataSet.getLong("category.id");
            if (LongUtil.isValidLong((Object)categoryId)) {
                this.getModel().setValue("category", (Object)categoryId);
            } else {
                categoryId = (Long)this.getView().getFormShowParameter().getCustomParam("categoryid");
                this.getModel().setValue("category", (Object)categoryId);
            }
        } else {
            Object cid = this.getView().getFormShowParameter().getCustomParam("categoryid");
            if (cid != null) {
                categoryId = LongUtil.toLong((Object)cid);
                this.getModel().setValue("category", (Object)categoryId);
            }
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"datasettype"});
        if (Objects.nonNull(dto.getId()) && (permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"fidm_dataset", (Long)dto.getId(), (Object)this.getDMModelId(), (String)"fidmmodel", (String)this.getBizAppId())) != null) {
            Long permClassId = permClassEntity.getLong("permclass.id");
            this.setValue("permclass", permClassId);
        }
    }

    private void buildVariable(DatasetDto dto) {
        Map varMap = dto.getVarMap();
        if (CollectionUtils.isEmpty((Map)varMap) || Objects.isNull(varMap)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{VAR_SELECT});
            return;
        }
        List varIds = varMap.keySet().stream().map(Long::parseLong).collect(Collectors.toList());
        List variableList = VariableService.getVariables((long)this.getDMModelId(), varIds);
        MulComboEdit mul = (MulComboEdit)this.getControl(VAR_SELECT);
        ArrayList comboItem = new ArrayList();
        variableList.forEach(variable -> comboItem.add(new ComboItem(new LocaleString(variable.getNumber() + " " + variable.getName()), String.valueOf(variable.getId()))));
        mul.setComboItems(comboItem);
    }

    @Override
    public void setValue(String key, Object value) {
        this.getModel().setValue(key, value);
    }
}

