/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.CommonDatasetEdit;

public class DataSetInfomationPlugin
extends CommonDatasetEdit {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        BasedataEdit permclass = (BasedataEdit)this.getView().getControl("permclass");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getDMModelId(), (String)"fidmmodel", (String)this.getView().getFormShowParameter().getAppId());
        BasedataEdit datasetBasedata = (BasedataEdit)this.getControl("category");
        datasetBasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("category".equals(key)) {
            Long modelId = LongUtil.toLong((Object)this.getModelId());
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
            filterList.add(new QFilter("model", "=", (Object)this.getDMModelId()));
            QFilter permqFilter = PermissionHelper.getReadAndWritePermFilter((long)modelId, (String)"far_datasetcategory");
            filterList.add(permqFilter);
            evt.setCustomQFilters(filterList);
            ArrayList<QFilter> filterList2 = new ArrayList<QFilter>(2);
            filterList2.add(new QFilter("model", "=", (Object)this.getDMModelId()));
            filterList2.add(permqFilter);
            ListShowParameter fsp = (ListShowParameter)evt.getFormShowParameter();
            fsp.getTreeFilterParameter().setQFilters(filterList2);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DatasetDto dto = this.getDto();
        this.buildBase(dto);
    }

    private DatasetDto getDto() {
        DatasetDto dto = (DatasetDto)JSON.parseObject((String)this.getFormCustomParam("data").toString(), (TypeReference)new TypeReference<DatasetDto>(){}, (Feature[])new Feature[0]);
        return dto;
    }

    private void buildBase(DatasetDto dto) {
        DynamicObject permClassEntity;
        this.setValue("datasettype", dto.getType());
        Boolean isCopy = (Boolean)this.getFormCustomParam("isCopy");
        if (Objects.nonNull(dto.getId()) || isCopy.booleanValue()) {
            DynamicObject dataSet;
            this.setValue("number", dto.getNumber());
            if (!isCopy.booleanValue()) {
                dataSet = DatasetDataReader.getDataSet((Long)dto.getId());
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
                this.setValue("name", dataSet.get("name"));
            } else {
                dataSet = DatasetDataReader.getDataSet((Long)LongUtil.toLong((Object)this.getFormCustomParam("dataset_id")));
                this.setValue("name", dataSet.get("name") + "_copy");
            }
            Long categoryId = dataSet.getLong("category.id");
            if (LongUtil.isValidLong((Object)categoryId)) {
                this.getModel().setValue("category", (Object)categoryId);
            } else {
                categoryId = (Long)this.getView().getFormShowParameter().getCustomParam("categoryid");
                this.getModel().setValue("category", (Object)categoryId);
            }
        } else {
            Long categoryId = (Long)this.getView().getFormShowParameter().getCustomParam("categoryid");
            this.getModel().setValue("category", (Object)categoryId);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"datasettype"});
        if (Objects.nonNull(dto.getId()) && (permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"fidm_dataset", (Long)dto.getId(), (Object)this.getDMModelId(), (String)"fidmmodel", (String)this.getBizAppId())) != null) {
            Long permClassId = permClassEntity.getLong("permclass.id");
            this.setValue("permclass", permClassId);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String operateName = this.getView().getFormShowParameter().getStatus().name();
        this.getPageCache().put("operation_log_name", operateName);
        DatasetDto dto = this.buildDto();
        dto.setScope("1");
        DatasetUtil.checkCondition((DatasetDto)dto);
        this.validDtoBaseInfo(dto);
        if (Objects.isNull(dto.getId()) || ((Boolean)this.getFormCustomParam("isCopy")).booleanValue()) {
            String datasetId = (String)this.getFormCustomParam("dataset_id");
            DatasetServiceHelper.checkDatasetNumber((String)dto.getNumber(), (long)this.getDMModelId(), (long)(Objects.equals("null", datasetId) ? 0L : LongUtil.toLong((Object)datasetId)));
            if (((Boolean)this.getFormCustomParam("isCopy")).booleanValue()) {
                DatasetUtil.buildManageVo((DatasetDto)dto, (Long)LongUtil.toLong((Object)datasetId));
            }
            this.initDataset(dto);
        } else {
            this.editDataset(dto);
        }
        IFormView view = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DatasetSingleNewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(view);
        this.getView().close();
    }

    private DatasetDto buildDto() {
        DatasetDto dto = this.getDto();
        dto.setNumber((String)this.getModel().getValue("number"));
        dto.setName(this.getModel().getValue("name"));
        dto.setCategoryId((Long)this.getModel().getValue("category_id"));
        return dto;
    }
}

