/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.common.dataset.DataJointDataSet;
import kd.epm.far.business.common.dataset.PreviewDataSet;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.StringLengthUtil;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.util.CollectionUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import org.apache.commons.lang.RandomStringUtils;

public class DataSetPreviewPlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage {
    protected static final String btn_ok = "btnok";
    private static final String btn_close = "btnclose";
    private static final String btn_cancel = "btncancel";
    private static final String VAR_PANEL = "varpanel";
    private static final String DIM_PANEL = "dimpanel";
    private static final String DIMF7MAP = "dimf7map";
    private static final String REAL_MODEL_ID = "realModelId";
    private static final String MODEL_TYPE = "modelType";
    private static final String DATASET_VALUE = "datasetValue";
    private static final String DATASET_VALUE_ZH = "datasetValueZh";
    private static final String DATASET_TYPE_CACHE = "datasetType";
    private static final String VARIABLE_LIST_CACHE = "variableList";
    private static final String ALL_DIM_MAP_CACHE = "allDimMap";
    protected static final String DIMENSION_NUMBER_MAP_CACHE = "dimension_number_map_cache";
    protected static final String ISCCURSIGNCACHE = "isccursigncache";
    private static final String DATASET_CHAPTERID_CACHE = "datasetChapterId";
    private static final String PROPERTY_CHANGED = "propertyChanged";
    private static final String PREVIEW_AGAIN_CACHE = "preview_again";

    private static void addStyle(TextEditElement ele) {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("10px");
        mg.setBottom("30px");
        mg.setRight("0");
        mg.setLeft("20px");
        sl.setMargin(mg);
        String name = ele.getName();
        String LabelLength = (name.length() + 1) * 12 + "px";
        ele.setLabelWidth(new LocaleString(LabelLength));
        ele.setHeight(new LocaleString("40px"));
        ele.setStyle(sl);
        ele.setWidth(new LocaleString("185px"));
        ele.setFontSize(12);
        ele.setFieldTextAlign("left");
        ele.setLabelDirection("v");
        ele.setMustInput(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_ok);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DatasetDto dto = this.getDto();
        if (Objects.nonNull(dto)) {
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
            this.getPageCache().put(MODEL_TYPE, modelType.getType());
            this.getPageCache().put(REAL_MODEL_ID, dto.getDataSrcId().toString());
            if (this.isISCType(null).booleanValue()) {
                this.getPageCache().put(DATASET_VALUE, dto.getValue());
            }
        } else if (Objects.nonNull(this.getFormCustomParam("dataset_id"))) {
            DynamicObject dataSet = DatasetDataReader.getDataSet((Long)((Long)this.getFormCustomParam("dataset_id")));
            if (Objects.equals(dataSet.getString("type"), DataSetTypeEnum.SINGLE_VALUED.getType())) {
                DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)((Long)this.getFormCustomParam("dataset_id")));
                DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)singleDS.getString("datasrctype"), (Long)singleDS.getLong("datasrcid"));
                this.getPageCache().put(MODEL_TYPE, modelType.getType());
                this.getPageCache().put(REAL_MODEL_ID, singleDS.getString("datasrcid"));
                if (this.isISCType(null).booleanValue()) {
                    DatasetDataVo datasetDataVo;
                    this.getPageCache().put(DATASET_VALUE, singleDS.getString("value"));
                    String data = singleDS.getString("data");
                    if (StringUtils.isNotEmpty((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null && datasetDataVo.getColumns() != null && datasetDataVo.getColumns().size() > 0) {
                        this.getPageCache().put(DATASET_VALUE_ZH, ((DatasetPropertyVo)datasetDataVo.getColumns().get(0)).getName());
                    }
                }
            } else {
                ModelInfo fidmModel = new ModelStrategyEx(Long.valueOf(this.getModelId())).getModel().getModelInfo();
                this.getPageCache().put(MODEL_TYPE, fidmModel.getModelType());
                this.getPageCache().put(REAL_MODEL_ID, "" + fidmModel.getModelId());
            }
        } else {
            ModelInfo fidmModel = new ModelStrategyEx(Long.valueOf(this.getModelId())).getModel().getModelInfo();
            this.getPageCache().put(MODEL_TYPE, fidmModel.getModelType());
            this.getPageCache().put(REAL_MODEL_ID, "" + fidmModel.getModelId());
        }
        if (!this.isEventDataJoint()) {
            this.initPanel();
        } else {
            this.showResultImmediately();
        }
    }

    private DatasetDto getDto() {
        Object datasetDto = this.getFormCustomParam("datasetDto");
        if (Objects.nonNull(datasetDto)) {
            return (DatasetDto)SerializationUtils.fromJsonString((String)datasetDto.toString(), DatasetDto.class);
        }
        return null;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        List<Map<String, Object>> varList = this.getVariableList();
        if (varList != null && !varList.isEmpty()) {
            for (Map<String, Object> varMap : varList) {
                this.getModel().setValue(varMap.get("number").toString(), (Object)varMap.get("defaultvalue").toString());
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        this.bcmProChange(e);
        this.getPageCache().put(PROPERTY_CHANGED, "");
    }

    public void onGetControl(OnGetControlArgs e) {
        if (this.getPage(this.getView()) != null) {
            Element element = this.getPage(this.getView()).findElementBySign(e.getKey());
            if (element == null) {
                return;
            }
            if (element != null && TextEditElement.class.isAssignableFrom(element.getClass())) {
                TextEdit edit = new TextEdit();
                edit.setKey(e.getKey());
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
            } else {
                Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
                if (f7DimMap == null || f7DimMap.isEmpty()) {
                    return;
                }
                Long dimId = (Long)f7DimMap.get(e.getKey());
                String modelType = this.getPageCache().get(MODEL_TYPE);
                if (dimId == null || modelType == null) {
                    return;
                }
                String ebDatset = "";
                DatasetDto dto = this.getDto();
                Long modelId = LongUtil.toLong((Object)this.getPageCache().get(REAL_MODEL_ID));
                ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, modelType);
                boolean isEb = DisModelTypeEnum.EB.getType().equals(modelType);
                if (Objects.nonNull(dto)) {
                    ebDatset = dto.getEbDataset();
                } else {
                    long datasetId = this.getDatasetId();
                    DynamicObject dataSet = DatasetDataReader.getDataSet((Long)datasetId);
                    if (!Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), dataSet.getString("type"))) {
                        DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)datasetId);
                        ebDatset = singleDS.getString("ebdataset");
                    } else {
                        ebDatset = isEb ? "default" : null;
                    }
                }
                DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(), (Long)dimId);
                BasedataEdit f7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, e.getKey(), null, false, ebDatset);
                e.setControl((Control)f7);
                if (element instanceof MultiBaseEditElement) {
                    DynamicObjectCollection selected = Objects.isNull(this.getModel().getValue(e.getKey())) ? new DynamicObjectCollection() : (DynamicObjectCollection)this.getModel().getValue(e.getKey());
                    MulBasedataEdit mulF7 = modelStrategyEx.getDimensionF7().openComMutilF7(this.getView(), selected, dimensionInfo, ebDatset, (BeforeF7SelectListener)this, e.getKey(), null);
                    e.setControl((Control)mulF7);
                } else if (element instanceof BaseEditElement) {
                    BasedataEdit singleMemberF7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, e.getKey(), null, false, ebDatset);
                    e.setControl((Control)singleMemberF7);
                }
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIMF7MAP));
        if (f7DimMap == null || f7DimMap.isEmpty()) {
            return;
        }
        Long dimId = (Long)f7DimMap.get(dimKey);
        String realModelId = this.getPageCache().get(REAL_MODEL_ID);
        if (dimId == null || realModelId == null) {
            return;
        }
        Long modelId = LongUtil.toLong((Object)realModelId);
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimId);
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        if (DmDimMemberEntityEnum.BCM_YEAR.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter("number", "not in", Arrays.asList("LastYear", "CurrentYear", "Year", "AllYear")));
        } else if (DmDimMemberEntityEnum.BCM_PERIOD.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter("number", "not in", Arrays.asList("LastPeriod", "CurrentPeriod")));
        }
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (btn_ok.equals(key)) {
            this.btnOkDoOperation();
        }
    }

    protected void btnOkDoOperation() {
        DatasetDto dto = this.getDto();
        if (!Objects.nonNull(dto)) {
            DatasetExpressionHelper.checkExpression((Long)this.getModelId(), (Long)this.getDatasetId());
        }
        try {
            this.showDatasetResults();
            this.getPageCache().put(PREVIEW_AGAIN_CACHE, "");
        }
        finally {
            this.getPageCache().remove(PROPERTY_CHANGED);
        }
        if (this.getPageCache().get(DIMENSION_NUMBER_MAP_CACHE) == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{btn_ok});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{btn_cancel});
        }
    }

    private void buildDimParams(DatasetDto dto, Map<String, Set<String>> params) {
        String[] split;
        String expression = dto.getExpression();
        if (StringUtils.isBlank((CharSequence)expression)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : split = expression.split(",")) {
            String[] dimAndMember = s.split("\\.");
            Set<String> value = params.get(dimAndMember[0].toUpperCase(Locale.ENGLISH));
            if (CollectionUtil.isEmpty(value)) {
                sb.append(s).append(",");
                continue;
            }
            String members = Joiner.on((String)";").join(value);
            sb.append(dimAndMember[0]).append(".{").append(members).append("}").append(",");
        }
        dto.setExpression(sb.substring(0, sb.length() - 1));
        dto.setTempExpression(dto.getExpression());
    }

    private void showDatasetResults() {
        Object result = null;
        DatasetDto dto = this.getDto();
        try {
            if (this.isEventDataJoint()) {
                result = new DataJointDataSet(Long.valueOf(this.getDatasetId()), this.getEventDataJointParam()).getResult();
            } else if (Objects.nonNull(dto)) {
                this.buildDimParams(dto, this.getDefaultMemberParams());
                result = DatasetUtil.getResult((DatasetDto)dto);
            } else {
                result = new PreviewDataSet(Long.valueOf(this.getDatasetId()), this.getDefaultMemberParams(), true).getResult();
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        if (result == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u7ed3\u679c\u3002", (String)"DataSetPreviewPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        if (result instanceof RuntimeException) {
            throw new KDBizException(((RuntimeException)result).getMessage());
        }
        if (result instanceof Exception) {
            throw new KDBizException(((Exception)result).getMessage());
        }
        try {
            this.showTableView(result);
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataSetPreviewPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
    }

    protected void showTableView(Object result) {
        String type;
        FormShowParameter fsp = new FormShowParameter();
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("previewtable");
        String formId = "fidm_preview_multi_line";
        fsp.setFormId(formId);
        fsp.setPageId(this.getPageIdAndCache(this.getPageCache(), formId));
        fsp.setFormId("fidm_preview_multi_line");
        fsp.setParentPageId(this.getView().getPageId());
        fsp.setCustomParam("dmmodelid", (Object)("" + this.getModelId()));
        DatasetDto dto = this.getDto();
        if (Objects.isNull(dto)) {
            type = this.getDatasetType();
            fsp.setCustomParam("type", (Object)type);
            fsp.setCustomParam("datasetId", (Object)this.getDatasetId());
        } else {
            type = dto.getType();
            fsp.setCustomParam("datasetDto", (Object)this.toByteSerialized(dto));
        }
        if (result instanceof Exception || Objects.isNull(result)) {
            return;
        }
        if ("1".equals(type)) {
            ArrayList dataList = new ArrayList(1);
            HashMap<String, String> ele = new HashMap<String, String>(2);
            if (ObjectUtil.equals((Object)DisModelTypeEnum.METADATA.getType(), (Object)this.getPageCache().get(MODEL_TYPE))) {
                ele.put(this.getPageCache().get(DATASET_VALUE), result.toString());
                fsp.setCustomParam(DATASET_VALUE_ZH, (Object)this.getPageCache().get(DATASET_VALUE_ZH));
                fsp.setCustomParam(DATASET_VALUE, (Object)this.getPageCache().get(DATASET_VALUE));
                fsp.setCustomParam(MODEL_TYPE, (Object)this.getPageCache().get(MODEL_TYPE));
            } else {
                ele.put("FMONEY", result.toString());
            }
            dataList.add(ele);
            fsp.setCustomParam("result", (Object)this.toByteSerialized(dataList));
        } else if ("2".equals(type)) {
            fsp.setCustomParam("result", (Object)this.toByteSerialized(result));
        } else if ("3".equals(type)) {
            if (!(result instanceof Map)) {
                return;
            }
            Map resultMap = (Map)result;
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(4);
            dataList.add(this.sortByOriginalOrder(resultMap));
            fsp.setCustomParam("result", (Object)this.toByteSerialized(dataList));
        }
        this.getView().showForm(fsp);
    }

    protected Map<String, Set<String>> getDefaultMemberParams() {
        HashMap<String, Set<String>> contextParams = new HashMap<String, Set<String>>(16);
        String iscCache = this.getPageCache().get(ISCCURSIGNCACHE);
        if (Objects.nonNull(iscCache)) {
            List curs = (List)SerializationUtils.fromJsonString((String)iscCache, List.class);
            HashSet set = Sets.newHashSetWithExpectedSize((int)1);
            for (String cur : curs) {
                String curValue = (String)this.getModel().getValue(cur);
                if (kd.bos.util.StringUtils.isNotEmpty((String)curValue)) {
                    set.add(curValue);
                    contextParams.put(cur, set);
                    continue;
                }
                contextParams.put(cur, new HashSet());
            }
        } else {
            String s = this.getPageCache().get(DIMENSION_NUMBER_MAP_CACHE);
            if (s == null) {
                return contextParams;
            }
            Map dimensionNumberMap = (Map)this.deSerializedBytes(s);
            if (dimensionNumberMap == null || dimensionNumberMap.isEmpty()) {
                return contextParams;
            }
            for (Map.Entry dimensionNumberEntry : dimensionNumberMap.entrySet()) {
                String dimNumber = (String)dimensionNumberEntry.getKey();
                String displayName = (String)dimensionNumberEntry.getValue();
                Object dyn = this.getModel().getValue(dimNumber);
                if (dyn == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d8\u91cf\u201c%s\u201d\u7684\u503c\u3002", (String)"DataSetPreviewPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]), displayName));
                }
                if (dyn instanceof DynamicObject) {
                    String memberValue = ((DynamicObject)dyn).getString("number");
                    contextParams.put(displayName, Sets.newHashSet((Object[])new String[]{memberValue}));
                    continue;
                }
                if (!(dyn instanceof DynamicObjectCollection)) continue;
                if (((DynamicObjectCollection)dyn).size() == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u53d8\u91cf\u201c%s\u201d\u7684\u503c\u3002", (String)"DataSetPreviewPlugin_13", (String)"epm-far-formplugin", (Object[])new Object[0]), displayName));
                }
                HashSet curs = Sets.newHashSetWithExpectedSize((int)((DynamicObjectCollection)dyn).size());
                for (DynamicObject dy : (DynamicObjectCollection)dyn) {
                    DynamicObject memberInfo = dy.getDynamicObject("fbasedataid");
                    String memberValue = memberInfo.getString("number");
                    curs.add(memberValue);
                }
                contextParams.put(displayName, curs);
            }
        }
        return contextParams;
    }

    private void initPanel() {
        JSONArray columns = new JSONArray();
        Boolean isISC = this.isISCType(columns);
        Area varPanel = new Area(VAR_PANEL);
        Area dimPanel = new Area(DIM_PANEL);
        DatasetDto dto = this.getDto();
        DatasetVarAndDim result = this.getVarAndDim(dto, isISC);
        List variableList = result.getVariableList();
        List curShortNumberList = result.getCurShortNumberList();
        List cursShortNumberList = result.getCursShortNumberList();
        if (isISC.booleanValue()) {
            this.initISCPanel(columns, variableList, curShortNumberList, cursShortNumberList, dimPanel, varPanel);
        } else {
            this.buildVarPanel(varPanel, variableList);
            this.buildDimPanel(dimPanel, curShortNumberList, true);
            this.buildDimPanel(dimPanel, cursShortNumberList, false);
            this.updataDynView(variableList, varPanel, dimPanel);
        }
    }

    private Boolean isISCType(JSONArray columns) {
        Boolean isISC = Boolean.FALSE;
        if (Objects.nonNull(this.getFormCustomParam("dataset_id"))) {
            String type;
            DynamicObject dataset = DatasetDataReader.getDataSet((Long)this.getDatasetId(), (boolean)false);
            if (Objects.nonNull(dataset) && ("1".equals(type = dataset.getString("type")) || "2".equals(type))) {
                DynamicObject datasetSingle = DatasetDataReader.getSingleDS((Long)this.getDatasetId(), (boolean)false);
                String dataSetSrcType = datasetSingle.getString("datasrctype");
                if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSetSrcType) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dataSetSrcType)) {
                    String data = datasetSingle.getString("data");
                    JSONObject jsonObject = JSON.parseObject((String)data);
                    columns = jsonObject.getJSONArray("columns");
                    isISC = Boolean.TRUE;
                }
            }
        } else {
            DatasetDto dto = this.getDto();
            if (Objects.nonNull(dto) && (DataSrcTypeEnum.ISC_METADATA.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dto.getDataSrcType()))) {
                JSONObject jsonObject = JSON.parseObject((String)dto.getData());
                columns = jsonObject.getJSONArray("columns");
                isISC = Boolean.TRUE;
            }
        }
        return isISC;
    }

    private DatasetVarAndDim getVarAndDim(DatasetDto dto, Boolean isISC) {
        DatasetVarAndDim result = Objects.nonNull(dto) ? DatasetServiceHelper.getDimVars((DatasetDto)dto) : (isISC != false ? DatasetServiceHelper.getVarAndDimVar((long)this.getModelId(), (long)this.getDatasetId(), (long)this.getChapterId(), (boolean)true, (boolean)true) : DatasetServiceHelper.getVarAndDimVar((long)this.getModelId(), (long)this.getDatasetId(), (long)this.getChapterId(), (boolean)true));
        return result;
    }

    private void initISCPanel(JSONArray columns, List<Map<String, Object>> variableList, List<String> curShortNumberList, List<String> cursShortNumberList, Area dimPanel, Area varPanel) {
        if (columns.size() > 0) {
            columns.forEach(column -> {
                String number = ((JSONObject)column).getString("number");
                String name = ((JSONObject)column).getString("name");
                if (curShortNumberList.contains(number)) {
                    TextEditElement textEditElement = this.createISCTextEditElement(name, number);
                    dimPanel.addElement((Element)textEditElement);
                }
            });
        }
        if (variableList.size() > 0 || curShortNumberList.size() > 0 || cursShortNumberList.size() > 0) {
            if (curShortNumberList.size() > 0) {
                this.getPageCache().put(ISCCURSIGNCACHE, SerializationUtils.toJsonString(curShortNumberList));
            }
            this.updataDynView(variableList, varPanel, dimPanel);
        } else {
            this.getPageCache().remove(ISCCURSIGNCACHE);
        }
    }

    private void updataDynView(List<Map<String, Object>> variableList, Area varPanel, Area dimPanel) {
        if (variableList.size() > 0) {
            this.getPageCache().put(VARIABLE_LIST_CACHE, this.toByteSerialized(variableList));
        }
        if (this.isShowPanel()) {
            if (Objects.nonNull(varPanel) || Objects.nonNull(dimPanel)) {
                Page page = new Page();
                if (varPanel != null) {
                    page.addArea(varPanel);
                }
                if (dimPanel != null) {
                    page.addArea(dimPanel);
                }
                this.setPage(this.getView(), page);
                page.updatePage(this.getView());
                this.getView().setVisible(Boolean.valueOf(true), new String[]{btn_ok, btn_cancel});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{btn_close});
            }
        } else {
            this.showResultImmediately();
        }
    }

    private void buildVarPanel(Area varPanel, List<Map<String, Object>> variableList) {
        if (variableList == null || variableList.isEmpty()) {
            return;
        }
        for (Map<String, Object> dataMap : variableList) {
            TextEditElement textEditElement = this.createTextEditElement(dataMap.get("name").toString(), dataMap.get("number").toString());
            varPanel.addElement((Element)textEditElement);
        }
    }

    private void buildDimPanel(Area dimPanel, List<String> shortNumberList, boolean isCur) {
        if (shortNumberList == null || shortNumberList.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> allDimMap = this.getDimMap();
        if (allDimMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataSetPreviewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        int size = 0;
        for (String shortNumber : shortNumberList) {
            Element element = ElementHelper.addBaseEditElement((Area)dimPanel, (String)shortNumber, (boolean)isCur, allDimMap, (IPageCache)this.getPageCache(), (String)DIMENSION_NUMBER_MAP_CACHE);
            if (element == null) continue;
            ElementHelper.buildF7StyleWithInput((Element)element, (boolean)false);
            ++size;
        }
    }

    private TextEditElement createTextEditElement(String name, String sign) {
        name = StringLengthUtil.cropNameString((String)name, (int)20);
        TextEditElement ele = new TextEditElement(name, sign, "");
        DataSetPreviewPlugin.addStyle(ele);
        ele.setEditStyle(1);
        ele.setLock("new,edit,view");
        return ele;
    }

    private TextEditElement createISCTextEditElement(String name, String sign) {
        name = StringLengthUtil.cropNameString((String)name, (int)20);
        TextEditElement ele = new TextEditElement(name, sign, "");
        DataSetPreviewPlugin.addStyle(ele);
        ele.setEditStyle(0);
        return ele;
    }

    @Override
    public long getModelId() {
        String modelId = this.getPageCache().get("dmmodelid");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            modelId = (String)this.getFormCustomParam("dmmodelid");
        }
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return Long.parseLong(modelId);
    }

    private long getDatasetId() {
        Long datasetId = (Long)this.getFormCustomParam("dataset_id");
        if (datasetId == null || datasetId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataSetPreviewPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return datasetId;
    }

    private String getDatasetType() {
        String type = this.getPageCache().get(DATASET_TYPE_CACHE);
        if (type != null) {
            return type;
        }
        DynamicObject dataset = this.getDataset();
        type = dataset.getString("type");
        this.getPageCache().put(DATASET_TYPE_CACHE, type);
        return type;
    }

    private long getChapterId() {
        String chapterId = this.getPageCache().get(DATASET_CHAPTERID_CACHE);
        if (chapterId != null) {
            return Long.parseLong(chapterId);
        }
        DynamicObject dataset = this.getDataset();
        chapterId = dataset.getString("chapterid");
        this.getPageCache().put(DATASET_CHAPTERID_CACHE, chapterId);
        return Long.parseLong(chapterId);
    }

    private DynamicObject getDataset() {
        long datasetId = this.getDatasetId();
        DynamicObject dataset = DatasetDataReader.getDataSet((Long)datasetId);
        if (dataset == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u6570\u636e\u96c6\u201c%s\u201d\u3002", (String)"DataSetPreviewPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetId));
        }
        this.getPageCache().put(DATASET_TYPE_CACHE, dataset.getString("type"));
        this.getPageCache().put(DATASET_CHAPTERID_CACHE, "" + dataset.getLong("chapterid"));
        return dataset;
    }

    private List<Map<String, Object>> getVariableList() {
        if (this.isEventDataJoint() || Objects.nonNull(this.getDto())) {
            return null;
        }
        String s = this.getPageCache().get(VARIABLE_LIST_CACHE);
        if (s != null) {
            return (List)this.deSerializedBytes(s);
        }
        List variableList = DatasetServiceHelper.getDatasetVariableList((Long)this.getDatasetId());
        if (variableList == null || variableList.isEmpty()) {
            return null;
        }
        this.getPageCache().put(VARIABLE_LIST_CACHE, this.toByteSerialized(variableList));
        return variableList;
    }

    private Map<String, Map<String, String>> getDimMap() {
        String s = this.getPageCache().get(ALL_DIM_MAP_CACHE);
        if (s != null) {
            return (Map)this.deSerializedBytes(s);
        }
        String modelType = this.getPageCache().get(MODEL_TYPE);
        Long modelId = LongUtil.toLong((Object)this.getPageCache().get(REAL_MODEL_ID));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, modelType);
        String dimEntity = modelStrategyEx.getDim().getDimEntity();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)dimEntity, (String)"id,shortnumber,number,name,membermodel,issysdimension", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), (String)"dseq");
        HashMap<String, Map<String, String>> allDimMap = new HashMap<String, Map<String, String>>(32);
        HashMap<String, Long> dimF7Map = new HashMap<String, Long>(32);
        for (DynamicObject dyn : dyns) {
            String dimensionId = dyn.getString("id");
            String shortNumber = dyn.getString("shortnumber").toUpperCase(Locale.ENGLISH);
            String dimNumber = dyn.getString("number").toLowerCase(Locale.ENGLISH);
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put("id", dimensionId);
            dimMap.put("name", dyn.getString("name"));
            dimMap.put("shortnumber", shortNumber);
            dimMap.put("number", dimNumber);
            dimMap.put("membermodel", DmDimMemberEntityEnum.getNewEntityNum((String)dyn.getString("membermodel")));
            allDimMap.put(shortNumber, dimMap);
            dimF7Map.put(dimNumber, Long.parseLong(dimensionId));
        }
        this.getPageCache().put(DIMF7MAP, this.toByteSerialized(dimF7Map));
        return allDimMap;
    }

    private Map<String, Object> sortByOriginalOrder(Map<String, Object> map) {
        if (map == null || map instanceof LinkedHashMap) {
            return map;
        }
        if (!"3".equals(this.getDatasetType())) {
            return map;
        }
        QFilter qFilter = new QFilter("dataset", "=", (Object)this.getDatasetId());
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"fidm_dataset_multivalue", (String)"number", (QFilter[])qFilter.toArray(), (String)"desq");
        if (dyns == null || dyns.isEmpty()) {
            return map;
        }
        List originalOrderNumberList = dyns.stream().map(e -> e.getString("number")).collect(Collectors.toList());
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        for (String number : originalOrderNumberList) {
            if (!map.containsKey(number)) continue;
            linkedHashMap.put(number, map.get(number));
        }
        return linkedHashMap;
    }

    private String getPageIdAndCache(IPageCache pageCache, String formId) {
        String pageId = formId + RandomStringUtils.randomAlphanumeric((int)10);
        String cache = pageCache.get("pagePool");
        Map<String, String> map = new HashMap<String, String>();
        if (cache != null) {
            map = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        map.put(pageId, formId);
        pageCache.put("pagePool", SerializationUtils.toJsonString(map));
        return pageId;
    }

    private boolean isShowPanel() {
        String dimension = this.getPageCache().get(DIMENSION_NUMBER_MAP_CACHE);
        String variable = this.getPageCache().get(VARIABLE_LIST_CACHE);
        String iscCurCache = this.getPageCache().get(ISCCURSIGNCACHE);
        return dimension != null || variable != null || iscCurCache != null;
    }

    private boolean isEventDataJoint() {
        return Objects.nonNull(this.getFormCustomParam("EVENT_DATA_JOINT_SEARCH"));
    }

    private JSONObject getEventDataJointParam() {
        return (JSONObject)this.getFormCustomParam("EVENT_DATA_JOINT_SEARCH");
    }

    private void showResultImmediately() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"contentpanel", "contentpanel1"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{btn_ok});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{btn_cancel});
        this.showDatasetResults();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isEventDataJoint()) {
            this.returnDataToParent("Refresh all table for auto scroll");
        }
    }
}

