/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class DataSetSelectPlugin
extends AbstractBaseDMFormPlugin {
    private static final String btn_ok = "btnok";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(btn_ok);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().close();
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (btn_ok.equals(key)) {
            this.openPageAddChapterDataSet();
        }
    }

    public void openPageAddChapterDataSet() {
        String modelId = (String)this.getFormCustomParam("DISC_MODEL_ID");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetSingleNewPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String type = this.getStringValue("type");
        if (StringUtils.isEmpty((CharSequence)type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6570\u636e\u96c6\u7c7b\u578b\u201d\u3002", (String)"DataSetSelectPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String sourceFrom = (String)this.getFormCustomParam("sourcefrom");
        if ("datasetlist".equals(sourceFrom)) {
            this.getView().returnDataToParent((Object)type);
            this.getView().close();
        } else {
            Object chapterObj = this.getFormCustomParam("chapterid");
            if (chapterObj == null || "0".equalsIgnoreCase(chapterObj.toString())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6570\u636e\u96c6ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataSetSelectPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            Long chapterId = (Long)this.getFormCustomParam("chapterid");
            boolean isFar = (Boolean)this.getFormCustomParam("isFar");
            if (isFar && !Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), type)) {
                this.showPopDataSetShowForm(modelId, type, chapterId);
            } else {
                this.showGuideDataSetShowForm(type, modelId, chapterId);
            }
        }
    }

    private void showPopDataSetShowForm(String modelId, String type, Long chapterId) {
        ModelStrategyEx strategyEx = new ModelStrategyEx(LongUtil.toLong((Object)modelId));
        DatasetDto dto = new DatasetDto();
        dto.setType(type);
        dto.setChapterId(chapterId);
        String modelType = strategyEx.getModel().getModelInfo().getModelType();
        dto.setDataSrcType(DataSrcTypeEnum.getEnumByDisType((String)modelType).getType());
        dto.setDataSrcId(LongUtil.toLong((Object)modelId));
        dto.setDiscmodelId(LongUtil.toLong((Object)modelId));
        FormShowParameter popFormShow = DatasetUtil.getPopFormShow((DatasetDto)dto, (boolean)Boolean.TRUE);
        popFormShow.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ""));
        this.getView().showForm(popFormShow);
    }

    private void showGuideDataSetShowForm(String type, String modelId, Long chapterId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ""));
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if ("1".equals(type) || "2".equals(type)) {
            fsp.setFormId("fidm_dataset_single_edit");
        } else if ("3".equals(type)) {
            fsp.setFormId("fidm_dataset_multivalue_n");
        }
        fsp.setCustomParam("KEY_MODEL_ID", (Object)("" + modelId));
        fsp.setCustomParam("type", (Object)type);
        fsp.setCustomParam("scope", (Object)"2");
        fsp.setCustomParam("chapterid", (Object)chapterId);
        fsp.setCustomParam("dmmodelid", (Object)modelId);
        this.getView().showForm(fsp);
    }

    private String getStringValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            return "";
        }
        return value.toString().trim();
    }
}

