/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.control.Control;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.VariableTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.faranalysis.uitls.AnalysisVariableHelper;

public class DataSetSelectVariablePlugin
extends AbstractBaseDMFormPlugin {
    private static final String BILLLISTAP = "billlistap";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addPackageDataListener(evt -> this.packData((PackageDataEvent)evt));
    }

    private void packData(PackageDataEvent e) {
        if (ColumnDesc.class.isAssignableFrom(e.getSource().getClass())) {
            Long defaultValue;
            String dimmemberType;
            String finalDefaultValue;
            String key = ((ColumnDesc)e.getSource()).getKey();
            DynamicObject rowData = e.getRowData();
            String valueType = rowData.getString("valuetype");
            if ("defaultvalue".equals(key) && DmVariableTypeEnum.DIM.getIndex().equals(valueType) && StringUtils.isNotEmpty((String)(finalDefaultValue = this.getDIMDefaultValue(dimmemberType = rowData.getString("dimmembertype"), defaultValue = Long.valueOf(rowData.getLong("defaultvalue")))))) {
                e.setFormatValue((Object)finalDefaultValue);
            }
            if ("defaultvalue".equals(key) && DmVariableTypeEnum.NUM.getIndex().equals(valueType) && rowData.getBigDecimal("defaultvalue") != null) {
                e.setFormatValue((Object)rowData.getBigDecimal("defaultvalue").stripTrailingZeros().toPlainString());
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addPackageDataListener(evt -> this.packData((PackageDataEvent)evt));
        FilterParameter fp = new FilterParameter();
        fp.setFilter(this.setBillListFilter());
        billList.setFilterParameter(fp);
        billList.clearSelection();
        billList.refresh();
    }

    private QFilter setBillListFilter() {
        Long dmmodelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodel");
        QFilter filter = new QFilter("model", "=", (Object)dmmodelId);
        filter.and("scope", "=", (Object)"1");
        return filter;
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            String defaultvalue;
            Object defaultValue;
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
            Object[] variableIds = listSelectedRowCollection.getPrimaryKeyValues();
            DynamicObjectCollection dynamicObjectCollection = AnalysisVariableHelper.getVariableDynamicObjectCollection(Arrays.asList(variableIds));
            ArrayList dimObjectList = Lists.newArrayListWithExpectedSize((int)6);
            ArrayList defaultValueList = Lists.newArrayListWithExpectedSize((int)6);
            ArrayList textObjectList = Lists.newArrayListWithExpectedSize((int)6);
            HashSet dimSet = Sets.newHashSetWithExpectedSize((int)8);
            Long dmmodelId = (Long)this.getView().getFormShowParameter().getCustomParam("dmmodel");
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmmodelId);
            List dimensionInfos = modelStrategyEx.getDim().getDimList();
            boolean existOtherVar = false;
            boolean existRepeatDim = false;
            String repeatDim = "";
            block0: for (DynamicObject variableObject : dynamicObjectCollection) {
                String[] parts;
                int valueType = variableObject.getInt("valuetype");
                if (VariableTypeEnum.DATE.getCode() == valueType || VariableTypeEnum.NUMBER.getCode() == valueType || VariableTypeEnum.ENUM.getCode() == valueType) {
                    existOtherVar = true;
                    continue;
                }
                if (VariableTypeEnum.DIM.getCode() == valueType) {
                    DimensionInfo dim = DimensionUtils.getDimById((List)dimensionInfos, (Long)LongUtil.toLong((Object)variableObject.get("disc_dim")));
                    if (!dimSet.add(dim.getShortNumber())) {
                        existRepeatDim = true;
                        repeatDim = dim.getShortNumber();
                        break;
                    }
                    dimObjectList.add(variableObject);
                    continue;
                }
                if (VariableTypeEnum.TEXT.getCode() != valueType) continue;
                defaultValue = variableObject.getString("defaultvalue");
                for (String part : parts = ((String)defaultValue).split(",")) {
                    String dimNum = part.split("\\.")[0];
                    if (dimSet.add(dimNum)) continue;
                    existRepeatDim = true;
                    repeatDim = dimNum;
                    break block0;
                }
                defaultValueList.add(defaultValue);
                textObjectList.add(variableObject);
            }
            if (existOtherVar) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u91cf\u4e2d\u5b58\u5728\u65e5\u671f\u3001\u6570\u5b57\u3001\u679a\u4e3e\u7c7b\u578b\uff0c\u8bf7\u9009\u62e9\u7ef4\u5ea6\u3001\u6587\u672c\u7c7b\u578b\u53d8\u91cf\u3002", (String)"DataSetSelectVariablePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            if (existRepeatDim) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d8\u91cf\u4e2d\u5b58\u5728\u91cd\u590d\u7ef4\u5ea6\u3002", (String)"DataSetSelectVariablePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean hasDimMember = true;
            boolean shortConflict = true;
            HashSet dimShortNumSet = Sets.newHashSetWithExpectedSize((int)16);
            defaultValue = defaultValueList.iterator();
            while (defaultValue.hasNext() && (hasDimMember = this.splitDimAndMemb(defaultvalue = (String)defaultValue.next(), "."))) {
                boolean hasComma = this.splitDimAndMemb(defaultvalue, ",");
                if (hasComma) {
                    String[] splitStirngArray;
                    for (String dimInfo : splitStirngArray = defaultvalue.split(",")) {
                        int first = (dimInfo = dimInfo.trim()).indexOf(".");
                        if (first == -1) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u53d8\u91cf\u6709\u8bef\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSetSelectVariablePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        String dimShortNum = dimInfo.substring(0, first);
                        shortConflict = dimShortNumSet.add(dimShortNum);
                    }
                    continue;
                }
                int first = (defaultvalue = defaultvalue.trim()).indexOf(".");
                if (first == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u53d8\u91cf\u6709\u8bef\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSetSelectVariablePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                String dimShortNum = defaultvalue.substring(0, first);
                shortConflict = dimShortNumSet.add(dimShortNum);
            }
            if (!shortConflict) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d8\u91cf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u7ef4\u5ea6\u3002", (String)"DataSetSelectVariablePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!hasDimMember) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u672c\u53d8\u91cf\u4e0d\u5305\u542b\u7ef4\u5ea6\u6210\u5458\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u7ef4\u5ea6\u3002", (String)"DataSetSelectVariablePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)2);
            returnMap.put("dim", dimObjectList);
            returnMap.put("text", textObjectList);
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        }
    }

    public boolean splitDimAndMemb(String param, String septer) {
        int first = (param = param.trim()).indexOf(septer);
        return first > 0;
    }

    private String getDIMDefaultValue(String dimmemberType, Long defaultValue) {
        DynamicObject dynamicObject;
        String entityNum = DmDimMemberEntityEnum.getOldEntityNum((String)dimmemberType);
        if (StringUtils.isEmpty((String)entityNum)) {
            entityNum = dimmemberType;
        }
        if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)entityNum, (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)defaultValue).toArray())) != null) {
            String name = dynamicObject.getLocaleString("name").getLocaleValue();
            if (name == null || StringUtils.isEmpty((String)name.trim())) {
                name = dynamicObject.getString("name");
            }
            return name;
        }
        return StringUtils.getEmpty();
    }
}

