/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractCategoryPlugin;

public class DatasetCategoryEditPlugin
extends AbstractCategoryPlugin {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DatasetCategoryEditPlugin.class);
    private static final String DMMODEL = "dmmodel";
    private static final String FIDMMODEL = "fidmmodel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(DMMODEL);
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)((BasedataEdit)this.getControl("permclass")), (Object)LongUtil.toLong((Object)modelId), (String)(ApplicationTypeEnum.CM == this.getAppType() ? "model" : FIDMMODEL), (String)this.getView().getFormShowParameter().getAppId());
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "parent"});
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Map listParam = this.getView().getFormShowParameter().getCustomParams();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus) && Objects.nonNull(listParam) && listParam.size() > 0) {
            Object parentId = listParam.get("parentid");
            this.getModel().setValue("parent", parentId);
            this.getView().setEnable(Boolean.FALSE, new String[]{"parent"});
            Object dmModel = listParam.get(DMMODEL);
            if (Objects.nonNull(dmModel)) {
                this.getModel().setValue("model", dmModel);
            }
            int seq = this.getCurNodeSequence((Long)dmModel, (Long)parentId);
            this.getModel().setValue("sequence", (Object)seq);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Object number = this.getModel().getValue("number");
            String operate = (String)this.getView().getFormShowParameter().getCustomParam("operate");
            if ("add".equals(operate)) {
                Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(DMMODEL);
                boolean existNumber = QueryServiceHelper.exists((String)"far_datasetcategory", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)((String)number)).and("model", "=", (Object)modelId)});
                if (existNumber) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"MyAnalysisListPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            if (!this.isValidNumber((String)number)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u3001\u534a\u89d2\u4e0b\u5212\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"MyAnalysisListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean isValidNumber(String number) {
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9._]+$").matcher(number);
        return matcherNumber.matches() && !number.contains("..") && !number.startsWith(".") && !number.startsWith("-");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save) {
            AnalysisOpLogParam logParam = this.getSingleLogParam();
            String operate = (String)this.getView().getFormShowParameter().getCustomParam("operate");
            if ("add".equals(operate)) {
                logParam.buildOpName(OperationName.ADD_DATASET_CATALOG);
            } else if ("modify".equals(operate)) {
                logParam.buildOpName(OperationName.MODIFY_DATASET_CATALOG);
            }
            if (isSuccess) {
                String appId = this.getView().getFormShowParameter().getAppId();
                Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(DMMODEL);
                PermClassEntityHelper.saveDiscPermClass((IDataModel)this.getModel(), (String)"far_datasetcategory", (Long)LongUtil.toLong(ids.get(0)), (Object)modelId, (OperationStatus)status, (String)FIDMMODEL, (String)appId);
                logParam.buildOpResult(OperationResult.SUCCESS);
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
                this.getView().returnDataToParent((Object)ids);
                this.getView().close();
            } else {
                logParam.buildOpResult(OperationResult.FAILURE);
                AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
            }
        }
    }

    private int getCurNodeSequence(Long modelId, Long parentId) {
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter parent = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{model, parent};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"far_datasetcategory", (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString("sequence");
            return (strSeq.isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    private AnalysisOpLogParam getSingleLogParam() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        String numberField = "number";
        String categoryNumber = (String)this.getModel().getValue("number");
        String modelNumber = model.getString(numberField);
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATASETCATEGORY).buildFormNumber("far_datasetcategory").buildAppId(this.getView()).buildFormatParams(new Object[]{modelNumber, categoryNumber});
    }

    public ApplicationTypeEnum getAppType() {
        String bizAppId = this.getView().getFormShowParameter().getAppId();
        return StringUtils.isEmpty((CharSequence)bizAppId) ? ApplicationTypeEnum.FAR : ApplicationTypeEnum.getEnumByNumber((String)bizAppId);
    }
}

