/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.epm.far.common.common.Pair;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DatasetConditionPlugin
extends AbstractBaseDMFormPlugin {
    private static final String CONDITION_FIELD = "conditionfield";
    private static final String COMBO_FIELD = "combofield";
    private static final String TEXT_FIELD = "textfield";
    private static final String BTN_OK = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        EntryGrid entryEntity = (EntryGrid)this.getControl("entryentity");
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dataEntity : entryEntity.getEntryData().getDataEntitys()) {
            String condition = dataEntity.getString(COMBO_FIELD);
            String value = dataEntity.getString(TEXT_FIELD);
            if (StringUtils.isBlank((CharSequence)condition) || StringUtils.isBlank((CharSequence)value)) continue;
            if (Objects.equals(condition, "like")) {
                sb.append("%").append(value).append(",");
                continue;
            }
            if (Objects.equals(condition, "in")) {
                sb.append(value).append(",");
                continue;
            }
            sb.append(condition).append(value).append(",");
        }
        String returStr = "";
        if (sb.length() > 0) {
            returStr = sb.substring(0, sb.length() - 1);
        }
        this.getView().setReturnData((Object)returStr);
        this.getView().returnDataToParent((Object)returStr);
        this.getView().close();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String name = (String)this.getFormCustomParam("name");
        this.getModel().setValue("name", (Object)name);
        String condition = (String)this.getFormCustomParam(CONDITION_FIELD);
        List<Pair<String, String>> listFromCondition = this.getListFromCondition(condition);
        this.createEntryEntity(listFromCondition);
    }

    private void createEntryEntity(List<Pair<String, String>> listFromCondition) {
        if (CollectionUtils.isEmpty(listFromCondition)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", listFromCondition.size());
        for (int i = 0; i < listFromCondition.size(); ++i) {
            Pair<String, String> pair = listFromCondition.get(i);
            this.getModel().setValue(COMBO_FIELD, pair.p1, i);
            this.getModel().setValue(TEXT_FIELD, pair.p2, i);
        }
    }

    private List<Pair<String, String>> getListFromCondition(String condition) {
        if (StringUtils.isBlank((CharSequence)condition)) {
            return Collections.emptyList();
        }
        String[] split = condition.split(",");
        StringBuilder sb = new StringBuilder();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        for (String s : split) {
            String value;
            if (s.startsWith("=")) {
                value = this.getValueWithOutCondition(s, "=");
                list.add(new Pair((Object)"=", (Object)value));
                continue;
            }
            if (s.startsWith(">=")) {
                value = this.getValueWithOutCondition(s, ">=");
                list.add(new Pair((Object)">=", (Object)value));
                continue;
            }
            if (s.startsWith("<=")) {
                value = this.getValueWithOutCondition(s, "<=");
                list.add(new Pair((Object)"<=", (Object)value));
                continue;
            }
            if (s.startsWith(">")) {
                value = this.getValueWithOutCondition(s, ">");
                list.add(new Pair((Object)">", (Object)value));
                continue;
            }
            if (s.startsWith("<")) {
                value = this.getValueWithOutCondition(s, "<");
                list.add(new Pair((Object)"<", (Object)value));
                continue;
            }
            if (s.startsWith("%")) {
                value = this.getValueWithOutCondition(s, "%");
                list.add(new Pair((Object)"like", (Object)value));
                continue;
            }
            sb.append(s).append(",");
        }
        if (sb.length() > 0) {
            list.add(new Pair((Object)"in", (Object)sb.substring(0, sb.length() - 1)));
        }
        return list;
    }

    private String getValueWithOutCondition(String s, String qcp) {
        if (s.length() <= qcp.length()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"'%s'\u6761\u4ef6\u8bf7\u8bbe\u7f6e\u5177\u4f53\u503c\u3002", (String)"DatasetConditionPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), s));
        }
        return s.substring(qcp.length());
    }
}

