/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.filter.dto.DatasetFilterItem;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSHelper;
import kd.epm.far.business.common.expression.dto.calc.DataSetCaclColumn;
import kd.epm.far.business.common.expression.dto.calc.DatasetCalcInfo;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.util.ResultInfoEx;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseFormPlugin;

public class DatasetFilterEntryPlugin
extends AbstractBaseDMFormPlugin
implements CellClickListener {
    protected static final String PARAM_DATASETID = "datasetId";
    protected static final String PARAM_FILTER = "filter";
    protected static final String KEY_DATASETCALCINFO = "key_datasetcalcinfo";
    protected static final String CTL_DATASET_FILTER_ENTRY = "entryentity";
    protected static final String CLOSEDCALLBACK_FILTER_VALUE = "singleMemberF7";
    protected static final String FIDM_MSG_CLOSE = "fidm_msg_close";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(CTL_DATASET_FILTER_ENTRY, "value", "btnok");
        EntryGrid entryGrid = (EntryGrid)this.getControl(CTL_DATASET_FILTER_ENTRY);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean success = this.initDatasetModel();
        if (!success) {
            return;
        }
        this.setComboItems();
        this.refreshDatasetFilter();
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
    }

    public Long getDmModelId() {
        Long modelId = (Long)this.getFormCustomParam("KEY_MODEL_ID");
        return modelId;
    }

    private Long getDatasetId() {
        Long datasetId = (Long)this.getFormCustomParam(PARAM_DATASETID);
        return datasetId;
    }

    private List<DatasetFilterItem> getDatasetFilter() {
        String serial = (String)this.getFormCustomParam(PARAM_FILTER);
        List datasetFilter = null;
        if (StringUtils.isNotEmpty((String)serial)) {
            datasetFilter = (List)JacksonUtils.fromJson((String)serial, (TypeReference)new TypeReference<List<DatasetFilterItem>>(){});
        }
        return datasetFilter;
    }

    private boolean initDatasetModel() {
        ResultInfoEx resultInfo = ExpressionDSHelper.getDatasetDtoById((Long)this.getDmModelId(), (Long)this.getDatasetId());
        if (!resultInfo.isSuccess().booleanValue()) {
            this.getView().showMessage(resultInfo.getMessage(), MessageTypes.Default, new ConfirmCallBackListener(FIDM_MSG_CLOSE));
            return false;
        }
        this.getPageCache().put(KEY_DATASETCALCINFO, DisclosureJsonHelper.toJSONString((Object)resultInfo.getData()));
        return true;
    }

    private DatasetCalcInfo getDatasetDto() {
        String dataStr = this.getPageCache().get(KEY_DATASETCALCINFO);
        if (StringUtils.isEmpty((String)dataStr)) {
            return null;
        }
        return (DatasetCalcInfo)DisclosureJsonHelper.convert((String)dataStr, DatasetCalcInfo.class);
    }

    private void setComboItems() {
        DatasetCalcInfo datasetCalcInfo = this.getDatasetDto();
        if (datasetCalcInfo != null) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(CTL_DATASET_FILTER_ENTRY);
            ComboEdit dimension = (ComboEdit)entryGrid.getFieldEdits().get(0);
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(datasetCalcInfo.getColumns().size());
            for (DataSetCaclColumn column : datasetCalcInfo.getColumns()) {
                data.add(new ComboItem(new LocaleString(column.getName()), column.getId()));
            }
            dimension.setComboItems(data);
        }
    }

    private void refreshDatasetFilter() {
        DatasetCalcInfo datasetCalcInfo = this.getDatasetDto();
        List<DatasetFilterItem> list = this.getDatasetFilter();
        if (list == null || list.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData(CTL_DATASET_FILTER_ENTRY);
        this.getModel().batchCreateNewEntryRow(CTL_DATASET_FILTER_ENTRY, list.size());
        this.getModel().beginInit();
        for (int i = 0; i < list.size(); ++i) {
            DatasetFilterItem item = list.get(i);
            String dimensionNumber = item.getDimensionNumber();
            this.getModel().setValue("link", (Object)item.getLink(), i);
            this.getModel().setValue("dimension", (Object)dimensionNumber, i);
            this.getModel().setValue("dimensionnumber", (Object)dimensionNumber, i);
            this.getModel().setValue("condition", (Object)item.getCondition(), i);
            this.getModel().setValue("memberid", (Object)item.getMemberId(), i);
            this.getModel().setValue("membernumber", (Object)item.getMemberNumber(), i);
            this.getModel().setValue("value", (Object)item.getValue(), i);
            ModelStrategyEx modelStrategyEx = ExpressionDSHelper.getModelStrategyEx((DatasetCalcInfo)datasetCalcInfo);
            if (modelStrategyEx == null || TypeUtils.containsIgnore((Collection)datasetCalcInfo.getMoneySet(), (String)dimensionNumber)) {
                this.getModel().setValue("dimension", (Object)dimensionNumber, i);
            } else {
                try {
                    if (StringUtils.isNotEmpty((String)item.getMemberNumber())) {
                        DimMemberInfo memberInfo = modelStrategyEx.getDimMember().findMemberByNumber(dimensionNumber, item.getMemberNumber(), false);
                        String memberName = item.getMemberNumber();
                        if (memberInfo != null) {
                            memberName = memberInfo.getName();
                        }
                        this.getModel().setValue("value", (Object)memberName, i);
                    } else {
                        this.getModel().setValue("value", (Object)item.getValue(), i);
                    }
                }
                catch (Exception ex) {
                    log.error("buildDatasetFilterEntry fail", (Throwable)ex);
                }
            }
            this.setValuleEnable(i, item.getCondition());
        }
        this.getModel().endInit();
        this.getView().updateView(CTL_DATASET_FILTER_ENTRY);
    }

    private void setValuleEnable(int row, String condition) {
        if (Objects.equals("is null", condition) || Objects.equals("is not null", condition)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"value"});
        } else {
            this.getView().setEnable(Boolean.TRUE, row, new String[]{"value"});
        }
    }

    private void setAllValueEnable() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CTL_DATASET_FILTER_ENTRY);
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.setValuleEnable(i, ((DynamicObject)entryEntity.get(i)).getString("condition"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "fidm_msg_close": {
                this.getView().close();
                break;
            }
        }
    }

    public void cellClick(CellClickEvent event) {
        if (event.getSource() instanceof EntryGrid) {
            String key;
            switch (key = ((EntryGrid)event.getSource()).getKey()) {
                case "entryentity": {
                    this.cellClickByDatasetFilter(key);
                    break;
                }
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "value": {
                this.cellClickByDatasetFilter(key);
                break;
            }
            case "btnok": {
                this.btnok();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "singleMemberF7": {
                this.setDatasetFilterValue(e);
                break;
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String keyName;
        super.propertyChanged(e);
        switch (keyName = e.getProperty().getName()) {
            case "dimension": {
                this.setDatasetFilterDimension(e);
                break;
            }
            case "condition": {
                this.setDatasetFilterValueByCondition(e);
                break;
            }
        }
    }

    private void cellClickByDatasetFilter(String key) {
        int row = this.getModel().getEntryCurrentRowIndex(CTL_DATASET_FILTER_ENTRY);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(CTL_DATASET_FILTER_ENTRY, row);
        DatasetCalcInfo datasetCalcInfo = this.getDatasetDto();
        switch (key) {
            case "value": {
                if (datasetCalcInfo == null) break;
                String dimensionNumber = (String)rowEntity.get("dimension");
                ModelStrategyEx modelStrategyEx = ExpressionDSHelper.getModelStrategyEx((DatasetCalcInfo)datasetCalcInfo);
                if (modelStrategyEx == null || TypeUtils.containsIgnore((Collection)datasetCalcInfo.getMoneySet(), (String)dimensionNumber)) {
                    return;
                }
                if (StringUtils.isEmpty((String)dimensionNumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7b5b\u9009\u5b57\u6bb5\u201d\u3002", (String)"DatasetFilterEntryPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                String condition = (String)rowEntity.get("condition");
                if (Objects.isNull(condition)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7b5b\u9009\u65b9\u5f0f\u201d\u3002", (String)"DatasetFilterEntryPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (Objects.equals("is null", condition) || Objects.equals("is not null", condition)) {
                    return;
                }
                try {
                    DimensionInfo dimensionInfo;
                    if (modelStrategyEx == null || (dimensionInfo = DimensionUtils.getDimByNumber((List)modelStrategyEx.getDim().getDimList(), (String)dimensionNumber)) == null) break;
                    modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, CLOSEDCALLBACK_FILTER_VALUE, this.getClass().getName(), true, "");
                }
                catch (Exception ex) {
                    AbstractBaseFormPlugin.log.error("cellClickByDatasetFilter", (Throwable)ex);
                }
                break;
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        int row = this.getModel().getEntryCurrentRowIndex(CTL_DATASET_FILTER_ENTRY);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(CTL_DATASET_FILTER_ENTRY, row);
        DatasetCalcInfo datasetCalcInfo = this.getDatasetDto();
        if (datasetCalcInfo != null) {
            DimensionInfo dimensionInfo;
            String dimensionNumber = (String)rowEntity.get("dimensionnumber");
            ModelStrategyEx modelStrategyEx = ExpressionDSHelper.getModelStrategyEx((DatasetCalcInfo)datasetCalcInfo);
            if (modelStrategyEx != null && (dimensionInfo = DimensionUtils.getDimByNumber((List)modelStrategyEx.getDim().getDimList(), (String)dimensionNumber)) != null) {
                QFilter qFilter = new QFilter("model", "=", (Object)datasetCalcInfo.getDataSrcId());
                qFilter.and(new QFilter("dimension", "=", (Object)dimensionInfo.getId()));
                ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
                filterList.add(qFilter);
                beforeF7SelectEvent.setCustomQFilters(filterList);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    private void setDatasetFilterValue(ClosedCallBackEvent e) {
        if (e.getReturnData() instanceof DynamicObject) {
            DynamicObject returnData = (DynamicObject)e.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(CTL_DATASET_FILTER_ENTRY);
            DynamicObject rowDyn = this.getModel().getEntryRowEntity(CTL_DATASET_FILTER_ENTRY, row);
            rowDyn.set("value", (Object)returnData.getString("name"));
            rowDyn.set("memberid", (Object)returnData.getLong("id"));
            rowDyn.set("membernumber", (Object)returnData.getString("number"));
            this.setAllValueEnable();
            this.getView().updateView(CTL_DATASET_FILTER_ENTRY);
        }
    }

    private void setDatasetFilterDimension(PropertyChangedArgs e) {
        int row = this.getModel().getEntryCurrentRowIndex(CTL_DATASET_FILTER_ENTRY);
        DynamicObject rowDyn = this.getModel().getEntryRowEntity(CTL_DATASET_FILTER_ENTRY, row);
        rowDyn.set("value", null);
        rowDyn.set("memberid", null);
        rowDyn.set("membernumber", null);
        this.setAllValueEnable();
        this.getView().updateView(CTL_DATASET_FILTER_ENTRY);
    }

    private void setDatasetFilterValueByCondition(PropertyChangedArgs e) {
        int row = this.getModel().getEntryCurrentRowIndex(CTL_DATASET_FILTER_ENTRY);
        DynamicObject rowDyn = this.getModel().getEntryRowEntity(CTL_DATASET_FILTER_ENTRY, row);
        String newCondition = (String)e.getChangeSet()[0].getNewValue();
        this.setValuleEnable(row, newCondition);
        rowDyn.set("value", null);
        rowDyn.set("memberid", null);
        rowDyn.set("membernumber", null);
        this.setAllValueEnable();
        this.getView().updateView(CTL_DATASET_FILTER_ENTRY);
    }

    private void btnok() {
        ArrayList<DatasetFilterItem> filterItems = new ArrayList<DatasetFilterItem>();
        DatasetCalcInfo datasetCalcInfo = this.getDatasetDto();
        ModelStrategyEx modelStrategyEx = ExpressionDSHelper.getModelStrategyEx((DatasetCalcInfo)datasetCalcInfo);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(CTL_DATASET_FILTER_ENTRY);
        for (DynamicObject entry : entryEntity) {
            String seq = entry.getString("seq");
            String condition = entry.getString("condition");
            String value = entry.getString("value");
            String dimensionNumber = entry.getString("dimension");
            String memberNumber = entry.getString("membernumber");
            String link = entry.getString("link");
            if (StringUtils.isEmpty((String)dimensionNumber)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u7b5b\u9009\u5b57\u6bb5\u201d\u3002", (String)"DatasetFilterEntryPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (StringUtils.isEmpty((String)condition)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u7b5b\u9009\u65b9\u5f0f\u201d\u3002", (String)"DatasetFilterEntryPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]), seq));
                return;
            }
            if (StringUtils.isEmpty((String)value) && !Objects.equals("is null", condition) && !Objects.equals("is not null", condition)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u7b5b\u9009\u503c\u201d\u3002", (String)"DatasetFilterEntryPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), seq));
                return;
            }
            Long dimensionId = 0L;
            Long memberId = 0L;
            if (modelStrategyEx == null || TypeUtils.containsIgnore((Collection)datasetCalcInfo.getMoneySet(), (String)dimensionNumber)) {
                memberNumber = value;
                if (!Objects.equals("is null", condition) && !Objects.equals("is not null", condition) && StringUtils.isEmpty((String)memberNumber)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u5f55\u5165\u201c\u7b5b\u9009\u503c\u201d\u3002", (String)"DatasetFilterEntryPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]), seq));
                    return;
                }
            } else if (modelStrategyEx != null) {
                DimensionInfo dimensionInfo;
                DimMemberInfo member = modelStrategyEx.getDimMember().findMemberByNumber(dimensionNumber, memberNumber, false);
                if (member == null) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u7b5b\u9009\u503c\u201d\u5f55\u5165\u7684 \u201c%2$s\u201d \u4e0e\u7ef4\u5ea6\u6210\u5458F7\u9875\u9762\u9009\u9879\u4e0d\u4e00\u81f4\u3002", (String)"DatasetFilterEntryPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]), seq, value));
                    return;
                }
                if (member != null) {
                    memberId = member.getId();
                    memberNumber = member.getNumber();
                }
                if ((dimensionInfo = DimensionUtils.getDimByNumber((List)modelStrategyEx.getDim().getDimList(), (String)dimensionNumber)) != null) {
                    dimensionId = dimensionInfo.getId();
                }
            }
            DatasetFilterItem filterItem = new DatasetFilterItem();
            filterItem.setLink(link);
            filterItem.setDimensionId(dimensionId);
            filterItem.setDimensionNumber(dimensionNumber);
            filterItem.setCondition(condition);
            filterItem.setMemberId(memberId);
            filterItem.setMemberNumber(memberNumber);
            filterItem.setValue(value);
            filterItems.add(filterItem);
        }
        this.getView().returnDataToParent((Object)JacksonUtils.toJson(filterItems));
        this.getView().close();
    }
}

