/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.common.common.enums.DefinedImpSourceEnum;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;

public class DatasetJoinPlugin
extends AbstractBaseDMFormPlugin {
    private static final String JOIN_SOURCE = "joinsource";
    private static final String JOIN_SELECT_FIELDS = "joinselectfields";
    private static final String JOIN_SELECT_FIELDS_NUM = "selectfields";
    private static final String BTN_OK = "btnok";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_OK);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Object value = this.getModel().getValue(JOIN_SELECT_FIELDS);
        if (Objects.nonNull(value)) {
            String[] split = value.toString().split(",");
            String joinSource = (String)this.getView().getFormShowParameter().getCustomParam(JOIN_SOURCE);
            MainEntityType userEntity = DatasetUtil.getEntityType((String)joinSource);
            Map allFields = userEntity.getAllFields();
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)split.length);
            for (String s : split) {
                if (!allFields.containsKey(s)) continue;
                returnMap.put(s, ((IDataEntityProperty)allFields.get(s)).getDisplayName().getLocaleValue());
            }
            this.getView().setReturnData((Object)SerializationUtils.toJsonString((Object)returnMap));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnMap));
        }
        this.getView().close();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String joinSource = (String)this.getView().getFormShowParameter().getCustomParam(JOIN_SOURCE);
        Map allSource = DefinedImpSourceEnum.getAllSource();
        if (!allSource.containsKey(joinSource)) {
            return;
        }
        this.initFieldCombo(joinSource);
        String selectFields = (String)this.getView().getFormShowParameter().getCustomParam(JOIN_SELECT_FIELDS_NUM);
        this.getModel().setValue(JOIN_SELECT_FIELDS, (Object)selectFields);
    }

    private void initFieldCombo(String number) {
        MainEntityType userEntity = DatasetUtil.getEntityType((String)number);
        Map allFields = userEntity.getAllFields();
        ArrayList items = Lists.newArrayListWithExpectedSize((int)allFields.size());
        for (Map.Entry entry : allFields.entrySet()) {
            items.add(new ComboItem(((IDataEntityProperty)entry.getValue()).getDisplayName(), (String)entry.getKey()));
        }
        ComboEdit selectComboEdit = (ComboEdit)this.getControl(JOIN_SELECT_FIELDS);
        selectComboEdit.setComboItems((List)items);
    }
}

