/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.enums.ApplicationTypeEnum;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.imp.AbsCommonImport;

public class DatasetListPlugin
extends AbstractBaseDMListPlugin {
    private static final String BILLLISTAP = "billlistap";
    private static final String FOCUSNODEID = "focusnodeid";
    private static final String ROOTNODEID = "rootNodeId";
    private static final String TREE_KEY = "treeview_group";
    private static final String TREELIST = "treelist";
    private static final String ctl_discmodel = "dmmodel";
    private static final String DATASET_NEW_CLOSE = "dataset_new_close";
    private static final String DATASET_DELETE_CONFIRM = "delete_dataset_confirm";
    private static final String ISDATASETREADONLY = "dataset";
    private static final String READONLYDATASET = "readonlydataset";
    private static final String DATASET_EXPORT_CONFIRM = "dataset_export_confirm";
    private static final String DISPLAYPROPERTY = "displayproperty";
    private static final String DELETEIDPAGECACHE = "deleteidpagecache";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("category_addnew", "category_delete", "category_modify", "category_up", "category_down");
        TreeView treeView = (TreeView)this.getControl(TREE_KEY);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                String nodeId = evt.getNodeId().toString();
                DatasetListPlugin.this.getPageCache().put(DatasetListPlugin.FOCUSNODEID, nodeId);
                DatasetListPlugin.this.setButtonVisible(nodeId);
                DatasetListPlugin.this.refreshBillList();
            }
        });
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener(this::billListHyperLinkClick);
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = this.getDMModelId();
        this.getModel().setValue(ctl_discmodel, (Object)modelId);
        this.initTree(modelId);
        this.getPageCache().put("dmmodelid", String.valueOf(modelId));
        this.refreshBillList();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_edit"});
    }

    private Boolean clickBeforeOperateCheck(String fourceNodeId) {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String appNum = ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId()).getAppnum();
        List onlyReadCatalogIds = PermissionHelper.getOnlyReadIds((String)"far_datasetcategory", (Long)modelId, (String)RequestContext.get().getUserId(), (String)appNum);
        if (Objects.nonNull(fourceNodeId) && onlyReadCatalogIds.contains(LongUtil.toLong((Object)fourceNodeId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"AbsPivotPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String fourceNodeId = this.getPageCache().get(FOCUSNODEID);
        Boolean checkStatus = this.clickBeforeOperateCheck(fourceNodeId);
        if (!checkStatus.booleanValue()) {
            return;
        }
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase(Locale.ENGLISH)) {
            case "category_addnew": {
                this.addCategory(fourceNodeId);
                break;
            }
            case "category_delete": {
                this.deleteCategory(fourceNodeId);
                break;
            }
            case "category_modify": {
                this.modifyCategory(fourceNodeId);
                break;
            }
            case "category_up": {
                this.moveUpCategory(fourceNodeId);
                break;
            }
            case "category_down": {
                this.moveDownCategory(fourceNodeId);
                break;
            }
        }
    }

    private void moveDownCategory(String fourceNodeId) {
        DynamicObject currentDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fourceNodeId, (String)"far_datasetcategory");
        String nodeNum = currentDynamicObject.getString("number");
        if ("root".equals(nodeNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"AbsPivotPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        int currentSeq = currentDynamicObject.getInt("sequence");
        QFilter afterNodeSeqFilter = new QFilter("sequence", ">", (Object)currentSeq);
        Long parentId = currentDynamicObject.getLong("parent.id");
        QFilter parentNodeIdFilter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] sqlFilters = new QFilter[]{afterNodeSeqFilter, parentNodeIdFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"far_datasetcategory", (String)"id,sequence", (QFilter[])sqlFilters, (String)"sequence asc", (int)1);
        if (Objects.isNull(dcs) || dcs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbsPivotPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long afterNodeId = ((DynamicObject)dcs.get(0)).getLong("id");
        DynamicObject afterDynamicObject = BusinessDataServiceHelper.loadSingle((Object)afterNodeId, (String)"far_datasetcategory");
        int afterSeq = afterDynamicObject.getInt("sequence");
        currentDynamicObject.set("sequence", (Object)afterSeq);
        afterDynamicObject.set("sequence", (Object)currentSeq);
        SaveServiceHelper.save((IDataEntityType)currentDynamicObject.getDataEntityType(), (Object[])new Object[]{currentDynamicObject, afterDynamicObject});
        String categoryName = currentDynamicObject.getString("name");
        String categoryNumber = currentDynamicObject.getString("number");
        AnalysisOpLogParam logParam = this.getCategorySingleLogParam(categoryName, categoryNumber);
        logParam.buildOpName(OperationName.NEXT_DATASET_CATALOG);
        logParam.buildOpResult(OperationResult.SUCCESS);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        this.refreshTreeView();
        String nodeText = afterDynamicObject.getString("name");
        this.getPageCache().put(FOCUSNODEID, fourceNodeId);
        TreeNode node = new TreeNode(String.valueOf(afterNodeId), fourceNodeId, nodeText);
        ((TreeView)this.getControl(TREE_KEY)).focusNode(node);
    }

    private void moveUpCategory(String fourceNodeId) {
        DynamicObject currentDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fourceNodeId, (String)"far_datasetcategory");
        String nodeNum = currentDynamicObject.getString("number");
        if ("root".equals(nodeNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"AbsPivotPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        int currentSeq = currentDynamicObject.getInt("sequence");
        Long parentId = currentDynamicObject.getLong("parent.id");
        QFilter beforeNodeSeqFilter = new QFilter("sequence", "<", (Object)currentSeq);
        QFilter parentNodeIdFilter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] sqlFilters = new QFilter[]{beforeNodeSeqFilter, parentNodeIdFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"far_datasetcategory", (String)"id,sequence", (QFilter[])sqlFilters, (String)"sequence desc", (int)1);
        if (Objects.isNull(dcs) || dcs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbsPivotPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long beforeNodeId = ((DynamicObject)dcs.get(0)).getLong("id");
        DynamicObject beforeDynamicObject = BusinessDataServiceHelper.loadSingle((Object)beforeNodeId, (String)"far_datasetcategory");
        int beforeSeq = beforeDynamicObject.getInt("sequence");
        currentDynamicObject.set("sequence", (Object)beforeSeq);
        beforeDynamicObject.set("sequence", (Object)currentSeq);
        SaveServiceHelper.save((IDataEntityType)currentDynamicObject.getDataEntityType(), (Object[])new Object[]{currentDynamicObject, beforeDynamicObject});
        String categoryName = currentDynamicObject.getString("name");
        String categoryNumber = currentDynamicObject.getString("number");
        AnalysisOpLogParam logParam = this.getCategorySingleLogParam(categoryName, categoryNumber);
        logParam.buildOpName(OperationName.UP_DATASET_CATALOG);
        logParam.buildOpResult(OperationResult.SUCCESS);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        this.refreshTreeView();
        this.getPageCache().put(FOCUSNODEID, fourceNodeId);
        String nodeText = beforeDynamicObject.getString("name");
        TreeNode node = new TreeNode(String.valueOf(beforeNodeId), fourceNodeId, nodeText);
        ((TreeView)this.getControl(TREE_KEY)).focusNode(node);
    }

    private void modifyCategory(String fourceNodeId) {
        DynamicObject currentDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fourceNodeId, (String)"far_datasetcategory");
        String nodeNum = currentDynamicObject.getString("number");
        if ("root".equals(nodeNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"AbsPivotPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("far_datasetcategory");
        QFilter q = new QFilter("id", "=", (Object)Long.valueOf(fourceNodeId));
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "name,number,parent.id,permclass.id";
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"far_datasetcategory", (String)selectFields, (QFilter[])filters);
        Long parnetId = dynamicObject.getLong("parent.id");
        baseShowParameter.setCustomParam("parentid", (Object)parnetId);
        baseShowParameter.setCustomParam("selectnodeid", (Object)fourceNodeId);
        String selectNodeNumber = dynamicObject.getString("number");
        baseShowParameter.setCustomParam("selectnodenumber", (Object)selectNodeNumber);
        String selectNodeName = dynamicObject.getString("name");
        baseShowParameter.setCustomParam("selectnodename", (Object)selectNodeName);
        Object dmModel = this.getModel().getValue("dmmodel_id");
        baseShowParameter.setPkId((Object)Long.valueOf(fourceNodeId));
        baseShowParameter.setStatus(OperationStatus.EDIT);
        baseShowParameter.setCustomParam(ctl_discmodel, dmModel);
        baseShowParameter.setCustomParam("operate", (Object)"modify");
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modifycategoryclosecallback"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void deleteCategory(String fourceNodeId) {
        DynamicObject currentDynamicObject = BusinessDataServiceHelper.loadSingle((Object)fourceNodeId, (String)"far_datasetcategory");
        String nodeNum = currentDynamicObject.getString("number");
        if ("root".equals(nodeNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"AbsPivotPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(DELETEIDPAGECACHE, fourceNodeId);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deletecategoryconfirmcallback");
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u8be5\u6570\u636e\u96c6\u5206\u7c7b\u5417\uff1f", (String)"DatasetListPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private void addCategory(String fourceNodeId) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("far_datasetcategory");
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        baseShowParameter.setCustomParam("parentid", (Object)LongUtil.toLong((Object)fourceNodeId));
        baseShowParameter.setCustomParam("selectnodeid", (Object)fourceNodeId);
        String selectNodeNumber = this.getSelectNodeNumber(fourceNodeId);
        baseShowParameter.setCustomParam("selectnodenumber", (Object)selectNodeNumber);
        Object dmModel = this.getModel().getValue("dmmodel_id");
        baseShowParameter.setCustomParam(ctl_discmodel, dmModel);
        baseShowParameter.setCustomParam("operate", (Object)"add");
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addcategoryclosecallback"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private String getSelectNodeNumber(String fourceNodeId) {
        QFilter q = new QFilter("id", "=", (Object)Long.valueOf(fourceNodeId));
        QFilter[] filters = new QFilter[]{q};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"far_datasetcategory", (String)"number", (QFilter[])filters);
        String selectNodeNumber = dynamicObject.getString("number");
        return selectNodeNumber;
    }

    private void setButtonVisible(String nodeId) {
        switch (nodeId) {
            case "1": 
            case "2": 
            case "root": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_newquery", "btn_newguide"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_new"});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_newquery", "btn_newguide"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_new"});
                break;
            }
        }
    }

    private void addPermClassFilter(QFilter qFilter) {
        HashSet noPermId = new HashSet(16);
        noPermId.addAll(PermClassEntityHelper.getDiscPermissionMap((String)"fidm_dataset", (Long)this.getDMModelId(), (Long)this.getUserId(), (String)this.getView().getFormShowParameter().getAppId()).get((Object)"1"));
        qFilter.and(new QFilter("id", "not in", noPermId));
    }

    private void refreshBillList() {
        try {
            TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
            List selectNodes = tree.getTreeState().getSelectedNodes();
            Map selectNode = (Map)selectNodes.get(0);
            String parentId = (String)selectNode.get("parentid");
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            String currentNodeId = (String)selectNode.get("id");
            if (kd.bos.util.StringUtils.isNotEmpty((String)parentId)) {
                qFilter.and("category", "=", (Object)Long.valueOf(currentNodeId));
            } else {
                qFilter.and("category", "=", (Object)Long.valueOf(currentNodeId));
                qFilter.or("category", "=", (Object)0L);
                qFilter.or("category", "is null", null);
            }
            long modelId = this.getModelId();
            qFilter.and("discmodel", "=", (Object)modelId);
            qFilter.and("scope", "=", (Object)"1");
            this.addPermClassFilter(qFilter);
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            billList.clearSelection();
            FilterParameter fp = new FilterParameter();
            fp.getQFilters().add(qFilter);
            billList.setFilterParameter(fp);
            billList.refresh();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (ctl_discmodel.equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newValue != null && oldValue != null && newValue.getPkValue().equals(oldValue.getPkValue())) {
                return;
            }
            if (newValue != null) {
                this.getPageCache().put("dmmodelid", newValue.getString("id"));
                Long modelId = newValue.getLong("id");
                TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
                tree.deleteAllNodes();
                this.initTree(modelId);
                this.refreshBillList();
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_new": {
                this.actionNew();
                break;
            }
            case "btn_newquery": {
                this.actionNewQuery();
                break;
            }
            case "btn_newguide": {
                this.actionNewGuide();
                break;
            }
            case "btn_refresh": {
                this.getPageCache().remove(READONLYDATASET);
                this.setButtonEnable(Boolean.TRUE);
                this.refreshBillList();
                break;
            }
            case "btn_edit": {
                this.actionEdit();
                break;
            }
            case "btn_manage": {
                this.openManage();
                break;
            }
            case "btn_del": {
                this.actionDelete();
                break;
            }
            case "btn_copy": {
                this.actionCopy();
                break;
            }
            case "btn_enable": {
                this.actionEnable(true);
                break;
            }
            case "btn_disable": {
                this.actionEnable(false);
                break;
            }
            case "btn_preview": {
                this.openPreviewPage();
                break;
            }
            case "btn_import": {
                this.openImportType();
                break;
            }
            case "btn_export": {
                this.beforeExport();
                break;
            }
            case "displayproperty": {
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows == null || selectedRows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long dataSetId = LongUtil.toLong((Object)billList.getSelectedRows().get(0).getPrimaryKeyValue());
                DatasetStyleEnum style = DatasetServiceHelper.getDatasetStyle((long)dataSetId);
                if (Objects.equals(DatasetStyleEnum.QUERY, style)) {
                    this.openEditPageWithGuide(dataSetId, "fidm_dataset", false);
                    break;
                }
                this.openDataSetDisplay(dataSetId, false);
                break;
            }
            case "btn_move": {
                this.moveCategory();
                break;
            }
        }
    }

    private void openManage() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long datasetId = (Long)billList.getFocusRowPkId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)billList.getEntityType().getName(), (String)"discmodel.id,type,currentstyle");
        String type = obj.getString("type");
        String currentStyle = obj.getString("currentstyle");
        if (!DataSetTypeEnum.MULTIPLE_ROW.getType().equals(type) || DatasetStyleEnum.GUIDE.getType().equals(currentStyle)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7ba1\u7406\u9875\u9762\u9700\u8981\u67e5\u8be2\u5f0f\u591a\u884c\u6570\u636e\u96c6\u6253\u5f00\u3002", (String)"DatasetListPlugin_57", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_dataset_manage");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setCustomParam("datasetId", (Object)datasetId);
        this.getView().showForm(fsp);
    }

    private void moveCategory() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList list = (BillList)this.getControl(BILLLISTAP);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u6570\u636e\u3002", (String)"DatasetListPlugin_58", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("far_move_datasetcategory");
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "movedatasetcategory"));
        fsp.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm(fsp);
    }

    private void actionNewGuide() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-business", (Object[])new Object[0]));
        fsp.setFormId("fidm_selectaddchaptertype");
        fsp.setCustomParam("DISC_MODEL_ID", (Object)String.valueOf(modelId));
        fsp.setCustomParam("sourcefrom", (Object)"datasetlist");
        fsp.setCustomParam("datasetshowtype", (Object)"guide");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "createguidedataset"));
        this.getView().showForm(fsp);
    }

    private void actionNewQuery() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-business", (Object[])new Object[0]));
        fsp.setFormId("fidm_selectaddchaptertype");
        fsp.setCustomParam("DISC_MODEL_ID", (Object)String.valueOf(modelId));
        fsp.setCustomParam("sourcefrom", (Object)"datasetlist");
        fsp.setCustomParam("datasetshowtype", (Object)"query");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "createquerydataset"));
        this.getView().showForm(fsp);
    }

    private void openDataSetDisplay(Long dataSetId, boolean isCopy) {
        this.checkPerm("btn_edit");
        ModelStrategy.checkUseModels((Long)dataSetId, (String)"");
        Object dmModel = this.getModel().getValue(ctl_discmodel);
        if (Objects.nonNull(dmModel)) {
            IFormView mainPageView = this.getView().getMainView();
            String pageId = this.getView().getPageId() + dataSetId + "fidm_dataset";
            String selectFields = "type,name";
            DynamicObject dataSetObject = QueryServiceHelper.queryOne((String)"fidm_dataset", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)dataSetId).toArray());
            String type = dataSetObject.getString("type");
            if (DataSetTypeEnum.MULTIPLE_VALUED.getType().equals(type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u503c\u6216\u591a\u884c\u6570\u636e\u96c6\u3002", (String)"DatasetListPlugin_43", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            this.checkTemplatePerm(dataSetId);
            if (mainPageView == null || mainPageView.getView(pageId) == null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                String dataSetName = dataSetObject.getString("name");
                if (StringUtils.isNotBlank((CharSequence)dataSetName)) {
                    formShowParameter.setCaption(dataSetName);
                }
                formShowParameter.setFormId(this.getQueryDatasetFromId());
                String focusNodeId = this.getPageCache().get(FOCUSNODEID);
                formShowParameter.setCustomParam("categoryid", (Object)Long.valueOf(focusNodeId));
                formShowParameter.setCustomParam("dataset_type", (Object)type);
                formShowParameter.setCustomParam("dataset_id", (Object)dataSetId);
                Long dmModelId = ((DynamicObject)dmModel).getLong("id");
                formShowParameter.setCustomParam("dmmodel_id", (Object)dmModelId);
                formShowParameter.setCustomParam("isCopy", (Object)isCopy);
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setPageId(pageId);
                this.getView().showForm(formShowParameter);
            } else {
                IFormView childFormView = mainPageView.getView(pageId);
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
        }
    }

    private void checkTemplatePerm(Long dataSetId) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)dataSetId);
        if (!Objects.equals(DataSrcTypeEnum.CM_TEMPLATE.getType(), singleDS.getString("datasrctype"))) {
            return;
        }
        String data = singleDS.getString("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_templateentity", (String)"name,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)vo.getTemplate().getTemplateId())});
        if (Objects.isNull(dynamicObject)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6765\u6e90\u62a5\u8868\u5df2\u88ab\u5220\u9664\u3002", (String)"DatasetListPlugin_54", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String name = dynamicObject.getString("name");
        if (!Objects.equals(dynamicObject.getString("status"), "1")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u62a5\u8868\u5df2\u88ab\u7981\u7528\u3002", (String)"DatasetListPlugin_55", (String)"epm-far-formplugin", (Object[])new Object[0]), name));
        }
        Map datasrcid = BCMMsServiceHelper.getTemplate((Long)singleDS.getLong("datasrcid"));
        if (!datasrcid.containsKey(vo.getTemplate().getTemplateId())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u62a5\u8868\u6743\u9650\u3002", (String)"DatasetListPlugin_56", (String)"epm-far-formplugin", (Object[])new Object[0]), name));
        }
    }

    private void beforeExport() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList list = (BillList)this.getControl(BILLLISTAP);
        if (list.getSelectedRows().size() != 0) {
            Object[] ids = list.getSelectedRows().getPrimaryKeyValues();
            QFilter filter = new QFilter("dataset.id", "in", (Object)ids).and("datasrctype", "in", (Object)Lists.newArrayList((Object[])new String[]{DataSrcTypeEnum.COMPONENT.getType(), DataSrcTypeEnum.CM_TEMPLATE.getType()}));
            boolean exists = QueryServiceHelper.exists((String)"fidm_dataset_single", (QFilter[])filter.toArray());
            if (exists) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u62a5\u8868\u5207\u7247\u548c\u6309\u8868\u53d6\u6570\u6570\u636e\u96c6\u6682\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"DatasetListPlugin_49", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DATASET_EXPORT_CONFIRM, (IFormPlugin)this));
                return;
            }
            this.exportData();
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5207\u7247\u548c\u6309\u8868\u53d6\u6570\u6570\u636e\u96c6\u6682\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"DatasetListPlugin_49", (String)"epm-far-formplugin", (Object[])new Object[0]));
        this.exportData();
    }

    @Override
    public DynamicObject[] handleDys(DynamicObject[] dys) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(Long.valueOf(this.getModelId()));
        ModelInfo model = modelStrategyEx.getModel().getModelInfo();
        boolean isEb = false;
        if (Objects.equals(DisModelTypeEnum.EB.getType(), model.getModelType())) {
            isEb = true;
        }
        String entityName = "bcm_model";
        HashMap modelMap = Maps.newHashMap();
        String entityType = "";
        if (!ObjectUtils.isEmpty((Object[])dys)) {
            DynamicObject[] dy = dys[0];
            entityType = dy.getDataEntityType().toString();
        }
        if (entityType.equals("fidm_dataset_single")) {
            for (DynamicObject dy : dys) {
                this.handleSingleDys(modelMap, dy, isEb, entityName);
            }
        } else {
            Map<Object, List<DynamicObject>> dataset = Arrays.stream(dys).collect(Collectors.groupingBy(c -> c.get(ISDATASETREADONLY)));
            ArrayList adjSettingImportData = Lists.newArrayListWithExpectedSize((int)13);
            dataset.entrySet().stream().forEach(entry -> {
                DynamicObject key = (DynamicObject)entry.getKey();
                List<DynamicObject> value = ((List)entry.getValue()).stream().sorted(Comparator.comparing(e -> (Integer)e.get("desq"))).collect(Collectors.toList());
                DynamicObject descDy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_dataset_multi");
                descDy.set("number", key.get("number"));
                descDy.set("name", key.get("name"));
                DynamicObjectCollection desEntryEntity = descDy.getDynamicObjectCollection("entryentity");
                value.forEach(c -> {
                    DynamicObject desEntry = desEntryEntity.addNew();
                    desEntry.set("formulanumber", c.get("number"));
                    desEntry.set("formulatext", c.get("formulatext"));
                    desEntry.set("formulaname", c.get("name"));
                    desEntry.set("formulatype", c.get("formulatype"));
                });
                adjSettingImportData.add(descDy);
            });
            if (adjSettingImportData.size() > 0) {
                dys = adjSettingImportData.toArray(new DynamicObject[adjSettingImportData.size()]);
            }
        }
        return dys;
    }

    private void handleSingleDys(Map<Long, String> modelMap, DynamicObject dy, boolean isEb, String entityName) {
        if (isEb && Objects.equals(dy.getString("datasrctype"), DataSrcTypeEnum.CURRENT_MODEL.getType())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u636e\u96c6\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u3002", (String)"DatasetListPlugin_37", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String type = dy.getString("dataset.type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            dy.set("dataset.type", (Object)DataSetTypeEnum.getEnumByType((String)type).getBridge().loadKDString());
        }
        long dataSrcId = dy.getLong("datasrcid");
        String number = dy.getString("datasrcnumber");
        if (StringUtils.isBlank((CharSequence)number)) {
            if (modelMap.containsKey(dataSrcId)) {
                dy.set("datasrcnumber", (Object)modelMap.get(dataSrcId));
            } else {
                DynamicObject srcModel = QueryServiceHelper.queryOne((String)entityName, (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataSrcId)});
                number = srcModel.getString("shownumber");
                dy.set("datasrcnumber", (Object)number);
                modelMap.put(dataSrcId, number);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportData() {
        AnalysisOpLogParam logParam = this.getSingleLogParam().buildOpName(OperationName.EXPORT);
        try {
            logParam.buildOpResult(OperationResult.SUCCESS);
            ArrayList types = Lists.newArrayList((Object[])new String[]{DataSrcTypeEnum.MERGE_MODEL.getType(), DataSrcTypeEnum.RPT_MODEL.getType(), DataSrcTypeEnum.CURRENT_MODEL.getType()});
            QFBuilder singleFilters = this.getExportFilters().and("datasrctype", "in", (Object)types);
            QFBuilder mutilFilters = this.getExportFilters();
            BillList list = (BillList)this.getControl(BILLLISTAP);
            Object[] primaryKeyValues = list.getSelectedRows().getPrimaryKeyValues();
            if (Objects.nonNull(primaryKeyValues) && primaryKeyValues.length > 0) {
                QFBuilder qFilter = new QFBuilder("id", "in", (Object)primaryKeyValues);
                this.export(singleFilters, mutilFilters, qFilter);
                return;
            }
            if (this.checkAll()) {
                this.exportData("fidm_dataset_single", singleFilters.toArray(), ResManager.loadKDString((String)"\u5355\u503c\u548c\u591a\u884c\u6570\u636e\u96c6\u5217\u8868\u5bfc\u51fa", (String)"DatasetListPlugin_50", (String)"epm-far-formplugin", (Object[])new Object[0]), "fidm_dataset_single_IMPT_S", "fidm_dataset_single");
                this.exportData("fidm_dataset_multivalue", mutilFilters.toArray(), ResManager.loadKDString((String)"\u591a\u503c\u6570\u636e\u96c6\u5217\u8868\u5bfc\u51fa", (String)"DatasetListPlugin_51", (String)"epm-far-formplugin", (Object[])new Object[0]), "fidm_dataset_multi_IMPT_S", "fidm_dataset_multi");
            } else {
                TreeView tree = (TreeView)this.getControl(TREE_KEY);
                Map focusNode = tree.getTreeState().getFocusNode();
                Long id = LongUtil.toLong(focusNode.get("id"));
                QFBuilder filter = new QFBuilder("discmodel", "=", (Object)this.getModelId());
                filter.and("scope", "=", (Object)"1");
                filter.and(new QFilter("category", "=", (Object)id));
                this.export(singleFilters, mutilFilters, filter);
            }
        }
        catch (Exception e) {
            logParam.buildOpResult(OperationResult.FAILURE);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff1a\"%s\"", (String)"DatasetListPlugin_35", (String)"epm-far-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        finally {
            AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
        }
    }

    private void export(QFBuilder singleFilters, QFBuilder mutilFilters, QFBuilder qFilter) {
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"fidm_dataset", (String)"id,type", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        Map typeIds = ids.stream().collect(Collectors.groupingBy(dy -> dy.getString("type"), Collectors.mapping(dy -> dy.getLong("id"), Collectors.toSet())));
        HashSet singleIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry entry : typeIds.entrySet()) {
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(entry.getKey())) {
                singleIds.addAll(entry.getValue());
                continue;
            }
            if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(entry.getKey())) {
                singleIds.addAll(entry.getValue());
                continue;
            }
            if (!DataSetTypeEnum.MULTIPLE_VALUED.getType().equals(entry.getKey())) continue;
            mutilFilters.add(new QFilter(ISDATASETREADONLY, "in", entry.getValue()));
            this.exportData("fidm_dataset_multivalue", mutilFilters.toArray(), ResManager.loadKDString((String)"\u591a\u503c\u6570\u636e\u96c6\u5217\u8868\u5bfc\u51fa", (String)"DatasetListPlugin_51", (String)"epm-far-formplugin", (Object[])new Object[0]), "fidm_dataset_multi_IMPT_S", "fidm_dataset_multi");
        }
        if (!CollectionUtils.isEmpty((Collection)singleIds)) {
            singleFilters.and(new QFilter(ISDATASETREADONLY, "in", (Object)singleIds));
            this.exportData("fidm_dataset_single", singleFilters.toArray(), ResManager.loadKDString((String)"\u5355\u503c/\u591a\u884c\u6570\u636e\u96c6\u5217\u8868\u5bfc\u51fa", (String)"DatasetListPlugin_52", (String)"epm-far-formplugin", (Object[])new Object[0]), "fidm_dataset_single_IMPT_S", "fidm_dataset_single");
        }
    }

    private boolean checkAll() {
        String number;
        TreeView tree = (TreeView)this.getControl(TREE_KEY);
        Map focusNode = tree.getTreeState().getFocusNode();
        return Objects.nonNull(focusNode) && StringUtils.equals((CharSequence)"root", (CharSequence)(number = focusNode.get("id").toString()));
    }

    private QFBuilder getExportFilters() {
        QFBuilder filter = new QFBuilder("dataset.discmodel", "=", (Object)this.getModelId());
        filter.and("dataset.scope", "=", (Object)"1");
        return filter;
    }

    public void openImportType() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("far_dataset_import");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_importtype"));
        this.getView().showForm(fsp);
    }

    public void handleImportFunction(ClosedCallBackEvent evt) {
        if (Objects.isNull(evt.getReturnData()) || StringUtils.isEmpty((CharSequence)evt.getReturnData().toString())) {
            return;
        }
        String type = evt.getReturnData().toString();
        if (StringUtils.equals((CharSequence)"1", (CharSequence)type)) {
            this.importSingleData();
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)type)) {
            this.importMultiData();
        }
    }

    private void importSingleData() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
        String listName = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5217\u8868", (String)"DatasetListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]);
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        AbsCommonImport.invokeOperation("fidm_dataset_single", "kd.epm.far.formplugin.common.dataset.DataSetImportPlugin", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
    }

    private void importMultiData() {
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importdataback");
        String listName = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5217\u8868", (String)"DatasetListPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]);
        ApplicationTypeEnum typeEnum = ApplicationTypeEnum.getApplication((String)this.getBizAppId());
        AbsCommonImport.invokeOperation("fidm_dataset_multi", "kd.epm.far.formplugin.common.dataset.DataSetImportMultiPlugin", closeCallBack, this.getModelId(), typeEnum, this.getView(), listName);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "dataset_new_close": {
                if (evt.getReturnData() == null) break;
                this.refreshBillList();
                break;
            }
            case "importdataback": {
                this.refreshBillList();
                break;
            }
            case "callback_importtype": {
                this.handleImportFunction(evt);
                break;
            }
            case "createquerydataset": {
                this.createQueryDatasetCallBack(evt);
                break;
            }
            case "createguidedataset": {
                this.createGuideDatasetCallBack(evt);
                break;
            }
            case "movedatasetcategory": {
                this.moveDatasetCategoryCallBack(evt);
                break;
            }
            case "addcategoryclosecallback": {
                this.addCategoryCloseCallBack(evt);
                break;
            }
            case "modifycategoryclosecallback": {
                this.modifyCategoryCloseCallBack(evt);
                break;
            }
        }
    }

    private void modifyCategoryCloseCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (Objects.nonNull(returnData)) {
            this.updateTreeView();
        }
    }

    private void updateTreeView() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.deleteAllNodes();
        Long modelId = (Long)this.getModel().getValue("dmmodel_id");
        List<Map<String, String>> treeList = this.buildTreeList(modelId);
        this.getPageCache().put(TREELIST, SerializationUtils.toJsonString(treeList));
        TreeNode root = this.createRootNode(modelId, Boolean.FALSE);
        String rootNodeId = this.getPageCache().get(ROOTNODEID);
        BCMTreeUtils.setEntryNodeDm((TreeNode)root, treeList, (String)rootNodeId);
        BCMTreeUtils.spreadAllNode((TreeNode)root);
        String fourceNodeId = this.getPageCache().get(FOCUSNODEID);
        TreeNode editNode = root.getTreeNode(fourceNodeId);
        tree.addNode(root);
        tree.updateNode(editNode);
        tree.focusNode(editNode);
    }

    private void refreshTreeView() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.deleteAllNodes();
        Long modelId = (Long)this.getModel().getValue("dmmodel_id");
        this.initTree(modelId);
    }

    private void initTree(Long modelId) {
        this.createRootCategoryData(modelId);
        List<Map<String, String>> treeList = this.buildTreeList(modelId);
        this.getPageCache().put(TREELIST, SerializationUtils.toJsonString(treeList));
        TreeNode root = this.createRootNode(modelId, Boolean.TRUE);
        String rootNodeId = this.getPageCache().get(ROOTNODEID);
        BCMTreeUtils.setEntryNodeDm((TreeNode)root, treeList, (String)rootNodeId);
        BCMTreeUtils.spreadAllNode((TreeNode)root);
        TreeView tree = (TreeView)this.getControl(TREE_KEY);
        tree.addNode(root);
        tree.focusNode(root);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_new"});
    }

    private void addCategoryCloseCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (Objects.nonNull(returnData)) {
            this.refreshTreeView();
        }
    }

    private void moveDatasetCategoryCallBack(ClosedCallBackEvent evt) {
        if (Objects.isNull(evt.getReturnData()) || StringUtils.isEmpty((CharSequence)evt.getReturnData().toString())) {
            return;
        }
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        AnalysisOpLogParam logParamSuccess = this.getMoveMultiLogParam(billList.getSelectedRows().size()).buildOpResult(OperationResult.SUCCESS);
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        String categoryId = evt.getReturnData().toString();
        for (ListSelectedRow row : billList.getSelectedRows()) {
            Object datasetId = row.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"fidm_dataset");
            dynamicObject.set("category", (Object)categoryId);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
            logParamSuccess.buildBatchFormatParams(new Object[]{model.getString("number"), dynamicObject.getString("number")});
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParamSuccess);
        this.refreshBillList();
    }

    private void createGuideDatasetCallBack(ClosedCallBackEvent evt) {
        if (Objects.isNull(evt.getReturnData()) || StringUtils.isEmpty((CharSequence)evt.getReturnData().toString())) {
            return;
        }
        String type = evt.getReturnData().toString();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATASET_NEW_CLOSE));
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if ("1".equals(type) || "2".equals(type)) {
            fsp.setFormId("fidm_dataset_single_edit");
        } else if ("3".equals(type)) {
            fsp.setFormId("fidm_dataset_multivalue_n");
        }
        long modelId = this.getModelId();
        fsp.setCustomParam("dmmodelid", (Object)("" + modelId));
        fsp.setCustomParam("type", (Object)type);
        this.getView().showForm(fsp);
    }

    private void createQueryDatasetCallBack(ClosedCallBackEvent evt) {
        if (Objects.isNull(evt.getReturnData()) || StringUtils.isEmpty((CharSequence)evt.getReturnData().toString())) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setStatus(OperationStatus.ADDNEW);
        long modelId = this.getModelId();
        String type = evt.getReturnData().toString();
        if ("3".equals(type)) {
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATASET_NEW_CLOSE));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            formShowParameter.setFormId("fidm_dataset_multivalue_n");
            formShowParameter.setCustomParam("dmmodelid", (Object)("" + modelId));
            formShowParameter.setCustomParam("type", (Object)type);
            this.getView().showForm(formShowParameter);
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u67e5\u8be2\u5f0f\u6570\u636e\u96c6", (String)"DatasetListPlugin_46", (String)"epm-far-formplugin", (Object[])new Object[0]));
            formShowParameter.setFormId(this.getQueryDatasetFromId());
            formShowParameter.setCustomParam("dataset_type", (Object)type);
            formShowParameter.setCustomParam("dmmodel_id", (Object)modelId);
            String focusNodeId = this.getPageCache().get(FOCUSNODEID);
            formShowParameter.setCustomParam("categoryid", (Object)Long.valueOf(focusNodeId));
            formShowParameter.setCustomParam("isCopy", (Object)false);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(formShowParameter);
        }
    }

    private String getQueryDatasetFromId() {
        String fromId = "far_dataset_display";
        try {
            DatasetUtil.getEntityType((String)"epdm_dm");
            fromId = "far_dataset_display_new";
        }
        catch (Exception e) {
            log.error("get epdm_dm error : " + e.getMessage());
        }
        return fromId;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "delete_dataset_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.actionDeleteResult();
                break;
            }
            case "dataset_export_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.exportData();
                break;
            }
            case "deletecategoryconfirmcallback": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                this.deleteCategoryConfirmCallBack();
                break;
            }
        }
    }

    private void deleteCategoryConfirmCallBack() {
        String fourceNodeId = this.getPageCache().get(DELETEIDPAGECACHE);
        QFilter currentFilter = new QFilter("id", "=", (Object)Long.parseLong(fourceNodeId));
        String selectFields = "id, name,number,parent.id,permclass.id,longnumber";
        QFilter[] currentfilters = new QFilter[]{currentFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"far_datasetcategory", (String)selectFields, (QFilter[])currentfilters);
        String longNumber = dynamicObject.getString("longnumber");
        QFilter longNumberFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
        long modelId = this.getModelId();
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] deletefilters = new QFilter[]{modelFilter, longNumberFilter};
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"far_datasetcategory", (String)selectFields, (QFilter[])deletefilters);
        HashSet categoryIds = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
        AnalysisOpLogParam logParamSuccess = this.getDelCategoryMultiLogParam(dynamicObjectCollection.size()).buildOpResult(OperationResult.SUCCESS);
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        for (DynamicObject delDynamicObject : dynamicObjectCollection) {
            Long categoryId = delDynamicObject.getLong("id");
            categoryIds.add(categoryId);
            logParamSuccess.buildBatchFormatParams(new Object[]{model.getString("number"), dynamicObject.getString("number")});
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"far_datasetcategory"), (Object[])categoryIds.toArray());
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParamSuccess);
        this.refreshTreeView();
        this.refreshBillList();
    }

    private void actionNew() {
        String focusNodeId = this.getPageCache().get(FOCUSNODEID);
        if (StringUtils.isEmpty((CharSequence)focusNodeId)) {
            focusNodeId = "0";
        }
        if (this.isRootNode(focusNodeId) || "0".equals(focusNodeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0b\u4e0d\u80fd\u65b0\u589e\u3002", (String)"DatasetListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        long modelId = this.getModelId();
        if (modelId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4f53\u7cfb\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetListPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATASET_NEW_CLOSE));
        fsp.setStatus(OperationStatus.ADDNEW);
        fsp.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u96c6", (String)"DatasetListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        if ("1".equals(focusNodeId) || "2".equals(focusNodeId)) {
            fsp.setFormId("fidm_dataset_single_edit");
        } else if ("3".equals(focusNodeId)) {
            fsp.setFormId("fidm_dataset_multivalue_n");
        }
        fsp.setCustomParam("dmmodelid", (Object)("" + modelId));
        fsp.setCustomParam("type", (Object)focusNodeId);
        this.getView().showForm(fsp);
    }

    private void actionEdit() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.openEditPageWithGuide(Long.valueOf(selectedRows.get(0).toString()), "fidm_dataset", false);
    }

    private void actionDelete() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (billList.getSelectedRows() == null || billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"DatasetListPlugin_27", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"DatasetListPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DATASET_DELETE_CONFIRM, (IFormPlugin)this));
    }

    private void actionDeleteResult() {
        String msg = "";
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        HashSet<Long> ids = new HashSet<Long>(2);
        AnalysisOpLogParam logParamSuccess = this.getMultiLogParam(billList.getSelectedRows().size()).buildOpResult(OperationResult.SUCCESS);
        AnalysisOpLogParam logParamFailure = this.getMultiLogParam(billList.getSelectedRows().size()).buildOpResult(OperationResult.FAILURE);
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        for (ListSelectedRow row : billList.getSelectedRows()) {
            DynamicObject dynamicObject = DatasetServiceHelper.getDataSetById((Long)LongUtil.toLong((Object)row.getPrimaryKeyValue()));
            if (dynamicObject == null) {
                msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u6570\u636e\u540e\u518d\u64cd\u4f5c\u3002", (String)"DatasetListPlugin_28", (String)"epm-far-formplugin", (Object[])new Object[0]), row.getName());
                this.getView().showTipNotification(msg);
                continue;
            }
            msg = this.checkActionDelete(dynamicObject.getLong("id"));
            if (!StringUtils.isEmpty((CharSequence)msg)) {
                this.getView().showTipNotification(msg);
                logParamFailure.buildBatchFormatParams(new Object[]{model.getString("number"), dynamicObject.getString("number")});
                continue;
            }
            logParamSuccess.buildBatchFormatParams(new Object[]{model.getString("number"), dynamicObject.getString("number")});
            ids.add(dynamicObject.getLong("id"));
        }
        if (ids.size() > 0) {
            DatasetServiceHelper.deleteDataSet(ids);
            msg = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"DatasetListPlugin_29", (String)"epm-far-formplugin", (Object[])new Object[0]), ids.size());
            this.getView().showSuccessNotification(msg);
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParamSuccess);
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParamFailure);
        this.refreshBillList();
    }

    private String checkActionDelete(Long datasetId) {
        DynamicObject report;
        DynamicObject cate;
        String msg = "";
        DynamicObject dataset = DatasetServiceHelper.getDataSetById((Long)datasetId);
        if (dataset == null) {
            return msg;
        }
        String datasetName = dataset.getString("name");
        if (dataset.getBoolean("status")) {
            return String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\"%s\"\u5df2\u542f\u7528,\u4e0d\u53ef\u5220\u9664\u3002", (String)"DatasetListPlugin_33", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName);
        }
        DynamicObject multiDS = QueryServiceHelper.queryOne((String)"fidm_dataset_multivalue", (String)"id,dataset.name", (QFilter[])new QFilter("single.dataset", "=", (Object)datasetId).toArray());
        if (multiDS != null) {
            msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201d%1$s\u201d\u88ab\u591a\u503c\u6570\u636e\u96c6\u201d%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_38", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName, multiDS.getString("dataset.name"));
            return msg;
        }
        DynamicObject pivot = QueryServiceHelper.queryOne((String)"far_pivot_scheme", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()).and(ISDATASETREADONLY, "=", (Object)datasetId)});
        if (pivot != null) {
            msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u6570\u636e\u5206\u6790\u65b9\u6848\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_47", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName, pivot.getString("name"));
            return msg;
        }
        DynamicObject module = QueryServiceHelper.queryOne((String)"fidm_modulerepository", (String)"id,number,name,catalog.id", (QFilter[])new QFilter[]{new QFilter("datasetid", "=", (Object)datasetId)});
        if (module == null) {
            return msg;
        }
        msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\"%s\"\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName);
        Long moduleId = module.getLong("id");
        if (module.getLong("catalog.id") > 0L && (cate = QueryServiceHelper.queryOne((String)"fidm_modulecatalog", (String)"id,name,catalogtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)module.getLong("catalog.id"))})) != null) {
            msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201d%1$s\u201d\u88ab\u7ec4\u4ef6\u5e93\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_39", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName);
            return msg;
        }
        DynamicObject chapter = QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"id,name,number,entryentity,template.id,template.name,template.templatecatalog.catalogtype,group.id", (QFilter[])new QFilter[]{new QFilter("entryentity.module", "=", (Object)moduleId)});
        if (chapter == null) {
            return msg;
        }
        Long chapterId = chapter.getLong("id");
        if (chapterId == null || chapterId <= 0L) {
            return msg;
        }
        if (chapter.getLong("template.id") > 0L) {
            String catalogtype = chapter.getString("template.templatecatalog.catalogtype");
            msg = "2".equals(catalogtype) ? String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u5206\u6790\u8bbe\u8ba1\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_31", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName, chapter.getString("template.name")) : String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u62a5\u544a\u6a21\u677f\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_26", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName, chapter.getString("template.name"));
            return msg;
        }
        if (chapter.getLong("group.id") > 0L) {
            msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u7ae0\u8282\u5e93\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_30", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName, chapter.getString("name"));
        }
        if ((report = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,name,entryentity,entryentity.chapter", (QFilter[])new QFilter[]{new QFilter("entryentity.chapter", "=", (Object)chapterId)})) != null) {
            msg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u201c%1$s\u201d\u88ab\u6211\u7684\u62a5\u544a\u201c%2$s\u201d\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DatasetListPlugin_40", (String)"epm-far-formplugin", (Object[])new Object[0]), datasetName, report.getString("name"));
            return msg;
        }
        return msg;
    }

    private void actionCopy() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        AnalysisOpLogParam logParam = this.getSingleLogParam().buildOpName(OperationName.COPY);
        this.getPageCache().put(OperationName.COPY.toString(), logParam.toString());
        Long selectedId = Long.valueOf(selectedRows.get(0).toString());
        if (Objects.equals(DatasetStyleEnum.QUERY, DatasetServiceHelper.getDatasetStyle((long)selectedId))) {
            this.openDataSetDisplay(selectedId, true);
        } else {
            this.openEditPageWithGuide(Long.valueOf(selectedRows.get(0).toString()), "fidm_dataset", true);
        }
    }

    private void openPreviewPage() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long datasetId = (Long)billList.getFocusRowPkId();
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)billList.getEntityType().getName(), (String)"discmodel.id,type");
        String type = obj.getString("type");
        if ("1".equals(type) || "2".equals(type)) {
            ModelStrategy.checkUseModels((Long)datasetId, (String)type);
        }
        DatasetServiceHelper.openPreviewPage((IFormView)this.getView(), (IFormPlugin)this, (long)this.getModelId(), (long)Long.parseLong(selectedRows.get(0).toString()));
    }

    private void actionEnable(boolean enable) {
        DynamicObject[] dyns = this.loadSelectedRows();
        if (dyns == null || dyns.length <= 0) {
            return;
        }
        for (DynamicObject dyn2 : dyns) {
            dyn2.set("status", (Object)(enable ? "1" : "0"));
            dyn2.set("modifier", (Object)Long.parseLong(RequestContext.get().getUserId()));
            dyn2.set("modifytime", (Object)TimeServiceHelper.now());
        }
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        ArrayList formatParamsList = Lists.newArrayListWithCapacity((int)dyns.length);
        Arrays.stream(dyns).forEach(dyn -> formatParamsList.add(new Object[]{model.getString("number"), dyn.getString("number")}));
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATASET).buildFormNumber("fidm_dataset").buildAppId(this.getView()).buildOpResult(OperationResult.SUCCESS).buildFormatParamsList((List)formatParamsList);
        SaveServiceHelper.save((DynamicObject[])dyns);
        if (enable) {
            logParam.buildOpName(OperationName.ENABLE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"DatasetListPlugin_16", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            logParam.buildOpName(OperationName.DISABLE);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"DatasetListPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        AnalysisOpLogHelper.batchWriteOperationLog((AnalysisOpLogParam)logParam);
        this.refreshBillList();
    }

    private DynamicObject[] loadSelectedRows() {
        Set<Long> selectedRowIds = this.getSelectedRowIds();
        if (selectedRowIds == null || selectedRowIds.size() <= 0) {
            return null;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", selectedRowIds);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"fidm_dataset", (String)"id,number,status,type,modifier,modifytime", (QFilter[])qfBuilder.toArray());
        if (dyns == null || dyns.length <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\u3002", (String)"DatasetListPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return null;
        }
        return dyns;
    }

    private Set<Long> getSelectedRowIds() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"DatasetListPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return null;
        }
        HashSet<Long> idList = new HashSet<Long>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            idList.add(Long.valueOf(selectedRow.toString()));
        }
        return idList;
    }

    protected void setButtonEnable(Boolean status) {
        this.getView().setEnable(status, new String[]{"btn_copy"});
        this.getView().setEnable(status, new String[]{"btn_del"});
        this.getView().setEnable(status, new String[]{"btn_enable"});
        this.getView().setEnable(status, new String[]{"btn_disable"});
    }

    private void createRootCategoryData(Long modelId) {
        QFilter mqFilter = new QFilter("model", "=", (Object)modelId);
        QFilter nqFilter = new QFilter("number", "=", (Object)"root");
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"far_datasetcategory", (QFilter[])new QFilter[]{mqFilter, nqFilter});
        if (catalog == null) {
            catalog = BusinessDataServiceHelper.newDynamicObject((String)"far_datasetcategory");
            catalog.set("model", (Object)modelId);
            catalog.set("number", (Object)"root");
            catalog.set("longnumber", (Object)"root");
            catalog.set("name", (Object)ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5206\u7c7b", (String)"DatasetListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            catalog.set("isleaf", (Object)Boolean.TRUE);
            catalog.set("status", (Object)"C");
            catalog.set("enable", (Object)"1");
            SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
        }
    }

    private TreeNode createRootNode(Long modelId, Boolean needCache) {
        TreeNode root = new TreeNode();
        QFilter numberFilter = new QFilter("number", "=", (Object)"root");
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{numberFilter, modelFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"far_datasetcategory", (String)"id", (QFilter[])filters);
        String rootNodeId = dynamicObject.getString("id");
        root.setId(rootNodeId);
        if (needCache.booleanValue()) {
            this.getPageCache().put(FOCUSNODEID, rootNodeId);
            this.getPageCache().put(ROOTNODEID, rootNodeId);
        }
        root.setParentid("");
        root.setIcon("kdfont kdfont-wenjianjia");
        root.setText(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5206\u7c7b", (String)"DatasetListPlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
        return root;
    }

    private List<Map<String, String>> buildTreeList(Long modelId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        String appNum = ApplicationTypeEnum.getEnumByNumber((String)this.getBizAppId()).getAppnum();
        QFilter permqFilter = PermissionHelper.getReadAndWritePermFilterWithAppNum((long)modelId, (String)"far_datasetcategory", (String)appNum);
        qFilters.add(permqFilter);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"far_datasetcategory", (String)"id,name,number,parent,parent.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence");
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(dynamicObjectCollection.size());
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Long nodeId = dynamicObject.getLong("id");
            String nodeName = dynamicObject.getString("name");
            String nodeNumber = dynamicObject.getString("number");
            Long parentNodeId = dynamicObject.getLong("parent.id");
            HashMap<String, String> nodeMap = new HashMap<String, String>(5);
            nodeMap.put("id", String.valueOf(nodeId));
            nodeMap.put("name", nodeName);
            nodeMap.put("number", nodeNumber);
            nodeMap.put("parentid", String.valueOf(parentNodeId));
            nodeMap.put("type", "catalog");
            treeList.add(nodeMap);
        }
        return treeList;
    }

    private boolean isRootNode(String nodeId) {
        return nodeId.equals(this.getPageCache().get(ROOTNODEID));
    }

    private void billListHyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.checkPerm("btn_edit");
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        Long selectId = (Long)list.getFocusRowPkId();
        DatasetStyleEnum style = DatasetServiceHelper.getDatasetStyle((long)selectId);
        if (Objects.equals(DatasetStyleEnum.QUERY, style)) {
            this.openDataSetDisplay(selectId, false);
        } else {
            this.openEditPageWithGuide(selectId, list.getEntityType().getName(), false);
        }
    }

    private Boolean hasFdata(Long datasetId) {
        DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)datasetId);
        String data = singleDS.getString("data");
        if (StringUtils.isBlank((CharSequence)data)) {
            return false;
        }
        DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        return DatasetUtil.checkDataSetVoExist((DatasetDataVo)vo);
    }

    private void openEditPageWithGuide() {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long selectedId = Long.valueOf(selectedRows.get(0).toString());
        this.openEditPageWithGuide(Long.valueOf(selectedRows.get(0).toString()), "fidm_dataset", true);
    }

    private void openEditPageWithGuide(Long datasetId, String entityName, boolean isCopy) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)entityName, (String)"discmodel.id,type");
        FormShowParameter fsp = new FormShowParameter();
        String type = obj.getString("type");
        if ("1".equals(type) || "2".equals(type)) {
            Boolean exist = this.hasFdata(datasetId);
            if (exist.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u4e0d\u652f\u6301\u4ee5\u5411\u5bfc\u5f0f\u6253\u5f00\u3002", (String)"DatasetListPlugin_48", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            fsp.setFormId("fidm_dataset_single_edit");
            ModelStrategy.checkUseModels((Long)datasetId, (String)type);
        } else {
            fsp.setFormId("fidm_dataset_multivalue_n");
        }
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        if (isCopy) {
            fsp.setCaption(ResManager.loadKDString((String)"\u590d\u5236\u6570\u636e\u96c6", (String)"DatasetListPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else {
            fsp.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u6570\u636e\u96c6", (String)"DatasetListPlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATASET_NEW_CLOSE));
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setCustomParam("dataset_id", (Object)("" + datasetId));
        fsp.setCustomParam("dmmodelid", (Object)("" + obj.getString("discmodel.id")));
        fsp.setCustomParam("scope", (Object)"1");
        fsp.setCustomParam("type", (Object)type);
        fsp.setCustomParam("isCopy", (Object)isCopy);
        fsp.setCustomParam(ISDATASETREADONLY, (Object)this.getPageCache().get(ISDATASETREADONLY));
        this.getView().showForm(fsp);
    }

    private void checkAdmin(Long datasetId) {
        DynamicObject dataset = QueryServiceHelper.queryOne((String)"fidm_dataset_single", (String)"id,datasrctype,datasrcid", (QFilter[])new QFilter(ISDATASETREADONLY, "=", (Object)datasetId).toArray());
        if (Objects.isNull(dataset)) {
            return;
        }
        Long modelId = dataset.getLong("datasrcid");
        IModel farModel = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.getModelType((String)dataset.getString("datasrctype"), (Long)modelId));
        if (!farModel.isAdmin(modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u6570\u636e\u6765\u6e90\u4f53\u7cfb\u6743\u9650,\u65e0\u6cd5\u64cd\u4f5c\u8be5\u6570\u636e\u96c6\u3002", (String)"DatasetListPlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public long getModelId() {
        String modelId = this.getPageCache().get("dmmodelid");
        if (StringUtils.isEmpty((CharSequence)modelId)) {
            return this.getDMModelId();
        }
        return Long.parseLong(modelId);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        if (billList.getSelectedRows().size() > 0) {
            Object[] selectNodeIds = billList.getSelectedRows().getPrimaryKeyValues();
            List<Long> readOnlyIds = this.getReadOnlyIds();
            boolean hasOnlyReadNode = false;
            for (Object selectNode : selectNodeIds) {
                if (!readOnlyIds.contains(LongUtil.toLong((Object)selectNode))) continue;
                hasOnlyReadNode = true;
                break;
            }
            if (hasOnlyReadNode) {
                this.setButtonEnable(Boolean.FALSE);
                this.getPageCache().put(ISDATASETREADONLY, "true");
            } else {
                this.setButtonEnable(Boolean.TRUE);
                this.getPageCache().put(ISDATASETREADONLY, "false");
            }
        } else {
            this.setButtonEnable(Boolean.TRUE);
        }
    }

    private List<Long> getReadOnlyIds() {
        if (this.getPageCache().get(READONLYDATASET) == null) {
            ArrayListMultimap permMap = PermClassEntityHelper.getDiscPermissionMap((String)"fidm_dataset", (Long)this.getDMModelId(), (Long)this.getUserId(), (String)this.getBizAppId());
            List onlyReadIds = permMap.get((Object)"2");
            this.getPageCache().put(READONLYDATASET, SerializationUtils.toJsonString((Object)onlyReadIds));
            return onlyReadIds;
        }
        String readOnlyListSeriallize = this.getPageCache().get(READONLYDATASET);
        List onlyReadIds = (List)SerializationUtils.fromJsonString((String)readOnlyListSeriallize, List.class);
        return onlyReadIds;
    }

    @Override
    public String getModelSign() {
        return ctl_discmodel;
    }

    private AnalysisOpLogParam getSingleLogParam() {
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATASET).buildFormNumber("fidm_dataset").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString("number")});
    }

    private AnalysisOpLogParam getMultiLogParam(int size) {
        return new AnalysisOpLogParam(size).buildOpCategory(OperationCategory.DATASET).buildFormNumber("fidm_dataset").buildAppId(this.getView()).buildOpName(OperationName.DELETE);
    }

    private AnalysisOpLogParam getMoveMultiLogParam(int size) {
        return new AnalysisOpLogParam(size).buildOpCategory(OperationCategory.DATASETCATEGORY).buildFormNumber("far_datasetcategory").buildAppId(this.getView()).buildOpName(OperationName.MOVE_DATASET_CATALOG);
    }

    private AnalysisOpLogParam getDelCategoryMultiLogParam(int size) {
        return new AnalysisOpLogParam(size).buildOpCategory(OperationCategory.DATASETCATEGORY).buildFormNumber("far_datasetcategory").buildAppId(this.getView()).buildOpName(OperationName.DELETE_DATASET_CATALOG);
    }

    private AnalysisOpLogParam getCategorySingleLogParam(String categoryName, String categoryNumber) {
        DynamicObject model = QueryServiceHelper.queryOne((String)"fidm_model", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getDMModelId())});
        return new AnalysisOpLogParam().buildOpCategory(OperationCategory.DATASETCATEGORY).buildFormNumber("far_datasetcategory").buildAppId(this.getView()).buildFormatParams(new Object[]{model.getString("number"), categoryNumber});
    }
}

