/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.bcm.BCMDimensionHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dimension.BCMMemberReader;
import kd.epm.far.business.bcm.dto.BCMMemberTreeNode;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.dataset.dto.DatasetCalculateVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetEntityVo;
import kd.epm.far.business.common.dataset.dto.DatasetJoinVo;
import kd.epm.far.business.common.dataset.dto.DatasetRenameVo;
import kd.epm.far.business.common.dataset.dto.DatasetVarAndDim;
import kd.epm.far.business.common.dataset.dto.SourceEntityVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetMutilExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmDimMemberEntityEnum;
import kd.epm.far.business.common.enums.FidmDataTypeEnum;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.f7.dto.MutilF7MemberResult;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DefinedImpSourceEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.faranalysis.AnalysisDesignConstants;
import org.apache.commons.collections.CollectionUtils;

public class DatasetManagePlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage {
    private static final String DIM_NUM = "dimnum";
    private static final String MEMBER_NUM = "membernum";
    private static final String GROUP = "group";
    private static final String ORDER = "order";
    private static final String TOP = "top";
    private static final String ASC = "asc";
    private static final String CACHE_COLUMNS = "cache_columns";
    private static final String CALCULATE_ENTRY_ENTITY = "calculateentryentity";
    protected static final String DIMENSION_NUMBER_MAP_CACHE = "dimension_number_map_cache";
    private static final String JOIN_ENTRY_ENTITY = "joinentryentity";
    private static final String CALCULATE_NUMBER = "calnumber";
    private static final String CALCULATE_NAME = "calname";
    private static final String CALCULATE_EXPRESSION = "calexpression";
    private static final String JOIN_NUMBER = "joinnumber";
    private static final String JOIN_SOURCE = "joinsource";
    private static final String JOIN_FIELD = "joinfield";
    private static final String JOIN_SELECT_FIELDS = "joinselectfields";
    private static final String JOIN_SELECT_FIELDS_NUM = "selectfields";
    private static final String PARAM_PANEL = "parampanel";
    private static final String ALL_DIM_MAP_CACHE = "allDimMap";
    private static final String DIM_F7_MAP = "dimf7map";
    private static final String DTO_CACHE = "dto_cache";
    private static final String JOIN_CLOSE = "joinclose";
    private static final String CALCULATE_CLOSE = "calculateclose";
    private static final String SELECT_MEMBER_CLOSE = "selectMemberClose";
    private static final String BTN_SAVE = "btn_save";
    private static final String BTN_QUERY = "btn_query";
    private static final String TOOL_BARAP = "toolbarap";
    private static final String TOOL_BARAP1 = "toolbarap1";
    private static final String CUSTOM_CONTROL_AP = "customcontrolap";
    private static final String CUSTOM_DATA_CONTROL_AP = "datacustomcontrolap";
    private static final String SHOW_SETTING_AP = "flexpanelap3";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(CALCULATE_EXPRESSION, JOIN_SELECT_FIELDS, MEMBER_NUM);
        this.addItemClickListeners(TOOL_BARAP, TOOL_BARAP1);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_save": {
                this.sendToCustom(null, AnalysisDesignConstants.PropsDataType.DATA_MANAGE_GETCOLUMN.toString(), CUSTOM_DATA_CONTROL_AP);
                break;
            }
            case "btn_query": {
                this.showResults();
            }
        }
    }

    private void buildParams(DatasetDto dto) {
        String s = this.getPageCache().get(DIMENSION_NUMBER_MAP_CACHE);
        if (s == null) {
            return;
        }
        Map dimensionNumberMap = (Map)this.deSerializedBytes(s);
        if (dimensionNumberMap == null || dimensionNumberMap.isEmpty()) {
            return;
        }
        DisModelTypeEnum typeEnum = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
        String expression = dto.getExpression();
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
        ModelStrategyEx strategyEx = new ModelStrategyEx(dto.getDataSrcId(), modelType.getType());
        Map<String, String> numberMap = strategyEx.getDim().getDimList().stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, DimensionInfo::getNumber, (k1, k2) -> k1));
        String[] split = expression.split(",");
        StringBuilder sb = new StringBuilder();
        for (String ex : split) {
            Object dyn;
            if (!ex.contains(".")) continue;
            String[] dimAndMembers = ex.split("\\.");
            String shortNumber = dimAndMembers[0];
            String dimNumber = numberMap.get(shortNumber);
            String member = dimAndMembers[1];
            if (member.contains("{")) {
                member = member.substring(1, member.length());
            }
            if ("$Cur".equals(member)) {
                sb.append(shortNumber).append(".");
                dyn = this.getModel().getValue(dimNumber);
                if (dyn == null) {
                    DimDefaultValueVo defaultValue = DimDefaultValueHelper.getDefaultValue((String)shortNumber, (Long)dto.getDataSrcId(), (DisModelTypeEnum)typeEnum, (String)dto.getEbDataset());
                    sb.append(defaultValue.getDefaultValue());
                } else {
                    String memberValue = ((DynamicObject)dyn).getString("number");
                    sb.append(memberValue);
                }
                sb.append(",");
                continue;
            }
            if ("$Curs".equals(member)) {
                sb.append(shortNumber).append(".");
                dyn = this.getModel().getValue(dimNumber);
                HashSet curs = Sets.newHashSetWithExpectedSize((int)16);
                if (((DynamicObjectCollection)dyn).size() == 0) {
                    DimDefaultValueVo defaultValue = DimDefaultValueHelper.getDefaultValue((String)shortNumber, (Long)dto.getDataSrcId(), (DisModelTypeEnum)typeEnum, (String)dto.getEbDataset());
                    List defaultCurs = defaultValue.getDefaultCurs();
                    defaultCurs.forEach(t -> {
                        if (t.getRange() == RangeEnum.VALUE_10.getValue()) {
                            curs.add(t.getNumber());
                        } else {
                            String modelNumber = BCMDimensionHelper.findModelNumberById((Object)dto.getDataSrcId());
                            Set result = BCMMsServiceHelper.batchGetMemberNumbers((String)modelNumber, (String)dimNumber, (String)t.getNumber(), (RangeEnum)RangeEnum.getRangeByVal((int)t.getRange()));
                            curs.addAll(result);
                        }
                    });
                    if (curs.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"", (String)"", (String)"", (Object[])new Object[0]));
                    }
                    sb.append("{").append(Joiner.on((String)";").join((Iterable)curs)).append("}");
                } else {
                    for (DynamicObject dy : (DynamicObjectCollection)dyn) {
                        DynamicObject memberInfo = dy.getDynamicObject("fbasedataid");
                        String memberValue = memberInfo.getString("number");
                        curs.add(memberValue);
                    }
                    sb.append("{").append(Joiner.on((String)";").join((Iterable)curs)).append("}");
                }
                sb.append(",");
                continue;
            }
            sb.append(ex).append(",");
        }
        dto.setExpression(sb.substring(0, sb.length() - 1));
    }

    private void showResults() {
        DatasetDto dto = this.buildDatasetDto();
        this.buildParams(dto);
        Object result = DatasetUtil.getResult((DatasetDto)dto);
        HashMap sendData = Maps.newHashMapWithExpectedSize((int)3);
        List dataList = (List)result;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            this.sendToCustomInit(dto);
            return;
        }
        Map<String, Pair<String, String>> numberMap = DatasetManagePlugin.getColumnHeaderMap(dto);
        List columnsByExpression = DatasetUtil.getColumnsByExpression((DatasetDto)dto);
        Map<String, String> nameMap = columnsByExpression.stream().collect(Collectors.toMap(map -> {
            String number = map.get("number").toString();
            if (number.contains("=")) {
                return number.split("=")[1].replace("'", "");
            }
            return number;
        }, map -> map.get("name").toString(), (k1, k2) -> k1));
        boolean hasSpecialHeader = false;
        List calculateVos = dto.getManageVo().getCalculateVos();
        HashSet calculateNumbers = Sets.newHashSetWithExpectedSize((int)16);
        calculateVos.forEach(t -> calculateNumbers.add(t.getNumber()));
        ArrayList columnHeader = Lists.newArrayListWithExpectedSize((int)((Map)dataList.get(0)).size());
        for (String s : ((Map)dataList.get(0)).keySet()) {
            HashMap header = Maps.newHashMapWithExpectedSize((int)2);
            header.put("name", nameMap.get(s));
            header.put("number", s);
            if (numberMap.containsKey(s)) {
                hasSpecialHeader = true;
                Pair<String, String> pair = numberMap.get(s);
                header.put("showName", pair.p1);
                header.put("entityName", pair.p2);
            }
            if (calculateNumbers.contains(s)) {
                header.put("canEdit", "false");
            } else {
                header.put("canEdit", "true");
            }
            columnHeader.add(header);
        }
        ArrayList data = Lists.newArrayListWithExpectedSize((int)dataList.size());
        for (Map map2 : dataList) {
            ArrayList returnData = Lists.newArrayListWithExpectedSize((int)map2.size());
            for (Map stringMap : columnHeader) {
                Object o = stringMap.get("number");
                if (Objects.isNull(o)) {
                    returnData.add(null);
                    continue;
                }
                Object value = map2.get(o.toString());
                if (Objects.isNull(value)) {
                    returnData.add(null);
                    continue;
                }
                returnData.add(value.toString());
            }
            data.add(returnData);
        }
        sendData.put("data", data);
        sendData.put("hasSpecialHeader", hasSpecialHeader);
        sendData.put("columnHeader", columnHeader);
        this.sendToCustom(sendData, AnalysisDesignConstants.PropsDataType.DATA_MANAGE_PREVIEW.toString(), CUSTOM_DATA_CONTROL_AP);
    }

    private Map<String, String> getFinalColumns() {
        Map<String, String> finalColumns = this.getBaseColmuns();
        List joinVoList = this.getEntityList(true);
        for (DatasetJoinVo joinVo : joinVoList) {
            if (StringUtils.isBlank((CharSequence)joinVo.getEntityName())) continue;
            Map<String, IDataEntityProperty> allFields = this.getAllFields(joinVo.getEntityName());
            for (String selectField : joinVo.getSelectFields()) {
                if (!allFields.containsKey(selectField)) continue;
                String column = joinVo.getEntityName() + "." + selectField;
                String name = allFields.get(selectField).getDisplayName().getLocaleValue();
                if (finalColumns.containsKey(column)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201c,\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7f16\u7801\u5b58\u5728\u91cd\u590d,\u8bf7\u5220\u9664\u3002", (String)"DatasetManagePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), column, name));
                }
                finalColumns.put(column, name);
            }
        }
        List calculateList = this.getEntityList(false);
        for (DatasetCalculateVo vo : calculateList) {
            if (StringUtils.isBlank((CharSequence)vo.getNumber())) continue;
            String column = vo.getNumber();
            String name = vo.getName().toString();
            if (finalColumns.containsKey(column)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201c,\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7f16\u7801\u5b58\u5728\u91cd\u590d,\u8bf7\u5220\u9664\u3002", (String)"DatasetManagePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), column, name));
            }
            finalColumns.put(vo.getNumber(), vo.getName().toString());
        }
        return finalColumns;
    }

    private Map<String, String> getBaseColmuns() {
        HashMap finalColumns = Maps.newHashMapWithExpectedSize((int)16);
        List<Map<String, Object>> oriColumns = this.getOriColumns(this.getDatasetDto());
        String dimNum = (String)this.getModel().getValue(DIM_NUM);
        String memNum = (String)this.getModel().getValue(MEMBER_NUM);
        DatasetUtil.addTransformRow((String)dimNum, (String)memNum, (Long)this.getDatasetDto().getDataSrcId(), oriColumns, Collections.emptyMap(), (String)this.getDatasetDto().getEbDataset());
        Map<String, String> groupMap = this.getGroupMap(this.getModel().getValue(GROUP));
        for (Map<String, Object> oriColumn : oriColumns) {
            if (FidmDataTypeEnum.getMeasureList().contains(oriColumn.get("type").toString())) {
                finalColumns.put(oriColumn.get("number").toString(), oriColumn.get("name").toString());
                continue;
            }
            if (groupMap.isEmpty()) {
                finalColumns.put(oriColumn.get("number").toString(), oriColumn.get("name").toString());
                continue;
            }
            String number = oriColumn.get("number").toString();
            if (groupMap.containsKey(number)) {
                finalColumns.put(oriColumn.get("number").toString(), oriColumn.get("name").toString());
                continue;
            }
            Object source = oriColumn.get("source");
            if (!Objects.nonNull(source) || !groupMap.containsKey(source.toString())) continue;
            finalColumns.put(oriColumn.get("number").toString(), oriColumn.get("name").toString());
        }
        return finalColumns;
    }

    private <T> List<T> getEntityList(boolean isJoin) {
        EntryGrid entryGrid;
        DynamicObject[] dataEntitys;
        String entity = CALCULATE_ENTRY_ENTITY;
        if (isJoin) {
            entity = JOIN_ENTRY_ENTITY;
        }
        if (Objects.isNull(dataEntitys = (entryGrid = (EntryGrid)this.getControl(entity)).getEntryData().getDataEntitys()) || dataEntitys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList returnList = Lists.newArrayListWithExpectedSize((int)dataEntitys.length);
        for (DynamicObject dy : dataEntitys) {
            if (isJoin) {
                returnList.add(DatasetUtil.getJoinVo((DynamicObject)dy));
                continue;
            }
            returnList.add(DatasetUtil.getCalculateVo((DynamicObject)dy));
        }
        return returnList;
    }

    @Override
    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "membernum": {
                this.openSelectPage();
                break;
            }
            case "calexpression": {
                this.openCalculatePage();
                break;
            }
            case "joinselectfields": {
                this.openJoinPage();
            }
        }
    }

    private void openSelectPage() {
        String dimnum = TypeConversionUtil.getStringValue((String)DIM_NUM, (IDataModel)this.getModel());
        if (StringUtils.isBlank((CharSequence)dimnum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7ef4\u5b57\u6bb5\u3002", (String)"DatasetSingleEditPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        DatasetDto datasetDto = this.getDatasetDto();
        Long modelId = datasetDto.getDataSrcId();
        List memeberNumberList = Lists.newArrayListWithExpectedSize((int)100);
        if (!StringUtils.isEmpty((CharSequence)TypeConversionUtil.getStringValue((String)MEMBER_NUM, (IDataModel)this.getModel()))) {
            memeberNumberList = JSON.parseArray((String)TypeConversionUtil.getStringValue((String)MEMBER_NUM, (IDataModel)this.getModel()), String.class);
        }
        String modelTypeEnumStr = DisModelTypeEnum.getModelType((String)datasetDto.getDataSrcType(), (Long)modelId).getType();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, modelTypeEnumStr);
        DimensionInfo dim = DimensionUtils.getDimByNumber((List)modelStrategyEx.getDim().getDimList(), (String)dimnum);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_MEMBER_CLOSE);
        modelStrategyEx.getDimensionF7().openMutilF7((AbstractFormPlugin)this, dim, memeberNumberList, closeCallBack, false);
    }

    public void customEvent(CustomEventArgs evt) {
        JSONObject jsonObject;
        super.customEvent(evt);
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_CALCULATE_EXPRESSION.toString()) && Objects.nonNull(eventArgs)) {
            jsonObject = JSON.parseObject((String)eventArgs);
            JSONObject result = jsonObject.getJSONObject("result");
            this.getModel().setValue(CALCULATE_EXPRESSION, (Object)result.getString("data"), result.getIntValue("index"));
        }
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_CALCULATE_EXPRESSION_CEHCK.toString())) {
            boolean checkResult = true;
            JSONObject jsonObject2 = JSON.parseObject((String)eventArgs);
            JSONObject result = jsonObject2.getJSONObject("result");
            String expression = result.getString("data");
            HashSet columns = Sets.newHashSet(this.getBaseColmuns().keySet());
            Set measureSet = this.getMeasureList().stream().map(t -> (String)t.get("number")).collect(Collectors.toSet());
            columns.removeAll(measureSet);
            try {
                DatasetMutilExpressionHelper.checkExpression((String)expression, (Set)columns, measureSet);
            }
            catch (Exception e) {
                checkResult = false;
            }
            this.sendToCustom(checkResult, AnalysisDesignConstants.PropsDataType.DATA_CALCULATE_EXPRESSION_CHECK.toString(), CUSTOM_CONTROL_AP);
        }
        if (eventName.equals(AnalysisDesignConstants.CallBackType.EVENT_MANAGE_GETCOLUMN.toString())) {
            jsonObject = JSON.parseObject((String)eventArgs);
            this.editDatset(jsonObject);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DatasetSingleNewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void editDatset(JSONObject jsonObject) {
        DatasetDto dto = this.buildDatasetDto();
        if (Objects.nonNull(jsonObject)) {
            JSONArray jsonArray = jsonObject.getJSONArray("result");
            Map<String, String> renameMap = this.getFinalColumns();
            ArrayList renameVos = Lists.newArrayListWithExpectedSize((int)16);
            for (Object o : jsonArray) {
                JSONObject res = (JSONObject)o;
                String number = res.getString("number");
                String name = res.getString("name");
                if (Objects.equals(name, renameMap.get(number))) continue;
                DatasetRenameVo datasetRenameVo = new DatasetRenameVo();
                datasetRenameVo.setNumber(number);
                datasetRenameVo.setName((Object)new LocaleString(name));
                renameVos.add(datasetRenameVo);
            }
            dto.getManageVo().setRenameVos((List)renameVos);
        }
        DatasetServiceHelper.editDataset((DatasetDto)dto, (IDataModel)this.getModel());
    }

    private void openCalculatePage() {
        int rowKey = this.getAndCheckSelectRow(CALCULATE_ENTRY_ENTITY);
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("result", this.getModel().getValue(CALCULATE_EXPRESSION, rowKey));
        data.put("column", this.getMeasureList());
        data.put("index", rowKey);
        this.sendToCustom(data, AnalysisDesignConstants.PropsDataType.DATA_CALCULATE_EXPRESSION.toString(), CUSTOM_CONTROL_AP);
    }

    private void sendToCustom(Object data, String dataType, String customControl) {
        CustomControl custom = (CustomControl)this.getView().getControl(customControl);
        JSONObject dataObj = new JSONObject();
        dataObj.put("dataType", (Object)dataType);
        dataObj.put("data", data);
        dataObj.put("t", (Object)TimeServiceHelper.now());
        custom.setData((Object)dataObj);
    }

    private List<Map<String, String>> getMeasureList() {
        DatasetDto dto = this.getDatasetDto();
        String dimNum = Objects.nonNull(this.getModel().getValue(DIM_NUM)) ? this.getModel().getValue(DIM_NUM).toString() : "";
        String memberNum = Objects.nonNull(this.getModel().getValue(MEMBER_NUM)) ? this.getModel().getValue(MEMBER_NUM).toString() : "";
        ArrayList measureList = Lists.newArrayListWithExpectedSize((int)16);
        if (StringUtils.isNotEmpty((CharSequence)memberNum)) {
            List memberNumList = (List)SerializationUtils.fromJsonString((String)memberNum, List.class);
            if (StringUtils.isNotEmpty((CharSequence)dto.getEbDataset())) {
                DynamicObject model = EbServiceHelper.getModel((Long)dto.getDataSrcId());
                for (String member : memberNumList) {
                    List memberList = EbServiceHelper.getMember((String)model.getString("shownumber"), (String)dto.getEbDataset(), (String)dimNum, (String)member, (RangeEnum)RangeEnum.VALUE_10);
                    if (!CollectionUtils.isNotEmpty((Collection)memberList)) continue;
                    HashMap measureMap = Maps.newHashMapWithExpectedSize((int)2);
                    measureMap.put("number", member);
                    measureMap.put("name", ((EbMember)memberList.get(0)).getName());
                    measureList.add(measureMap);
                }
            } else {
                String modelNumber = BCMMemberReader.findModelNumberById((Object)dto.getDataSrcId());
                for (String member : memberNumList) {
                    BCMMemberTreeNode memberByNumber = BCMMemberReader.findMemberByNumber((String)modelNumber, (String)dimNum, (String)member);
                    if (Objects.equals(BCMMemberTreeNode.NotFoundTreeNode, memberByNumber)) continue;
                    HashMap measureMap = Maps.newHashMapWithExpectedSize((int)2);
                    measureMap.put("number", member);
                    measureMap.put("name", memberByNumber.getName());
                    measureList.add(measureMap);
                }
            }
            return measureList;
        }
        List<Map<String, Object>> oriColumns = this.getOriColumns(dto);
        for (Map<String, Object> oriColumn : oriColumns) {
            String number = oriColumn.get("number").toString();
            String type = oriColumn.get("type").toString();
            if (!FidmDataTypeEnum.getMeasureList().contains(type)) continue;
            HashMap measureMap = Maps.newHashMapWithExpectedSize((int)2);
            measureMap.put("number", number);
            measureMap.put("name", oriColumn.get("name").toString());
            measureList.add(measureMap);
        }
        return measureList;
    }

    private void initOnCombo() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)3);
        items.add(new ComboItem(new LocaleString("ID"), "id"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"DataSetDisplayPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0])), "number"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataSetDisplayPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0])), "name"));
        ComboEdit fieldComboEdit = (ComboEdit)this.getControl(JOIN_FIELD);
        fieldComboEdit.setComboItems((List)items);
    }

    private void initSourceCombo() {
        ComboEdit comboEdit = (ComboEdit)this.getControl(JOIN_SOURCE);
        Map allSource = DefinedImpSourceEnum.getAllSource();
        ArrayList items = Lists.newArrayListWithExpectedSize((int)allSource.size());
        for (Map.Entry entry : allSource.entrySet()) {
            items.add(new ComboItem(new LocaleString(((DefinedImpSourceEnum)entry.getValue()).getName()), (String)entry.getKey()));
        }
        comboEdit.setComboItems((List)items);
    }

    private int getAndCheckSelectRow(String entity) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entity);
        int[] selectedRows = entryGrid.getSelectRows();
        if (selectedRows.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return selectedRows[0];
    }

    private void openJoinPage() {
        int rowKey = this.getAndCheckSelectRow(JOIN_ENTRY_ENTITY);
        Object value = this.getModel().getValue(JOIN_SOURCE, rowKey);
        if (Objects.isNull(value)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DatasetListPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("fidm_dataset_join");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(JOIN_SOURCE, this.getModel().getValue(JOIN_SOURCE, rowKey));
        fsp.setCustomParam(JOIN_SELECT_FIELDS_NUM, this.getModel().getValue(JOIN_SELECT_FIELDS_NUM, rowKey));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "joinclose_" + rowKey));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (Objects.isNull(returnData)) {
            return;
        }
        if (actionId.startsWith(JOIN_CLOSE)) {
            String[] s = actionId.split("_");
            Map map = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
            this.getModel().setValue(JOIN_SELECT_FIELDS, (Object)String.join((CharSequence)",", map.values()), Integer.parseInt(s[1]));
            this.getModel().setValue(JOIN_SELECT_FIELDS_NUM, (Object)String.join((CharSequence)",", map.keySet()), Integer.parseInt(s[1]));
        }
        if (actionId.equals(SELECT_MEMBER_CLOSE)) {
            this.setMemberNum(evt.getReturnData());
        }
    }

    private DatasetDto getDatasetDto() {
        String dtoStr = this.getPageCache().get(DTO_CACHE);
        if (StringUtils.isBlank((CharSequence)dtoStr)) {
            Long datasetId = (Long)this.getView().getFormShowParameter().getCustomParam("datasetId");
            DatasetDto dto = DatasetUtil.getSingleDataSetDto((Long)datasetId);
            this.getPageCache().put(DTO_CACHE, JSON.toJSONString((Object)dto));
            return dto;
        }
        return (DatasetDto)JSON.parseObject((String)dtoStr, (TypeReference)new TypeReference<DatasetDto>(){}, (Feature[])new Feature[0]);
    }

    private void setMemberNum(Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        DatasetDto datasetDto = this.getDatasetDto();
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)datasetDto.getDataSrcType(), (Long)datasetDto.getDataSrcId());
        MutilF7MemberResult mutilF7MemberResult = new ModelStrategyEx(datasetDto.getDataSrcId(), modelType.getType()).getDimensionF7().getMutilF7MemberList((AbstractFormPlugin)this, returnData);
        if (mutilF7MemberResult.getMemberInfos().size() > 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u6210\u5458\u6700\u591a\u9009\u62e95\u4e2a\u3002", (String)"DatasetSingleEditPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        List memberList = mutilF7MemberResult.getMemberInfos().stream().map(DimMemberInfo::getNumber).collect(Collectors.toList());
        this.getModel().setValue(MEMBER_NUM, (Object)SerializationUtils.toJsonString(memberList));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DatasetDto dto = this.getDatasetDto();
        if (Objects.equals(DataSrcTypeEnum.CM_TEMPLATE.getType(), dto.getDataSrcType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SHOW_SETTING_AP});
        }
        this.buildParamPanel(dto);
        List<Map<String, Object>> columns = this.getOriColumns(dto);
        Map<String, String> groupMap = this.getGroupMap(dto.getGroupBy());
        this.buildComboEdit(GROUP, columns, groupMap.keySet());
        this.buildComboEdit(ORDER, columns, groupMap.keySet());
        this.buildDimComboEdit(dto, columns, groupMap);
        this.getModel().setValue(GROUP, (Object)dto.getGroupBy());
        this.getModel().setValue(ORDER, (Object)dto.getOrderBy());
        this.getModel().setValue(TOP, (Object)dto.getTop());
        this.getModel().setValue(ASC, (Object)dto.getAsc());
        this.getModel().setValue(DIM_NUM, (Object)dto.getDimNum());
        this.getModel().setValue(MEMBER_NUM, (Object)dto.getMemberNum());
        this.initSourceCombo();
        this.initOnCombo();
        this.initCalcalateEntity();
        this.initJoinEntity(columns);
        this.sendToCustomInit(dto);
    }

    private void sendToCustomInit(DatasetDto dto) {
        List columns = DatasetUtil.getColumnsByExpression((DatasetDto)dto, (boolean)false);
        HashMap sendData = Maps.newHashMapWithExpectedSize((int)2);
        boolean hasSpecialHeader = false;
        Map<String, Pair<String, String>> numberMap = DatasetManagePlugin.getColumnHeaderMap(dto);
        ArrayList columnHeader = Lists.newArrayListWithExpectedSize((int)columns.size());
        for (Map column : columns) {
            HashMap header = Maps.newHashMapWithExpectedSize((int)2);
            Object name = column.get("name");
            Object number = column.get("number");
            header.put("name", name);
            header.put("number", number);
            if (numberMap.containsKey(number)) {
                hasSpecialHeader = true;
                Pair<String, String> pair = numberMap.get(number);
                header.put("showName", pair.p1);
                header.put("entityName", pair.p2);
            }
            columnHeader.add(header);
        }
        sendData.put("columnHeader", columnHeader);
        sendData.put("hasSpecialHeader", hasSpecialHeader);
        this.sendToCustom(sendData, AnalysisDesignConstants.PropsDataType.DATA_MANAGE_PREVIEW.toString(), CUSTOM_DATA_CONTROL_AP);
    }

    private static Map<String, Pair<String, String>> getColumnHeaderMap(DatasetDto dto) {
        List joinVos;
        HashMap numberMap = Maps.newHashMapWithExpectedSize((int)16);
        DatasetEntityVo manageVo = dto.getManageVo();
        if (Objects.nonNull(manageVo) && CollectionUtils.isNotEmpty((Collection)(joinVos = manageVo.getJoinVos()))) {
            Map allSource = DefinedImpSourceEnum.getAllSource();
            for (DatasetJoinVo joinVo : joinVos) {
                if (numberMap.containsKey(joinVo.getJoinNumber())) {
                    Pair pair = (Pair)numberMap.get(joinVo.getJoinNumber());
                    numberMap.put(joinVo.getJoinNumber(), new Pair((Object)((String)pair.p1 + ";" + ((DefinedImpSourceEnum)allSource.get(joinVo.getEntityName())).getName()), (Object)((String)pair.p2 + ";" + joinVo.getEntityName())));
                    continue;
                }
                numberMap.put(joinVo.getJoinNumber(), new Pair((Object)((DefinedImpSourceEnum)allSource.get(joinVo.getEntityName())).getName(), (Object)joinVo.getEntityName()));
            }
        }
        return numberMap;
    }

    private void buildDimComboEdit(DatasetDto dto, List<Map<String, Object>> columns, Map<String, String> groupMap) {
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.ISC_METADATA.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(dto.getDataSrcType()) || DataSrcTypeEnum.COMPONENT.getType().equals(dto.getDataSrcType())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DIM_NUM, MEMBER_NUM});
            return;
        }
        if (DataSrcTypeEnum.MERGE_MODEL.getType().equals(dto.getDataSrcType()) && LongUtil.isvalidLong((Object)dto.getExtendsModelId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{DIM_NUM, MEMBER_NUM});
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(DIM_NUM);
        if (!groupMap.isEmpty()) {
            ArrayList items = Lists.newArrayListWithExpectedSize((int)groupMap.size());
            groupMap.entrySet().forEach(entry -> items.add(new ComboItem(new LocaleString((String)entry.getValue()), (String)entry.getKey())));
            comboEdit.setComboItems((List)items);
            return;
        }
        if (CollectionUtils.isEmpty(columns)) {
            comboEdit.setComboItems(Collections.emptyList());
            return;
        }
        ArrayList items = Lists.newArrayListWithExpectedSize((int)columns.size());
        for (Map<String, Object> column : columns) {
            String type = column.get("type").toString();
            if (!Objects.equals(FidmDataTypeEnum.LCD.type, type) && !Objects.equals(FidmDataTypeEnum.LBD.type, type)) continue;
            String number = column.get("number").toString();
            items.add(new ComboItem(new LocaleString(column.get("name").toString()), number));
        }
        comboEdit.setComboItems((List)items);
        this.clearValue(DIM_NUM, MEMBER_NUM);
    }

    private Map<String, String> getGroupMap(Object groupStr) {
        if (StringUtils.isBlank((Object)groupStr)) {
            return Collections.emptyMap();
        }
        String[] split = groupStr.toString().split(",");
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)split.length);
        Map<String, Map<String, String>> columnMap = this.getColumnMap();
        for (String shortNumber : split) {
            if (!columnMap.containsKey(shortNumber)) continue;
            returnMap.put(columnMap.get(shortNumber).get("number"), columnMap.get(shortNumber).get("name"));
        }
        return returnMap;
    }

    private Map<String, String> getEffectiveColumns(List<Map<String, Object>> columns) {
        Map<String, String> groupMap = this.getGroupMap(this.getModel().getValue(GROUP));
        if (!groupMap.isEmpty()) {
            return columns.stream().filter(t -> {
                if (groupMap.containsKey(t.get("number").toString())) {
                    return true;
                }
                return Objects.nonNull(t.get("source")) && groupMap.containsKey(t.get("source").toString());
            }).collect(Collectors.toMap(t -> t.get("number").toString(), t -> t.get("name").toString()));
        }
        String dimNum = Objects.nonNull(this.getModel().getValue(DIM_NUM)) ? this.getModel().getValue(DIM_NUM).toString() : "";
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)columns.size());
        for (Map<String, Object> column : columns) {
            String number = column.get("number").toString();
            String name = column.get("name").toString();
            String source = StringUtils.isNotBlank((Object)column.get("source")) ? column.get("source").toString() : "";
            String type = column.get("type").toString();
            if (StringUtils.isNotBlank((CharSequence)dimNum) && (dimNum.equals(number) || dimNum.equals(source)) || FidmDataTypeEnum.getMeasureList().contains(type)) continue;
            returnMap.put(number, name);
        }
        return returnMap;
    }

    private List<Map<String, Object>> getOriColumns(DatasetDto dto) {
        String s = this.getPageCache().get(CACHE_COLUMNS);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            return (List)JSON.parseObject((String)s, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        }
        List columns = DatasetUtil.getColumnsByExpression((DatasetDto)dto, (boolean)true);
        this.getPageCache().put(CACHE_COLUMNS, JSON.toJSONString((Object)columns));
        return columns;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIM_F7_MAP));
        if (f7DimMap == null || f7DimMap.isEmpty()) {
            return;
        }
        Long dimId = (Long)f7DimMap.get(dimKey);
        DatasetDto datasetDto = this.getDatasetDto();
        Long modelId = datasetDto.getDataSrcId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimId);
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        if (DmDimMemberEntityEnum.BCM_YEAR.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter("number", "not in", Arrays.asList("LastYear", "CurrentYear", "Year", "AllYear")));
        } else if (DmDimMemberEntityEnum.BCM_PERIOD.getNumber().equalsIgnoreCase(dimKey)) {
            filterList.add(new QFilter("number", "not in", Arrays.asList("LastPeriod", "CurrentPeriod")));
        }
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }

    public void onGetControl(OnGetControlArgs e) {
        if (this.getPage(this.getView()) != null) {
            Element element = this.getPage(this.getView()).findElementBySign(e.getKey());
            if (element == null) {
                return;
            }
            Map f7DimMap = (Map)this.deSerializedBytes(this.getPageCache().get(DIM_F7_MAP));
            if (f7DimMap == null || f7DimMap.isEmpty()) {
                return;
            }
            Long dimId = (Long)f7DimMap.get(e.getKey());
            if (!LongUtil.isvalidLong((Object)dimId)) {
                return;
            }
            DatasetDto dto = this.getDatasetDto();
            DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
            Long modelId = dto.getDataSrcId();
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId, modelType.getType());
            String ebDataset = dto.getEbDataset();
            DimensionInfo dimensionInfo = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(), (Long)dimId);
            BasedataEdit f7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, e.getKey(), null, false, ebDataset);
            e.setControl((Control)f7);
            if (element instanceof MultiBaseEditElement) {
                DynamicObjectCollection selected = Objects.isNull(this.getModel().getValue(e.getKey())) ? new DynamicObjectCollection() : (DynamicObjectCollection)this.getModel().getValue(e.getKey());
                MulBasedataEdit mulF7 = modelStrategyEx.getDimensionF7().openComMutilF7(this.getView(), selected, dimensionInfo, ebDataset, (BeforeF7SelectListener)this, e.getKey(), null);
                e.setControl((Control)mulF7);
            } else if (element instanceof BaseEditElement) {
                BasedataEdit singleMemberF7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dimensionInfo, e.getKey(), null, false, ebDataset);
                e.setControl((Control)singleMemberF7);
            }
        }
    }

    private void buildParamPanel(DatasetDto dto) {
        String expression = dto.getExpression();
        if (!DatasetSpecialVarHelper.isContainCurVar((String)expression) && !DatasetSpecialVarHelper.isContainCursVar((String)expression)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{PARAM_PANEL});
            return;
        }
        DatasetVarAndDim result = DatasetServiceHelper.getVarAndDimVar((long)dto.getDiscmodelId(), (long)dto.getId(), (long)dto.getChapterId(), (boolean)true);
        List curShortNumberList = result.getCurShortNumberList();
        List cursShortNumberList = result.getCursShortNumberList();
        Area panel = new Area(PARAM_PANEL);
        this.buildDimPanel(panel, curShortNumberList, true);
        this.buildDimPanel(panel, cursShortNumberList, false);
        Page page = new Page();
        page.addArea(panel);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void buildDimPanel(Area paramPanel, List<String> shortNumberList, boolean isCur) {
        if (CollectionUtils.isEmpty(shortNumberList)) {
            return;
        }
        Map<String, Map<String, String>> allDimMap = this.getColumnMap();
        if (allDimMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u5f53\u524d\u4f53\u7cfb\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"DataSetPreviewPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        for (String shortNumber : shortNumberList) {
            ElementHelper.addBaseEditElement((Area)paramPanel, (String)shortNumber, (boolean)isCur, allDimMap, (IPageCache)this.getPageCache(), (String)DIMENSION_NUMBER_MAP_CACHE);
        }
    }

    private Map<String, Map<String, String>> getColumnMap() {
        String s = this.getPageCache().get(ALL_DIM_MAP_CACHE);
        if (s != null) {
            return (Map)this.deSerializedBytes(s);
        }
        DatasetDto datasetDto = this.getDatasetDto();
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(datasetDto.getDataSrcType()) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(datasetDto.getDataSrcType()) || DataSrcTypeEnum.BCM_ISC_METADATA.getType().equals(datasetDto.getDataSrcType())) {
            List<Map<String, Object>> oriColumns = this.getOriColumns(this.getDatasetDto());
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)oriColumns.size());
            oriColumns.forEach(t -> {
                String number = t.get("number").toString();
                HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                map.put("number", number);
                map.put("name", t.get("name").toString());
                returnMap.put(number, map);
            });
            return returnMap;
        }
        return this.getDimMap(datasetDto);
    }

    private Map<String, Map<String, String>> getDimMap(DatasetDto dto) {
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dto.getDataSrcId(), modelType.getType());
        String dimEntity = modelStrategyEx.getDim().getDimEntity();
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)dimEntity, (String)"id,shortnumber,number,name,membermodel,issysdimension", (QFilter[])new QFilter("model", "=", (Object)dto.getDataSrcId()).toArray(), (String)"dseq");
        HashMap<String, Map<String, String>> allDimMap = new HashMap<String, Map<String, String>>(32);
        HashMap<String, Long> dimF7Map = new HashMap<String, Long>(32);
        for (DynamicObject dyn : dyns) {
            String dimensionId = dyn.getString("id");
            String shortNumber = dyn.getString("shortnumber").toUpperCase(Locale.ENGLISH);
            String dimNumber = dyn.getString("number");
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put("id", dimensionId);
            dimMap.put("name", dyn.getString("name"));
            dimMap.put("shortnumber", shortNumber);
            dimMap.put("number", dimNumber);
            dimMap.put("membermodel", DmDimMemberEntityEnum.getNewEntityNum((String)dyn.getString("membermodel")));
            allDimMap.put(shortNumber, dimMap);
            dimF7Map.put(dimNumber.toLowerCase(Locale.ENGLISH), Long.parseLong(dimensionId));
        }
        if (DisModelTypeEnum.CM == modelType && !dimF7Map.containsKey("SE")) {
            SourceEntityVo sourceEntityVo = new SourceEntityVo();
            HashMap<String, String> dimMap = new HashMap<String, String>(16);
            dimMap.put("id", sourceEntityVo.getNumber());
            dimMap.put("name", sourceEntityVo.getName());
            dimMap.put("shortnumber", sourceEntityVo.getShortNumber());
            dimMap.put("number", sourceEntityVo.getNumber());
            dimMap.put("membermodel", "bcm_entitymembertree");
            allDimMap.put(sourceEntityVo.getShortNumber(), dimMap);
            dimF7Map.put(sourceEntityVo.getNumber().toLowerCase(Locale.ENGLISH), (Long)dimF7Map.get("entity"));
        }
        this.getPageCache().put(DIM_F7_MAP, this.toByteSerialized(dimF7Map));
        return allDimMap;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        switch (propertyName) {
            case "group": {
                this.afterGroupChanged(value);
                break;
            }
            case "dimnum": {
                this.clearValue(MEMBER_NUM);
                List<Map<String, Object>> oriColumns = this.getOriColumns(this.getDatasetDto());
                this.joinEntityCheck(oriColumns);
                break;
            }
            case "joinsource": {
                this.clearValue(JOIN_SELECT_FIELDS, JOIN_SELECT_FIELDS_NUM);
                break;
            }
            case "joinselectfields": {
                if (!StringUtils.isBlank((Object)value)) break;
                this.clearValue(JOIN_SELECT_FIELDS_NUM);
                break;
            }
        }
    }

    private void clearValue(String ... params) {
        for (String param : params) {
            this.getModel().setValue(param, null);
        }
    }

    private void afterGroupChanged(Object value) {
        Map<String, String> groupMap = this.getGroupMap(value);
        List<Map<String, Object>> oriColumns = this.getOriColumns(this.getDatasetDto());
        List<Map<String, Object>> textColumns = oriColumns.stream().filter(t -> !FidmDataTypeEnum.getMeasureList().contains(t.get("type").toString())).collect(Collectors.toList());
        this.buildComboEdit(ORDER, oriColumns, groupMap.isEmpty() ? Collections.emptySet() : groupMap.keySet());
        this.buildDimComboEdit(this.getDatasetDto(), textColumns, groupMap);
        this.joinEntityCheck(oriColumns);
    }

    private void initCalcalateEntity() {
        Long datasetId = (Long)this.getView().getFormShowParameter().getCustomParam("datasetId");
        DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)datasetId);
        DynamicObjectCollection calculateEntity = singleDS.getDynamicObjectCollection("calculateentity");
        if (CollectionUtils.isEmpty((Collection)calculateEntity)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(CALCULATE_ENTRY_ENTITY, calculateEntity.size());
        for (int i = 0; i < calculateEntity.size(); ++i) {
            this.getModel().setValue(CALCULATE_NUMBER, (Object)((DynamicObject)calculateEntity.get(i)).getString(CALCULATE_NUMBER), i);
            this.getModel().setValue(CALCULATE_NAME, (Object)((DynamicObject)calculateEntity.get(i)).getString(CALCULATE_NAME), i);
            this.getModel().setValue(CALCULATE_EXPRESSION, (Object)((DynamicObject)calculateEntity.get(i)).getString(CALCULATE_EXPRESSION), i);
        }
    }

    private DatasetDto buildDatasetDto() {
        IDataModel model = this.getModel();
        DatasetDto datasetDto = this.getDatasetDto();
        datasetDto.setGroupBy((String)model.getValue(GROUP));
        datasetDto.setOrderBy((String)model.getValue(ORDER));
        datasetDto.setTop(Objects.isNull(model.getValue(TOP)) ? null : Integer.valueOf(model.getValue(TOP).toString()));
        datasetDto.setAsc((String)model.getValue(ASC));
        Object dimNum = model.getValue(DIM_NUM);
        if (StringUtils.isNotBlank((Object)dimNum) && StringUtils.isBlank((Object)model.getValue(MEMBER_NUM))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u7ef4\u6210\u5458\u3002", (String)"DatasetSingleEditPlugin_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Map<String, String> baseColmuns = this.getBaseColmuns();
        datasetDto.setDimNum((String)dimNum);
        datasetDto.setMemberNum((String)model.getValue(MEMBER_NUM));
        EntryGrid join = (EntryGrid)this.getControl(JOIN_ENTRY_ENTITY);
        ArrayList joinVoList = Lists.newArrayListWithExpectedSize((int)join.getEntryData().getDataEntitys().length);
        for (int i = 0; i < join.getEntryData().getDataEntitys().length; ++i) {
            DynamicObject dataEntity = join.getEntryData().getDataEntitys()[i];
            DatasetJoinVo datasetJoinVo = new DatasetJoinVo();
            String number = dataEntity.getString(JOIN_NUMBER);
            if (StringUtils.isBlank((CharSequence)number)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String source = dataEntity.getString(JOIN_SOURCE);
            if (StringUtils.isBlank((CharSequence)source)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String joinField = dataEntity.getString(JOIN_FIELD);
            if (StringUtils.isBlank((CharSequence)joinField)) {
                throw new KDBizException(ResManager.loadKDString((String)"join\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String selectFields = dataEntity.getString(JOIN_SELECT_FIELDS_NUM);
            if (StringUtils.isBlank((CharSequence)selectFields)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u51fa\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_7", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            datasetJoinVo.setJoinNumber(number);
            datasetJoinVo.setEntityName(source);
            datasetJoinVo.setOnField(joinField);
            datasetJoinVo.setSeq(Integer.valueOf(i));
            datasetJoinVo.setSelectFieldStr(selectFields);
            String[] split = selectFields.split(",");
            HashSet selectFidlds = Sets.newHashSetWithExpectedSize((int)split.length);
            for (String s : split) {
                String columnNumber = dataEntity.getString(JOIN_SOURCE) + "." + s;
                if (baseColmuns.containsKey(columnNumber)) {
                    Map<String, IDataEntityProperty> allFields = this.getAllFields(dataEntity.getString(JOIN_SOURCE));
                    String columnName = allFields.get(s).getDisplayName().getLocaleValue();
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201c,\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7f16\u7801\u5b58\u5728\u91cd\u590d,\u8bf7\u5220\u9664\u3002", (String)"DatasetManagePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), columnNumber, columnName));
                }
                baseColmuns.put(columnNumber, columnNumber);
                selectFidlds.add(s);
            }
            datasetJoinVo.setSelectFields((Set)selectFidlds);
            joinVoList.add(datasetJoinVo);
        }
        EntryGrid calculate = (EntryGrid)this.getControl(CALCULATE_ENTRY_ENTITY);
        ArrayList calculateVoList = Lists.newArrayListWithExpectedSize((int)calculate.getEntryData().getDataEntitys().length);
        for (int i = 0; i < calculate.getEntryData().getDataEntitys().length; ++i) {
            DynamicObject dataEntity = calculate.getEntryData().getDataEntitys()[i];
            String number = dataEntity.getString(CALCULATE_NUMBER);
            String name = dataEntity.get(CALCULATE_NAME).toString();
            if (StringUtils.isBlank((CharSequence)number)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            DatasetServiceHelper.checkDatasetNumberFormat((String)number);
            if (baseColmuns.containsKey(number)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201c,\u540d\u79f0\u4e3a\u201c%2$s\u201d\u7684\u7f16\u7801\u5b58\u5728\u91cd\u590d,\u8bf7\u5220\u9664\u3002", (String)"DatasetManagePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), number, name));
            }
            if (number.length() > 50) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5217\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"DatasetManagePlugin_8", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            if (name.length() > 50) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u5217\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"DatasetManagePlugin_9", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            String expression = dataEntity.getString(CALCULATE_EXPRESSION);
            if (StringUtils.isBlank((CharSequence)expression)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DatasetManagePlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            DatasetCalculateVo calculateVo = new DatasetCalculateVo();
            calculateVo.setNumber(number);
            calculateVo.setSeq(Integer.valueOf(i));
            calculateVo.setName((Object)name);
            calculateVo.setExpression(expression);
            calculateVoList.add(calculateVo);
        }
        DatasetEntityVo saveVo = new DatasetEntityVo();
        saveVo.setCalculateVos((List)calculateVoList);
        saveVo.setJoinVos((List)joinVoList);
        datasetDto.setManageVo(saveVo);
        return datasetDto;
    }

    private void joinEntityCheck(List<Map<String, Object>> columns) {
        Map<String, String> effectiveCloumns = this.getEffectiveColumns(columns);
        EntryGrid entryGrid = (EntryGrid)this.getControl(JOIN_ENTRY_ENTITY);
        ComboEdit comboEdit = (ComboEdit)this.getControl(JOIN_NUMBER);
        if (effectiveCloumns.isEmpty()) {
            this.getModel().deleteEntryData(JOIN_ENTRY_ENTITY);
            comboEdit.setComboItems(Collections.emptyList());
            return;
        }
        ArrayList items = Lists.newArrayListWithExpectedSize((int)effectiveCloumns.size());
        effectiveCloumns.forEach((key, value) -> items.add(new ComboItem(new LocaleString(value), key)));
        comboEdit.setComboItems((List)items);
        if (entryGrid.getEntryData().getDataEntitys().length <= 0) {
            return;
        }
        ArrayList removeRowIndex = Lists.newArrayListWithExpectedSize((int)16);
        for (int i = entryGrid.getEntryData().getDataEntitys().length - 1; i >= 0; --i) {
            DynamicObject dataEntity = entryGrid.getEntryData().getDataEntitys()[i];
            if (effectiveCloumns.containsKey(dataEntity.getString(JOIN_NUMBER))) continue;
            removeRowIndex.add(i);
        }
        if (CollectionUtils.isNotEmpty((Collection)removeRowIndex)) {
            int[] ints = new int[removeRowIndex.size()];
            for (int i = 0; i < removeRowIndex.size(); ++i) {
                ints[i] = (Integer)removeRowIndex.get(i);
            }
            this.getModel().deleteEntryRows(JOIN_ENTRY_ENTITY, ints);
        }
    }

    private void initJoinEntity(List<Map<String, Object>> columns) {
        Map<String, String> effectiveCloumns = this.getEffectiveColumns(columns);
        if (effectiveCloumns.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(JOIN_NUMBER);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)effectiveCloumns.size());
        effectiveCloumns.forEach((key, value) -> items.add(new ComboItem(new LocaleString(value), key)));
        comboEdit.setComboItems((List)items);
        Long datasetId = (Long)this.getView().getFormShowParameter().getCustomParam("datasetId");
        DynamicObject singleDS = DatasetDataReader.getSingleDS((Long)datasetId);
        DynamicObjectCollection joinentity = singleDS.getDynamicObjectCollection("joinentity");
        if (CollectionUtils.isEmpty((Collection)joinentity)) {
            return;
        }
        List collect = joinentity.stream().filter(t -> effectiveCloumns.containsKey(t.getString(JOIN_NUMBER))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(JOIN_ENTRY_ENTITY, collect.size());
        for (int i = 0; i < collect.size(); ++i) {
            DynamicObject dy = (DynamicObject)collect.get(i);
            this.getModel().setValue(JOIN_NUMBER, (Object)dy.getString(JOIN_NUMBER), i);
            this.getModel().setValue(JOIN_SOURCE, (Object)dy.getString(JOIN_SOURCE), i);
            this.getModel().setValue(JOIN_FIELD, (Object)dy.getString(JOIN_FIELD), i);
            this.getModel().setValue(JOIN_SELECT_FIELDS_NUM, (Object)dy.getString(JOIN_SELECT_FIELDS_NUM), i);
            Map<String, IDataEntityProperty> allFields = this.getAllFields(dy.getString(JOIN_SOURCE));
            StringBuilder sb = new StringBuilder();
            for (String selectField : dy.getString(JOIN_SELECT_FIELDS_NUM).split(",")) {
                sb.append(allFields.get(selectField).getDisplayName().getLocaleValue()).append(",");
            }
            this.getModel().setValue(JOIN_SELECT_FIELDS, (Object)sb.substring(0, sb.length() - 1), i);
        }
    }

    private Map<String, IDataEntityProperty> getAllFields(String entityName) {
        MainEntityType entityType = DatasetUtil.getEntityType((String)entityName);
        return entityType.getAllFields();
    }

    private void buildComboEdit(String comboKey, List<Map<String, Object>> columns, Set<String> groupList) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboKey);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)columns.size());
        if (CollectionUtils.isEmpty(columns)) {
            comboEdit.setComboItems((List)items);
            return;
        }
        Map<String, Map<String, String>> columnMap = this.getColumnMap();
        HashMap numberTrans = Maps.newHashMapWithExpectedSize((int)columnMap.size());
        for (Map.Entry<String, Map<String, String>> entry : columnMap.entrySet()) {
            numberTrans.put(entry.getValue().get("number"), entry.getKey());
        }
        for (Map map : columns) {
            String number = map.get("number").toString();
            String type = map.get("type").toString();
            if (GROUP.equals(comboKey) && !FidmDataTypeEnum.getMeasureList().contains(type) && !FidmDataTypeEnum.LET.type.equals(type)) {
                number = numberTrans.getOrDefault(number, number);
                items.add(new ComboItem(new LocaleString(map.get("name").toString()), number));
                continue;
            }
            if (!ORDER.equals(comboKey)) continue;
            if (FidmDataTypeEnum.getMeasureList().contains(map.get("type").toString())) {
                number = numberTrans.getOrDefault(number, number);
                items.add(new ComboItem(new LocaleString(map.get("name").toString()), number));
                continue;
            }
            if (CollectionUtils.isEmpty(groupList)) {
                if (FidmDataTypeEnum.LET.type.equals(type)) continue;
                number = numberTrans.getOrDefault(number, number);
                items.add(new ComboItem(new LocaleString(map.get("name").toString()), number));
                continue;
            }
            if (!groupList.contains(number)) continue;
            number = numberTrans.getOrDefault(number, number);
            items.add(new ComboItem(new LocaleString(map.get("name").toString()), number));
        }
        comboEdit.setComboItems((List)items);
        this.clearValue(comboKey);
    }
}

