/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.query.QFilter;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.BCMMember;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.common.control.entry.DynamicEntry;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetCalculateVo;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetEntityVo;
import kd.epm.far.business.common.dataset.dto.DatasetJoinVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetRenameVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbMember;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DatasetMultiLineShowPlugin
extends AbstractBaseDMListPlugin
implements DynamicPage {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String FMONEY = "FMONEY";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String result = (String)this.getFormCustomParam("result");
        if (result == null || result.isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
            if (Objects.nonNull(entryGrid)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ENTRYENTITY});
            }
            return;
        }
        List dataList = (List)this.deSerializedBytes(result);
        if (dataList == null || dataList.isEmpty()) {
            return;
        }
        ArrayList<String> cols = new ArrayList<String>(32);
        cols.addAll(((Map)dataList.get(0)).keySet());
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)cols.size());
        this.createTable(cols, nameMap, dataList);
        if (dataList.size() > 1) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, dataList.size() - 1);
        }
        int index = 0;
        for (Map dataMap : dataList) {
            if (dataMap == null || dataMap.isEmpty()) continue;
            for (Map.Entry data : dataMap.entrySet()) {
                this.getModel().setValue((String)nameMap.getOrDefault(data.getKey(), new Pair(data.getKey(), data.getKey())).p2, data.getValue(), index);
            }
            ++index;
        }
    }

    private List<String> createTable(List<String> cols, Map<String, Pair<String, String>> nameMap, List<Map<String, Object>> dataList) {
        String name;
        this.buildNameMap(nameMap, cols, dataList);
        ArrayList<String> colNames = new ArrayList<String>(10);
        Page page = new Page();
        DynamicEntry entry = new DynamicEntry(KEY_ENTRYENTITY);
        LocaleString width = new LocaleString("10%");
        boolean isContainFmoney = false;
        for (String param : cols) {
            if (FMONEY.equalsIgnoreCase(param)) {
                isContainFmoney = true;
                continue;
            }
            String sign = (String)nameMap.getOrDefault((Object)param, (Pair<String, String>)new Pair((Object)param, (Object)param)).p2;
            name = Objects.nonNull(nameMap.get(param)) ? (String)nameMap.get((Object)param).p1 + "/" + (String)nameMap.get((Object)param).p2 : param;
            TextEditElement textEditElement = this.createTextEditElement(name, sign, width, 1);
            textEditElement.setLock("new,edit");
            entry.addElement((Element)textEditElement);
            colNames.add(sign);
        }
        if (isContainFmoney) {
            name = Objects.nonNull(nameMap.get(FMONEY)) ? (String)nameMap.get((Object)FMONEY).p1 + "/" + FMONEY : FMONEY;
            TextEditElement textEditElement = this.createTextEditElement(name, FMONEY, width, 1);
            textEditElement.setLock("new,edit");
            entry.addElement((Element)textEditElement);
            colNames.add(FMONEY);
        }
        page.addEntry(entry);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        return colNames;
    }

    private Boolean singleExtHasId(Long datasetId, List<Map<String, Object>> dataList, Map<String, Pair<String, String>> nameMap, List<String> cols) {
        String value;
        DynamicObject dyn = DatasetDataReader.getSingleDS((Long)datasetId);
        Long extendModelId = dyn.getLong("extendsmodelid");
        if (LongUtil.isValidLong((Object)extendModelId) && kd.bos.util.StringUtils.isNotEmpty((String)(value = dyn.getString("value")))) {
            String dataSrcType = dyn.getString("datasrctype");
            Long datasetSrcId = dyn.getLong("datasrcid");
            return this.operateSignleExtFmoney(dataList, dataSrcType, datasetSrcId, extendModelId, nameMap, value, cols);
        }
        return Boolean.FALSE;
    }

    private Boolean signleExtNoId(List<Map<String, Object>> dataList, Map<String, Pair<String, String>> nameMap, List<String> cols) {
        String value;
        Long extendModelId;
        DatasetDto dto = (DatasetDto)this.deSerializedBytes((String)this.getFormCustomParam("datasetDto"));
        if (Objects.nonNull(dto) && LongUtil.isValidLong((Object)(extendModelId = dto.getExtendsModelId())) && kd.bos.util.StringUtils.isNotEmpty((String)(value = dto.getValue()))) {
            String dataSrcType = dto.getDataSrcType();
            return this.operateSignleExtFmoney(dataList, dataSrcType, dto.getDataSrcId(), extendModelId, nameMap, value, cols);
        }
        return Boolean.FALSE;
    }

    private Boolean operateSignleExtFmoney(List<Map<String, Object>> dataList, String dataSrcType, Long dataSrcId, Long extendModelId, Map<String, Pair<String, String>> nameMap, String value, List<String> cols) {
        Map<String, Object> data;
        Map extendsFields = new DatasetDimService().getExtendsFields(dataSrcType, dataSrcId, extendModelId, "");
        if (extendsFields.get(value) != null && dataList.size() > 0 && Objects.nonNull((data = dataList.get(0)).get(FMONEY))) {
            nameMap.put(value, (Pair<String, String>)new Pair(extendsFields.get(value), (Object)value));
            cols.clear();
            cols.add(value);
            Object singleValue = data.get(FMONEY);
            data.clear();
            data.put(value, singleValue);
            dataList.clear();
            dataList.add(data);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void buildNameMap(Map<String, Pair<String, String>> nameMap, List<String> cols, List<Map<String, Object>> dataList) {
        Long datasetId = (Long)this.getFormCustomParam("datasetId");
        String type = (String)this.getFormCustomParam("type");
        cols.stream().forEach(v -> {
            if ("SourceEntity".equals(v)) {
                nameMap.put("SourceEntity", new Pair((Object)ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-formplugin", (Object[])new Object[0]), (Object)"SourceEntity"));
            } else if ("SourceEntity-name".equals(v)) {
                nameMap.put("SourceEntity-name", new Pair((Object)ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7-\u540d\u79f0", (String)"SourceEntity_name", (String)"epm-far-formplugin", (Object[])new Object[0]), (Object)"SourceEntity-name"));
            } else if ("SourceEntity-number".equals(v)) {
                nameMap.put("SourceEntity-number", new Pair((Object)ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7-\u7f16\u7801", (String)"SourceEntity_number", (String)"epm-far-formplugin", (Object[])new Object[0]), (Object)"SourceEntity-number"));
            }
        });
        if (Objects.equals(DataSetTypeEnum.SINGLE_VALUED.getType(), type)) {
            if (ObjectUtil.equals((Object)DisModelTypeEnum.METADATA.getType(), (Object)this.getFormCustomParam("modelType"))) {
                String datasetValueZh = (String)this.getFormCustomParam("datasetValueZh");
                String value = (String)this.getFormCustomParam("datasetValue");
                nameMap.put(value, (Pair<String, String>)new Pair((Object)datasetValueZh, (Object)value));
                return;
            }
            if (LongUtil.isvalidLong((Object)datasetId) ? this.singleExtHasId(datasetId, dataList, nameMap, cols) != false : this.signleExtNoId(dataList, nameMap, cols) != false) {
                return;
            }
            nameMap.put(FMONEY, (Pair<String, String>)new Pair((Object)ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"DatasetMultiLineShowPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), (Object)FMONEY));
            return;
        }
        if (Objects.equals(DataSetTypeEnum.MULTIPLE_VALUED.getType(), type)) {
            DynamicObject[] dyns;
            if (Objects.isNull(datasetId)) {
                return;
            }
            QFilter qfilter = new QFilter("dataset.id", "=", (Object)datasetId);
            for (DynamicObject dyn : dyns = DatasetDataReader.getMultiDataSetValues((QFilter[])new QFilter[]{qfilter}).toArray(new DynamicObject[0])) {
                nameMap.put(dyn.getString("number"), (Pair<String, String>)new Pair((Object)dyn.getString("name"), (Object)dyn.getString("number")));
            }
            return;
        }
        nameMap.put(FMONEY, (Pair<String, String>)new Pair((Object)ResManager.loadKDString((String)"\u5ea6\u91cf\u503c", (String)"DatasetMultiLineShowPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), (Object)FMONEY));
        if (LongUtil.isvalidLong((Object)datasetId)) {
            this.buildNameMapByDatsetId(datasetId, nameMap);
        } else {
            this.buildNameMapByModelId(nameMap);
        }
    }

    private void buildManage(DynamicObject singleDS, Map<String, Pair<String, String>> nameMap) {
        DynamicObjectCollection renameEntity;
        DynamicObjectCollection calculateEntity;
        DynamicObjectCollection joinEntity = singleDS.getDynamicObjectCollection("joinentity");
        if (CollectionUtils.isNotEmpty((Collection)joinEntity)) {
            for (Object dy : joinEntity) {
                String[] selectfields;
                String source = dy.getString("joinsource");
                MainEntityType dataEntityType = DatasetUtil.getEntityType((String)source);
                Map allFields = dataEntityType.getAllFields();
                for (String selectfield : selectfields = dy.getString("selectfields").split(",")) {
                    if (!allFields.containsKey(selectfield)) continue;
                    nameMap.put(source + "." + selectfield, (Pair<String, String>)new Pair((Object)((IDataEntityProperty)allFields.get(selectfield)).getDisplayName().getLocaleValue(), (Object)(source + "%" + selectfield)));
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(calculateEntity = singleDS.getDynamicObjectCollection("calculateentity")))) {
            for (DynamicObject dy : calculateEntity) {
                String number = dy.getString("calnumber");
                String name = dy.getLocaleString("calname").getLocaleValue();
                nameMap.put(number, (Pair<String, String>)new Pair((Object)name, (Object)number));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(renameEntity = singleDS.getDynamicObjectCollection("renameentity")))) {
            for (DynamicObject dy : renameEntity) {
                String number = dy.getString("renamenumber");
                String replace = number.replace(".", "%");
                nameMap.put(number, (Pair<String, String>)new Pair((Object)dy.getLocaleString("renamename").getLocaleValue(), (Object)replace));
            }
        }
    }

    private void buildManage(DatasetDto dto, Map<String, Pair<String, String>> nameMap) {
        List renameVos;
        List calculateVos;
        DatasetEntityVo saveVo = dto.getManageVo();
        if (Objects.isNull(saveVo)) {
            return;
        }
        List joinVos = saveVo.getJoinVos();
        if (CollectionUtils.isNotEmpty((Collection)joinVos)) {
            for (DatasetJoinVo vo : joinVos) {
                String[] selectfields;
                String source = vo.getEntityName();
                MainEntityType dataEntityType = DatasetUtil.getEntityType((String)source);
                Map allFields = dataEntityType.getAllFields();
                for (String selectfield : selectfields = vo.getSelectFieldStr().split(",")) {
                    if (!allFields.containsKey(selectfield)) continue;
                    nameMap.put(source + "." + selectfield, (Pair<String, String>)new Pair((Object)((IDataEntityProperty)allFields.get(selectfield)).getDisplayName().getLocaleValue(), (Object)(source + "%" + selectfield)));
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(calculateVos = saveVo.getCalculateVos()))) {
            for (DatasetCalculateVo vo : calculateVos) {
                String number = vo.getNumber();
                String name = vo.getName().toString();
                nameMap.put(number, (Pair<String, String>)new Pair((Object)name, (Object)number));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(renameVos = saveVo.getRenameVos()))) {
            for (DatasetRenameVo vo : renameVos) {
                String number = vo.getNumber();
                String replace = number.replace(".", "%");
                nameMap.put(number, (Pair<String, String>)new Pair((Object)vo.getNameStr(), (Object)replace));
            }
        }
    }

    private void buildNameMapByDatsetId(Long datasetId, Map<String, Pair<String, String>> nameMap) {
        DynamicObject dyn = DatasetDataReader.getSingleDS((Long)datasetId);
        String dataSrcType = dyn.getString("datasrctype");
        if (Objects.equals(DataSrcTypeEnum.ISC_METADATA.getType(), dataSrcType)) {
            DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)dyn.getString("data"), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            for (DatasetPropertyVo column : vo.getColumns()) {
                String replace = column.getNumber().replace(".", "%");
                nameMap.put(column.getNumber(), (Pair<String, String>)new Pair((Object)column.getName(), (Object)replace));
            }
            this.buildManage(dyn, nameMap);
            return;
        }
        Map<String, String> collect = new DatasetServiceHelper().getDimList(datasetId, true).stream().collect(Collectors.toMap(o -> o.get("number").toString(), o -> o.get("name").toString()));
        for (Map.Entry<String, String> entry : collect.entrySet()) {
            nameMap.put(entry.getKey(), (Pair<String, String>)new Pair((Object)entry.getValue(), (Object)entry.getKey()));
        }
        long sourceModelId = dyn.getLong("datasrcid");
        String memberNum = dyn.getString("membernum");
        String dimNum = dyn.getString("dimNum");
        if (StringUtils.isNotEmpty((String)memberNum)) {
            if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
                List memberNumList = (List)SerializationUtils.fromJsonString((String)memberNum, List.class);
                String shownumber = EbServiceHelper.getModel((Long)sourceModelId).getString("shownumber");
                String ebDataset = dyn.getString("ebdataset");
                for (String s : memberNumList) {
                    List member = EbServiceHelper.getMember((String)shownumber, (String)ebDataset, (String)dimNum, (String)s, (RangeEnum)RangeEnum.VALUE_10);
                    if (CollectionUtils.isEmpty((Collection)member)) {
                        return;
                    }
                    String replace = s.replace(".", "%");
                    nameMap.put(s, (Pair<String, String>)new Pair((Object)((EbMember)member.get(0)).getName(), (Object)replace));
                }
            } else {
                String modelNumber = BCMDataReader.findModelNumberById((Long)sourceModelId);
                List memberNumList = (List)SerializationUtils.fromJsonString((String)memberNum, List.class);
                for (String s : memberNumList) {
                    BCMMember member = BCMMsServiceHelper.findMemberByNumber((String)modelNumber, (String)dyn.getString("dimnum"), (String)s);
                    if (Objects.isNull(member)) continue;
                    String replace = s.replace(".", "%");
                    nameMap.put(s, (Pair<String, String>)new Pair((Object)member.getName(), (Object)replace));
                }
            }
        }
        this.buildManage(dyn, nameMap);
    }

    private void buildNameMapByModelId(Map<String, Pair<String, String>> nameMap) {
        String data;
        DatasetDataVo datasetDataVo;
        DatasetDto dto = (DatasetDto)this.deSerializedBytes((String)this.getFormCustomParam("datasetDto"));
        if (Objects.isNull(dto)) {
            return;
        }
        String dataSrcType = dto.getDataSrcType();
        if (Objects.equals(DataSrcTypeEnum.ISC_METADATA.getType(), dataSrcType) || Objects.equals(DataSrcTypeEnum.BCM_ISC_METADATA.getType(), dataSrcType)) {
            DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
            for (DatasetPropertyVo column : vo.getColumns()) {
                String replace = column.getNumber().replace(".", "%");
                nameMap.put(column.getNumber(), (Pair<String, String>)new Pair((Object)column.getName(), (Object)replace));
            }
            this.buildManage(dto, nameMap);
            return;
        }
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)dto.getDataSrcId());
        List dimList = new ModelStrategyEx(dto.getDataSrcId(), modelType.getType()).getDim().getDimList();
        for (DimensionInfo info : dimList) {
            String number = info.getNumber();
            String name = info.getName();
            nameMap.put(number, (Pair<String, String>)new Pair((Object)name, (Object)number));
        }
        String extendNumber = dto.getExtendsModelNumber();
        if (Objects.equals(dto.getDataSrcType(), DataSrcTypeEnum.CM_TEMPLATE.getType()) && !StringUtils.equals((String)(datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0])).getTemplate().getArea(), (String)"hasDim")) {
            extendNumber = datasetDataVo.getTemplate().getArea();
        }
        if (StringUtils.isNotBlank((String)extendNumber)) {
            DatasetDimService service = new DatasetDimService();
            List data2 = service.getExtendsModel(dto.getDataSrcType(), dto.getDataSrcId());
            Map<String, String> map = data2.stream().collect(Collectors.toMap(t -> (String)t.p1, t -> (String)t.p3));
            Long extendModelId = LongUtil.toLong(map.get(extendNumber));
            Map extendsFields = new DatasetDimService().getExtendsFields(dataSrcType, dto.getDataSrcId(), extendModelId, "");
            for (Map.Entry entry : extendsFields.entrySet()) {
                nameMap.put((String)entry.getKey(), (Pair<String, String>)new Pair(entry.getValue(), entry.getKey()));
            }
        }
        if (StringUtils.isNotEmpty((String)dto.getMemberNum())) {
            String modelNumber = BCMDataReader.findModelNumberById((Long)dto.getDataSrcId());
            List memberNumList = (List)SerializationUtils.fromJsonString((String)dto.getMemberNum(), List.class);
            for (String s : memberNumList) {
                BCMMember member = BCMMsServiceHelper.findMemberByNumber((String)modelNumber, (String)dto.getDimNum(), (String)s);
                if (Objects.isNull(member)) continue;
                String replace = s.replace(".", "%");
                nameMap.put(s, (Pair<String, String>)new Pair((Object)member.getName(), (Object)replace));
                nameMap.put(dto.getDimNum() + "='" + s + "'", (Pair<String, String>)new Pair((Object)member.getName(), (Object)replace));
            }
        }
        if (StringUtils.isBlank((String)(data = dto.getData()))) {
            this.buildManage(dto, nameMap);
            return;
        }
        DatasetDataVo vo = (DatasetDataVo)JSON.parseObject((String)data, (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        List columns = vo.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            this.buildManage(dto, nameMap);
            return;
        }
        for (DatasetPropertyVo propertyVo : columns) {
            String name;
            String number;
            if (Objects.equals(ColumnTypeEnum.MEASURE.getCode(), propertyVo.getType()) || !nameMap.containsKey(propertyVo.getSource())) continue;
            String dimName = (String)nameMap.get((Object)propertyVo.getSource()).p1;
            if (Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), propertyVo.getType())) {
                number = propertyVo.getSource() + "-" + propertyVo.getNumber();
                name = dimName + "-" + propertyVo.getName();
                nameMap.put(number, (Pair<String, String>)new Pair((Object)name, (Object)number));
                continue;
            }
            number = propertyVo.getSource() + "-Property-" + propertyVo.getNumber();
            name = String.format(ResManager.loadKDString((String)"%1$s-%2$s", (String)"DatasetServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]), dimName, propertyVo.getName());
            nameMap.put(number, (Pair<String, String>)new Pair((Object)name, (Object)number));
        }
        this.buildManage(dto, nameMap);
    }

    private TextEditElement createTextEditElement(String name, String sign, LocaleString width, int editStyle) {
        TextEditElement textEditElement = new TextEditElement(name, sign, "");
        textEditElement.setEditStyle(editStyle);
        textEditElement.setWidth(width);
        textEditElement.setLock("new,edit,view");
        return textEditElement;
    }

    @Override
    public String getModelSign() {
        return "";
    }
}

