/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.f7.BCMF7Helper;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DatasetTemplateVo;
import kd.epm.far.business.common.dataset.dto.SourceEntityVo;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.dataset.AbsDatasetPopEditPlugin;
import kd.epm.far.formplugin.common.dataset.SEUtils;
import org.apache.commons.collections.CollectionUtils;

public class DatasetPopMergePlugin
extends AbsDatasetPopEditPlugin {
    public DatasetDimService fidmDimService = new DatasetDimService();
    private List<DimTypesEnum> defaultEnum = Lists.newArrayList((Object[])new DimTypesEnum[]{DimTypesEnum.ENTITY, DimTypesEnum.YEAR, DimTypesEnum.PERIOD, DimTypesEnum.SCENARIO, DimTypesEnum.CURRENCY});

    @Override
    protected void openMutiF7(List<Map<String, String>> memberNumbers, DimensionInfo dim, Integer index) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "mutiF7_" + index);
        BCMF7Helper.openMutilF7((AbstractFormPlugin)this, (Long)LongUtil.toLong((Object)this.getModel().getValue("modelselect")), (DimensionInfo)dim, memberNumbers, (CloseCallBack)closeCallBack, (boolean)true, (Boolean)false);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DatasetDto dto = this.commonAfterCreate();
        if (!this.isCurPlugin()) {
            return;
        }
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dto.getDataSrcType(), (Long)dto.getDataSrcId());
        List useModels = ModelStrategy.getStrategy((DisModelTypeEnum)modelType).getUseModels();
        if (CollectionUtils.isEmpty((Collection)useModels) || useModels.stream().noneMatch(t -> dto.getDataSrcId().equals(t.getLong("id")))) {
            return;
        }
        this.buildModelComboEdit(useModels);
        this.getModel().setValue("modelselect", (Object)dto.getDataSrcId());
        this.initTypeComboEdit(dto.getDataSrcType());
        this.buildByType(dto);
        this.afterTemplateSelect(dto.getTemplateId());
        this.afterExtendSelect(dto.getExtendsModelId());
        this.getModel().setValue("areaselect", (Object)dto.getArea());
        if (StringUtils.isNotBlank((CharSequence)dto.getArea())) {
            Set hideColumns = Sets.newHashSetWithExpectedSize((int)16);
            if (StringUtils.isNotBlank((CharSequence)dto.getData())) {
                DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
                hideColumns = datasetDataVo.getHideColumns();
            }
            this.afterAreaSelect(dto.getArea(), dto.getExpression(), hideColumns);
        } else {
            this.buildEntity(dto);
        }
        this.getModel().setValue("groupbyfield", (Object)StringUtils.isNotBlank((CharSequence)dto.getGroupBy()));
        this.setVisibleBySourceFrom();
    }

    private void buildByType(DatasetDto dto) {
        DatasetModelTypeEnum type = DatasetModelTypeEnum.DEFAULT;
        if (LongUtil.isvalidLong((Object)dto.getTemplateId())) {
            type = DatasetModelTypeEnum.TEMPLATE;
        } else if (LongUtil.isvalidLong((Object)dto.getExtendsModelId())) {
            type = DatasetModelTypeEnum.EXTEND;
        }
        this.getModel().setValue("typeselect", (Object)type.getIndex());
        this.afterTypeSelect(type, dto.getDataSrcId());
        this.getModel().setValue("templateselect", (Object)dto.getTemplateId());
        this.getModel().setValue("extendselect", (Object)dto.getExtendsModelId());
    }

    @Override
    protected void setVisibleBySourceFrom() {
        Object value;
        IDataModel model = this.getModel();
        HashSet showSet = Sets.newHashSet((Object[])new String[]{"modelselect", "typeselect"});
        if (this.isSingle(this.getDto())) {
            showSet.add("singleflex");
            if (LongUtil.isvalidLong((Object)model.getValue("extendselect"))) {
                showSet.add("returnvalue");
            }
        } else {
            showSet.add("mutiflex");
        }
        if (Objects.isNull(value = model.getValue("typeselect"))) {
            return;
        }
        if (DatasetModelTypeEnum.DEFAULT.getIndex().equals(value.toString())) {
            showSet.add("treeviewap");
            showSet.add("groupbyfield");
        }
        if (DatasetModelTypeEnum.EXTEND.getIndex().equals(value.toString())) {
            showSet.add("treeviewap");
            showSet.add("extendselect");
            showSet.add("groupbyfield");
        }
        if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(value.toString())) {
            showSet.add("templateselect");
            showSet.add("areaselect");
        }
        this.setVisibleBySourceFrom(showSet);
    }

    protected void buildEntity(DatasetDto dto) {
        List columns;
        SourceEntityVo sourceEntityVo;
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        if (StringUtils.isNotBlank((CharSequence)dto.getData())) {
            datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        }
        Set hideColumns = datasetDataVo.getHideColumns();
        List<DimensionInfo> dimList = this.getDimList(dto.getDataSrcId());
        Map shortMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, Function.identity()));
        Map<String, String> numberMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getNumber, DimensionInfo::getName));
        if (StringUtils.isNotBlank((CharSequence)dto.getExpression())) {
            String[] split;
            for (String dimAndNumber : split = dto.getExpression().split(",")) {
                boolean showColumns;
                int i = dimAndNumber.indexOf(46);
                String dim = dimAndNumber.substring(0, i);
                String members = dimAndNumber.substring(i + 1);
                members = members.replace(";", ",");
                members = members.replace("{", "");
                members = members.replace("}", "");
                DimensionInfo info = (DimensionInfo)shortMap.get(dim);
                boolean bl = showColumns = CollectionUtils.isEmpty((Collection)hideColumns) || !hideColumns.contains(info.getNumber());
                if (DatasetSpecialVarHelper.params.contains(members)) {
                    this.addEntity(info.getNumber(), info.getName(), "root", null, ColumnTypeEnum.FIXED_COLUMN.getCode() + "", null, showColumns, members);
                    continue;
                }
                this.addEntity(info.getNumber(), info.getName(), "root", null, ColumnTypeEnum.FIXED_COLUMN.getCode() + "", members, showColumns, null);
            }
        }
        if ((sourceEntityVo = datasetDataVo.getSourceEntityVo()) != null) {
            boolean showColumns;
            orgs.clear();
            orgs.addAll(sourceEntityVo.getMembers() == null ? new ArrayList() : sourceEntityVo.getMembers());
            DimensionInfo info = SEUtils.getSEDimensionInfo();
            boolean bl = showColumns = CollectionUtils.isEmpty((Collection)hideColumns) || !hideColumns.contains(info.getNumber());
            if (sourceEntityVo.getMembers() == null || sourceEntityVo.getMembers().isEmpty()) {
                this.addEntity(info.getNumber(), info.getName(), "root", null, ColumnTypeEnum.FIXED_COLUMN.getCode() + "", null, showColumns, null);
            } else {
                List members = sourceEntityVo.getMembers();
                String seMsByPop = SEUtils.getSEMsByPop(members);
                this.addEntity(info.getNumber(), info.getName(), "root", null, ColumnTypeEnum.FIXED_COLUMN.getCode() + "", seMsByPop, showColumns, null);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(columns = datasetDataVo.getColumns()))) {
            return;
        }
        for (DatasetPropertyVo column : columns) {
            boolean showColumns = CollectionUtils.isEmpty((Collection)hideColumns) || !hideColumns.contains(column.getNumber());
            String condition = this.buildCondition(column.getFilters());
            String name = numberMap.getOrDefault(column.getSource(), "");
            if ("SourceEntity".equals(column.getSource())) {
                name = ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]);
            }
            if (Objects.equals(column.getType(), ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode())) {
                String number = this.generateCustomTreeNodeId(column.getNumber(), column.getSource(), column.getType());
                this.addEntity(number, column.getName(), column.getSource(), name, column.getType().toString(), condition, showColumns, null);
                continue;
            }
            this.addEntity(column.getNumber(), column.getName(), column.getSource(), name, column.getType().toString(), condition, showColumns, null);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (!this.isCurPlugin()) {
            return;
        }
        this.buildReturnValueCombo();
    }

    @Override
    protected boolean isDim(Object type, String parent) {
        if (!Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), Integer.valueOf(type.toString()))) {
            return Boolean.FALSE;
        }
        return "root".equals(parent);
    }

    @Override
    protected void buildDatasetDto(DatasetDto dto) {
        IDataModel model = this.getModel();
        Object modelId = model.getValue("modelselect");
        if (!LongUtil.isvalidLong((Object)modelId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        dto.setDataSrcId(LongUtil.toLong((Object)modelId));
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        StringBuilder sb = new StringBuilder();
        StringBuilder groupSb = new StringBuilder();
        StringBuilder moneySb = new StringBuilder();
        List<DimensionInfo> dimList = this.getDimList(dto.getDataSrcId());
        Map<String, String> dimMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getNumber, DimensionInfo::getShortNumber));
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        boolean needGroup = (Boolean)this.getModel().getValue("groupbyfield");
        datasetDataVo.setHideColumns((Set)Sets.newHashSetWithExpectedSize((int)16));
        Map treeMap = (Map)JSON.parseObject((String)this.getPageCache().get("treeMap"), (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){}, (Feature[])new Feature[0]);
        String s = this.getPageCache().get("ignoreColumn");
        Set ignoreSet = Sets.newHashSetWithExpectedSize((int)16);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            ignoreSet = (Set)SerializationUtils.fromJsonString((String)s, Set.class);
        }
        boolean isTemplate = Objects.equals(DatasetModelTypeEnum.TEMPLATE.getIndex(), this.getModel().getValue("typeselect").toString());
        SourceEntityVo sourceEntityVo = null;
        for (DynamicObject entity : grid.getEntryData().getDataEntitys()) {
            String number = entity.getString("numberfield");
            if (ignoreSet.contains(number)) {
                if (entity.getBoolean("showfield")) continue;
                datasetDataVo.getHideColumns().add(entity.getString("numberfield"));
                continue;
            }
            String shortNumber = dimMap.get(number);
            if ("SourceEntity".equals(number)) {
                sourceEntityVo = new SourceEntityVo();
                Object o = entity.get("conditionfield");
                if (o != null && StringUtils.isNotEmpty((CharSequence)o.toString())) {
                    sourceEntityVo.setMembers(orgs);
                }
                if (needGroup) {
                    groupSb.append("SE").append(",");
                }
                datasetDataVo.setSourceEntityVo(sourceEntityVo);
            } else {
                this.fixedHandler(sb, groupSb, shortNumber, needGroup, entity, datasetDataVo, treeMap, isTemplate);
            }
            this.attributeHandler(entity, datasetDataVo, treeMap);
            this.measureHandler(entity, datasetDataVo, moneySb);
        }
        dto.setExpression(null);
        dto.setTempExpression(null);
        if (sb.length() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6784\u5efa\u6b63\u786e\u8868\u8fbe\u5f0f\u3002", (String)"DataSetDisplayPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        dto.setExpression(sb.substring(0, sb.length() - 1));
        dto.setTempExpression(dto.getExpression());
        this.builDatasetDtoByType(dto, groupSb, moneySb, datasetDataVo);
        dto.setData(JSON.toJSONString((Object)datasetDataVo));
    }

    private void builDatasetDtoByType(DatasetDto dto, StringBuilder groupSb, StringBuilder moneySb, DatasetDataVo datasetDataVo) {
        IDataModel model = this.getModel();
        Object type = this.getModel().getValue("typeselect");
        if (DatasetModelTypeEnum.DEFAULT.getIndex().equals(type.toString())) {
            dto.setExtendsModelId(null);
            dto.setExtendsModelNumber(null);
            dto.setValue("FMONEY");
            if (groupSb.length() > 0) {
                dto.setGroupBy(groupSb.substring(0, groupSb.length() - 1));
            } else {
                dto.setGroupBy(null);
            }
            return;
        }
        if (DatasetModelTypeEnum.EXTEND.getIndex().equals(type.toString())) {
            dto.setExtendsModelId(LongUtil.toLong((Object)model.getValue("extendselect")));
            List extendsModel = this.fidmDimService.getExtendsModel(DataSrcTypeEnum.MERGE_MODEL.getType(), dto.getDataSrcId());
            for (Tuple tuple : extendsModel) {
                if (!StringUtils.equals((CharSequence)((CharSequence)tuple.p3), (CharSequence)dto.getExtendsModelId().toString())) continue;
                dto.setExtendsModelNumber((String)tuple.p1);
            }
            if (Objects.equals(dto.getType(), DataSetTypeEnum.SINGLE_VALUED.getType())) {
                Object value = model.getValue("returnvalue");
                if (Objects.isNull(value)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fd4\u56de\u503c\u3002", (String)"DataSetDisplayPlugin_37", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                dto.setValue(value.toString());
            } else {
                if (StringUtils.isBlank((CharSequence)moneySb)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8fd4\u56de\u503c\u3002", (String)"DataSetDisplayPlugin_37", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                dto.setValue(moneySb.substring(0, moneySb.length() - 1));
            }
            if (groupSb.length() > 0) {
                dto.setGroupBy(groupSb.substring(0, groupSb.length() - 1));
            } else {
                dto.setGroupBy(null);
            }
            return;
        }
        if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(type.toString())) {
            DatasetTemplateVo templateVo = new DatasetTemplateVo();
            templateVo.setTemplateId(LongUtil.toLong((Object)model.getValue("templateselect")));
            String area = (String)model.getValue("areaselect");
            templateVo.setArea(area);
            datasetDataVo.setTemplate(templateVo);
            dto.setDataSrcType(DataSrcTypeEnum.CM_TEMPLATE.getType());
            dto.setGroupBy(null);
            if ("hasDim".equals(area)) {
                dto.setValue("FMONEY");
            } else {
                String extendListStr = this.getPageCache().get("extendsList");
                List extendList = (List)SerializationUtils.fromJsonString((String)extendListStr, List.class);
                Optional<Map> any = extendList.stream().filter(t -> area.equals(t.get("number").toString())).findAny();
                if (!any.isPresent()) {
                    return;
                }
                Map extendMap = any.get();
                dto.setExtendsModelId(LongUtil.toLong(extendMap.get("id")));
                dto.setExtendsModelNumber(extendMap.get("number").toString());
                dto.setValue(String.join((CharSequence)",", (List)extendMap.get("members")));
            }
        }
    }

    private void measureHandler(DynamicObject entity, DatasetDataVo datasetDataVo, StringBuilder moneySb) {
        if (!Objects.equals(ColumnTypeEnum.MEASURE.getCode(), entity.getInt("typefield"))) {
            return;
        }
        moneySb.append(entity.getString("numberfield")).append(",");
        DatasetPropertyVo vo = new DatasetPropertyVo();
        vo.setNumber(entity.getString("numberfield"));
        vo.setName(entity.getString("namefield"));
        vo.setType(Integer.valueOf(ColumnTypeEnum.MEASURE.getCode()));
        vo.setSource("extend");
        String condition = entity.getString("conditionfield");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            vo.setFilters(this.buildFilter(condition));
        }
        if (datasetDataVo.getColumns() == null) {
            datasetDataVo.setColumns((List)Lists.newArrayList((Object[])new DatasetPropertyVo[]{vo}));
        } else {
            datasetDataVo.getColumns().add(vo);
        }
    }

    private void attributeHandler(DynamicObject entity, DatasetDataVo datasetDataVo, Map<String, Map<String, String>> treeMap) {
        if (!Objects.equals(ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode(), entity.getInt("typefield"))) {
            return;
        }
        this.buildDatasetProperty(entity, datasetDataVo, ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode(), treeMap);
    }

    private void buildDatasetProperty(DynamicObject entity, DatasetDataVo datasetDataVo, int type, Map<String, Map<String, String>> treeMap) {
        String condition;
        String number = entity.getString("numberfield");
        if (ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode() == type) {
            number = number.split("@")[0];
        }
        if (!entity.getBoolean("showfield")) {
            String hideColumn = ColumnTypeEnum.ATTRIBUTE_COLUMN.getCode() == type ? entity.getString("parentfield") + "-Property-" + number : entity.getString("parentfield") + "-" + entity.getString("numberfield");
            datasetDataVo.getHideColumns().add(hideColumn);
        }
        DatasetPropertyVo vo = new DatasetPropertyVo();
        vo.setNumber(number);
        vo.setName(entity.getString("namefield"));
        vo.setType(Integer.valueOf(type));
        if (!Objects.equals(entity.getString("parentfield"), "root")) {
            vo.setSource(entity.getString("parentfield"));
            vo.setName(treeMap.get(this.generateCustomTreeNodeId(vo.getNumber(), vo.getSource(), type)).get("name"));
        }
        if (StringUtils.isNotBlank((CharSequence)(condition = entity.getString("conditionfield")))) {
            vo.setFilters(this.buildFilter(condition));
        }
        if (datasetDataVo.getColumns() == null) {
            datasetDataVo.setColumns((List)Lists.newArrayList((Object[])new DatasetPropertyVo[]{vo}));
        } else {
            datasetDataVo.getColumns().add(vo);
        }
    }

    private void fixedHandler(StringBuilder sb, StringBuilder groupSb, String shortNumber, boolean needGroup, DynamicObject entity, DatasetDataVo datasetDataVo, Map<String, Map<String, String>> treeMap, boolean isTemplate) {
        String param;
        if (!Objects.equals(ColumnTypeEnum.FIXED_COLUMN.getCode(), entity.getInt("typefield"))) {
            return;
        }
        if (!Objects.equals(entity.getString("parentfield"), "root")) {
            this.buildDatasetProperty(entity, datasetDataVo, ColumnTypeEnum.FIXED_COLUMN.getCode(), treeMap);
            return;
        }
        if (!entity.getBoolean("showfield")) {
            datasetDataVo.getHideColumns().add(entity.getString("numberfield"));
        }
        sb.append(shortNumber).append(".");
        if (needGroup && entity.getBoolean("showfield")) {
            groupSb.append(shortNumber).append(",");
        }
        if (StringUtils.isNotBlank((CharSequence)(param = entity.getString("paramfield")))) {
            sb.append(param);
            if (isTemplate && !DimTypesEnum.ENTITY.getShortNumber().equals(shortNumber) && "$Curs".equalsIgnoreCase(param)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6574\u8868\u53d6\u6570\u6682\u65f6\u53ea\u652f\u6301\u7ec4\u7ec7\u591a\u9009\u3002", (String)"DatasetPopMergePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), entity.getString("namefield")));
            }
        } else {
            if (StringUtils.isBlank((CharSequence)entity.getString("conditionfield"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201d%s\u201d\u5b57\u6bb5\u8bf7\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6\uff08\u5305\u542b\u53c2\u6570\uff09\u6216\u79fb\u9664\u3002", (String)"DatasetPopMergePlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]), entity.getString("namefield")));
            }
            String condition = entity.getString("conditionfield");
            if (isTemplate && !DimTypesEnum.ENTITY.getShortNumber().equals(shortNumber) && condition.contains(",")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6574\u8868\u53d6\u6570\u6682\u65f6\u53ea\u652f\u6301\u7ec4\u7ec7\u591a\u9009\u3002", (String)"DatasetPopMergePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]), entity.getString("namefield")));
            }
            String replace = condition.replace(",", ";");
            sb.append("{").append(replace).append("}");
        }
        sb.append(",");
    }

    @Override
    protected void buildReturnValueCombo() {
        if (!this.isSingle(this.getDto())) {
            return;
        }
        Object extendModeId = this.getModel().getValue("extendselect");
        if (!LongUtil.isvalidLong((Object)extendModeId)) {
            return;
        }
        Object modelId = this.getModel().getValue("modelselect");
        List extendsList = this.fidmDimService.getExtendsFieldstTuple(DataSrcTypeEnum.MERGE_MODEL.getType(), LongUtil.toLong((Object)modelId), LongUtil.toLong((Object)extendModeId));
        Map<String, String> extendMap = extendsList.stream().filter(t -> StringUtils.equals((CharSequence)"number", (CharSequence)((CharSequence)t.p3))).collect(Collectors.toMap(t -> (String)t.p1, t -> (String)t.p2));
        ComboEdit comboEdit = (ComboEdit)this.getControl("returnvalue");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        boolean needClearReturnValue = true;
        Object value = this.getModel().getValue("returnvalue");
        for (DynamicObject dataEntity : entryGrid.getEntryData().getDataEntitys()) {
            String number = dataEntity.getString("numberfield");
            if (extendMap.containsKey(number)) {
                items.add(new ComboItem(new LocaleString(extendMap.get(number)), number));
            }
            if (!Objects.equals(number, value)) continue;
            needClearReturnValue = false;
        }
        comboEdit.setComboItems((List)items);
        if (needClearReturnValue) {
            this.getModel().setValue("returnvalue", null);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.isCurPlugin()) {
            return;
        }
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        switch (propertyName) {
            case "sourcefrom": {
                this.setVisibleBySourceFrom();
                this.clearValue("modelselect", "extendselect", "templateselect", "areaselect");
                this.clearComboEdit("typeselect", "templateselect", "areaselect");
                this.getModel().setValue("typeselect", (Object)DatasetModelTypeEnum.DEFAULT.getIndex());
                if (Objects.equals(DataSrcTypeEnum.MERGE_MODEL.getType(), value)) {
                    this.buildModelComboEdit(ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.CM).getUseModels());
                    this.paramHandler(DataSrcTypeEnum.MERGE_MODEL);
                    return;
                }
                if (!Objects.equals(DataSrcTypeEnum.RPT_MODEL.getType(), value)) break;
                this.buildModelComboEdit(ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.RPT).getUseModels());
                this.paramHandler(DataSrcTypeEnum.RPT_MODEL);
                return;
            }
            case "typeselect": {
                if (Objects.isNull(value)) {
                    return;
                }
                this.setVisibleBySourceFrom();
                this.clearValue("extendselect", "templateselect", "areaselect", "groupbyfield");
                this.afterTypeSelect(DatasetModelTypeEnum.getByIndex((String)value.toString()), LongUtil.toLong((Object)this.getModel().getValue("modelselect")));
                break;
            }
            case "modelselect": {
                if (StringUtils.isBlank((Object)value)) {
                    return;
                }
                this.initTypeComboEdit((String)this.getModel().getValue("sourcefrom"));
                this.clearEntity();
                this.afterTypeSelect(DatasetModelTypeEnum.getByIndex((String)this.getModel().getValue("typeselect").toString()), LongUtil.toLong((Object)value));
                break;
            }
            case "templateselect": {
                this.clearEntity();
                this.clearValue("areaselect");
                if (Objects.isNull(value)) break;
                this.afterTemplateSelect(LongUtil.toLong((Object)value));
                break;
            }
            case "areaselect": {
                if (Objects.isNull(value)) break;
                this.afterAreaSelect(value.toString(), null, Collections.emptySet());
                break;
            }
            case "extendselect": {
                if (StringUtils.isBlank((Object)value)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"returnvalue"});
                    this.initTree(LongUtil.toLong((Object)this.getModel().getValue("modelselect")));
                    this.removeEntity(this.getDimList(LongUtil.toLong((Object)this.getModel().getValue("modelselect"))));
                    return;
                }
                this.afterExtendSelect(LongUtil.toLong((Object)value));
                break;
            }
        }
    }

    private void clearComboEdit(String ... params) {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        for (String param : params) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(param);
            comboEdit.setComboItems((List)items);
            this.getModel().setValue(param, null);
        }
    }

    private void afterAreaSelect(String area, String expression, Set<String> hideColumns) {
        Long modelId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
        List dimList = new ModelStrategyEx(modelId, DisModelTypeEnum.CM.getType()).getDim().getDimList();
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        if (StringUtils.isNotBlank((CharSequence)expression)) {
            String[] split;
            Map<String, String> numberMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, DimensionInfo::getNumber));
            for (String dimAndNumber : split = expression.split(",")) {
                int i = dimAndNumber.indexOf(46);
                String dim = dimAndNumber.substring(0, i);
                String members = dimAndNumber.substring(i + 1);
                members = members.replace(";", ",");
                members = members.replace("{", "");
                members = members.replace("}", "");
                params.put(numberMap.getOrDefault(dim, dim), members);
            }
        }
        HashSet existNumber = Sets.newHashSetWithExpectedSize((int)this.defaultEnum.size());
        for (DimTypesEnum dimTypesEnum : this.defaultEnum) {
            String condition = this.getByNumber(params, false, dimTypesEnum.getNumber());
            String param = this.getByNumber(params, true, dimTypesEnum.getNumber());
            this.addEntity(dimTypesEnum.getNumber(), dimTypesEnum.getName(), "root", "", ColumnTypeEnum.FIXED_COLUMN.getCode() + "", condition, !hideColumns.contains(dimTypesEnum.getNumber()), param);
            existNumber.add(dimTypesEnum.getNumber());
        }
        Map<String, String> nameMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getNumber, DimensionInfo::getName));
        String pageDimStr = this.getPageCache().get("pageDim");
        Map pageDim = (Map)SerializationUtils.fromJsonString((String)pageDimStr, Map.class);
        String hidDimStr = this.getPageCache().get("hideDim");
        HashSet ignoreSet = Sets.newHashSetWithExpectedSize((int)16);
        List hidden = (List)SerializationUtils.fromJsonString((String)hidDimStr, List.class);
        if (StringUtils.equals((CharSequence)area, (CharSequence)"hasDim")) {
            this.buildDimEntity(existNumber, nameMap, pageDim, hidden, params, hideColumns);
            for (DimensionInfo dimensionInfo : dimList) {
                String number = dimensionInfo.getNumber();
                if (existNumber.contains(number)) continue;
                this.addEntity(number, dimensionInfo.getName(), "root", "", ColumnTypeEnum.FIXED_COLUMN.getCode() + "", null, !hideColumns.contains(number), null, false);
                ignoreSet.add(number);
            }
            this.getPageCache().put("ignoreColumn", SerializationUtils.toJsonString((Object)ignoreSet));
            return;
        }
        String extendListStr = this.getPageCache().get("extendsList");
        List extendList = (List)SerializationUtils.fromJsonString((String)extendListStr, List.class);
        Optional<Map> any = extendList.stream().filter(t -> area.equals(t.get("number").toString())).findAny();
        if (!any.isPresent()) {
            return;
        }
        Map extendMap = any.get();
        Set extendsDims = this.fidmDimService.getExtendsDimNumbers(LongUtil.toLong(extendMap.get("id")));
        pageDim.keySet().retainAll(extendsDims);
        Iterator iterator = hidden.iterator();
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            if (extendsDims.contains(next.get("dimNumber").toString())) continue;
            iterator.remove();
        }
        this.buildDimEntity(existNumber, nameMap, pageDim, hidden, params, hideColumns);
        for (String number : extendsDims) {
            if (existNumber.contains(number)) continue;
            ignoreSet.add(number);
            this.addEntity(number, nameMap.get(number), "root", "", ColumnTypeEnum.FIXED_COLUMN.getCode() + "", null, !hideColumns.contains(number), null, false);
        }
        Map extendsFields = this.fidmDimService.getExtendsFields(DataSrcTypeEnum.MERGE_MODEL.getType(), modelId, LongUtil.toLong(extendMap.get("id")), "");
        List members = (List)extendMap.get("members");
        members.forEach(member -> {
            ignoreSet.add(member);
            this.addEntity((String)member, (String)extendsFields.get(member), "root", "", ColumnTypeEnum.MEASURE.getCode() + "", null, !hideColumns.contains(member), null, false);
        });
        this.getPageCache().put("ignoreColumn", SerializationUtils.toJsonString((Object)ignoreSet));
    }

    private void buildDimEntity(Set<String> existNumber, Map<String, String> nameMap, Map<String, List<Map<String, Object>>> pageDim, List<Map<String, Object>> hidden, Map<String, String> params, Set<String> hideColumns) {
        for (String string : pageDim.keySet()) {
            if (existNumber.contains(string)) continue;
            String condition = this.getByNumber(params, false, string);
            String param = this.getByNumber(params, true, string);
            this.addEntity(string, nameMap.get(string), "root", "", ColumnTypeEnum.FIXED_COLUMN.getCode() + "", condition, !hideColumns.contains(string), param);
            existNumber.add(string);
        }
        for (Map map : hidden) {
            String dimNumber = (String)map.get("dimNumber");
            if (existNumber.contains(dimNumber)) continue;
            String value = (String)map.get("number");
            this.addEntity(dimNumber, nameMap.get(dimNumber), "root", "", ColumnTypeEnum.FIXED_COLUMN.getCode() + "", value, !hideColumns.contains(dimNumber), null, false);
            existNumber.add(dimNumber);
        }
    }

    private String getByNumber(Map<String, String> params, boolean isParam, String key) {
        if (!params.containsKey(key)) {
            return null;
        }
        String s = params.get(key);
        if (isParam) {
            return "$Cur".equals(s) || "$Curs".equals(s) ? s : null;
        }
        return "$Cur".equals(s) || "$Curs".equals(s) ? null : s;
    }

    private void afterTemplateSelect(Long templateId) {
        if (!LongUtil.isvalidLong((Object)templateId)) {
            return;
        }
        Map temp = BCMMsServiceHelper.getAreaByTemplateId((Long)templateId);
        if (Objects.isNull(temp) || temp.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("areaselect");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)12);
        this.getPageCache().put("hideDim", SerializationUtils.toJsonString(temp.get("hideDim")));
        this.getPageCache().put("pageDim", SerializationUtils.toJsonString(temp.get("pageDim")));
        if (Boolean.parseBoolean(temp.get("hasDim").toString())) {
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b", (String)"DataSetDisplayPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0])), "hasDim"));
        }
        if (Boolean.parseBoolean(temp.get("hasExtend").toString())) {
            Map extendMap = (Map)temp.get("extendsMap");
            List data = this.fidmDimService.getExtendsModel(TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel()), LongUtil.toLong((Object)TypeConversionUtil.getStringValue((String)"modelselect", (IDataModel)this.getModel())));
            ArrayList extendList = Lists.newArrayListWithExpectedSize((int)extendMap.size());
            Map<String, Pair> collect = data.stream().collect(Collectors.toMap(t -> (String)t.p1, t -> new Pair(t.p2, t.p3)));
            for (Map.Entry entry : extendMap.entrySet()) {
                Pair pair = collect.get(entry.getKey());
                String extendName = (String)pair.p1;
                String title = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b-%s", (String)"DataSetDisplayPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]), extendName);
                items.add(new ComboItem(new LocaleString(title), (String)entry.getKey()));
                HashMap map = Maps.newHashMapWithExpectedSize((int)4);
                map.put("number", entry.getKey());
                map.put("name", extendName);
                map.put("id", LongUtil.toLong((Object)pair.p2));
                map.put("members", entry.getValue());
                extendList.add(map);
            }
            this.getPageCache().put("extendsList", SerializationUtils.toJsonString((Object)extendList));
        }
        comboEdit.setComboItems((List)items);
    }

    private void removeEntity(List<DimensionInfo> collect) {
        Set numberSet = collect.stream().map(t -> t.getNumber()).collect(Collectors.toSet());
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] dataEntitys = grid.getEntryData().getDataEntitys();
        ArrayList deleteRows = Lists.newArrayListWithExpectedSize((int)16);
        for (int i = dataEntitys.length - 1; i > 0; --i) {
            if (numberSet.contains(dataEntitys[i].getString("numberfield")) || numberSet.contains(dataEntitys[i].getString("parentfield"))) continue;
            deleteRows.add(i);
        }
        if (CollectionUtils.isNotEmpty((Collection)deleteRows)) {
            int[] ints = new int[deleteRows.size()];
            for (int i = 0; i < deleteRows.size(); ++i) {
                ints[i] = (Integer)deleteRows.get(i);
            }
            this.getModel().deleteEntryRows("entryentity", ints);
        }
    }

    private void initTree(Long modelId) {
        List<DimensionInfo> dimList = this.getDimList(modelId);
        List<DynamicObject> customMemberProperties = this.getCustomMemberProperties(dimList);
        this.initTreeNode(dimList, Collections.emptyList(), customMemberProperties);
    }

    @Override
    protected List<DimensionInfo> getDimList(Long modelId) {
        String type = (String)this.getModel().getValue("sourcefrom");
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)type, (Long)modelId);
        ModelStrategyEx strategy = new ModelStrategyEx(modelId, modelType.getType());
        List dimList = strategy.getDim().getDimList();
        if (DisModelTypeEnum.RPT == modelType) {
            dimList = dimList.stream().filter(t -> !DimTypesEnum.PROCESS.getNumber().equals(t.getNumber()) && !DimTypesEnum.AUDITTRIAL.getNumber().equals(t.getNumber())).collect(Collectors.toList());
        }
        return dimList;
    }

    private void afterExtendSelect(Long extendId) {
        if (!LongUtil.isvalidLong((Object)extendId)) {
            return;
        }
        if (this.isSingle(this.getDto())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"returnvalue"});
        }
        Long modelId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
        List<DimensionInfo> dimList = this.getDimList(modelId);
        Set extendsDims = this.fidmDimService.getExtendsDims(extendId);
        List<DimensionInfo> collect = dimList.stream().filter(t -> extendsDims.contains(t.getShortNumber())).collect(Collectors.toList());
        List extendsList = this.fidmDimService.getExtendsFieldstTuple(DataSrcTypeEnum.MERGE_MODEL.getType(), modelId, extendId);
        List<DynamicObject> customMemberProperties = this.getCustomMemberProperties(collect);
        this.initTreeNode(collect, extendsList, customMemberProperties);
        this.removeEntity(collect);
        this.buildReturnValueCombo();
    }

    private void afterTypeSelect(DatasetModelTypeEnum type, Long modelId) {
        this.clearEntity();
        boolean operateIsible = true;
        switch (type) {
            case DEFAULT: {
                this.initTree(modelId);
                break;
            }
            case EXTEND: {
                if (!LongUtil.isvalidLong((Object)modelId)) break;
                this.buildExtendComboEdit(modelId);
                break;
            }
            case TEMPLATE: {
                if (LongUtil.isvalidLong((Object)modelId)) {
                    this.buildTepmlateComboEdit(modelId);
                }
                operateIsible = false;
                break;
            }
            case INTEGRATION: {
                break;
            }
        }
        this.getView().setVisible(Boolean.valueOf(operateIsible), new String[]{"groupbyfield"});
    }

    @Override
    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (!this.isCurPlugin()) {
            return;
        }
        if (DatasetModelTypeEnum.TEMPLATE.getIndex().equals(this.getModel().getValue("typeselect"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u8868\u53d6\u6570\u8bf7\u52ff\u5220\u9664\u5217\u3002", (String)"DatasetConditionPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        super.beforeDeleteRow(e);
    }

    private void buildTepmlateComboEdit(Long modelId) {
        Map template = BCMMsServiceHelper.getTemplate((Long)modelId);
        ComboEdit comboEdit = (ComboEdit)this.getControl("templateselect");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)12);
        if (Objects.isNull(template) || template.isEmpty()) {
            comboEdit.setComboItems((List)items);
            return;
        }
        for (Map.Entry entry : template.entrySet()) {
            items.add(new ComboItem(new LocaleString((String)entry.getValue()), ((Long)entry.getKey()).toString()));
        }
        comboEdit.setComboItems((List)items);
    }

    private void buildExtendComboEdit(Long modelId) {
        this.getModel().setValue("extendselect", null);
        List data = this.fidmDimService.getExtendsModel(DataSrcTypeEnum.MERGE_MODEL.getType(), modelId);
        this.dataSetOperate.buildComboEditForTuple(this.getView(), data, "extendselect");
    }

    private List<DynamicObject> getCustomMemberProperties(List<DimensionInfo> dimInfoList) {
        HashSet dimIds = Sets.newHashSetWithExpectedSize((int)dimInfoList.size());
        dimInfoList.forEach(dim -> {
            Long dimId = dim.getId();
            dimIds.add(dimId);
        });
        QFilter dimFilter = new QFilter("dimension", "in", (Object)dimIds);
        QFilter levelFilter = new QFilter("level", "=", (Object)0);
        return QueryServiceHelper.query((String)"bcm_definedpropertyvalue", (String)"id,name,number,dimension.id,dimension.number", (QFilter[])new QFilter[]{dimFilter, levelFilter});
    }
}

