/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.common.dataset.dto.ColumnTypeEnum;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetMetadataVo;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.IntegrationProperty;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.AbsDatasetPopEditPlugin;
import org.apache.commons.collections.CollectionUtils;

public class DatasetPopMetadataPlugin
extends AbsDatasetPopEditPlugin {
    public static final String ISCMETADATA_ID = "iscmetadata_id";
    public static final String MEASURE_SET = "measure_set";
    public static final String PROP_ENTRYENTITY = "prop_entryentity";
    public static final String PROP_NAME = "prop_name";
    public static final String PROP_LABEL = "prop_label";
    public static final String DATA_TYPE = "data_type";
    public static final String DATA_SCHEMA = "data_schema";
    public static final Set<String> METADATANUMTYPE = Sets.newHashSet((Object[])new String[]{"decimal", "integer"});
    public static final Set<String> TABLENUMTYPE = Sets.newHashSet((Object[])new String[]{"bigint", "int", "decimal"});
    public static final String DECIMAL = "decimal";
    public static final String NUMTYPE = "kdfont kdfont-zhishitu2";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DatasetDto dto = this.commonAfterCreate();
        if (!this.isCurPlugin()) {
            return;
        }
        this.setVisibleBySourceFrom();
        if (Objects.isNull(dto.getData())) {
            return;
        }
        DatasetDataVo datasetDataVo = (DatasetDataVo)JSON.parseObject((String)dto.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0]);
        if (Objects.isNull(datasetDataVo.getMetadata())) {
            return;
        }
        this.getModel().setValue("metadatatype", (Object)datasetDataVo.getMetadata().getMetadataType());
        this.getModel().setValue("iscmetadata", (Object)datasetDataVo.getMetadata().getMetadataId());
        this.buildEntity(datasetDataVo);
        this.initTreeNode(datasetDataVo.getMetadata().getMetadataId());
        this.buildReturnValueCombo();
        if (this.isSingle(dto)) {
            this.getModel().setValue("returnvalue", (Object)dto.getValue());
        } else {
            this.getModel().setValue("returnvalues", (Object)dto.getValue());
        }
        if (Objects.nonNull(dto.getValue())) {
            this.afterReturnValueChanged(Sets.newHashSet((Object[])dto.getValue().split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getGroupBy())) {
            this.getModel().setValue("groupbyfield", (Object)true);
        }
    }

    private void buildEntity(DatasetDataVo datasetDataVo) {
        List propertyVo = datasetDataVo.getColumns();
        Set hideColumns = datasetDataVo.getHideColumns();
        for (DatasetPropertyVo column : propertyVo) {
            boolean showColumns = CollectionUtils.isEmpty((Collection)hideColumns) || !hideColumns.contains(column.getNumber());
            String condition = this.buildCondition(column.getFilters());
            this.addEntity(column.getNumber(), column.getName(), column.getSource(), "", column.getType().toString(), condition, showColumns, null);
        }
    }

    private void initTreeNode(Long metaDataId) {
        List<IntegrationProperty> integrationPropertyList = this.getMetadataProperty(metaDataId);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId("root");
        root.isDisabled();
        tree.addNode(root);
        HashMap treeMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet numCache = Sets.newHashSetWithExpectedSize((int)integrationPropertyList.size());
        for (IntegrationProperty integrationProperty : integrationPropertyList) {
            String propNumber = integrationProperty.getPropNumber();
            String propLabel = integrationProperty.getPropLabel();
            String dataType = integrationProperty.getDataType();
            TreeNode firstMetadataNode = BCMTreeUtils.createTreeNode((String)propNumber, (String)propLabel, (String)dataType, (String)"root");
            treeMap.put(propNumber, this.buildTreeMap(propNumber, propLabel, "", "root"));
            String metadataType = (String)this.getModel().getValue("metadatatype");
            if ("1".equals(metadataType)) {
                if (METADATANUMTYPE.contains(dataType)) {
                    firstMetadataNode.setIcon(NUMTYPE);
                    numCache.add(propNumber);
                } else {
                    firstMetadataNode.setIcon("kdfont kdfont-qushu2");
                }
                List childPropertyList = integrationProperty.getChildPropertyList();
                if (childPropertyList != null && childPropertyList.size() > 0) {
                    childPropertyList.forEach(childproperty -> {
                        String childPropNumber = childproperty.getPropNumber();
                        String childPropLabel = childproperty.getPropLabel();
                        String childDataType = childproperty.getDataType();
                        TreeNode childMetadataNode = BCMTreeUtils.createTreeNode((String)childPropNumber, (String)(propLabel + "_" + childPropLabel), (String)childDataType, (String)propNumber);
                        treeMap.put(childPropNumber, this.buildTreeMap(childPropNumber, childPropLabel, "", propNumber));
                        if (METADATANUMTYPE.contains(childDataType)) {
                            childMetadataNode.setIcon(NUMTYPE);
                            numCache.add(childPropNumber);
                        } else {
                            childMetadataNode.setIcon("kdfont kdfont-qushu2");
                        }
                        firstMetadataNode.addChild(childMetadataNode);
                    });
                }
            } else if ("2".equals(metadataType)) {
                if (TABLENUMTYPE.contains(dataType)) {
                    firstMetadataNode.setIcon(NUMTYPE);
                    numCache.add(propNumber);
                } else if (dataType.startsWith(DECIMAL)) {
                    firstMetadataNode.setIcon(NUMTYPE);
                    numCache.add(propNumber);
                } else {
                    firstMetadataNode.setIcon("kdfont kdfont-qushu2");
                }
            }
            root.addChild(firstMetadataNode);
        }
        tree.addNode(root);
        tree.updateNode(root);
        tree.expand("root");
        this.getPageCache().put("treeMap", JSON.toJSONString((Object)treeMap));
        this.getPageCache().put(MEASURE_SET, SerializationUtils.toJsonString((Object)numCache));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("iscmetadata".equals(key)) {
            String metadataType;
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("iscmetadata")).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList<QFilter>();
            }
            if ("1".equals(metadataType = (String)this.getModel().getValue("metadatatype"))) {
                qFilterList.add(new QFilter("type", "=", (Object)"ENTITY"));
            } else if ("2".equals(metadataType)) {
                qFilterList.add(new QFilter("type", "=", (Object)"TABLE"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"DataSetDisplayPlugin_33", (String)"epm-far-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    @Override
    protected void setVisibleBySourceFrom() {
        HashSet showSet = Sets.newHashSet((Object[])new String[]{"metadatatype", "iscmetadata", "treeviewap"});
        if (this.isSingle(this.getDto())) {
            showSet.add("singleflex");
            showSet.add("returnvalue");
        } else {
            showSet.add("mutiflex");
            showSet.add("returnvalues");
            showSet.add("groupbyfield");
        }
        this.setVisibleBySourceFrom(showSet);
    }

    private List<IntegrationProperty> getMetadataProperty(Long iscMetadataId) {
        DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)iscMetadataId, (String)"isc_metadata_schema");
        DynamicObjectCollection entryentityCollection = integrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
        ArrayList integrationPropertyList = Lists.newArrayListWithExpectedSize((int)entryentityCollection.size());
        ArrayList nodeExistFields = Lists.newArrayListWithExpectedSize((int)5);
        HashMap propNameMaps = Maps.newHashMapWithExpectedSize((int)entryentityCollection.size());
        String metadataType = (String)this.getModel().getValue("metadatatype");
        IntegrationProperty integrationProperty = null;
        for (DynamicObject propEntryEntity : entryentityCollection) {
            String propName = propEntryEntity.getString(PROP_NAME);
            String propLabel = propEntryEntity.getString(PROP_LABEL);
            String propDataType = propEntryEntity.getString(DATA_TYPE);
            String propDataSchema = propEntryEntity.getString(DATA_SCHEMA);
            propNameMaps.put(propName, propLabel);
            if ("REF".equals(propDataType) && "1".equals(metadataType)) {
                DynamicObject childIntegrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)propDataSchema)});
                if (childIntegrateObject != null) {
                    DynamicObjectCollection childEntryentityCollection = childIntegrateObject.getDynamicObjectCollection(PROP_ENTRYENTITY);
                    ArrayList childIntegrationPropertyList = Lists.newArrayListWithExpectedSize((int)childEntryentityCollection.size());
                    childEntryentityCollection.forEach(childPropEntryEntity -> {
                        String childPropName = childPropEntryEntity.getString(PROP_NAME);
                        String childPropLabel = childPropEntryEntity.getString(PROP_LABEL);
                        String childPropDataType = childPropEntryEntity.getString(DATA_TYPE);
                        String childdPropDataSchema = childPropEntryEntity.getString(DATA_SCHEMA);
                        String childField = propName + "." + childPropName;
                        propNameMaps.put(childField, childPropLabel);
                        IntegrationProperty childIntegrationProperty = new IntegrationProperty(childField, childPropLabel, childPropDataType, childdPropDataSchema, null);
                        childIntegrationPropertyList.add(childIntegrationProperty);
                    });
                    integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, (List)childIntegrationPropertyList);
                } else {
                    nodeExistFields.add(propLabel);
                    integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, null);
                }
            } else {
                integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, null);
            }
            integrationPropertyList.add(integrationProperty);
        }
        this.getPageCache().put(iscMetadataId + "name", SerializationUtils.toJsonString((Object)propNameMaps));
        if (nodeExistFields.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"DatasetSingleNewPlugin_62", (String)"epm-far-formplugin", (Object[])new Object[]{((Object)nodeExistFields).toString()}));
        }
        return integrationPropertyList;
    }

    @Override
    protected void buildReturnValueCombo() {
        Object value;
        String comboKey;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Set metaNumSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(MEASURE_SET), Set.class);
        boolean single = this.isSingle(this.getDto());
        HashSet returnValues = Sets.newHashSetWithExpectedSize((int)16);
        if (single) {
            comboKey = "returnvalue";
            value = this.getModel().getValue("returnvalue");
            if (StringUtils.isNotBlank((Object)value)) {
                returnValues.add(value.toString());
            }
        } else {
            comboKey = "returnvalues";
            value = this.getModel().getValue("returnvalues");
            if (StringUtils.isNotBlank((Object)value)) {
                String[] split = value.toString().split(",");
                returnValues.addAll(Arrays.stream(split).filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
            }
        }
        HashSet numbers = Sets.newHashSetWithExpectedSize((int)entryGrid.getEntryData().getDataEntitys().length);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dataEntity : entryGrid.getEntryData().getDataEntitys()) {
            String number = dataEntity.getString("numberfield");
            numbers.add(number);
            if (!metaNumSet.contains(number)) continue;
            items.add(new ComboItem(new LocaleString(dataEntity.getString("namefield")), number));
        }
        returnValues.retainAll(numbers);
        if (CollectionUtils.isNotEmpty((Collection)returnValues)) {
            this.getModel().setValue(comboKey, (Object)Joiner.on((String)",").join((Iterable)returnValues));
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboKey);
        comboEdit.setComboItems((List)items);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.isCurPlugin()) {
            return;
        }
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        switch (propertyName) {
            case "sourcefrom": {
                this.setVisibleBySourceFrom();
                this.paramHandler(DataSrcTypeEnum.ISC_METADATA);
                this.clearValue("metadatatype", "iscmetadata");
                this.clearReturnValues();
                break;
            }
            case "metadatatype": {
                this.clearEntity();
                this.clearTree();
                this.clearValue("iscmetadata", "returnvalue", "returnvalues");
                this.clearReturnValues();
                break;
            }
            case "iscmetadata": {
                this.clearTree();
                this.clearEntity();
                this.clearValue("returnvalue", "returnvalues");
                this.clearReturnValues();
                if (Objects.isNull(value)) {
                    return;
                }
                this.afterDataSelect(LongUtil.toLong((Object)this.getModel().getValue(ISCMETADATA_ID)));
                break;
            }
            case "returnvalues": {
                if (Objects.isNull(value)) {
                    this.afterReturnValueChanged(Collections.emptySet());
                    return;
                }
                String[] split = value.toString().split(",");
                Set<String> values = Arrays.stream(split).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toSet());
                this.afterReturnValueChanged(values);
                break;
            }
            case "returnvalue": {
                if (Objects.isNull(value)) {
                    this.afterReturnValueChanged(Collections.emptySet());
                    return;
                }
                this.afterReturnValueChanged(Sets.newHashSet((Object[])new String[]{value.toString()}));
            }
        }
    }

    private void clearReturnValues() {
        boolean single = this.isSingle(this.getDto());
        String comboKey = single ? "returnvalue" : "returnvalues";
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboKey);
        comboEdit.setComboItems((List)Lists.newArrayListWithExpectedSize((int)16));
    }

    private void afterReturnValueChanged(Set<String> values) {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        for (int i = 0; i < grid.getEntryData().getDataEntitys().length; ++i) {
            String number = grid.getEntryData().getDataEntitys()[i].getString("numberfield");
            if (values.contains(number)) {
                this.getModel().setValue("showfield", (Object)true, i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"showfield"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"showfield"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (!this.isCurPlugin()) {
            return;
        }
        this.buildReturnValueCombo();
    }

    @Override
    protected void buildDatasetDto(DatasetDto dto) {
        Set<Object> returnValues;
        IDataModel model = this.getModel();
        Object dataId = model.getValue(ISCMETADATA_ID);
        if (!LongUtil.isvalidLong((Object)dataId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"DataSetDisplayPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        if (this.isSingle(dto)) {
            Object value = model.getValue("returnvalue");
            if (Objects.isNull(value) || StringUtils.isBlank((Object)value)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"DataSetDisplayPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            returnValues = Sets.newHashSet((Object[])new String[]{value.toString()});
            dto.setValue(value.toString());
        } else {
            Object values = model.getValue("returnvalues");
            if (Objects.isNull(values) || StringUtils.isBlank((Object)values)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5fc5\u586b\u5b57\u6bb5\u3002", (String)"DataSetDisplayPlugin_25", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            returnValues = Arrays.stream(values.toString().split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toSet());
            dto.setValue(Joiner.on((String)",").join((Iterable)returnValues));
        }
        boolean needGroup = (Boolean)this.getModel().getValue("groupbyfield");
        StringBuilder groupSb = new StringBuilder();
        DatasetDataVo datasetDataVo = new DatasetDataVo();
        datasetDataVo.setHideColumns((Set)Sets.newHashSetWithExpectedSize((int)16));
        DatasetMetadataVo metadataVo = new DatasetMetadataVo();
        metadataVo.setMetadataType((String)model.getValue("metadatatype"));
        metadataVo.setMetadataId(LongUtil.toLong((Object)dataId));
        datasetDataVo.setMetadata(metadataVo);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        for (DynamicObject entity : grid.getEntryData().getDataEntitys()) {
            String number = entity.getString("numberfield");
            if (!returnValues.contains(number)) {
                if (!entity.getBoolean("showfield")) {
                    datasetDataVo.getHideColumns().add(number);
                } else if (needGroup) {
                    groupSb.append(number).append(",");
                }
            }
            DatasetPropertyVo vo = new DatasetPropertyVo();
            vo.setNumber(entity.getString("numberfield"));
            vo.setName(entity.getString("namefield"));
            vo.setType(Integer.valueOf(ColumnTypeEnum.FIXED_COLUMN.getCode()));
            vo.setSource("metadata");
            vo.setId(entity.getString("numberfield"));
            String condition = entity.getString("conditionfield");
            if (StringUtils.isNotBlank((CharSequence)condition)) {
                vo.setFilters(this.buildFilter(condition));
            }
            if (datasetDataVo.getColumns() == null) {
                datasetDataVo.setColumns((List)Lists.newArrayList((Object[])new DatasetPropertyVo[]{vo}));
                continue;
            }
            datasetDataVo.getColumns().add(vo);
        }
        if (groupSb.length() == 0) {
            dto.setGroupBy(null);
        } else {
            dto.setGroupBy(groupSb.substring(0, groupSb.length() - 1));
        }
        dto.setData(JSON.toJSONString((Object)datasetDataVo));
    }

    private void afterDataSelect(Long dataId) {
        this.initTreeNode(dataId);
    }
}

