/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.far.business.bcm.BCMDataReader;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dto.ReportDimResult;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.operatestrategy.GuideDataSetOperate;
import kd.epm.far.business.common.dataset.operatestrategy.IDataSetOperate;
import kd.epm.far.business.common.dataset.util.DatasetDimService;
import kd.epm.far.business.common.dataset.util.DatasetExpressionHelper;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DatasetStyleEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.f7.dto.MutilF7MemberResult;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.permclass.PermClassEntityHelper;
import kd.epm.far.business.common.strategy.IModel;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDataset;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.json.JacksonUtils;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.CommonDatasetEdit;
import org.apache.commons.collections.CollectionUtils;

public class DatasetSingleEditPlugin
extends CommonDatasetEdit {
    private static final String ctl_preview = "preview";
    private static final String PREVIEWLABEL = "previewlabel";
    private static final String ctl_guide = "guide";
    private static final String ctl_memberselect = "memberselect";
    private static final String FORMULA_DETAILS_PANEL = "formuladetailspanel";
    private static final String ctl_expression = "expression";
    private static final String ctl_defvalue = "defvalue";
    private static final String ctl_groupby = "groupby";
    private static final String ctl_orderby = "orderby";
    private static final String ctl_top = "top";
    private static final String ctl_radioasc = "radioasc";
    private static final String ctl_radiodesc = "radiodesc";
    private static final String ctl_singlevalue = "singlevalue";
    private static final String ctl_mulvalue = "mulvalue";
    private static final String ctl_dimnum = "dimnum";
    private static final String ctl_memnum = "memnum";
    private static final String COPY_POSTFIX = "_copy";
    private static final String EXTENDS_SELECT_NUMBERS_CACHE = "EXTENDS_SELECT_NUMBERS_CACHE";
    private static final String PROPERTY_CHANGED = "propertyChanged";
    private static final String CLICK_BTN_OK = "click_btn_ok";
    private static final String DATASET_PREVIEW_CONFIRM = "dataset_preview_confirm";
    private static final String DATASET_GUIDE_CLOSE = "dataset_guide_close";
    private static final String SELECT_MEMBER_CLOSE = "select_member_close";
    private static final String DIMNUM = "dimnum";
    private DatasetDimService fidmDimService = new DatasetDimService();
    private IDataSetOperate dataSetOperate = new GuideDataSetOperate();
    private static final String SHORT_NUMBER_MAP = "short_number_map";
    private static final String MEMBER_NUMBER_LIST = "member_number_list";
    private static final String OPERATION_LOG_NAME = "operation_log_name";

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btn_ok", ctl_preview, ctl_guide, ctl_memberselect);
        BasedataEdit permclass = (BasedataEdit)this.getView().getControl("permclass");
        PermClassEntityHelper.setPermClassFilter((BasedataEdit)permclass, (Object)this.getDMModelId(), (String)"fidmmodel", (String)this.getView().getFormShowParameter().getAppId());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "dataset_guide_close": {
                if (evt.getReturnData() == null) break;
                String ex = (String)evt.getReturnData();
                this.getModel().setValue(ctl_expression, (Object)ex);
                break;
            }
            case "select_member_close": {
                this.setMemberNum(evt.getReturnData());
                break;
            }
        }
    }

    private void setMemberNum(Object returnData) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        Object datasrcid = this.getModel().getValue("datasrcid");
        if (datasrcid == null) {
            return;
        }
        Long modelId = LongUtil.toLong((Object)datasrcid);
        MutilF7MemberResult mutilF7MemberResult = new ModelStrategyEx(modelId).getDimensionF7().getMutilF7MemberList((AbstractFormPlugin)this, returnData);
        if (mutilF7MemberResult.getMemberInfos().size() > 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u6210\u5458\u6700\u591a\u9009\u62e95\u4e2a\u3002", (String)"DatasetSingleEditPlugin_6", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        List memberList = mutilF7MemberResult.getMemberInfos().stream().map(t -> t.getNumber()).collect(Collectors.toList());
        this.getPageCache().put(MEMBER_NUMBER_LIST, SerializationUtils.toJsonString(memberList));
        this.getModel().setValue(ctl_memnum, (Object)SerializationUtils.toJsonString(memberList));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String type = (String)this.getFormCustomParam("type");
        if (!DataSetTypeEnum.getSingleEditTypes().contains(type)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u7c7b\u578b\u9519\u8bef\u3002", (String)"DatasetSingleNewPlugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        this.setVisibleByType(type);
        this.setDataSrcTypeCombo(type);
        DatasetDto dto = this.buildDataSetDto();
        this.setDataSrcTypeComboEdit(dto.getDataSrcType());
        this.setDataSrcIdComboEdit(dto.getDataSrcId());
        this.setExtendsComboEdit(LongUtil.isvalidLong((Object)dto.getExtendsModelId()));
        this.setExtendsIDComboEdit(dto);
        this.setDetailsComboEdit(dto.getExpression(), dto.getGroupBy(), dto.getOrderBy(), dto.getEbDataset());
        this.fillForm(dto);
        this.loadDimNum();
        if (Objects.equals(this.getFormCustomParam("isCopy"), false)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    private void setDetailsComboEdit(String expression, String groupBy, String orderBy, String ebDataset) {
        List dims = DatasetExpressionHelper.getExpressionDimList((String)expression, (Long)this.getDMModelId(), (Long)((Long)this.getFormCustomParam("chapterid")));
        this.setGroupComboEdit(dims, groupBy, ebDataset);
        this.setOrderComboEdit(dims, orderBy, this.getStringValue(ctl_groupby));
    }

    private void setExtendsIDComboEdit(DatasetDto dto) {
        if (DataSrcTypeEnum.COMPONENT.getType().equals(dto.getDataSrcType())) {
            this.buildComponentExpression(dto.getComponentId());
        } else {
            this.setValueComboEdit(dto.getExtendsModelId());
        }
    }

    private void setExtendsComboEdit(boolean enable) {
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{ctl_mulvalue, ctl_singlevalue});
        this.getModel().setValue("extends", (Object)enable);
        Long dataSrcId = this.getLongValue("datasrcid");
        String dataSrcType = this.getStringValue("datasrctype");
        if (LongUtil.isvalidLong((Object)dataSrcId) && Objects.equals(DisModelTypeEnum.EB, DisModelTypeEnum.getModelType((String)dataSrcType, (Long)dataSrcId))) {
            return;
        }
        if (enable) {
            this.setExtendsComboEdit();
        } else {
            this.setValueComboEdit(null);
            this.clearValue("extendsmodelid");
        }
        ComboEdit extendsModelIdComboEdit = (ComboEdit)this.getControl("extendsmodelid");
        extendsModelIdComboEdit.setVisible("", enable);
        if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(this.getFormCustomParam("type"))) {
            this.getView().setVisible(Boolean.valueOf(!enable), new String[]{"dimnum", ctl_memnum, ctl_memberselect});
        }
    }

    private boolean isSingleDataset() {
        String type = (String)this.getFormCustomParam("type");
        return Objects.equals(DataSetTypeEnum.SINGLE_VALUED.getType(), type);
    }

    private String getValueKey() {
        if (this.isSingleDataset()) {
            return ctl_singlevalue;
        }
        return ctl_mulvalue;
    }

    private void setValueComboEdit(Long extendsId) {
        String controlKey = this.getValueKey();
        ComboEdit comboEdit = (ComboEdit)this.getControl(controlKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (!LongUtil.isvalidLong((Object)extendsId)) {
            items.add(new ComboItem(new LocaleString("FMONEY"), "FMONEY"));
            comboEdit.setComboItems(items);
            this.getModel().setValue(controlKey, (Object)"FMONEY");
            return;
        }
        this.getModel().setValue(controlKey, (Object)"");
        long dataSrcId = this.getLongValue("datasrcid");
        String dataSrcType = this.getStringValue("datasrctype");
        Map extSelects = this.fidmDimService.getExtendsFields(dataSrcType, Long.valueOf(dataSrcId), extendsId, "");
        if (extSelects != null && !extSelects.isEmpty()) {
            HashSet extSelectNums = new HashSet(extSelects.size());
            for (Map.Entry ext : extSelects.entrySet()) {
                items.add(new ComboItem(new LocaleString((String)ext.getKey() + " " + (String)ext.getValue()), (String)ext.getKey()));
                extSelectNums.add(ext.getKey());
            }
            this.getPageCache().put(EXTENDS_SELECT_NUMBERS_CACHE, this.toByteSerialized(extSelectNums));
        }
        comboEdit.setComboItems(items);
    }

    private void setDataSrcIdComboEdit(Long dataSrcId) {
        ArrayList<ComboItem> items;
        if (!LongUtil.isvalidLong((Object)dataSrcId)) {
            return;
        }
        this.getModel().setValue("datasrcid", (Object)dataSrcId);
        String dataSrcType = this.getStringValue("datasrctype");
        this.clearValue(ctl_expression);
        ComboEdit comboEdit = (ComboEdit)this.getControl("extendsmodelid");
        if (Objects.equals(dataSrcType, DataSrcTypeEnum.COMPONENT.getType())) {
            DynamicObjectCollection array = QueryServiceHelper.query((String)"bcm_component_info", (String)"id,name,number,selectedarea", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)dataSrcId)});
            ArrayList<ComboItem> items2 = new ArrayList<ComboItem>(16);
            if (array == null || array.size() <= 0) {
                comboEdit.setComboItems(items2);
                return;
            }
            for (DynamicObject dyn : array) {
                if (Objects.equals("ALL", dyn.getString("selectedarea"))) continue;
                items2.add(new ComboItem(new LocaleString(dyn.getString("name")), dyn.getString("id")));
            }
            comboEdit.setComboItems(items2);
        }
        if (Objects.equals(DisModelTypeEnum.getModelType((String)dataSrcType, (Long)dataSrcId), DisModelTypeEnum.EB)) {
            DynamicObject model = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB).getModel(dataSrcId);
            List datasets = EbServiceHelper.getDataset((String)model.getString("shownumber"));
            items = new ArrayList<ComboItem>(16);
            if (CollectionUtils.isEmpty((Collection)datasets)) {
                comboEdit.setComboItems(items);
                return;
            }
            for (EbDataset data : datasets) {
                items.add(new ComboItem(new LocaleString(data.getName()), data.getNumber()));
            }
            comboEdit.setComboItems(items);
        }
        Boolean anExtends = (Boolean)this.getModel().getValue("extends");
        if (Objects.equals(dataSrcType, DataSrcTypeEnum.MERGE_MODEL.getType()) && anExtends.booleanValue()) {
            Long modelId = this.getLongValue("datasrcid");
            if (modelId == 0L) {
                comboEdit.setComboItems(null);
                return;
            }
            items = new ArrayList(16);
            String controlKey = this.getValueKey();
            ComboEdit controlKeyComboEdit = (ComboEdit)this.getControl(controlKey);
            controlKeyComboEdit.setComboItems(items);
            this.clearValue(controlKey, "extendsmodelid");
            List data = this.fidmDimService.getExtendsModel(dataSrcType, modelId);
            this.cacheExtmodel(data);
            this.buildComboEditForTuple(data, "extendsmodelid");
        }
    }

    private void setVisibleByType(String type) {
        if (Objects.equals(DataSetTypeEnum.SINGLE_VALUED.getType(), type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ctl_mulvalue, ctl_groupby, ctl_orderby, ctl_top, ctl_radioasc, ctl_radiodesc, "dimnum", ctl_memnum, ctl_memberselect});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ctl_singlevalue, ctl_defvalue});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{ctl_mulvalue, ctl_singlevalue});
    }

    private DatasetDto buildDataSetDto() {
        String fidmmodelId = (String)this.getFormCustomParam("dmmodelid");
        this.getPageCache().put("dmmodelid", fidmmodelId);
        DatasetDto dataSetDto = new DatasetDto();
        dataSetDto.setDataSrcType(DataSrcTypeEnum.CURRENT_MODEL.getType());
        dataSetDto.setDataSrcId(LongUtil.toLong((Object)fidmmodelId));
        dataSetDto.setValue("FMONEY");
        dataSetDto.setExpression(dataSetDto.buildDetails());
        dataSetDto.setDefValue("3");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (Objects.isNull(status) || !status.equals((Object)OperationStatus.EDIT)) {
            return dataSetDto;
        }
        Long datasetId = Long.valueOf((String)this.getFormCustomParam("dataset_id"));
        Boolean isCopy = (Boolean)this.getFormCustomParam("isCopy");
        dataSetDto = this.dataSetOperate.buildDataSetDto(dataSetDto, status, datasetId.longValue(), isCopy);
        this.getPageCache().put("datasetDto", SerializationUtils.toJsonString((Object)dataSetDto));
        return dataSetDto;
    }

    private void setDataSrcTypeCombo(String type) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("datasrctype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.CURRENT_MODEL.getName()), DataSrcTypeEnum.CURRENT_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.MERGE_MODEL.getName()), DataSrcTypeEnum.MERGE_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.RPT_MODEL.getName()), DataSrcTypeEnum.RPT_MODEL.getType()));
        items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.EB_MODEL.getName()), DataSrcTypeEnum.EB_MODEL.getType()));
        if (Objects.equals(DataSetTypeEnum.MULTIPLE_ROW.getType(), type) && this.isMergeModel()) {
            items.add(new ComboItem(new LocaleString(DataSrcTypeEnum.COMPONENT.getName()), DataSrcTypeEnum.COMPONENT.getType()));
        }
        comboEdit.setComboItems(items);
        this.getModel().setValue(ctl_defvalue, (Object)"3");
    }

    private boolean isMergeModel() {
        ModelInfo dmModel = this.getDMModel();
        return Objects.equals(dmModel.getModelType(), DisModelTypeEnum.CM.getType());
    }

    private void loadDimNum() {
        Object[] split;
        Object datasrcid = this.getModel().getValue("datasrcid");
        if (Objects.isNull(datasrcid) || StringUtil.isEmptyString((String)datasrcid.toString()) || !LongUtil.isvalidLong((Object)datasrcid)) {
            return;
        }
        String dimValue = (String)this.getModel().getValue("dimnum");
        Long modelId = LongUtil.toLong((Object)datasrcid);
        if (Objects.equals(DisModelTypeEnum.getModelType((String)this.getStringValue("datasrctype"), (Long)modelId), DisModelTypeEnum.EB)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("dimnum");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
        List dims = DatasetExpressionHelper.getExpressionDimList((String)this.getStringValue(ctl_expression), (Long)this.getDMModelId(), (Long)((Long)this.getFormCustomParam("chapterid")));
        if (CollectionUtils.isEmpty((Collection)dims)) {
            return;
        }
        String groupBy = (String)this.getModel().getValue(ctl_groupby);
        if (StringUtils.isNotEmpty((CharSequence)groupBy) && (split = groupBy.split(",")).length > 0) {
            dims = Lists.newArrayList((Object[])split);
        }
        DisModelTypeEnum datasrctype = DisModelTypeEnum.getModelType((String)this.getStringValue("datasrctype"), (Long)this.getModelId());
        Map map = ModelStrategy.getStrategy((DisModelTypeEnum)datasrctype).getDimensionNumber2nameMap(modelId, this.getStringValue("extendsmodelid"));
        boolean needClear = true;
        for (String dim : dims) {
            String s = (String)map.get(dim);
            if (StringUtils.isBlank((CharSequence)s)) continue;
            String[] split2 = s.split(";");
            data.add(new ComboItem(new LocaleString(split2[1]), split2[0]));
            if (!Objects.equals(dimValue, split2[0])) continue;
            needClear = false;
        }
        if (needClear) {
            this.getModel().setValue("dimnum", (Object)"");
        }
        comboEdit.setComboItems(data);
    }

    private boolean checkPerm() {
        String isReadOnly = (String)this.getFormCustomParam(this.getView().getFormShowParameter(), "dataset");
        return !StringUtil.equals((String)"true", (String)isReadOnly);
    }

    private void showDetails() {
        Boolean showDetails = (Boolean)this.getModel().getValue("showdetails");
        if (showDetails == null || Boolean.FALSE.equals(showDetails)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FORMULA_DETAILS_PANEL});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FORMULA_DETAILS_PANEL});
        if ("1".equals(this.getFormCustomParam("type"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ctl_expression, ctl_singlevalue, ctl_defvalue});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ctl_groupby, ctl_orderby, ctl_top, ctl_radioasc, ctl_radiodesc});
        } else {
            IDataModel dataModel = this.getModel();
            String dataSrcType = (String)dataModel.getValue("datasrctype");
            ModelInfo dmModel = this.getDMModel();
            String modelType = dmModel.getModelType();
            DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType((String)dataSrcType);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ctl_expression, ctl_mulvalue});
            this.batchSetVisible(this.needShowDimNum(typeEnum, modelType), "dimnum", ctl_memnum, ctl_memberselect, ctl_groupby, ctl_orderby, ctl_top, ctl_radioasc, ctl_radiodesc);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ctl_defvalue});
        }
        String dataSrcType = (String)this.getModel().getValue("datasrctype");
        if (DataSrcTypeEnum.COMPONENT.getType().equals(dataSrcType)) {
            this.fillIsComponent(true);
        }
    }

    private void fillForm(DatasetDto dto) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("number", (Object)dto.getNumber());
        dataModel.setValue("name", dto.getName());
        dataModel.setValue(ctl_expression, (Object)dto.getExpression());
        dataModel.setValue(ctl_defvalue, (Object)dto.getDefValue());
        dataModel.setValue(ctl_orderby, (Object)dto.getOrderBy());
        dataModel.setValue("asc", (Object)dto.getAsc());
        dataModel.setValue(ctl_top, (Object)dto.getTop());
        dataModel.setValue("details", (Object)dto.buildDetails((String)this.getFormCustomParam("type")));
        if (LongUtil.isvalidLong((Object)dto.getId())) {
            this.fillPermClass(dto.getId());
        }
        if (DataSrcTypeEnum.COMPONENT.getType().equals(dto.getDataSrcType())) {
            ComboEdit extendsModelIdComboEdit = (ComboEdit)this.getControl("extendsmodelid");
            extendsModelIdComboEdit.setVisible("", true);
            dataModel.setValue("extendsmodelid", (Object)dto.getComponentId());
        } else if (StringUtils.isNotEmpty((CharSequence)dto.getEbDataset())) {
            dataModel.setValue("extendsmodelid", (Object)dto.getEbDataset());
        } else {
            dataModel.setValue("extendsmodelid", (Object)dto.getExtendsModelId());
        }
        dataModel.setValue(this.getValueKey(), (Object)dto.getValue());
        dataModel.setValue("dimnum", (Object)dto.getDimNum());
        if (StringUtils.isNotEmpty((CharSequence)dto.getMemberNum())) {
            String memberNum = dto.getMemberNum();
            dataModel.setValue(ctl_memnum, (Object)memberNum);
            this.getPageCache().put(MEMBER_NUMBER_LIST, memberNum);
        }
    }

    private void fillPermClass(long datasetId) {
        DynamicObject permClassEntity = PermClassEntityHelper.getDiscPermissionClassEntity((String)"fidm_dataset", (Long)datasetId, (Object)this.getDMModelId(), (String)"fidmmodel", (String)"");
        if (permClassEntity != null) {
            Long permClassId = permClassEntity.getLong("permclass.id");
            this.getModel().setValue("permclass", (Object)permClassId);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(CLICK_BTN_OK) != null) {
            this.getView().returnDataToParent((Object)"");
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Boolean isCopy = (Boolean)this.getFormCustomParam("isCopy");
        if (Objects.equals(Boolean.TRUE, isCopy)) {
            this.getPageCache().put(OPERATION_LOG_NAME, OperationName.COPY.toString());
        } else if (Objects.equals(fsp.getStatus(), OperationStatus.EDIT)) {
            this.getPageCache().put(OPERATION_LOG_NAME, OperationName.MODIFY.toString());
        } else {
            this.getPageCache().put(OPERATION_LOG_NAME, OperationName.CREATE.toString());
        }
        if ("btn_ok".equals(key)) {
            DatasetDto dto;
            if (Objects.equals(Boolean.TRUE, isCopy)) {
                super.checkPerm("btn_copy", this.getView().getParentView().getEntityId());
            } else if (Objects.equals(fsp.getStatus(), OperationStatus.EDIT)) {
                super.checkPerm("btn_ok");
            } else {
                super.checkPerm("btn_new", this.getView().getParentView().getEntityId());
            }
            if (!this.checkPerm()) {
                this.writeLog(OperationResult.FAILURE);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u60a8\u4ec5\u6709\u201c\u53ea\u8bfb\u201d\u6743\u9650\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"DatasetSingleEditPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                dto = this.prepareSave();
            }
            catch (KDBizException e) {
                this.writeLog(OperationResult.FAILURE);
                throw e;
            }
            if (Objects.equals(Boolean.TRUE, isCopy)) {
                try {
                    DatasetServiceHelper.addDataset((DatasetDto)dto, (IDataModel)this.getModel());
                }
                catch (KDBizException e) {
                    this.writeLog(OperationResult.FAILURE);
                    throw e;
                }
                this.writeLog(OperationResult.SUCCESS);
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"DatasetSingleNewPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.getView().returnDataToParent((Object)"");
                this.getView().close();
                return;
            }
            if (fsp.getStatus() != null && fsp.getStatus().equals((Object)OperationStatus.EDIT)) {
                this.editDataset(dto);
            } else {
                this.initDataset(dto);
                this.afterInit(dto.getId());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DatasetSingleNewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
        } else if (ctl_preview.equals(key)) {
            String propertyChanged = this.getPageCache().get(PROPERTY_CHANGED);
            if (propertyChanged != null || Objects.equals(Boolean.TRUE, isCopy)) {
                super.checkPerm("btn_copy", this.getView().getParentView().getEntityId());
                this.showConfirmOnPreview();
            } else {
                String datasetId = (String)this.getFormCustomParam("dataset_id");
                if (StringUtils.isNotBlank((CharSequence)datasetId)) {
                    ModelStrategy.checkUseModels((Long)Long.valueOf(datasetId), (String)"");
                }
                this.openPreviewPage();
            }
        } else if (ctl_guide.equals(key)) {
            this.openGuidePage();
        } else if (ctl_memberselect.equals(key)) {
            this.openSelectPage();
        }
    }

    private boolean checkMemberNum() {
        String dimNum = this.getStringValue("dimnum");
        if (StringUtils.isBlank((CharSequence)dimNum)) {
            return true;
        }
        String memNum = this.getStringValue(ctl_memnum);
        return !StringUtils.isBlank((CharSequence)memNum);
    }

    private void openSelectPage() {
        String dimnum = this.getStringValue("dimnum");
        if (StringUtils.isBlank((CharSequence)dimnum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7ef4\u5b57\u6bb5\u3002", (String)"DatasetSingleEditPlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Object datasrcid = this.getModel().getValue("datasrcid");
        Long modelId = LongUtil.toLong((Object)datasrcid);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECT_MEMBER_CLOSE);
        List memeberNumberList = new ArrayList(100);
        if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get(MEMBER_NUMBER_LIST))) {
            memeberNumberList = JSON.parseArray((String)this.getPageCache().get(MEMBER_NUMBER_LIST), String.class);
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        DimensionInfo dim = DimensionUtils.getDimByNumber((List)modelStrategyEx.getDim().getDimList(), (String)dimnum);
        modelStrategyEx.getDimensionF7().openMutilF7((AbstractFormPlugin)this, dim, memeberNumberList, closeCallBack, false);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "dataset_preview_confirm": {
                if (!MessageBoxResult.Yes.equals((Object)evt.getResult())) break;
                DatasetDto dto = this.prepareSave();
                String id = (String)this.getFormCustomParam("dataset_id");
                if (Objects.equals(Boolean.TRUE, this.getFormCustomParam("isCopy")) || Objects.isNull(id)) {
                    this.initDataset(dto);
                    this.afterInit(dto.getId());
                } else {
                    this.editDataset(dto);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DatasetSingleNewPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                this.openPreviewPage();
                break;
            }
        }
    }

    private void afterInit(Long datasetId) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        fsp.setCustomParam("dataset_id", (Object)String.valueOf(datasetId));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{ctl_preview, PREVIEWLABEL});
        fsp.setCustomParam("isCopy", (Object)false);
        fsp.setStatus(OperationStatus.EDIT);
        this.getPageCache().put(FormShowParameter.class.getSimpleName(), fsp.toString());
    }

    private DatasetDto prepareSave() {
        this.getPageCache().remove(PROPERTY_CHANGED);
        this.getPageCache().put(CLICK_BTN_OK, "");
        DatasetDto dto = this.buildDatasetDtoFromPage();
        this.valid(dto);
        dto.setStyle(DatasetStyleEnum.GUIDE.getType());
        return dto;
    }

    private DatasetDto buildDatasetDtoFromPage() {
        Object name;
        String memberListStr;
        DatasetDto dto = new DatasetDto();
        dto.setDiscmodelId(this.getDMModelId());
        dto.setType((String)this.getFormCustomParam("type"));
        dto.setNumber(this.getStringValue("number"));
        dto.setDimNum(this.getStringValue("dimnum"));
        if (StringUtils.isNotEmpty((CharSequence)dto.getDimNum()) && StringUtils.isNotEmpty((CharSequence)(memberListStr = this.getPageCache().get(MEMBER_NUMBER_LIST)))) {
            dto.setMemberNum(memberListStr);
        }
        if ((name = this.getModel().getValue("name")) instanceof Map) {
            if (!((Map)name).isEmpty()) {
                dto.setName((Object)LocaleString.fromMap((Map)((Map)name)));
            }
        } else {
            dto.setName((Object)name.toString());
        }
        dto.setDataSrcType(this.getStringValue("datasrctype"));
        dto.setDataSrcId(this.getLongValue("datasrcid"));
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)this.getStringValue("datasrctype"), (Long)this.getLongValue("datasrcid"));
        if (Objects.equals(modelType, DisModelTypeEnum.EB)) {
            String extendsmodelid = this.getStringValue("extendsmodelid");
            dto.setEbDataset(extendsmodelid);
            if (LongUtil.isvalidLong((Object)dto.getDataSrcId())) {
                DynamicObject model = EbServiceHelper.getModel((Long)dto.getDataSrcId());
                dto.setDataSrcNumber(model.getString("shownumber"));
            }
        } else {
            if (LongUtil.isvalidLong((Object)this.getLongValue("extendsmodelid"))) {
                if (DataSrcTypeEnum.COMPONENT.getType().equals(this.getStringValue("datasrctype"))) {
                    dto.setComponentId(this.getLongValue("extendsmodelid"));
                } else {
                    dto.setExtendsModelId(this.getLongValue("extendsmodelid"));
                    Map id2number = new HashMap(2);
                    if (this.getPageCache().get("extmodel") != null) {
                        id2number = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("extmodel"));
                    }
                    dto.setExtendsModelNumber((String)id2number.get(this.getStringValue("extendsmodelid")));
                }
            }
            if (LongUtil.isvalidLong((Object)dto.getDataSrcId())) {
                DynamicObject model = BCMDataReader.getModel((Long)dto.getDataSrcId());
                dto.setDataSrcNumber(model.getString("shownumber"));
            }
        }
        dto.setExpression(this.getStringValue(ctl_expression));
        if (Objects.equals("1", this.getFormCustomParam("type"))) {
            dto.setValue(this.getStringValue(ctl_singlevalue));
            dto.setDefValue(this.getStringValue(ctl_defvalue));
        } else {
            dto.setValue(this.getStringValue(ctl_mulvalue));
        }
        dto.setValue(this.getStringValue(Objects.equals("1", this.getFormCustomParam("type")) ? ctl_singlevalue : ctl_mulvalue));
        dto.setGroupBy(this.getStringValue(ctl_groupby));
        dto.setOrderBy(this.getStringValue(ctl_orderby));
        dto.setAsc(this.getStringValue("asc"));
        dto.setTop(this.getIntValue(ctl_top));
        String scope = (String)this.getFormCustomParam("scope");
        if (StringUtils.isNotEmpty((CharSequence)scope) && "2".equals(scope)) {
            dto.setScope(scope);
            dto.setChapterId((Long)this.getFormCustomParam("chapterid"));
        } else {
            dto.setScope("1");
        }
        dto.setValue(dto.value());
        return dto;
    }

    private void valid(DatasetDto dto) {
        this.validDto(dto, this.isShowExtends(), this.checkMemberNum());
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != null && status.equals((Object)OperationStatus.EDIT)) {
            Boolean isCopy = (Boolean)this.getFormCustomParam("isCopy");
            if (Boolean.TRUE.equals(isCopy)) {
                DatasetServiceHelper.checkDatasetNumber((String)dto.getNumber(), (long)this.getDMModelId(), (long)0L);
            } else {
                String datasetId = (String)this.getFormCustomParam("dataset_id");
                DatasetServiceHelper.checkDatasetNumber((String)dto.getNumber(), (long)this.getDMModelId(), (long)Long.parseLong(datasetId));
            }
        } else {
            DatasetServiceHelper.checkDatasetNumber((String)dto.getNumber(), (long)this.getDMModelId(), (long)0L);
        }
    }

    private String checkValidDimsForGroupby(String expression) {
        String[] expressions = expression.split(",");
        HashSet<String> set = new HashSet<String>(8);
        Set<String> items = this.getComboItems(ctl_groupby);
        if (items.size() == 0) {
            return "";
        }
        for (String s : expressions) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (!items.contains(s) || set.contains(s)) {
                if (!items.contains(s)) {
                    return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684%1$s \u7684 %2$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u5b58\u5728 \u3002", (String)"DatasetSingleNewPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]), expression, s);
                }
                if (set.contains(s)) {
                    return String.format(ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684%1$s \u7684 %2$s\u91cd\u590d \u3002", (String)"DatasetSingleNewPlugin_35", (String)"epm-far-formplugin", (Object[])new Object[0]), expression, s);
                }
            }
            if (!items.contains(s)) continue;
            set.add(s);
        }
        return "";
    }

    private String checkValidDimsForOrderby(String expression) {
        String[] expressions = expression.split(",");
        String[] groupbys = this.getStringValue(ctl_groupby).split(",");
        HashSet<String> set = new HashSet<String>(8);
        Set<String> items = this.getComboItems(ctl_groupby);
        if (items.size() == 0) {
            return "";
        }
        List grouplist = Arrays.stream(groupbys).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(grouplist)) {
            for (String g : expressions) {
                if (StringUtils.isBlank((CharSequence)g)) continue;
                if (!grouplist.contains(g)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6392\u5e8f\u5b57\u6bb5%1$s \u4e0d\u5728\u5206\u7ec4\u5b57\u6bb5%2$s\u4e2d \u3002", (String)"DatasetSingleNewPlugin_43", (String)"epm-far-formplugin", (Object[])new Object[0]), g, this.getStringValue(ctl_groupby)));
                }
                set.add(g);
            }
        } else {
            for (String s : expressions) {
                if (StringUtils.isBlank((CharSequence)s)) continue;
                if (!items.contains(s) || set.contains(s)) {
                    if (!items.contains(s)) {
                        return String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684%1$s \u7684 %2$s\uff0c\u8bf7\u786e\u8ba4\u8be5\u7ef4\u5ea6\u5b58\u5728 \u3002", (String)"DatasetSingleNewPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]), expression, s);
                    }
                    if (set.contains(s)) {
                        return String.format(ResManager.loadKDString((String)"\u201c\u7ef4\u5ea6\u7ec4\u5408\u201d\u4e2d\u7684%1$s \u7684 %2$s\u91cd\u590d \u3002", (String)"DatasetSingleNewPlugin_35", (String)"epm-far-formplugin", (Object[])new Object[0]), expression, s);
                    }
                }
                if (!items.contains(s)) continue;
                set.add(s);
            }
        }
        return "";
    }

    private Set<String> getComboItems(String comboEditKey) {
        Map controlMetaState = this.getClientViewProxy().getControlMetaState(comboEditKey);
        HashSet<String> valueSet = new HashSet<String>();
        if (controlMetaState instanceof Map) {
            Object metaState = controlMetaState.get("st");
            ArrayList viewStateList = (ArrayList)metaState;
            for (int i = 0; i < viewStateList.size(); ++i) {
                Object comboItem = viewStateList.get(i);
                if (!(comboItem instanceof List)) continue;
                for (Object comboContent : (List)comboItem) {
                    if (!(comboContent instanceof String)) continue;
                    valueSet.add((String)comboContent);
                }
            }
        }
        return valueSet;
    }

    private void batchSetVisible(boolean b, String ... keys) {
        this.getView().setVisible(Boolean.valueOf(b), keys);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getPageCache().put(PROPERTY_CHANGED, "");
        IDataModel dataModel = this.getModel();
        String propertyName = e.getProperty().getName();
        String dataSrcType = (String)dataModel.getValue("datasrctype");
        switch (propertyName) {
            case "datasrctype": {
                if (StringUtils.isEmpty((CharSequence)dataSrcType)) {
                    return;
                }
                this.setDataSrcTypeComboEdit(dataSrcType);
                break;
            }
            case "expression": 
            case "singlevalue": 
            case "mulvalue": 
            case "defvalue": 
            case "groupby": 
            case "orderby": 
            case "top": {
                Object newValue;
                if (ctl_defvalue.equals(propertyName) && ((newValue = e.getChangeSet()[0].getNewValue()) == null || newValue.toString().isEmpty())) {
                    dataModel.setValue(ctl_defvalue, (Object)"3");
                }
                if (this.checktheSame(propertyName)) {
                    return;
                }
                this.buildOrderbySortby();
                this.buildDetails();
                this.loadDimNum();
                break;
            }
            case "details": {
                if (this.checktheSame(propertyName)) {
                    return;
                }
                List<String> list = this.findExpression();
                if (CollectionUtils.isEmpty(list)) {
                    return;
                }
                String type = (String)this.getFormCustomParam("type");
                if ("1".equals(type)) {
                    dataModel.setValue(ctl_expression, (Object)list.get(0));
                    if (this.isShowExtends()) {
                        dataModel.setValue(ctl_singlevalue, (Object)this.trimExtSelectNumbers(list.get(1)));
                    }
                    dataModel.setValue(ctl_defvalue, (Object)DatasetDto.getDefValueByName((String)list.get(2)));
                } else {
                    dataModel.setValue(ctl_expression, (Object)list.get(0));
                    if (this.isShowExtends()) {
                        dataModel.setValue(ctl_mulvalue, (Object)this.trimExtSelectNumbers(list.get(1)));
                    }
                    dataModel.setValue(ctl_groupby, (Object)list.get(2));
                    dataModel.setValue(ctl_orderby, (Object)list.get(3));
                    dataModel.setValue(ctl_top, (Object)list.get(4));
                    String msg = this.checkValidDimsForGroupby(list.get(2)) + this.checkValidDimsForOrderby(list.get(3));
                    if (StringUtils.isNotEmpty((CharSequence)msg)) {
                        this.getView().showErrorNotification(msg);
                    }
                }
                this.buildOrderbySortby();
                break;
            }
            case "showdetails": {
                this.showDetails();
                break;
            }
            case "extends": {
                this.setExtendsComboEdit((Boolean)this.getValue(propertyName));
                break;
            }
            case "datasrcid": {
                this.setDataSrcIdComboEdit(LongUtil.toLong((Object)this.getModel().getValue("datasrcid")));
                break;
            }
            case "extendsmodelid": {
                Object value = this.getValue(propertyName);
                if (Objects.isNull(value) || StringUtil.isEmptyString((String)value.toString())) {
                    return;
                }
                if (Objects.equals(DisModelTypeEnum.getModelType((String)dataSrcType, (Long)LongUtil.toLong((Object)this.getModel().getValue("datasrcid"))), DisModelTypeEnum.EB)) {
                    this.clearValue(ctl_expression);
                    return;
                }
                if (!LongUtil.isvalidLong((Object)value)) {
                    return;
                }
                DatasetDto datasetDto = new DatasetDto();
                datasetDto.setDataSrcType(dataSrcType);
                if (DataSrcTypeEnum.COMPONENT.getType().equals(dataSrcType)) {
                    datasetDto.setComponentId(LongUtil.toLong((Object)value));
                } else {
                    datasetDto.setExtendsModelId(LongUtil.toLong((Object)value));
                }
                this.setExtendsIDComboEdit(datasetDto);
                break;
            }
            case "dimnum": {
                this.initEmptyValueByKey(ctl_memnum);
                this.getPageCache().put(MEMBER_NUMBER_LIST, null);
                break;
            }
        }
    }

    private void initEmptyValueByKey(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, (Object)"");
        }
    }

    private void fillIsComponent(boolean isComponent) {
        this.batchSetVisible(!isComponent, "extends", ctl_guide, ctl_expression, "details", "showdetails");
        ComboEdit edit = (ComboEdit)this.getControl("extendsmodelid");
        String msg = isComponent ? ResManager.loadKDString((String)"\u62a5\u8868\u5207\u7247", (String)"DatasetSingleEditPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b", (String)"DatasetSingleEditPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]);
        edit.setCaption(new LocaleString(msg));
        edit.setVisible("", isComponent);
    }

    private void buildComponentExpression(Object newValue) {
        if (newValue == null || StringUtil.isEmptyString((String)newValue.toString()) || !LongUtil.isvalidLong((Object)newValue)) {
            return;
        }
        Long componentId = LongUtil.toLong((Object)newValue);
        if (BCMMsServiceHelper.reportsectionCheckArea((Long)componentId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5207\u7247\u5305\u542b\u6d6e\u52a8\u533a\u57df\uff0c\u6682\u4e0d\u652f\u6301\u9009\u62e9\u3002", (String)"DatasetSingleEditPlugin_4", (String)"epm-far-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("extendsmodelid", (Object)0L);
            return;
        }
        StringBuilder sb = new StringBuilder();
        ReportDimResult reportDimResult = BCMMsServiceHelper.reportDimResultQueryData((Long)componentId);
        String pageDim = reportDimResult.getPageDim();
        List list = (List)JacksonUtils.fromJson((String)pageDim, List.class);
        for (String dim : list) {
            String shortNumber = this.getShortNumber(dim);
            sb.append(shortNumber).append(".").append("$Cur").append(",");
        }
        LinkedHashSet dimKeys = reportDimResult.getDimKeys();
        List dimValues = reportDimResult.getDimValues();
        HashMap members = Maps.newHashMapWithExpectedSize((int)16);
        for (Object dimValue : dimValues) {
            if (StringUtils.isEmpty((CharSequence)dimValue)) continue;
            String[] split = ((String)dimValue).split("#");
            for (int i = 0; i < split.length; ++i) {
                if (members.containsKey(i)) {
                    ((Set)members.get(i)).add(split[i]);
                    continue;
                }
                HashSet sets = Sets.newHashSetWithExpectedSize((int)16);
                sets.add(split[i]);
                members.put(i, sets);
            }
        }
        int index = 0;
        for (String dimKey : dimKeys) {
            String shortNumber = this.getShortNumber(dimKey);
            Set strings = (Set)members.get(index);
            ++index;
            if (CollectionUtils.isEmpty((Collection)strings)) continue;
            sb.append(shortNumber).append(".");
            if (strings.size() == 1) {
                for (String s1 : strings) {
                    sb.append(s1);
                }
                sb.append(",");
                continue;
            }
            sb.append("{");
            for (String s1 : strings) {
                sb.append(s1).append(";");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("},");
        }
        String substring = sb.substring(0, sb.length() - 1);
        this.getModel().setValue(ctl_expression, (Object)substring);
    }

    private String getShortNumber(String number) {
        String shortNumber = DimTypesEnum.getShortNumberByNumber((String)number);
        if (StringUtils.isNotEmpty((CharSequence)shortNumber)) {
            return shortNumber;
        }
        return this.getShortNumberByCache(number);
    }

    private String getShortNumberByCache(String number) {
        Object modelId = this.getModel().getValue("datasrcid");
        String mapStr = this.getPageCache().get(SHORT_NUMBER_MAP + modelId);
        if (StringUtils.isNotEmpty((CharSequence)mapStr)) {
            return (String)((Map)JSONObject.parseObject((String)mapStr, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0])).get(number);
        }
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"bcm_dimension", (String)"number,shortnumber", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)LongUtil.toLong((Object)modelId))});
        HashMap map = Maps.newHashMapWithExpectedSize((int)dcs.size());
        dcs.forEach(t -> map.put(t.getString("number"), t.getString("shortnumber")));
        this.getPageCache().put(SHORT_NUMBER_MAP + modelId, JSON.toJSONString((Object)map));
        return (String)map.get(number);
    }

    private void buildDetails() {
        DatasetDto dto = new DatasetDto();
        dto.setExpression(this.getStringValue(ctl_expression));
        dto.setValue(this.getStringValue(Objects.equals("1", this.getFormCustomParam("type")) ? ctl_singlevalue : ctl_mulvalue));
        dto.setDefValue(this.getStringValue(ctl_defvalue));
        dto.setGroupBy(this.getStringValue(ctl_groupby));
        dto.setOrderBy(this.getStringValue(ctl_orderby));
        dto.setTop(this.getIntValue(ctl_top));
        this.getModel().setValue("details", (Object)dto.buildDetails((String)this.getFormCustomParam("type")));
    }

    private boolean checktheSame(String key) {
        String currentValue = this.getStringValue(key);
        List<String> list = this.findExpression();
        if (CollectionUtils.isEmpty(list)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u8868\u8fbe\u5f0f\u4e2d\u53c2\u6570\u6570\u91cf\u4e0e\u5e94\u6709\u6570\u91cf\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u3002", (String)"DatasetSingleNewPlugin_52", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String type = (String)this.getFormCustomParam("type");
        int index = 0;
        if ("details".equals(key)) {
            if ("1".equals(type)) {
                if (list.size() != 3) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u8868\u8fbe\u5f0f\u4e2d\u53c2\u6570\u6570\u91cf\u4e0e\u5e94\u6709\u6570\u91cf\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u3002", (String)"DatasetSingleNewPlugin_52", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                if (Objects.equals(list.get(0), this.getStringValue(ctl_expression)) && Objects.equals(list.get(1), this.getStringValue(ctl_singlevalue)) && Objects.equals(list.get(2), this.getStringValue(ctl_defvalue))) {
                    return true;
                }
            } else {
                if (list.size() != 5) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u8868\u8fbe\u5f0f\u4e2d\u53c2\u6570\u6570\u91cf\u4e0e\u5e94\u6709\u6570\u91cf\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\u53d6\u6570\u8868\u8fbe\u5f0f\u8bbe\u7f6e\u3002", (String)"DatasetSingleNewPlugin_52", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
                if (Objects.equals(list.get(0), this.getStringValue(ctl_expression)) && Objects.equals(list.get(1), this.getStringValue(ctl_mulvalue)) && Objects.equals(list.get(2), this.getStringValue("groupBy")) && Objects.equals(list.get(3), this.getStringValue("orderBy")) && Objects.equals(list.get(4), this.getStringValue(ctl_top))) {
                    return true;
                }
            }
            return false;
        }
        switch (key) {
            case "expression": {
                index = 0;
                break;
            }
            case "singlevalue": 
            case "mulvalue": {
                index = 1;
                break;
            }
            case "defvalue": {
                index = 2;
                break;
            }
            case "groupby": {
                index = 2;
                break;
            }
            case "orderby": {
                index = 3;
                break;
            }
            case "top": {
                index = 4;
                break;
            }
        }
        return index > list.size() || Objects.equals(currentValue, list.get(index));
    }

    private void buildOrderbySortby() {
        if (StringUtils.isEmpty((CharSequence)this.getStringValue(ctl_expression))) {
            this.clearComboEdit(ctl_groupby, ctl_orderby);
            this.clearValue(ctl_groupby, ctl_orderby, ctl_top, ctl_memnum, "dimnum");
            ComboEdit comboEdit = (ComboEdit)this.getControl("dimnum");
            ArrayList data = new ArrayList(16);
            comboEdit.setComboItems(data);
            return;
        }
        List dims = DatasetExpressionHelper.getExpressionDimList((String)this.getStringValue(ctl_expression), (Long)this.getDMModelId(), (Long)((Long)this.getFormCustomParam("chapterid")));
        this.setGroupComboEdit(dims, this.getStringValue(ctl_groupby), this.getStringValue("extendsmodelid"));
        this.setOrderComboEdit(dims, this.getStringValue(ctl_orderby), this.getStringValue(ctl_groupby));
    }

    private void clearComboEdit(String ... params) {
        for (String param : params) {
            ComboEdit comobo = (ComboEdit)this.getControl(param);
            comobo.setComboItems(Collections.emptyList());
        }
    }

    private boolean isShowExtends() {
        Boolean showExtends = (Boolean)this.getModel().getValue("extends");
        return Boolean.TRUE.equals(showExtends);
    }

    private String trimExtSelectNumbers(String value) {
        if (value == null || value.trim().isEmpty()) {
            return "";
        }
        if ("FMONEY".equals(value)) {
            return value;
        }
        String[] array = value.split(",");
        if (array == null || array.length <= 0) {
            return "";
        }
        String cache = this.getPageCache().get(EXTENDS_SELECT_NUMBERS_CACHE);
        if (cache == null || cache.isEmpty()) {
            return "";
        }
        Set extSelectNums = (Set)this.deSerializedBytes(cache);
        if (extSelectNums == null || extSelectNums.isEmpty()) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(8);
        for (String ele : array) {
            if (!extSelectNums.contains(ele = ele.trim()) || list.contains(ele)) continue;
            list.add(ele);
        }
        return list.isEmpty() ? "" : String.join((CharSequence)",", list);
    }

    private List<String> findExpression() {
        String details = this.getStringValue("details");
        return DatasetServiceHelper.findExpressionRegex((String)details);
    }

    private void setDataSrcTypeComboEdit(String dataSrcType) {
        if (StringUtils.isEmpty((CharSequence)dataSrcType)) {
            return;
        }
        this.getModel().setValue("datasrctype", (Object)dataSrcType);
        this.getModel().setValue("datasrcid", null);
        ModelInfo dmModel = this.getDMModel();
        String modelType = dmModel.getModelType();
        this.setExtendsComboEdit(false);
        FieldEdit fieldEdit = (FieldEdit)this.getControl("extends");
        fieldEdit.setVisible("", false);
        ComboEdit extendsModelIdComboEdit = (ComboEdit)this.getControl("extendsmodelid");
        extendsModelIdComboEdit.setVisible("", false);
        ComboEdit dataSrcIdComboEdit = (ComboEdit)this.getControl("datasrcid");
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType((String)dataSrcType);
        if (Objects.isNull(typeEnum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u6570\u636e\u6e90\u7c7b\u578b,\u6682\u4e0d\u652f\u6301\u3002", (String)"DatasetSingleNewPlugin_56", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        switch (typeEnum) {
            case CURRENT_MODEL: {
                if (DisModelTypeEnum.CM.getType().equalsIgnoreCase(dmModel.getModelType())) {
                    fieldEdit.setVisible("", true);
                }
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_44", (String)"epm-far-formplugin", (Object[])new Object[0])));
                if (DisModelTypeEnum.EB.getType().equals(modelType)) {
                    extendsModelIdComboEdit.setVisible("", true);
                    extendsModelIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u636e\u96c6", (String)"DatasetSingleNewPlugin_57", (String)"epm-far-formplugin", (Object[])new Object[0])));
                }
                this.getModel().setValue("datasrcid", (Object)dmModel.getId());
                break;
            }
            case MERGE_MODEL: {
                fieldEdit.setVisible("", true);
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u5e76\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0])));
                break;
            }
            case COMPONENT: {
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u5e76\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_11", (String)"epm-far-formplugin", (Object[])new Object[0])));
                extendsModelIdComboEdit.setVisible("", true);
                extendsModelIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62a5\u8868\u5207\u7247", (String)"DatasetSingleEditPlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0])));
                this.getModel().setValue("datasrcid", (Object)dmModel.getId());
                break;
            }
            case RPT_MODEL: {
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_58", (String)"epm-far-formplugin", (Object[])new Object[0])));
                break;
            }
            case EB_MODEL: {
                extendsModelIdComboEdit.setVisible("", true);
                extendsModelIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u636e\u96c6", (String)"DatasetSingleNewPlugin_57", (String)"epm-far-formplugin", (Object[])new Object[0])));
                dataSrcIdComboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9884\u7b97\u4f53\u7cfb", (String)"DatasetSingleNewPlugin_55", (String)"epm-far-formplugin", (Object[])new Object[0])));
                break;
            }
        }
        this.batchSetVisible(!Objects.equals(typeEnum, DataSrcTypeEnum.COMPONENT), ctl_expression, "details", ctl_guide, "showdetails");
        this.batchSetVisible(this.needShowDimNum(typeEnum, modelType), "dimnum", ctl_memnum, ctl_memberselect, ctl_groupby, ctl_orderby, ctl_top, ctl_radioasc, ctl_radiodesc);
        this.buildModelComboEdit();
        this.clearValue(ctl_expression);
    }

    private void clearValue(String ... params) {
        for (String param : params) {
            this.getModel().setValue(param, (Object)"");
        }
    }

    private boolean needShowDimNum(DataSrcTypeEnum typeEnum, String modelType) {
        if (Objects.equals(this.getFormCustomParam("type"), DataSetTypeEnum.SINGLE_VALUED.getType())) {
            return false;
        }
        if (Objects.equals(typeEnum, DataSrcTypeEnum.EB_MODEL)) {
            return false;
        }
        return !Objects.equals(typeEnum, DataSrcTypeEnum.CURRENT_MODEL) || !DisModelTypeEnum.EB.getType().equals(modelType);
    }

    private void buildModelComboEdit() {
        DynamicObject sourceModel = this.getOriginSourceModel();
        if (Objects.isNull(sourceModel)) {
            return;
        }
        String dataSrcType = this.getStringValue("datasrctype");
        DataSrcTypeEnum typeEnum = DataSrcTypeEnum.getByType((String)dataSrcType);
        if (Objects.isNull(typeEnum)) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        switch (typeEnum) {
            case CURRENT_MODEL: 
            case COMPONENT: {
                DisModelTypeEnum type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)sourceModel.getLong("id"));
                IModel strategy = ModelStrategy.getStrategy((DisModelTypeEnum)type);
                List useModels = strategy.getUseModels();
                if (CollectionUtils.isEmpty((Collection)useModels)) {
                    return;
                }
                Optional<DynamicObject> any = useModels.stream().filter(dy -> Objects.equals(dy.getLong("id"), sourceModel.getLong("id"))).findAny();
                if (!any.isPresent()) {
                    return;
                }
                DynamicObjectCollection collection = new DynamicObjectCollection();
                collection.add((Object)sourceModel);
                this.buildDataSrcIdComboEdit((List<DynamicObject>)collection, true);
                break;
            }
            case MERGE_MODEL: {
                IModel strategy = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.CM);
                this.buildDataSrcIdComboEdit(strategy.getUseModels(), false);
                this.getModel().setValue("datasrcid", (Object)"");
                break;
            }
            case RPT_MODEL: {
                IModel strategy = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.RPT);
                this.buildDataSrcIdComboEdit(strategy.getUseModels(), false);
                this.getModel().setValue("datasrcid", (Object)"");
                break;
            }
            case EB_MODEL: {
                IModel strategy = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB);
                this.buildDataSrcIdComboEdit(strategy.getUseModels(), false);
                this.getModel().setValue("datasrcid", (Object)"");
            }
        }
    }

    private void setExtendsComboEdit() {
        Long modelId = this.getLongValue("datasrcid");
        if (modelId == 0L) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("extendsmodelid");
            comboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b", (String)"DatasetSingleEditPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0])));
            comboEdit.setComboItems(null);
            return;
        }
        ArrayList items = new ArrayList(16);
        String controlKey = this.getValueKey();
        ComboEdit comboEdit = (ComboEdit)this.getControl(controlKey);
        comboEdit.setComboItems(items);
        this.clearValue(controlKey, "extendsmodelid");
        String dataSrcType = (String)this.getValue("datasrctype");
        List data = this.fidmDimService.getExtendsModel(dataSrcType, modelId);
        this.cacheExtmodel(data);
        this.buildComboEditForTuple(data, "extendsmodelid");
    }

    private void cacheExtmodel(List<Tuple<String, String, String>> data) {
        HashMap<Object, Object> id2number = new HashMap<Object, Object>(data.size());
        for (Tuple<String, String, String> one : data) {
            id2number.put(one.p3, one.p1);
        }
        this.getPageCache().put("extmodel", SerializationUtils.serializeToBase64(id2number));
    }

    private void setGroupComboEdit(List<String> dims, String value, String ebDataset) {
        this.buildComboEdit(dims, ctl_groupby);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            String[] all = value.split(",");
            String newvalue = Arrays.stream(all).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.joining(","));
            this.getModel().setValue(ctl_groupby, (Object)newvalue);
            if (StringUtils.isBlank((CharSequence)newvalue)) {
                return;
            }
            Long modelId = this.getLongValue("datasrcid");
            ComboEdit comboEdit = (ComboEdit)this.getControl("dimnum");
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(16);
            Map map = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.getModelType((String)this.getStringValue("datasrctype"), (Long)modelId)).getDimensionNumber2nameMap(modelId, ebDataset);
            for (String dim : all) {
                String s2 = (String)map.get(dim);
                if (StringUtils.isBlank((CharSequence)s2)) continue;
                String[] split = s2.split(";");
                data.add(new ComboItem(new LocaleString(split[1]), split[0]));
            }
            comboEdit.setComboItems(data);
        }
    }

    private void setOrderComboEdit(List<String> dims, String value, String groupby) {
        if (StringUtils.isEmpty((CharSequence)groupby) || Arrays.stream(groupby.split(",")).allMatch(s -> StringUtils.isEmpty((CharSequence)s) || StringUtils.isEmpty((CharSequence)s.trim()))) {
            this.buildComboEdit(dims, ctl_orderby);
        } else {
            String[] scope = groupby.split(",");
            dims = Arrays.stream(scope).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.toList());
            this.buildComboEdit(dims, ctl_orderby);
        }
        if (!StringUtils.isEmpty((CharSequence)value)) {
            String[] all = value.split(",");
            List<String> finalDims = dims;
            String newvalue = Arrays.stream(all).filter(s -> StringUtils.isNotEmpty((CharSequence)s) && finalDims.contains(s) && StringUtils.isNotEmpty((CharSequence)s.trim())).collect(Collectors.joining(","));
            this.getModel().setValue(ctl_orderby, (Object)newvalue);
        }
    }

    private void buildComboEditForTuple(List<Tuple<String, String, String>> data, String comboEditKey) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboEditKey);
        comboEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b", (String)"DatasetSingleEditPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0])));
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (data == null || data.size() <= 0) {
            comboEdit.setComboItems(items);
            return;
        }
        for (Tuple<String, String, String> s : data) {
            items.add(new ComboItem(new LocaleString((String)s.p1 + " " + (String)s.p2), (String)s.p3));
        }
        comboEdit.setComboItems(items);
    }

    private void buildComboEdit(List<String> dims, String comboEditKey) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboEditKey);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (dims == null || dims.size() <= 0) {
            comboEdit.setComboItems(items);
            return;
        }
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)this.getStringValue("datasrctype"), (Long)this.getLongValue("datasrcid"));
        List dimList = new ModelStrategyEx(this.getLongValue("datasrcid"), modelType.getType()).getDim().getDimList();
        Map<String, String> shortNumberMap = dimList.stream().collect(Collectors.toMap(DimensionInfo::getShortNumber, DimensionInfo::getName));
        for (String dim : dims) {
            items.add(new ComboItem(new LocaleString(shortNumberMap.get(dim)), dim));
        }
        comboEdit.setComboItems(items);
    }

    private void buildDataSrcIdComboEdit(List<DynamicObject> array, boolean isCurrent) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("datasrcid");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        if (CollectionUtils.isEmpty(array)) {
            comboEdit.setComboItems(items);
            return;
        }
        for (DynamicObject dyn : array) {
            if (!isCurrent && Objects.equals(this.getDMModelId(), dyn.getLong("id"))) continue;
            items.add(new ComboItem(new LocaleString(dyn.getString("shownumber") + " " + dyn.getString("name")), dyn.getString("id")));
        }
        comboEdit.setComboItems(items);
    }

    private String getStringValue(String key) {
        Object value = this.getModel().getValue(key);
        if (value == null) {
            return "";
        }
        return this.removeSpecialValue(value.toString().trim());
    }

    private Long getLongValue(String key) {
        String stringValue = this.getStringValue(key);
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return 0L;
        }
        return Long.valueOf(stringValue);
    }

    private Integer getIntValue(String key) {
        String stringValue = this.getStringValue(key);
        if (StringUtils.isEmpty((CharSequence)stringValue)) {
            return 0;
        }
        return Integer.valueOf(stringValue);
    }

    private String formatMultiSelectStr(String by) {
        String[] a;
        if (StringUtils.isEmpty((CharSequence)by)) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(8);
        for (String one : a = by.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)one)) continue;
            list.add(one);
        }
        return String.join((CharSequence)",", list);
    }

    private void showConfirmOnPreview() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u4fdd\u5b58\u5e76\u8df3\u8f6c\u81f3\u9884\u89c8\u9875\u9762\uff1f", (String)"DatasetSingleNewPlugin_40", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DATASET_PREVIEW_CONFIRM, (IFormPlugin)this));
    }

    private void openPreviewPage() {
        String id = (String)this.getFormCustomParam("dataset_id");
        if (id == null) {
            return;
        }
        DatasetServiceHelper.openPreviewPage((IFormView)this.getView(), (IFormPlugin)this, (long)this.getDMModelId(), (long)Long.parseLong(id));
    }

    private void openGuidePage() {
        ModelInfo dmModel = this.getDMModel();
        Long datasrcid = this.getLongValue("datasrcid");
        String dataSrcType = this.getStringValue("datasrctype");
        if (StringUtils.isEmpty((CharSequence)dataSrcType) || !LongUtil.isvalidLong((Object)datasrcid)) {
            return;
        }
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)datasrcid);
        boolean isCurrentApp = Objects.equals(dmModel.getModelType(), modelType.getType());
        String expression = this.getStringValue(ctl_expression);
        if (!isCurrentApp && DatasetSpecialVarHelper.isContain((String)expression)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u4f53\u7cfb\u76f8\u540c\u6570\u636e\u6765\u6e90\u5e94\u7528\uff0c\u4e0d\u652f\u6301\u7ef4\u5ea6\u53d8\u91cf\u3002", (String)"DatasetSingleEditPlugin_56", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter fsp = new FormShowParameter();
        if (Objects.equals(modelType, DisModelTypeEnum.EB)) {
            String dataSetNumber = this.getStringValue("extendsmodelid");
            if (StringUtils.isEmpty((CharSequence)dataSetNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9884\u7b97\u6570\u636e\u96c6\u3002", (String)"DatasetSingleNewPlugin_59", (String)"epm-far-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject model = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB).getModel(datasrcid);
            fsp.setFormId("fidm_dataset_dim_guide_eb");
            fsp.setCustomParam("dataSetNumber", (Object)dataSetNumber);
            fsp.setCustomParam("modelNumber", (Object)model.getString("shownumber"));
        } else {
            fsp.setFormId("fidm_dataset_dim_guide");
        }
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATASET_GUIDE_CLOSE));
        fsp.setCustomParam("modelId", (Object)this.getLongValue("datasrcid"));
        fsp.setCustomParam("extendId", (Object)this.getStringValue("extendsmodelid"));
        fsp.setCustomParam(ctl_expression, (Object)expression);
        fsp.setCustomParam("isCurrentApp", (Object)isCurrentApp);
        this.checkExpression(this.getStringValue(ctl_expression));
        this.getView().showForm(fsp);
    }

    private void checkExpression(String expression) {
        String[] split;
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return;
        }
        for (String s : split = expression.split(",")) {
            if (!s.endsWith("$")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u5305\u542b\u5176\u4ed6\u53d8\u91cf\u6210\u5458\u65e0\u6cd5\u89e3\u6790", (String)"DataSetDimGuidePlugin_5", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private String removeSpecialValue(String strIn) {
        if (StringUtils.isEmpty((CharSequence)strIn)) {
            return strIn;
        }
        return strIn.replace("\r", "").replace("\n", "");
    }

    @Override
    public String getModelSign() {
        return "";
    }
}

