/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;

public class ISNgModelListPlugin
extends AbstractBaseDMListPlugin {
    private static final String ctl_billlist = "billlistap";
    private static final String ctl_toolbar = "toolbarap";

    @Override
    public void initialize() {
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            DisclosureFormHelper.resetAppId((IFormView)this.getView());
        }
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(ctl_toolbar);
        BillList billList = (BillList)this.getView().getControl(ctl_billlist);
        billList.addHyperClickListener(this::billListHyperLinkClick);
        billList.addSetFilterListener(this::setFilter);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        ResultInfo resultInfo;
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            DisclosureFormHelper.resetAppId((IFormView)this.getView());
        }
        super.afterCreateNewData(e);
        this.setValue("dmmodel", this.getDMModelId());
        if (LongUtil.isvalidLong((Object)this.getDMModelId()) && !(resultInfo = new ModelStrategyEx(this.getDMModelId()).getModel().checkModel()).isSuccess().booleanValue()) {
            this.getView().showErrorNotification(resultInfo.getMessage());
        }
        this.refreshBillList();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Long dmModelId = this.getDMModelId();
        if (LongUtil.isvalidLong((Object)dmModelId)) {
            QFilter qFilter = new QFilter("model.id", "=", (Object)dmModelId);
            e.getQFilters().add(qFilter);
        } else {
            QFilter qFilter = new QFilter("1", "!=", (Object)1);
            e.getQFilters().add(qFilter);
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_refresh": {
                this.refreshBillList();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        ResultInfo resultInfo;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (Objects.equals(this.getModelSign(), key) && !(resultInfo = new ModelStrategyEx(this.getDMModelId()).getModel().checkModel()).isSuccess().booleanValue()) {
            this.getView().showErrorNotification(resultInfo.getMessage());
        }
        this.refreshBillList();
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl(ctl_billlist);
        billList.addSetFilterListener(this::setFilter);
        billList.setOrderBy("number");
        billList.refresh();
        billList.clearSelection();
    }

    private void billListHyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        Long selectId = (Long)((BillList)hyperLinkClickEvent.getSource()).getFocusRowPkId();
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("bcm_isngmodel");
        fsp.setParentPageId(this.getView().getPageId());
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCaption(ResManager.loadKDString((String)"\u96c6\u6210\u6570\u636e\u6e90", (String)"ISNgModelListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setCustomParam("id", (Object)("" + selectId));
        this.getView().showForm(fsp);
    }

    @Override
    public String getModelSign() {
        return "dmmodel";
    }
}

