/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.IntegrationProperty;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.util.ComboEditUtil;
import kd.epm.far.business.epm.EPMServiceHelper;
import kd.epm.far.business.epm.dto.EPMVoucherFieldVo;
import kd.epm.far.business.epm.enums.VoucherModelTypeEnum;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.dataset.AbstractDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.DataSetDisplayPlugin;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;

public class IntegrationServiceDatasetPlugin
extends DataSetDisplayPlugin {
    @Override
    public void registerListener(EventObject e) {
        BasedataEdit voucher;
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("iscmetadata");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((voucher = (BasedataEdit)this.getControl("voucher")) != null) {
            voucher.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if ((DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) && OperationStatus.EDIT.equals((Object)operationStatus)) {
            this.afterCreateNewDataEdit(e);
        }
    }

    @Override
    public void click(EventObject evt) {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String type;
        String key = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl("iscmetadata")).getQFilters();
        if (qFilterList == null) {
            qFilterList = new ArrayList<QFilter>();
        }
        if ("iscmetadata".equals(key)) {
            type = (String)this.getModel().getValue("metadatatype");
            if ("1".equals(type)) {
                qFilterList.add(new QFilter("type", "=", (Object)"ENTITY"));
            } else if ("2".equals(type)) {
                qFilterList.add(new QFilter("type", "=", (Object)"TABLE"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u3002", (String)"DataSetDisplayPlugin_33", (String)"epm-far-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
        if ("voucher".equals(key)) {
            type = (String)this.getModel().getValue("vouchertype");
            VoucherModelTypeEnum typeEnum = VoucherModelTypeEnum.getByIndex((String)type);
            qFilterList.add(new QFilter("type.number", "=", (Object)typeEnum.getNumber()));
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
        }
    }

    public void afterCreateNewDataEdit(EventObject e) {
        this.dataSetDtoAfterNew = this.buildDataSetDto(this.dataSetDtoAfterNew);
        if (this.dataSetDtoAfterNew != null && DataSetDisplayUtil.isMetadtaSrcType(this.dataSetDtoAfterNew).booleanValue()) {
            DatasetDataVo datasetDataVo;
            List propertyVo;
            this.getModel().setValue("metadatatype", (Object)this.dataSetDtoAfterNew.getMetadataType());
            this.getModel().setValue("iscmetadata", (Object)this.dataSetDtoAfterNew.getMetadataId());
            if (LongUtil.isvalidLong((Object)this.dataSetDtoAfterNew.getVoucherId())) {
                this.getModel().setValue("voucher", (Object)this.dataSetDtoAfterNew.getVoucherId());
                this.getModel().setValue("vouchertype", (Object)this.dataSetDtoAfterNew.getVoucherType());
            }
            if ((propertyVo = (datasetDataVo = (DatasetDataVo)JSON.parseObject((String)this.dataSetDtoAfterNew.getData(), (TypeReference)new TypeReference<DatasetDataVo>(){}, (Feature[])new Feature[0])).getColumns()).size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u96c6\u6210\u5bf9\u8c61\u6570\u636e", (String)"DataSetDisplayPlugin_22", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
            List<String> selectNumbers = propertyVo.stream().map(DatasetPropertyVo::getNumber).collect(Collectors.toList());
            if (DataSrcTypeEnum.EPM_VOUCHER.getType().equals(this.dataSetDtoAfterNew.getDataSrcType())) {
                List<EPMVoucherFieldVo> fieldList = this.getEpmVoucherField(this.dataSetDtoAfterNew.getVoucherId());
                this.initAndSelectVoucherTree(selectNumbers, fieldList);
            } else {
                List<IntegrationProperty> integrationPropertyList = this.getMetadataProperty();
                this.initAndSelectMetadataTree(selectNumbers, integrationPropertyList);
            }
            this.setOtherMetadataCombo(propertyVo, this.dataSetDtoAfterNew);
            this.initEditMetadataCustomEvent(propertyVo);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        switch (propertyName) {
            case "groupby": {
                String stringValue = TypeConversionUtil.getStringValue((String)"groupby", (IDataModel)this.getModel());
                if (!DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom) && !DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) break;
                if (StringUtils.isNotBlank((CharSequence)stringValue)) {
                    this.changedMetadataOrderCombo(stringValue);
                    break;
                }
                TreeView tree = (TreeView)this.getView().getControl("treeviewap");
                List selectNodes = tree.getTreeState().getSelectedNodes();
                Map treeNodeInfo = selectNodes.stream().collect(Collectors.toMap(selectNode -> (String)selectNode.get("id"), selectNode -> (String)selectNode.get("text"), (k1, k2) -> k1, LinkedHashMap::new));
                this.getModel().setValue("orderfield", null);
                ComboEditUtil.buildComboEdit((Map)treeNodeInfo, (String)"orderfield", (IFormView)this.getView());
                break;
            }
            case "iscmetadata": {
                if (Objects.isNull(value)) {
                    this.metadataIsNull(custom, sourceFrom);
                    return;
                }
                this.setSourceFromPropertyChanged();
                this.reset();
                List<IntegrationProperty> integrationPropertyList = this.getMetadataProperty();
                this.initAndSelectMetadataTree(Collections.EMPTY_LIST, integrationPropertyList);
                DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
                this.setFormShowCustomParam("");
                break;
            }
            case "voucher": {
                if (Objects.isNull(value)) {
                    this.metadataIsNull(custom, sourceFrom);
                    return;
                }
                this.setSourceFromPropertyChanged();
                List<EPMVoucherFieldVo> fieldList = this.getEpmVoucherField(((DynamicObject)value).getLong("id"));
                this.initAndSelectVoucherTree(Collections.EMPTY_LIST, fieldList);
                DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
                this.setFormShowCustomParam("");
                this.clearValue("textareafield", "detailfield", "groupby", "orderfield", "topfield", "singleextendval", "mulvalue", "singlevalselect");
                break;
            }
            case "metadatatype": 
            case "vouchertype": {
                if (Objects.isNull(value)) {
                    return;
                }
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                this.metadataIsNull(custom, sourceFrom);
                break;
            }
            case "mulvalue": {
                if (!Objects.nonNull(value)) break;
                this.setMulValueChanged();
                break;
            }
        }
    }

    private List<EPMVoucherFieldVo> getEpmVoucherField(Long voucherId) {
        if (!LongUtil.isvalidLong((Object)voucherId)) {
            return Collections.emptyList();
        }
        return EPMServiceHelper.getField((Long)voucherId);
    }

    private void metadataIsNull(CustomControl custom, String sourceFrom) {
        this.setSourceFromPropertyChanged();
        String clearKey = "iscmetadata";
        if (DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) {
            clearKey = "voucher";
        }
        this.getModel().setValue(clearKey, null);
        this.reset();
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        DataSetDisplayUtil.sendDataInitVue(null, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
        this.setFormShowCustomParam("");
    }

    private void setMulValueChanged() {
        String stringValue = TypeConversionUtil.getStringValue((String)"mulvalue", (IDataModel)this.getModel());
        ArrayList mulValueList = Lists.newArrayListWithExpectedSize((int)16);
        mulValueList.addAll(Arrays.asList(stringValue.split(",")).stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList()));
        Long iscMetadataId = (Long)this.getModel().getValue("iscmetadata_id");
        String metaNumType = this.getPageCache().get("metanumtype");
        if (Objects.nonNull(metaNumType)) {
            Set metaNumSet = (Set)SerializationUtils.fromJsonString((String)metaNumType, Set.class);
            String metadtaNameCache = this.getPageCache().get(iscMetadataId + "name");
            Map nameCache = Maps.newHashMapWithExpectedSize((int)10);
            if (Objects.nonNull(metadtaNameCache)) {
                nameCache = (Map)SerializationUtils.fromJsonString((String)metadtaNameCache, Map.class);
            }
            ListIterator mulValueIterator = mulValueList.listIterator();
            while (mulValueIterator.hasNext()) {
                String mulValue = (String)mulValueIterator.next();
                if (metaNumSet.contains(mulValue)) continue;
                mulValueIterator.remove();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010%s\u3011 \u4e0d\u662f\u6570\u503c\u578b\u7c7b\u578b\uff0c\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u5ea6\u91cf\u503c", (String)"DataSetDisplayPlugin_24", (String)"epm-far-formplugin", (Object[])new Object[]{nameCache.get(mulValue)}));
            }
            String str = String.join((CharSequence)",", mulValueList);
            this.getModel().setValue("mulvalue", (Object)str);
        }
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) {
            this.metadataTreeNodeCheck(treeNodeCheckEvent);
        }
    }

    private void metadataTreeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
        JSONObject dataObj = new JSONObject();
        Boolean checked = treeNodeCheckEvent.getChecked();
        dataObj.put("isChecked", (Object)checked);
        List selectNodeList = ((TreeView)treeNodeCheckEvent.getSource()).getTreeState().getSelectedNodes();
        Map treeNodeInfo = selectNodeList.stream().collect(Collectors.toMap(selectNode -> (String)selectNode.get("id"), selectNode -> (String)selectNode.get("text"), (k1, k2) -> k1, LinkedHashMap::new));
        if (treeNodeInfo.size() > 0) {
            String metaNumType = this.getPageCache().get("metanumtype");
            String dataSetType = (String)this.getFormCustomParam("dataset_type");
            if (Objects.nonNull(metaNumType)) {
                Set metaNumSet = (Set)SerializationUtils.fromJsonString((String)metaNumType, Set.class);
                Map filterTreeNodeInfo = selectNodeList.stream().filter(node -> metaNumSet.contains((String)node.get("id"))).collect(Collectors.toMap(selectNode -> (String)selectNode.get("id"), selectNode -> (String)selectNode.get("text"), (k1, k2) -> k1, LinkedHashMap::new));
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                    ComboEditUtil.buildComboEdit((Map)filterTreeNodeInfo, (String)"singlevalselect", (IFormView)this.getView());
                } else {
                    ComboEditUtil.buildComboEdit((Map)filterTreeNodeInfo, (String)"mulvalue", (IFormView)this.getView());
                }
            }
            if (!DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                ComboEditUtil.buildComboEdit((Map)treeNodeInfo, (String)"orderfield", (IFormView)this.getView());
                ComboEditUtil.buildComboEdit((Map)treeNodeInfo, (String)"groupby", (IFormView)this.getView());
            }
            String currentNodeId = (String)treeNodeCheckEvent.getNodeId();
            if (!checked.booleanValue()) {
                this.setMetadtaComboValue(currentNodeId);
            }
        }
        dataObj.put("checkedNodes", (Object)selectNodeList);
        String nodeId = String.valueOf(treeNodeCheckEvent.getNodeId());
        dataObj.put("clickNodeId", (Object)nodeId);
        dataObj.put("filters", DataSetDisplayUtil.filters);
        dataObj.put("dataType", (Object)AbstractDatasetDisplayPlugin.PropsDataType.METADATA_TREENODE_CHECK.toString());
        dataObj.put("t", (Object)TimeServiceHelper.now());
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendToVue(dataObj, custom);
    }

    private void setMetadtaComboValue(String currentNodeId) {
        String orderField;
        String groupBy;
        String mulValue = (String)this.getModel().getValue("mulvalue");
        if (kd.bos.util.StringUtils.isNotEmpty((String)mulValue)) {
            List strings = Arrays.stream(mulValue.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            strings.remove(currentNodeId);
            ComboEditUtil.buildComboEditValue(strings, (String)"mulvalue", (IDataModel)this.getModel());
        }
        if (currentNodeId.equals(this.getModel().getValue("singlevalselect"))) {
            this.getModel().setValue("singlevalselect", null);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(groupBy = (String)this.getModel().getValue("groupby")))) {
            List strings = Arrays.stream(groupBy.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            strings.remove(currentNodeId);
            ComboEditUtil.buildComboEditValue(strings, (String)"groupby", (IDataModel)this.getModel());
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(orderField = (String)this.getModel().getValue("orderfield")))) {
            List strings = Arrays.stream(orderField.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            strings.remove(currentNodeId);
            ComboEditUtil.buildComboEditValue(strings, (String)"orderfield", (IDataModel)this.getModel());
        }
    }

    private void changedMetadataOrderCombo(String stringValue) {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        List selectNodes = tree.getTreeState().getSelectedNodes();
        if (stringValue.contains(",")) {
            List selectGroupList = Arrays.stream(stringValue.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            Map treeNodeInfo = selectNodes.stream().collect(Collectors.toMap(selectNode -> (String)selectNode.get("id"), selectNode -> (String)selectNode.get("text"), (k1, k2) -> k1, LinkedHashMap::new));
            Map orderComboEdits = treeNodeInfo.entrySet().stream().filter(entry -> selectGroupList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k1, LinkedHashMap::new));
            this.getModel().setValue("orderfield", null);
            ComboEditUtil.buildComboEdit((Map)orderComboEdits, (String)"orderfield", (IFormView)this.getView());
            ComboEditUtil.buildComboEditValue(selectGroupList, (String)"orderfield", (IDataModel)this.getModel());
        }
    }

    private void initAndSelectVoucherTree(List<String> selectNumbers, List<EPMVoucherFieldVo> fieldList) {
        ArrayList selectTreeNodeList = Lists.newArrayListWithExpectedSize((int)selectNumbers.size());
        if (CollectionUtils.isEmpty(fieldList)) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.deleteAllNodes();
            this.getPageCache().remove("metanumtype");
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setId("root");
        HashSet numCache = Sets.newHashSetWithExpectedSize((int)fieldList.size());
        fieldList.forEach(field -> {
            String propNumber = field.getNumber();
            String propLabel = field.getName();
            String dataType = field.getType();
            TreeNode firstMetadataNode = BCMTreeUtils.createTreeNode((String)propNumber, (String)propLabel, (String)dataType, (String)"root");
            if (VOUCHER_MEASURE_TYPE_SET.contains(dataType)) {
                firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                numCache.add(propNumber);
            } else {
                firstMetadataNode.setIcon("kdfont kdfont-qushu2");
            }
            if (selectNumbers.contains(propNumber)) {
                selectTreeNodeList.add(firstMetadataNode);
            }
            root.addChild(firstMetadataNode);
        });
        tree.addNode(root);
        if (numCache.size() > 0) {
            this.getPageCache().put("metanumtype", SerializationUtils.toJsonString((Object)numCache));
        }
        if (selectTreeNodeList.size() > 0) {
            tree.checkNodes((List)selectTreeNodeList);
        }
        tree.expand("root");
    }

    private void initAndSelectMetadataTree(List<String> selectNumbers, List<IntegrationProperty> integrationPropertyList) {
        ArrayList selectTreeNodeList = Lists.newArrayListWithExpectedSize((int)selectNumbers.size());
        if (integrationPropertyList.size() > 0) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.deleteAllNodes();
            TreeNode root = new TreeNode();
            root.setId("root");
            HashSet numCache = Sets.newHashSetWithExpectedSize((int)integrationPropertyList.size());
            integrationPropertyList.forEach(integrationproperty -> {
                String propNumber = integrationproperty.getPropNumber();
                String propLabel = integrationproperty.getPropLabel();
                String dataType = integrationproperty.getDataType();
                TreeNode firstMetadataNode = BCMTreeUtils.createTreeNode((String)propNumber, (String)propLabel, (String)dataType, (String)"root");
                String metadataType = (String)this.getModel().getValue("metadatatype");
                if ("1".equals(metadataType)) {
                    List childPropertyList;
                    if (METADATANUMTYPE.contains(dataType)) {
                        firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                        numCache.add(propNumber);
                    } else {
                        firstMetadataNode.setIcon("kdfont kdfont-qushu2");
                    }
                    if (selectNumbers.contains(propNumber)) {
                        selectTreeNodeList.add(firstMetadataNode);
                    }
                    if ((childPropertyList = integrationproperty.getChildPropertyList()) != null && childPropertyList.size() > 0) {
                        childPropertyList.forEach(childproperty -> {
                            String childPropNumber = childproperty.getPropNumber();
                            String childPropLabel = childproperty.getPropLabel();
                            String childDataType = childproperty.getDataType();
                            TreeNode childMetadataNode = BCMTreeUtils.createTreeNode((String)childPropNumber, (String)(propLabel + "_" + childPropLabel), (String)childDataType, (String)propNumber);
                            if (METADATANUMTYPE.contains(childDataType)) {
                                childMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                                numCache.add(childPropNumber);
                            } else {
                                childMetadataNode.setIcon("kdfont kdfont-qushu2");
                            }
                            if (selectNumbers.contains(childPropNumber)) {
                                selectTreeNodeList.add(childMetadataNode);
                            }
                            firstMetadataNode.addChild(childMetadataNode);
                        });
                    }
                } else if ("2".equals(metadataType)) {
                    if (TABLENUMTYPE.contains(dataType)) {
                        firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                        numCache.add(propNumber);
                    } else if (dataType.startsWith("decimal")) {
                        firstMetadataNode.setIcon("kdfont kdfont-zhishitu2");
                        numCache.add(propNumber);
                    } else {
                        firstMetadataNode.setIcon("kdfont kdfont-qushu2");
                    }
                    if (selectNumbers.contains(propNumber)) {
                        selectTreeNodeList.add(firstMetadataNode);
                    }
                }
                root.addChild(firstMetadataNode);
            });
            tree.addNode(root);
            if (numCache.size() > 0) {
                this.getPageCache().put("metanumtype", SerializationUtils.toJsonString((Object)numCache));
            }
            if (selectTreeNodeList.size() > 0) {
                tree.checkNodes((List)selectTreeNodeList);
            }
            tree.expand("root");
        } else if (integrationPropertyList.size() == 0) {
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            tree.deleteAllNodes();
            this.getPageCache().remove("metanumtype");
        }
    }

    private List<IntegrationProperty> getMetadataProperty() {
        Long iscMetadataId = (Long)this.getModel().getValue("iscmetadata_id");
        DynamicObject integrateObject = BusinessDataServiceHelper.loadSingleFromCache((Object)iscMetadataId, (String)"isc_metadata_schema");
        DynamicObjectCollection entryentityCollection = integrateObject.getDynamicObjectCollection("prop_entryentity");
        ArrayList integrationPropertyList = Lists.newArrayListWithExpectedSize((int)entryentityCollection.size());
        ArrayList nodeExistFields = Lists.newArrayListWithExpectedSize((int)5);
        HashMap propNameMaps = Maps.newHashMapWithExpectedSize((int)entryentityCollection.size());
        String metadataType = (String)this.getModel().getValue("metadatatype");
        IntegrationProperty integrationProperty = null;
        for (DynamicObject propEntryEntity : entryentityCollection) {
            String propName = propEntryEntity.getString("prop_name");
            String propLabel = propEntryEntity.getString("prop_label");
            String propDataType = propEntryEntity.getString("data_type");
            String propDataSchema = propEntryEntity.getString("data_schema");
            propNameMaps.put(propName, propLabel);
            if ("REF".equals(propDataType) && "1".equals(metadataType)) {
                DynamicObject childIntegrateObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_metadata_schema", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)propDataSchema)});
                if (childIntegrateObject != null) {
                    DynamicObjectCollection childEntryentityCollection = childIntegrateObject.getDynamicObjectCollection("prop_entryentity");
                    ArrayList childIntegrationPropertyList = Lists.newArrayListWithExpectedSize((int)childEntryentityCollection.size());
                    childEntryentityCollection.forEach(childPropEntryEntity -> {
                        String childPropName = childPropEntryEntity.getString("prop_name");
                        String childPropLabel = childPropEntryEntity.getString("prop_label");
                        String childPropDataType = childPropEntryEntity.getString("data_type");
                        String childdPropDataSchema = childPropEntryEntity.getString("data_schema");
                        String childField = propName + "." + childPropName;
                        propNameMaps.put(childField, childPropLabel);
                        IntegrationProperty childIntegrationProperty = new IntegrationProperty(childField, childPropLabel, childPropDataType, childdPropDataSchema, null);
                        childIntegrationPropertyList.add(childIntegrationProperty);
                    });
                    integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, (List)childIntegrationPropertyList);
                } else {
                    nodeExistFields.add(propLabel);
                    integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, null);
                }
            } else {
                integrationProperty = new IntegrationProperty(propName, propLabel, propDataType, propDataSchema, null);
            }
            integrationPropertyList.add(integrationProperty);
        }
        this.getPageCache().put(iscMetadataId + "name", SerializationUtils.toJsonString((Object)propNameMaps));
        if (nodeExistFields.size() > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u5173\u8054\u7684\u5b9e\u4f53\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"DatasetSingleNewPlugin_62", (String)"epm-far-formplugin", (Object[])new Object[]{((Object)nodeExistFields).toString()}));
        }
        return integrationPropertyList;
    }

    private void setOtherMetadataCombo(List<DatasetPropertyVo> propertyVo, DatasetDto dataSetDto) {
        String orderBy;
        Map selectCombos = propertyVo.stream().collect(Collectors.toMap(DatasetPropertyVo::getNumber, DatasetPropertyVo::getName, (k1, k2) -> k1, LinkedHashMap::new));
        String groupBy = dataSetDto.getGroupBy();
        if (kd.bos.util.StringUtils.isEmpty((String)groupBy)) {
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"groupby", (IFormView)this.getView());
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"orderfield", (IFormView)this.getView());
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"mulvalue", (IFormView)this.getView());
            orderBy = dataSetDto.getOrderBy();
            if (kd.bos.util.StringUtils.isNotEmpty((String)orderBy)) {
                this.getModel().setValue("orderfield", (Object)orderBy);
            }
        } else {
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"groupby", (IFormView)this.getView());
            this.getModel().setValue("groupby", (Object)groupBy);
            orderBy = dataSetDto.getOrderBy();
            List selectGroupList = Arrays.stream(groupBy.split(",")).filter(t -> StringUtils.isNotBlank((CharSequence)t.trim())).collect(Collectors.toList());
            Map orderComboEdits = selectCombos.entrySet().stream().filter(entry -> selectGroupList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (k1, k2) -> k1, LinkedHashMap::new));
            ComboEditUtil.buildComboEdit((Map)orderComboEdits, (String)"orderfield", (IFormView)this.getView());
            if (kd.bos.util.StringUtils.isNotEmpty((String)orderBy)) {
                this.getModel().setValue("orderfield", (Object)orderBy);
            }
        }
        String datasetType = (String)this.getFormCustomParam("dataset_type");
        String value = dataSetDto.getValue();
        if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(datasetType)) {
            ComboEditUtil.buildComboEdit((Map)selectCombos, (String)"singlevalselect", (IFormView)this.getView());
            this.getModel().setValue("singlevalselect", (Object)value);
        } else {
            this.setMultiValueAfterCreate(dataSetDto, selectCombos, propertyVo);
            String asc = dataSetDto.getAsc();
            this.setOrderValue(asc);
        }
    }

    private void setMultiValueAfterCreate(DatasetDto dataSetDto, Map<String, String> selectCombos, List<DatasetPropertyVo> propertyVo) {
        Set metaNumSet;
        String value = dataSetDto.getValue();
        String metaNumType = this.getPageCache().get("metanumtype");
        Map valueCombos = selectCombos;
        if (Objects.nonNull(metaNumType) && (metaNumSet = (Set)SerializationUtils.fromJsonString((String)metaNumType, Set.class)).size() > 0) {
            valueCombos = propertyVo.stream().filter(property -> metaNumSet.contains(property.getNumber())).collect(Collectors.toMap(DatasetPropertyVo::getNumber, DatasetPropertyVo::getName, (k1, k2) -> k1, LinkedHashMap::new));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
            ComboEditUtil.buildComboEdit(valueCombos, (String)"mulvalue", (IFormView)this.getView());
            this.getModel().setValue("mulvalue", (Object)value);
        } else {
            ComboEditUtil.buildComboEdit(valueCombos, (String)"mulvalue", (IFormView)this.getView());
        }
        Integer top = dataSetDto.getTop();
        if (top != null && top > 0) {
            this.getModel().setValue("topfield", (Object)top);
        }
    }

    private void initEditMetadataCustomEvent(List<DatasetPropertyVo> propertyVo) {
        ArrayList dimList = Lists.newArrayListWithExpectedSize((int)11);
        HashMap input = Maps.newHashMapWithExpectedSize((int)6);
        input.put("input", propertyVo);
        dimList.add(input);
        String sourceFrom = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendDataInitVue(dimList, AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_INIT.toString(), custom, sourceFrom, (String)this.getFormCustomParam("dataset_type"), this.getAllNumType());
    }
}

