/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.dataset.util.DatasetUtil;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.formplugin.common.dataset.AbstractDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.SaveDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;
import org.apache.commons.collections.CollectionUtils;

public class QueryDatasetResultPlugin
extends AbstractDatasetDisplayPlugin {
    @Override
    public void itemClick(ItemClickEvent evt) {
        String opKey = evt.getItemKey();
        if ("querybutton".equals(opKey)) {
            super.itemClick(evt);
            this.checkExist();
            if (Objects.equals(Boolean.FALSE, this.beforeSave())) {
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"datasettableflexpanelap"});
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_QUERY.toString(), custom);
        }
    }

    @Override
    public void click(EventObject evt) {
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        if (StringUtils.isEmpty((CharSequence)eventName)) {
            log.info("customEvent eventName is empty");
            return;
        }
        String eventArgs = evt.getEventArgs();
        if (AbstractDatasetDisplayPlugin.CallBackType.EVENT_CASCADER_DATA_QUERY.toString().equals(eventName)) {
            if (Objects.nonNull(this.getModel().getValue("typeselect"))) {
                String typeSelect = (String)this.getModel().getValue("typeselect");
                if (DatasetModelTypeEnum.INTEGRATION.getIndex().equals(typeSelect)) {
                    this.queryMetadataResult(eventArgs);
                    return;
                }
            }
            String sourceFrom = (String)this.getModel().getValue("sourcefrom");
            if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) {
                if (this.queryMetaResultCheck().booleanValue()) {
                    this.queryMetadataResult(eventArgs);
                }
            } else {
                this.queryCustomResult(eventArgs);
            }
        }
    }

    private void queryMetadataResult(String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        List datas = (List)JSON.parseObject((String)jsonObject.getString("custom"), (TypeReference)new TypeReference<List<DatasetPropertyVo>>(){}, (Feature[])new Feature[0]);
        if (datas.size() > 0) {
            DatasetDto datasetDto = this.createDataSetDao(eventArgs);
            DatasetUtil.checkCondition((DatasetDto)datasetDto);
            Object result = DatasetUtil.getResult((DatasetDto)datasetDto);
            if (result != null) {
                List queryResult = new ArrayList(10);
                String datasetType = (String)this.getFormCustomParam("dataset_type");
                if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(datasetType)) {
                    HashMap<String, Object> map = new HashMap<String, Object>(1);
                    String key = (String)this.getModel().getValue("singlevalselect");
                    if (Objects.nonNull(key)) {
                        map.put(key, result);
                        queryResult.add(map);
                    }
                } else {
                    queryResult = (List)result;
                }
                if (queryResult.size() > 0) {
                    FormShowParameter formShowParameter = this.setFormShowParameter();
                    try {
                        formShowParameter.setCustomParam("datasetDto", (Object)this.toByteSerialized(datasetDto));
                        formShowParameter.setCustomParam("result", (Object)this.toByteSerialized(queryResult));
                        formShowParameter.setCustomParam("type", (Object)this.toByteSerialized(queryResult));
                        this.getView().showForm(formShowParameter);
                    }
                    catch (Exception exception) {
                        log.error((Throwable)exception);
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataSetPreviewPlugin_12", (String)"epm-far-formplugin", (Object[])new Object[0]), new Object[0]));
                    }
                } else {
                    this.setFormShowCustomParam("");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5339\u914d\u67e5\u8be2\u6570\u636e\u3002", (String)"DataSetDisplayPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.setFormShowCustomParam("");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5339\u914d\u67e5\u8be2\u6570\u636e\u3002", (String)"DataSetDisplayPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.setFormShowCustomParam("");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5339\u914d\u67e5\u8be2\u6570\u636e\u3002", (String)"DataSetDisplayPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void queryCustomResult(String eventArgs) {
        if (!this.commonCheck().booleanValue()) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        List sm = (List)JSON.parseObject((String)jsonObject.getString("dim"), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List<Map<String, String>> sources = sm.stream().filter(v -> !"SourceEntity".equals(v.get("dimNumber"))).collect(Collectors.toList());
        Boolean limitCount = jsonObject.getBoolean("limitCount");
        String datasetType = (String)this.getFormCustomParam("dataset_type");
        if (Objects.nonNull(limitCount) && limitCount.booleanValue() && StringUtils.isBlank((Object)this.getModel().getValue("extendmodelselect")) && DataSetTypeEnum.MULTIPLE_ROW.getType().equals(datasetType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u884c\u6570\u636e\u96c6\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2\u65f6\uff0c\u672a\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u7684\u7ef4\u5ea6\u9ed8\u8ba4\u586b\u5165$All\uff0c\u4e14\u6700\u591a\u8fd4\u56de100\u884c\u6570\u636e\u3002", (String)"DataSetDisplayPlugin_39", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        boolean isTemplate = DataSetDisplayUtil.isCMTemplate(this.getModel());
        this.checkDimEmpty(sources.stream().map(t -> (String)t.get("parentid")).collect(Collectors.toSet()));
        this.buildDefaultMember(sources);
        String queryData = DataSetDisplayUtil.buidExpression(sources, isTemplate);
        jsonObject.put("dim", (Object)sm);
        if (StringUtils.isNotBlank((CharSequence)queryData)) {
            this.getModel().setValue("textareafield", (Object)queryData);
            FormShowParameter formShowParameter = this.setFormShowParameter();
            this.showResult(formShowParameter, jsonObject.toJSONString());
        } else {
            this.setFormShowCustomParam("");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5339\u914d\u67e5\u8be2\u6570\u636e\u3002", (String)"DataSetDisplayPlugin_14", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkDimEmpty(Set<String> dimKeys) {
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6784\u5efa\u6b63\u786e\u8868\u8fbe\u5f0f\u3002", (String)"DataSetDisplayPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        String value = (String)this.getModel().getValue("sourcefrom");
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)value, (Long)Long.valueOf((String)this.getModel().getValue("modelselect")));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(Long.valueOf((String)this.getModel().getValue("modelselect")), modelType.getType());
        Map collect = modelStrategyEx.getDim().getDimList().stream().collect(Collectors.toMap(t -> t.getId().toString(), Function.identity()));
        StringBuilder sb = new StringBuilder();
        checkedNodeIds.removeAll(dimKeys);
        if (CollectionUtils.isNotEmpty((Collection)checkedNodeIds)) {
            for (String checkedNodeId : checkedNodeIds) {
                if (!collect.containsKey(checkedNodeId)) continue;
                sb.append(((DimensionInfo)collect.get(checkedNodeId)).getName()).append(" ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584%s\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DataSetDisplayPlugin_20", (String)"epm-far-formplugin", (Object[])new Object[0]), sb.toString().trim()));
        }
    }

    private void buildDefaultMember(List<Map<String, String>> members) {
        String dimdefaultvalue = (String)this.getModel().getValue("dimdefaultvalue");
        for (Map<String, String> member : members) {
            String needReset = member.get("needReset");
            if (!Objects.nonNull(needReset) || !Objects.equals("1", needReset)) continue;
            String number = DatasetServiceHelper.getDefaultMemberNumber((Long)LongUtil.toLong((Object)this.getModel().getValue("modelselect")), (String)dimdefaultvalue, (String)member.get("shortNumber"), (String)member.get("entity"), (Long)LongUtil.toLong((Object)member.get("parentid")));
            member.put("number", number);
        }
    }

    private void showResult(FormShowParameter formShowParameter, String eventArgs) {
        DatasetDto datasetDto = this.createDataSetDao(eventArgs);
        if (StringUtils.isEmpty((CharSequence)datasetDto.getTempExpression())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6784\u5efa\u6b63\u786e\u8868\u8fbe\u5f0f\u3002", (String)"DataSetDisplayPlugin_15", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        List selectNodeList = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getSelectedNodes();
        SaveDatasetDisplayPlugin.buildSE(eventArgs, datasetDto, selectNodeList);
        DatasetUtil.buildDetails((DatasetDto)datasetDto);
        this.getModel().setValue("detailfield", (Object)datasetDto.getDetails());
        String dataSetType = (String)this.getView().getFormShowParameter().getCustomParam("dataset_type");
        DatasetUtil.checkCondition((DatasetDto)datasetDto);
        datasetDto.setExpression(datasetDto.getTempExpression());
        try {
            Object result = DatasetUtil.getResult((DatasetDto)datasetDto);
            formShowParameter.setCustomParam("type", (Object)dataSetType);
            if (DataSetTypeEnum.SINGLE_VALUED.getType().equals(dataSetType)) {
                HashMap element = Maps.newHashMapWithExpectedSize((int)1);
                element.put("FMONEY", result);
                ArrayList dataList = Lists.newArrayListWithExpectedSize((int)1);
                dataList.add(element);
                formShowParameter.setCustomParam("datasetDto", (Object)this.toByteSerialized(datasetDto));
                formShowParameter.setCustomParam("result", (Object)this.toByteSerialized(dataList));
            } else if (DataSetTypeEnum.MULTIPLE_ROW.getType().equals(dataSetType)) {
                formShowParameter.setCustomParam("datasetDto", (Object)this.toByteSerialized(datasetDto));
                formShowParameter.setCustomParam("result", (Object)this.toByteSerialized(result));
            }
        }
        catch (Exception exception) {
            this.getView().showTipNotification(exception.getMessage());
            LOGGER.error((Throwable)exception);
        }
        this.getView().showForm(formShowParameter);
    }
}

