/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DimInfo;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;

public class SEUtils {
    public static final Long SE_ID = 3141592653589L;

    public static List<TreeNode> getSETreeNodes(TreeNode root) {
        DimInfo dimensionInfo = SEUtils.getSEDimInfo();
        List<TreeNode> se = DataSetDisplayUtil.createDimensionNode(dimensionInfo, new DynamicObjectCollection(), root, false);
        if (se.size() > 0) {
            TreeNode treeNode = se.get(0);
            treeNode.setParentid("SE");
        }
        return se;
    }

    public static boolean hasOrg(String data) {
        DatasetDataVo datasetDataVo;
        if (!StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null) {
            List collect;
            if (datasetDataVo.getSourceEntityVo() != null) {
                return true;
            }
            List columns = datasetDataVo.getColumns();
            if (columns != null && !columns.isEmpty() && !(collect = columns.stream().filter(v -> "SourceEntity".equals(v.getSource())).collect(Collectors.toList())).isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasOrgDim(String data) {
        DatasetDataVo datasetDataVo;
        return !StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data) && (datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)) != null && datasetDataVo.getSourceEntityVo() != null;
    }

    public static List<Map<String, String>> buildInitData(List<DimMemberInfo> dims) {
        ArrayList<Map<String, String>> nima = new ArrayList<Map<String, String>>(12);
        if (dims == null || dims.isEmpty()) {
            HashMap<String, String> ms = new HashMap<String, String>(12);
            ms.put("number", "$Cur");
            ms.put("shortNumber", "SE");
            ms.put("dimnumber", "SourceEntity");
            ms.put("name", ResManager.loadKDString((String)"\u5f53\u524d\u6210\u5458", (String)"SourceEntity_Member", (String)"epm-far-business", (Object[])new Object[0]));
            ms.put("range", "");
            ms.put("rangename", "");
            nima.add(ms);
            return nima;
        }
        for (DimMemberInfo dim : dims) {
            HashMap<String, String> ms = new HashMap<String, String>(12);
            ms.put("id", String.valueOf(dim.getId()));
            ms.put("number", dim.getNumber());
            ms.put("shortNumber", "SE");
            ms.put("dimnumber", "SourceEntity");
            ms.put("name", dim.getName());
            ms.put("range", RangeEnum.getRangeByVal((int)dim.getRange()).getNumber());
            ms.put("rangename", RangeEnum.getRangeByVal((int)dim.getRange()).getName());
            ms.put("dimension", "SE");
            nima.add(ms);
        }
        return nima;
    }

    public static DimInfo getSEDimInfo() {
        DimInfo dimensionInfo = new DimInfo();
        dimensionInfo.setId(Long.valueOf(3141592653589L));
        dimensionInfo.setDimId("3141592653589");
        dimensionInfo.setName(ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]));
        dimensionInfo.setNumber("SourceEntity");
        dimensionInfo.setShortNumber("SE");
        dimensionInfo.setMemberModel("SE");
        return dimensionInfo;
    }

    public static DimensionInfo getSEDimensionInfo() {
        DimensionInfo dimensionInfo = new DimensionInfo();
        dimensionInfo.setId(Long.valueOf(3141592653589L));
        dimensionInfo.setName(ResManager.loadKDString((String)"\u6765\u6e90\u7ec4\u7ec7", (String)"SourceEntity", (String)"epm-far-business", (Object[])new Object[0]));
        dimensionInfo.setNumber("SourceEntity");
        dimensionInfo.setShortNumber("SE");
        dimensionInfo.setEntityName("Entity");
        return dimensionInfo;
    }

    public static String getSEMsByPop(List<DimMemberInfo> dims) {
        if (dims == null || dims.isEmpty()) {
            return "$Cur";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dims.size(); ++i) {
            DimMemberInfo dim = dims.get(i);
            String number = dim.getNumber();
            sb.append(number);
            int range = dim.getRange();
            if (range != 0 && range != 10) {
                sb.append(".").append(RangeEnum.getRangeByVal((int)range).getNumber());
            }
            if (i == dims.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

