/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.far.business.bcm.dimension.RPTDimType;
import kd.epm.far.business.common.dataset.dto.DatasetDataVo;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DatasetPropertyVo;
import kd.epm.far.business.common.dataset.dto.DimInfo;
import kd.epm.far.business.common.dataset.dto.SourceEntityVo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DmVariableTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.far.enums.DataSetTypeEnum;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.enums.DimEntityNumEnum;
import kd.epm.far.common.common.enums.DimTypesEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.dataset.AbstractDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.SEUtils;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;
import org.apache.commons.collections.CollectionUtils;

public class SaveDatasetDisplayPlugin
extends AbstractDatasetDisplayPlugin {
    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("resetconfirm".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.reset();
        }
    }

    @Override
    public void click(EventObject evt) {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "modelselectcallback": {
                if (evt.getReturnData() == null) break;
                this.selectGlobalVars(evt.getReturnData());
                break;
            }
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String opKey = evt.getItemKey();
        if ("savedataset".equals(opKey)) {
            super.itemClick(evt);
            this.checkExist();
            if (Objects.equals(Boolean.FALSE, this.beforeSave())) {
                return;
            }
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_SAVEDATASET.toString(), custom);
        } else if ("globalvarselect".equalsIgnoreCase(opKey)) {
            super.itemClick(evt);
            this.checkExist();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("far_dataset_selectvar");
            formShowParameter.setParentPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("dmmodel", this.getFormCustomParam("dmmodel_id"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modelselectcallback"));
            this.getView().showForm(formShowParameter);
        } else if ("resetstatus".equalsIgnoreCase(opKey)) {
            super.itemClick(evt);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u6e05\u7a7a\u8fc7\u6ee4\u6761\u4ef6\u548c\u5c55\u793a\u8bbe\u7f6e\u5185\u5bb9?", (String)"DataSetDisplayPlugin_18", (String)"epm-far-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("resetconfirm"));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        if (StringUtils.isEmpty((CharSequence)eventName)) {
            return;
        }
        String eventArgs = evt.getEventArgs();
        if (!AbstractDatasetDisplayPlugin.CallBackType.EVENT_CASCADER_DATA_SAVEDATASET.toString().equals(eventName)) return;
        Boolean check = this.commonFieldCheck();
        if (!check.booleanValue()) {
            return;
        }
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        List members = (List)JSON.parseObject((String)jsonObject.getString("dim"), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List<Map<String, String>> dimNumbers = members.stream().filter(v -> !"SourceEntity".equals(v.get("dimNumber"))).collect(Collectors.toList());
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        String formId = "far_dataset_info";
        String varSelect = this.getPageCache().get("VAR_SELECT");
        if (Objects.isNull(varSelect) && Objects.isNull(this.getPageCache().get("isChanged"))) {
            this.selectGlobalVars(new HashMap());
        }
        DatasetDto datasetDto = this.createDataSetDao(eventArgs);
        FormShowParameter formShowParameter = new FormShowParameter();
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(sourceFrom) || DataSrcTypeEnum.EPM_VOUCHER.getType().equals(sourceFrom)) {
            Boolean checkMetadataInfo = this.beforeSaveMetadata(jsonObject);
            if (!checkMetadataInfo.booleanValue()) return;
            formId = "far_dataset_metasave";
        } else if (Objects.nonNull(this.getModel().getValue("typeselect")) && DatasetModelTypeEnum.INTEGRATION.getIndex().equals((String)this.getModel().getValue("typeselect"))) {
            formId = "far_dataset_metasave";
        } else {
            boolean isTemplate = DataSetDisplayUtil.isCMTemplate(this.getModel());
            String queryData = DataSetDisplayUtil.buidExpression(dimNumbers, isTemplate);
            this.getModel().setValue("textareafield", (Object)queryData);
            datasetDto.setTempExpression(queryData);
            Map<String, Pair<Boolean, String>> curDimMap = this.getCurDimMap(dimNumbers.stream().map(t -> (String)t.get("parentid")).collect(Collectors.toSet()));
            formShowParameter.setCustomParam("curMap", (Object)SerializationUtils.toJsonString(curDimMap));
            if (!this.beforeSave().booleanValue()) {
                return;
            }
        }
        List selectNodeList = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getSelectedNodes();
        SaveDatasetDisplayPlugin.buildSE(eventArgs, datasetDto, selectNodeList);
        formShowParameter.setFormId(formId);
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("data", (Object)SerializationUtils.toJsonString((Object)datasetDto));
        formShowParameter.setCustomParam("isCopy", this.getFormCustomParam("isCopy"));
        formShowParameter.setCustomParam("dataset_id", (Object)("" + this.getFormCustomParam("dataset_id")));
        Object cid = this.getView().getFormShowParameter().getCustomParam("categoryid");
        Long categoryId = 0L;
        if (cid != null) {
            categoryId = LongUtil.toLong((Object)cid);
        }
        formShowParameter.setCustomParam("categoryid", (Object)categoryId);
        formShowParameter.setCustomParam("dmmodel_id", (Object)this.getView().getFormShowParameter().getCustomParam("dmmodel_id").toString());
        this.getView().showForm(formShowParameter);
    }

    public static void buildSE(String evt, DatasetDto datasetDto, List<Map<String, Object>> selectNodeList) {
        DatasetDataVo datasetDataVo;
        JSONObject jsonObject = JSON.parseObject((String)evt);
        List members = (List)JSON.parseObject((String)jsonObject.getString("dim"), (TypeReference)new TypeReference<List<Map<String, String>>>(){}, (Feature[])new Feature[0]);
        List sources = members.stream().filter(v -> "SourceEntity".equals(v.get("dimNumber"))).collect(Collectors.toList());
        if (sources.isEmpty()) {
            List collect;
            DatasetDataVo datasetDataVo2;
            List columns;
            if (CollectionUtils.isEmpty(selectNodeList)) {
                return;
            }
            String data = datasetDto.getData();
            boolean hasSe = selectNodeList.stream().anyMatch(t -> SEUtils.SE_ID.toString().equals(t.get("id")));
            if (hasSe) {
                DatasetDataVo datasetDataVo3 = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
                datasetDto.setHasSourceOrg(true);
                SourceEntityVo sourceEntityVo = new SourceEntityVo();
                datasetDataVo3.setSourceEntityVo(sourceEntityVo);
                datasetDto.setData(JSON.toJSONString((Object)datasetDataVo3));
                return;
            }
            if (!StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data) && (columns = (datasetDataVo2 = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class)).getColumns()) != null && !columns.isEmpty() && !(collect = columns.stream().filter(v -> "SourceEntity".equals(v.getSource())).collect(Collectors.toList())).isEmpty()) {
                datasetDto.setHasSourceOrg(true);
                SourceEntityVo sourceEntityVo = new SourceEntityVo();
                datasetDataVo2.setSourceEntityVo(sourceEntityVo);
                datasetDto.setData(JSON.toJSONString((Object)datasetDataVo2));
            }
            return;
        }
        datasetDto.setHasSourceOrg(true);
        ArrayList<DimMemberInfo> mbers = new ArrayList<DimMemberInfo>(12);
        SourceEntityVo sourceEntityVo = new SourceEntityVo();
        for (Map source : sources) {
            String id = String.valueOf(source.get("id"));
            if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
            DimMemberInfo dims = new DimMemberInfo();
            dims.setId(Long.valueOf(Long.parseLong(String.valueOf(source.get("id")))));
            dims.setName(String.valueOf(source.get("name")));
            dims.setNumber(String.valueOf(source.get("number")));
            dims.setRange(10);
            if (StringUtils.isNotEmpty((CharSequence)String.valueOf(source.get("range")))) {
                dims.setRange(RangeEnum.getRangeByNumber((String)String.valueOf(source.get("range"))).getValue());
            }
            mbers.add(dims);
        }
        sourceEntityVo.setMembers(mbers);
        String data = datasetDto.getData();
        if (!StringUtils.isEmpty((CharSequence)data) && StringUtils.isNotBlank((CharSequence)data)) {
            datasetDataVo = (DatasetDataVo)JSONObject.parseObject((String)data, DatasetDataVo.class);
            datasetDataVo.setSourceEntityVo(sourceEntityVo);
            datasetDto.setData(JSON.toJSONString((Object)datasetDataVo));
        } else {
            datasetDataVo = new DatasetDataVo();
            datasetDataVo.setSourceEntityVo(sourceEntityVo);
            datasetDto.setData(JSON.toJSONString((Object)datasetDataVo));
        }
    }

    private void setDimGlobalVars(String dataSrcType, Object data) {
        HashMap templateDimTypes;
        List selectNodeList = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getSelectedNodes();
        Set selectNodeIds = selectNodeList.stream().filter(t -> {
            if (DataSrcTypeEnum.EB_MODEL.getType().equals(dataSrcType)) {
                return true;
            }
            return Boolean.parseBoolean(t.get("isParent").toString()) && LongUtil.isValidLong(t.get("id"));
        }).map(t -> LongUtil.toLong(t.get("id"))).collect(Collectors.toSet());
        Long modelSelectId = LongUtil.toLong((Object)this.getModel().getValue("modelselect"));
        String type = DisModelTypeEnum.getModelType((String)dataSrcType, (Long)modelSelectId).getType();
        List dimList = new ModelStrategyEx(modelSelectId, type).getDim().getDimList();
        dimList.add(SEUtils.getSEDimensionInfo());
        Set selectNodeNum = dimList.stream().filter(dim -> selectNodeIds.contains(dim.getId())).map(dim -> dim.getShortNumber()).collect(Collectors.toSet());
        HashMap dimToVModels = Maps.newHashMapWithExpectedSize((int)8);
        Map returnData = (Map)data;
        List returnDimObject = (List)returnData.get("dim");
        List returnTextObject = (List)returnData.get("text");
        HashSet varNums = Sets.newHashSetWithExpectedSize((int)8);
        if (Objects.isNull(returnDimObject)) {
            returnDimObject = Lists.newArrayListWithExpectedSize((int)8);
        } else {
            returnDimObject.forEach(o -> varNums.add(o.getString("number")));
        }
        if (Objects.isNull(returnTextObject)) {
            returnTextObject = Lists.newArrayListWithExpectedSize((int)8);
        } else {
            returnTextObject.forEach(o -> varNums.add(o.getString("number")));
        }
        DatasetDto dataSetDto = new DatasetDto();
        String isChanged = this.getPageCache().get("isChanged");
        if (Objects.isNull(isChanged)) {
            Set expressionVarNums = this.buildDataSetDto(dataSetDto).getVarNums();
            QFilter filter = new QFilter("number", "in", (Object)expressionVarNums);
            filter.and("scope", "=", (Object)"1");
            filter.and("model", "=", (Object)LongUtil.toLong((Object)this.getView().getFormShowParameter().getCustomParam("dmmodel_id")));
            Collection dyns = DatasetDataReader.getVariables((QFilter[])filter.toArray());
            for (DynamicObject dy : dyns) {
                String number = dy.getString("number");
                if (varNums.contains(number)) continue;
                String valuetype = dy.getString("valuetype");
                if (DmVariableTypeEnum.TEXT.getIndex().equals(valuetype)) {
                    returnTextObject.add(dy);
                    continue;
                }
                if (!DmVariableTypeEnum.DIM.getIndex().equals(valuetype)) continue;
                returnDimObject.add(dy);
            }
        }
        HashMap varMap = Maps.newHashMapWithExpectedSize((int)(returnDimObject.size() + returnTextObject.size()));
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType)) {
            List dimInfoList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("TEMPLATE_DIMS_CACHE"), DimInfo.class);
            templateDimTypes = Maps.newHashMapWithExpectedSize((int)dimInfoList.size());
            for (Object o2 : dimInfoList) {
                DimInfo dimInfo = (DimInfo)o2;
                templateDimTypes.put(dimInfo.getShortNumber(), dimInfo.getRptDimType());
            }
        } else {
            templateDimTypes = Maps.newHashMapWithExpectedSize((int)0);
        }
        if (returnDimObject.size() > 0) {
            returnDimObject.forEach(dynamicObject -> {
                Long defaultValue = dynamicObject.getLong("defaultvalue");
                String entityNumber = dynamicObject.getString("dimmembertype");
                DynamicObject memberObject = BusinessDataServiceHelper.loadSingleFromCache((String)entityNumber, (String)"id,number,name,dimension,dimension.shortnumber,dseq", (QFilter[])new QFilter("id", "=", (Object)defaultValue).toArray());
                DynamicObject dimObject = memberObject.getDynamicObject("dimension");
                String dimShortNum = dimObject.getString("shortnumber");
                if (!selectNodeNum.contains(dimShortNum)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf \u201c%1$s\u201c \u4e2d\u7684\u7ef4\u5ea6 \u201c%2$s\u201d \u6ca1\u6709\u5728\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u9009\u4e2d\uff0c\u8bf7\u5148\u9009\u62e9\u3002", (String)"DataSetDisplayPlugin_30", (String)"epm-far-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), dimShortNum));
                    return;
                }
                if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType) && this.verifyDimOverwritten(dimShortNum, templateDimTypes)) {
                    return;
                }
                String dimNumber = DimTypesEnum.getNumberByShortNumber((String)dimShortNum);
                String dimEntity = DimEntityNumEnum.getEntieyNumByNumber((String)dimNumber);
                DynamicObject memberObjectForDataSrc = BusinessDataServiceHelper.loadSingle((String)dimEntity, (String)"id,name", (QFilter[])new QFilter("number", "=", (Object)memberObject.getString("number")).and("model", "=", (Object)modelSelectId).and("dimension.shortnumber", "=", (Object)dimShortNum).toArray());
                if (Objects.isNull(memberObjectForDataSrc)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf \u201c%1$s\u201c \u4e2d\u7684\u7ef4\u5ea6\u6210\u5458 \u201c%2$s\u201d \u4e0d\u5b58\u5728\u3002", (String)"DataSetDisplayPlugin_29", (String)"epm-far-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), memberObject.get("name").toString()));
                    return;
                }
                JSONArray varInfo = new JSONArray();
                JSONObject oneVar = new JSONObject();
                varInfo.add((Object)oneVar);
                oneVar.put("number", (Object)dynamicObject.getString("number"));
                oneVar.put("name", (Object)dynamicObject.getString("name"));
                oneVar.put("dimShortNum", (Object)dimShortNum);
                varMap.put(dynamicObject.getString("id"), varInfo.toJSONString());
                if (!varNums.contains(dynamicObject.getString("number"))) {
                    return;
                }
                ArrayList<HashMap> list = new ArrayList<HashMap>();
                HashMap map = Maps.newHashMapWithExpectedSize((int)8);
                list.add(map);
                map.put("shortNumber", dimShortNum);
                map.put("number", memberObject.getString("number"));
                map.put("dseq", memberObject.getString("dseq"));
                map.put("rangename", RangeEnum.VALUE_10.getNumber());
                map.put("dimnumber", memberObject.getString("dimension.number"));
                map.put("name", ((OrmLocaleValue)memberObject.get("name")).getLocaleValue());
                map.put("range", "self");
                map.put("id", memberObject.getString("id"));
                map.put("label", memberObject.getString("number") + ((OrmLocaleValue)memberObject.get("name")).getLocaleValue());
                map.put("dimension", memberObject.getString("dimension.memberform"));
                dimToVModels.put(dimShortNum, list);
            });
        }
        if (returnTextObject.size() > 0) {
            returnTextObject.forEach(textObject -> {
                String defaultValue = textObject.getString("defaultvalue");
                defaultValue = defaultValue.trim();
                String[] dimParts = defaultValue.split(",");
                Boolean isFit = Boolean.TRUE;
                for (String dimPart : dimParts) {
                    int first = dimPart.indexOf(".");
                    if (first == -1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u96c6\u5f15\u7528\u7684\u5168\u5c40\u53d8\u91cf\u7f3a\u5c11\u7ef4\u5ea6\u4fe1\u606f\uff0c\u751f\u6210\u6570\u636e\u96c6\u540e\u65e0\u6cd5\u590d\u7528\u8be5\u53d8\u91cf\uff0c\u8bf7\u5728\u53d8\u91cf\u8bbe\u7f6e\u4e2d\u8865\u5168\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"SaveDatasetDisplayPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                        isFit = Boolean.FALSE;
                        continue;
                    }
                    String dimShortNum = dimPart.substring(0, first);
                    if (!selectNodeNum.contains(dimShortNum)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf \u201c%1$s\u201c \u4e2d\u7684\u7ef4\u5ea6 \u201c%2$s\u201d \u6ca1\u6709\u5728\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u9009\u4e2d\uff0c\u8bf7\u5148\u9009\u62e9\u3002", (String)"DataSetDisplayPlugin_30", (String)"epm-far-formplugin", (Object[])new Object[0]), textObject.getString("number"), dimShortNum));
                        return;
                    }
                    if (!DataSrcTypeEnum.CM_TEMPLATE.getType().equals(dataSrcType) || !this.verifyDimOverwritten(dimShortNum, templateDimTypes)) continue;
                    return;
                }
                if (isFit.booleanValue()) {
                    HashMap tempVModels = Maps.newHashMapWithExpectedSize((int)8);
                    dataSetDto.setTempExpression(defaultValue);
                    dataSetDto.setDataSrcId(modelSelectId);
                    dataSetDto.setDataSrcType(dataSrcType);
                    dataSetDto.setEbDataset((String)this.getModel().getValue("ebdataset"));
                    Map<String, List<Map<String, String>>> dimMemberMap = DataSetDisplayUtil.getExpressionDimInfo(dataSetDto);
                    for (List<Map<String, String>> tempList : dimMemberMap.values()) {
                        for (Map<String, String> member : tempList) {
                            if (!Objects.isNull(member.get("id"))) continue;
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5168\u5c40\u53d8\u91cf \u201c%1$s\u201c \u4e2d\u7684\u7ef4\u5ea6\u6210\u5458 \u201c%2$s\u201d \u4e0d\u5b58\u5728\u3002", (String)"DataSetDisplayPlugin_29", (String)"epm-far-formplugin", (Object[])new Object[0]), textObject.getString("number"), member.get("number")));
                            return;
                        }
                    }
                    tempVModels.putAll(dimMemberMap);
                    JSONArray varInfo = new JSONArray();
                    for (String dimShortNum : dimMemberMap.keySet()) {
                        JSONObject oneVar = new JSONObject();
                        varInfo.add((Object)oneVar);
                        oneVar.put("number", (Object)textObject.getString("number"));
                        oneVar.put("name", (Object)textObject.getString("name"));
                        oneVar.put("dimShortNum", (Object)dimShortNum);
                    }
                    varMap.put(textObject.getString("id"), varInfo.toJSONString());
                    if (!varNums.contains(textObject.getString("number"))) {
                        return;
                    }
                    dimToVModels.putAll(tempVModels);
                }
            });
        }
        if (varMap.size() > 0) {
            this.getPageCache().put("VAR_SELECT", SerializationUtils.toJsonString((Object)varMap));
        }
        if (dimToVModels.isEmpty()) {
            return;
        }
        JSONObject dataObj = new JSONObject();
        dataObj.put("dimToVModels", (Object)dimToVModels);
        dataObj.put("ranges", (Object)DataSetDisplayUtil.getRangeData(dataSrcType));
        dataObj.put("dataType", (Object)AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_VAR_SELECT.toString());
        dataObj.put("t", (Object)TimeServiceHelper.now());
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendToVue(dataObj, custom);
    }

    private boolean verifyDimOverwritten(String dimShortNum, Map<String, RPTDimType> templateDimTypes) {
        RPTDimType dimType;
        if (Objects.nonNull(templateDimTypes) && (RPTDimType.HIDDEN == (dimType = templateDimTypes.get(dimShortNum)) || RPTDimType.ROWCOL == dimType)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6 \u201c%1$s\u201d \u5728\u6309\u8868\u53d6\u6570\u4e2d\u4e3a\u9690\u85cf\u7ef4\u6216\u62d3\u5c55\u7ef4\uff0c\u4e0d\u652f\u6301\u5168\u5c40\u53d8\u91cf\u586b\u5145\u3002", (String)"DataSetDisplayPlugin_40", (String)"epm-far-formplugin", (Object[])new Object[0]), dimShortNum));
            return true;
        }
        return false;
    }

    private void setISCGlobalVars(Object data) {
        Map returnData = (Map)data;
        List returnTextObject = (List)returnData.get("text");
        HashSet varNums = Sets.newHashSetWithExpectedSize((int)8);
        if (Objects.isNull(returnTextObject)) {
            returnTextObject = Lists.newArrayListWithExpectedSize((int)8);
        } else {
            returnTextObject.forEach(text -> varNums.add(text.getString("number")));
        }
        ArrayList varValueList = Lists.newArrayListWithExpectedSize((int)returnTextObject.size());
        for (DynamicObject varObject : returnTextObject) {
            String varValue = varObject.getString("defaultvalue");
            varValueList.add(varValue);
        }
        List selectNodeList = ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getSelectedNodes();
        Set selectNodeIds = selectNodeList.stream().map(t -> (String)t.get("id")).collect(Collectors.toSet());
        Boolean notExist = Boolean.TRUE;
        block1: for (String nodeId : selectNodeIds) {
            for (String varValue : varValueList) {
                if (!varValue.startsWith(nodeId)) continue;
                notExist = Boolean.FALSE;
                continue block1;
            }
        }
        if (!notExist.booleanValue()) {
            JSONObject dataObj = new JSONObject();
            dataObj.put("defaultvalues", (Object)varValueList);
            dataObj.put("dataType", (Object)AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_ISCVAR_SELECT.toString());
            dataObj.put("t", (Object)TimeServiceHelper.now());
            CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
            DataSetDisplayUtil.sendToVue(dataObj, custom);
        }
    }

    private void selectGlobalVars(Object data) {
        String dataSrcType = TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel());
        if (DataSetDisplayUtil.isCMTemplate(this.getModel())) {
            dataSrcType = DataSrcTypeEnum.CM_TEMPLATE.getType();
        }
        if (DataSrcTypeEnum.ISC_METADATA.getType().equals(dataSrcType)) {
            this.setISCGlobalVars(data);
        } else {
            this.setDimGlobalVars(dataSrcType, data);
        }
    }

    private Map<String, Pair<Boolean, String>> getCurDimMap(Set<String> dimKeys) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        List checkedNodeIds = tree.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)checkedNodeIds)) {
            return returnMap;
        }
        DisModelTypeEnum modelType = DisModelTypeEnum.getModelType((String)((String)this.getModel().getValue("sourcefrom")), (Long)LongUtil.toLong((Object)this.getModel().getValue("modelselect")));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(Long.valueOf((String)this.getModel().getValue("modelselect")), modelType.getType());
        Map collect = modelStrategyEx.getDim().getDimList().stream().collect(Collectors.toMap(t -> t.getId().toString(), Function.identity()));
        checkedNodeIds.removeAll(dimKeys);
        Set<String> getUsedDim = this.getUsedDim();
        boolean isUsed = DataSetDisplayUtil.isCMTemplate(this.getModel());
        if (CollectionUtils.isNotEmpty((Collection)checkedNodeIds)) {
            for (String checkedNodeId : checkedNodeIds) {
                if (!collect.containsKey(checkedNodeId)) continue;
                DimensionInfo dimensionInfo = (DimensionInfo)collect.get(checkedNodeId);
                returnMap.put(dimensionInfo.getShortNumber(), new Pair((Object)(isUsed ? isUsed : getUsedDim.contains(dimensionInfo.getShortNumber())), (Object)dimensionInfo.getName()));
            }
        }
        return returnMap;
    }

    private Set<String> getUsedDim() {
        String orderBy;
        HashSet usedDim = Sets.newHashSetWithExpectedSize((int)16);
        String groupBy = TypeConversionUtil.getStringValue((String)"groupby", (IDataModel)this.getModel());
        if (StringUtils.isNotBlank((CharSequence)groupBy)) {
            usedDim.addAll(Arrays.asList(groupBy.split(",")));
        }
        if (StringUtils.isNotBlank((CharSequence)(orderBy = TypeConversionUtil.getStringValue((String)"orderfield", (IDataModel)this.getModel())))) {
            usedDim.addAll(Arrays.asList(orderBy.split(",")));
        }
        return usedDim;
    }

    private Boolean beforeSaveMetadata(JSONObject jsonObject) {
        List datas = (List)JSON.parseObject((String)jsonObject.getString("custom"), (TypeReference)new TypeReference<List<DatasetPropertyVo>>(){}, (Feature[])new Feature[0]);
        if (datas.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5b57\u6bb5\u4e0e\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"DataSetDisplayPlugin_19", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String datasetType = (String)this.getFormCustomParam("dataset_type");
        String comboValue = DataSetTypeEnum.SINGLE_VALUED.getType().equals(datasetType) ? (String)this.getModel().getValue("singlevalselect") : (String)this.getModel().getValue("mulvalue");
        if (kd.bos.util.StringUtils.isEmpty((String)comboValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u5ea6\u91cf\u503c\u5b57\u6bb5\u3002", (String)"DataSetDisplayPlugin_32", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Boolean result = this.queryMetaResultCheck();
        if (!result.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Boolean commonFieldCheck() {
        Integer topValue;
        if (Objects.nonNull(this.getModel().getValue("topfield")) && (topValue = (Integer)this.getModel().getValue("topfield")) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u524d\u51e0\u6570\u636e\u201d\u5fc5\u987b\u662f\u6b63\u6574\u6570\u3002", (String)"DatasetSingleNewPlugin_17", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (!this.commonCheck().booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

