/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dataset;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.epm.far.business.bcm.BCMMsServiceHelper;
import kd.epm.far.business.bcm.dimension.RPTDimType;
import kd.epm.far.business.common.dataset.dto.DatasetDto;
import kd.epm.far.business.common.dataset.dto.DimInfo;
import kd.epm.far.business.common.dataset.util.DatasetDataReader;
import kd.epm.far.business.common.dataset.util.DatasetServiceHelper;
import kd.epm.far.business.common.enums.DataSrcTypeEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.common.common.enums.DatasetModelTypeEnum;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.TypeConversionUtil;
import kd.epm.far.formplugin.common.dataset.AbstractDatasetDisplayPlugin;
import kd.epm.far.formplugin.common.dataset.DataSetDisplayPlugin;
import kd.epm.far.formplugin.common.util.DataSetDisplayUtil;
import org.apache.commons.collections.CollectionUtils;

public class TemplateDataSetPlugin
extends DataSetDisplayPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String sourceFrom = (String)this.getModel().getValue("sourcefrom");
        if (DataSrcTypeEnum.CM_TEMPLATE.getType().equals(sourceFrom) && OperationStatus.EDIT.equals((Object)operationStatus)) {
            this.afterCreateNewDataEdit(e);
        }
    }

    @Override
    public void click(EventObject evt) {
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
    }

    @Override
    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }

    private void afterCreateNewDataEdit(EventObject e) {
        this.dataSetDtoAfterNew = this.buildDataSetDto(this.dataSetDtoAfterNew);
        if (this.dataSetDtoAfterNew != null && DataSetDisplayUtil.isTemplate(this.dataSetDtoAfterNew).booleanValue()) {
            this.buildTypeComboEdit(DataSrcTypeEnum.MERGE_MODEL.getType());
            this.getModel().setValue("sourcefrom", (Object)DataSrcTypeEnum.CM_TEMPLATE.getType());
            this.sourceFromChanged(DataSrcTypeEnum.MERGE_MODEL.getType());
            this.getModel().setValue("sourcefrom", (Object)DataSrcTypeEnum.MERGE_MODEL.getType());
            this.getModel().setValue("modelselect", (Object)this.dataSetDtoAfterNew.getDataSrcId());
            this.getModel().setValue("typeselect", (Object)DatasetModelTypeEnum.TEMPLATE.getIndex());
            this.modelSelectChanged(this.dataSetDtoAfterNew);
            this.buildTemplateCombo();
            this.buildAreaCombo(this.dataSetDtoAfterNew.getTemplateId());
            if (LongUtil.isvalidLong((Object)this.dataSetDtoAfterNew.getExtendsModelId())) {
                this.getModel().setValue("extendmodelselect", (Object)this.dataSetDtoAfterNew.getExtendsModelId());
            }
            List<DimInfo> dimInfoList = this.getDimInfo();
            List<DimInfo> selectDimInfoList = this.getDimFromTemplate(dimInfoList);
            this.rebuildExpression(this.dataSetDtoAfterNew);
            List<TreeNode> treeNodeList = this.initTreeNode(dimInfoList, "init");
            this.dataSetDtoAfterNew.setTempExpression(this.buildTemplateTemp(dimInfoList, this.dataSetDtoAfterNew.getTempExpression()));
            Map<String, List<Map<String, String>>> dimAndMember = DataSetDisplayUtil.getExpressionDimInfo(this.dataSetDtoAfterNew);
            String extendValue = this.dataSetDtoAfterNew.getValue();
            TreeView tree = (TreeView)this.getView().getControl("treeviewap");
            DataSetDisplayUtil.checkedTreeNode(treeNodeList, dimAndMember, Collections.emptyList(), extendValue, tree);
            this.initCustomControl(selectDimInfoList, this.dataSetDtoAfterNew, dimAndMember);
            this.getModel().setValue("template", (Object)this.dataSetDtoAfterNew.getTemplateId());
            this.getModel().setValue("area", (Object)this.dataSetDtoAfterNew.getArea());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"groupby", "orderfield", "orderby", "topfield"});
        }
    }

    private void rebuildExpression(DatasetDto dataSetDto) {
        Object datasetId = this.getFormCustomParam("dataset_id");
        if (Objects.isNull(datasetId)) {
            return;
        }
        long id = LongUtil.toLong((Object)datasetId);
        String expression = dataSetDto.getExpression();
        DynamicObject dataSet = DatasetDataReader.getDataSet((Long)id);
        List datasetVariableList = DatasetServiceHelper.getDatasetVariableList((Long)id, (Long)dataSet.getLong("chapterid"));
        String modifiedExpression = this.checkVarValid(expression, datasetVariableList);
        Set varNums = DatasetServiceHelper.extractVariables((DatasetDto)dataSetDto);
        String tempExpression = DatasetServiceHelper.variableResolveOf((String)modifiedExpression, (List)datasetVariableList);
        dataSetDto.setVarNums(varNums);
        dataSetDto.setTempExpression(tempExpression);
    }

    private String checkVarValid(String expression, List<Map<String, Object>> datasetVariableList) {
        List dimInfoList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("TEMPLATE_DIMS_CACHE"), DimInfo.class);
        HashMap templateDimTypes = Maps.newHashMapWithExpectedSize((int)dimInfoList.size());
        for (Object o : dimInfoList) {
            DimInfo dimInfo = (DimInfo)o;
            templateDimTypes.put(dimInfo.getShortNumber(), dimInfo.getRptDimType());
        }
        Iterator<Map<String, Object>> iterator = datasetVariableList.iterator();
        ArrayList removedDatasetVar = Lists.newArrayListWithExpectedSize((int)10);
        while (iterator.hasNext()) {
            String[] parts;
            Map<String, Object> next = iterator.next();
            String number = String.valueOf(next.get("number"));
            String value = String.valueOf(next.get("defaultvalue"));
            for (String part : parts = value.split(",")) {
                String dimShortNum = part.split("\\.")[0];
                RPTDimType dimType = (RPTDimType)templateDimTypes.get(dimShortNum);
                if (dimType != RPTDimType.HIDDEN && dimType != RPTDimType.ROWCOL) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d8\u91cf \u201c%1$s\u201d \u4e2d\u7684\u7ef4\u5ea6 \u201c%2$s\u201d \u5728\u6309\u8868\u53d6\u6570\u4e2d\u4e3a\u9690\u85cf\u7ef4\u6216\u62d3\u5c55\u7ef4\uff0c\u4e0d\u652f\u6301\u5168\u5c40\u53d8\u91cf\u586b\u5145\u3002", (String)"DataSetDisplayPlugin_41", (String)"epm-far-formplugin", (Object[])new Object[0]), number, dimShortNum));
                removedDatasetVar.add(next);
                iterator.remove();
            }
        }
        if (removedDatasetVar.isEmpty()) {
            return expression;
        }
        List collect = removedDatasetVar.stream().map(var -> String.valueOf(var.get("number"))).collect(Collectors.toList());
        String regex = "\\$(" + String.join((CharSequence)"|", collect) + ")\\$";
        Pattern VARIABLE_REGEX = Pattern.compile(regex);
        StringBuffer sb = new StringBuffer();
        Matcher matcher = VARIABLE_REGEX.matcher(expression);
        while (matcher.find()) {
            String findStr = matcher.group();
            String replacement = "";
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        if (sb.length() > 0) {
            if (sb.charAt(0) == ',') {
                sb.delete(0, 1);
            }
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.delete(sb.length() - 1, sb.length());
            }
        }
        return sb.toString().replaceAll(",{2,}", ",");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object value = this.getModel().getValue(propertyName);
        switch (propertyName) {
            case "template": {
                if (!LongUtil.isvalidLong((Object)value)) {
                    return;
                }
                this.getModel().setValue("area", null);
                this.buildAreaCombo(LongUtil.toLong((Object)value));
                CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
                DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
                break;
            }
            case "area": {
                String stringValue = TypeConversionUtil.getStringValue((String)"area", (IDataModel)this.getModel());
                if (StringUtils.isBlank((CharSequence)stringValue)) {
                    return;
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"globalvarselect"});
                this.areaPropertyChanged(stringValue);
                break;
            }
        }
    }

    private String buildTemplateTemp(List<DimInfo> dimInfoList, String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return expression;
        }
        String[] split = expression.split(",");
        Set collect = dimInfoList.stream().map(DimInfo::getShortNumber).collect(Collectors.toSet());
        HashSet existDims = Sets.newHashSetWithExpectedSize((int)split.length);
        for (String s : split) {
            existDims.add(s.split("\\.")[0]);
        }
        collect.removeAll(existDims);
        if (CollectionUtils.isEmpty(collect)) {
            return expression;
        }
        StringBuilder sb = new StringBuilder().append(expression);
        for (String s : collect) {
            sb.append(",").append(s).append(".").append("$Cur").append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void buildAreaCombo(Long templateId) {
        Map temp = BCMMsServiceHelper.getAreaByTemplateId((Long)templateId);
        if (Objects.isNull(temp) || temp.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("area");
        ArrayList items = Lists.newArrayListWithExpectedSize((int)12);
        this.getPageCache().put("hideDim", SerializationUtils.toJsonString(temp.get("hideDim")));
        if (Boolean.parseBoolean(temp.get("hasDim").toString())) {
            this.getPageCache().put("pageDim", SerializationUtils.toJsonString(temp.get("pageDim")));
            this.getPageCache().put("dimensionMap", SerializationUtils.toJsonString(temp.get("dimensionMap")));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u591a\u7ef4\u6a21\u578b", (String)"DataSetDisplayPlugin_23", (String)"epm-far-formplugin", (Object[])new Object[0])), "hasDim"));
        }
        if (Boolean.parseBoolean(temp.get("hasExtend").toString())) {
            String s1 = SerializationUtils.toJsonString(temp.get("extendsMap"));
            this.getPageCache().put("extendsMap", s1);
            Map extendsMap = (Map)SerializationUtils.fromJsonString((String)s1, Map.class);
            List data = this.fidmDimService.getExtendsModel(TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel()), LongUtil.toLong((Object)TypeConversionUtil.getStringValue((String)"modelselect", (IDataModel)this.getModel())));
            Map<String, String> collect = data.stream().collect(Collectors.toMap(t -> (String)t.p1, t -> (String)t.p2));
            for (String s : extendsMap.keySet()) {
                String extendName = collect.get(s);
                String title = String.format(ResManager.loadKDString((String)"\u62d3\u5c55\u6a21\u578b-%s", (String)"DataSetDisplayPlugin_34", (String)"epm-far-formplugin", (Object[])new Object[0]), extendName);
                items.add(new ComboItem(new LocaleString(title), s));
            }
        }
        comboEdit.setComboItems((List)items);
    }

    private List<DimInfo> getDimFromTemplate(List<DimInfo> dimInfoList) {
        this.getPageCache().put("TEMPLATE_DIMS_CACHE", JSONObject.toJSONString(dimInfoList));
        return dimInfoList;
    }

    private void areaPropertyChanged(String stringValue) {
        CustomControl custom = (CustomControl)this.getView().getControl("customcontrolap");
        DataSetDisplayUtil.sendToVue(AbstractDatasetDisplayPlugin.PropsDataType.CASCADER_DATA_CLEAR.toString(), custom);
        DatasetDto dto = new DatasetDto();
        String tempExpression = this.getPageCache().get("tempExpression");
        dto.setTempExpression(StringUtils.isBlank((CharSequence)tempExpression) ? "" : tempExpression);
        dto.setDataSrcId(LongUtil.toLong((Object)this.getModel().getValue("modelselect")));
        dto.setDataSrcType(DataSrcTypeEnum.CM_TEMPLATE.getType());
        if (!StringUtils.equals((CharSequence)stringValue, (CharSequence)"hasDim")) {
            this.getPageCache().put("existextednmodelitem", "true");
            Map<String, String> map = this.getExtendMap(dto.getDataSrcType(), dto.getDataSrcId());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!StringUtils.equals((CharSequence)entry.getValue(), (CharSequence)stringValue)) continue;
                dto.setExtendsModelId(LongUtil.toLong((Object)entry.getKey()));
                dto.setExtendsModelNumber(stringValue);
                break;
            }
            this.extSelects = this.fidmDimService.getExtendsFields(TypeConversionUtil.getStringValue((String)"sourcefrom", (IDataModel)this.getModel()), LongUtil.toLong((Object)TypeConversionUtil.getStringValue((String)"modelselect", (IDataModel)this.getModel())), dto.getExtendsModelId(), "");
            Map extendsMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("extendsMap"), Map.class);
            dto.setValue(Joiner.on((String)",").join((Iterable)extendsMap.get(stringValue)));
        } else {
            dto.setValue("FMONEY");
        }
        this.buildAreaComboValue(dto);
    }

    private void buildAreaComboValue(DatasetDto dataSetDto) {
        if (LongUtil.isvalidLong((Object)dataSetDto.getExtendsModelId())) {
            this.getModel().setValue("extendmodelselect", (Object)dataSetDto.getExtendsModelId());
        }
        List<DimInfo> dimInfoList = this.getDimInfo();
        List<TreeNode> treeNodeList = this.initTreeNode(dimInfoList, "init");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dataSetDto.getDataSrcId(), DisModelTypeEnum.CM.getType());
        DataSetDisplayUtil.initDimAndMember(modelStrategyEx, dimInfoList, DisModelTypeEnum.CM.getType());
        List<DimInfo> selectDimInfoList = this.getDimFromTemplate(dimInfoList);
        Map<String, List<Map<String, String>>> dimAndMember = this.getTemDimAndMember(dimInfoList);
        String extendValue = this.getExtendColumn(dataSetDto);
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        DataSetDisplayUtil.checkedTreeNode(treeNodeList, dimAndMember, Collections.emptyList(), extendValue, tree);
        this.initCustomControl(selectDimInfoList, dataSetDto, dimAndMember);
    }

    private Map<String, List<Map<String, String>>> getTemDimAndMember(List<DimInfo> dimInfoList) {
        HashMap dimAndMember = Maps.newHashMapWithExpectedSize((int)8);
        dimInfoList.forEach(dim -> {
            String shorNumber = dim.getShortNumber();
            dimAndMember.put(shorNumber, Collections.emptyList());
        });
        String hiddenDimStr = this.getPageCache().get("hideDim");
        if (StringUtils.isBlank((CharSequence)hiddenDimStr)) {
            return dimAndMember;
        }
        Map<String, String> numberToShortNumber = dimInfoList.stream().collect(Collectors.toMap(DimInfo::getNumber, DimInfo::getShortNumber, (a, b) -> a));
        List hidden = (List)SerializationUtils.fromJsonString((String)hiddenDimStr, List.class);
        for (Map hiddenDimMap : hidden) {
            ArrayList memberList = Lists.newArrayListWithExpectedSize((int)1);
            HashMap member = Maps.newHashMapWithExpectedSize((int)8);
            String shortNumber = numberToShortNumber.get((String)hiddenDimMap.get("dimNumber"));
            member.put("shortNumber", shortNumber);
            member.put("number", (String)hiddenDimMap.get("number"));
            member.put("dseq", "1");
            member.put("rangename", RangeEnum.VALUE_10.getName());
            member.put("dimnumber", (String)hiddenDimMap.get("dimNumber"));
            member.put("name", (String)hiddenDimMap.get("name"));
            member.put("range", "self");
            String memberId = String.valueOf(hiddenDimMap.get("id"));
            member.put("id", memberId);
            member.put("label", hiddenDimMap.get("number") + " " + hiddenDimMap.get("number"));
            member.put("dimension", (String)hiddenDimMap.get("dimension"));
            memberList.add(member);
            dimAndMember.put(shortNumber, memberList);
        }
        return dimAndMember;
    }
}

