/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dimension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.eb.EBDimensionHelper;
import kd.epm.far.business.eb.EbServiceHelper;
import kd.epm.far.business.eb.dto.EbDataset;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMListPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DimDefaultValueListPlugin
extends AbstractBaseDMListPlugin {
    private String EXTENDSMODELID = "extendsmodelid";
    private static final String MUL_MS = "MUL_MS";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object model = this.getModel().getValue("model");
        if (Objects.isNull(model)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        Long curModelId = this.getCurModelId();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(curModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        if (DisModelTypeEnum.EB.getType().equals(modelInfo.getModelType())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.EXTENDSMODELID});
            this.getModel().setValue(this.EXTENDSMODELID, (Object)"default");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.EXTENDSMODELID});
        }
        this.refreshBillList();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals("model")) {
            Long curModelId = this.getCurModelId();
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(curModelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            if (DisModelTypeEnum.EB.getType().equals(modelInfo.getModelType())) {
                this.getModel().setValue(this.EXTENDSMODELID, (Object)"default");
                this.getView().setVisible(Boolean.valueOf(true), new String[]{this.EXTENDSMODELID});
            } else {
                this.getModel().setValue(this.EXTENDSMODELID, null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.EXTENDSMODELID});
                this.refreshBillList();
            }
        } else if (name.equals(this.EXTENDSMODELID) && Objects.nonNull(value = this.getModel().getValue(this.EXTENDSMODELID)) && StringUtils.isNotBlank((String)value.toString())) {
            this.refreshEbBillList();
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (Objects.equals(key, "btn_refresh")) {
            this.refreshBillList();
        }
        if (!Objects.equals(key, "btn_edit")) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u6570\u636e\u3002", (String)"DimDefaultValueListPlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
            return;
        }
        int pageRow = entryGrid.getPageRow();
        DynamicObject[] dataEntities = entryGrid.getEntryData().getDataEntitys();
        ArrayList lists = Lists.newArrayListWithCapacity((int)selectRows.length);
        for (int row : selectRows) {
            int cur = row % pageRow;
            DynamicObject dataEntity = dataEntities[cur];
            String defaultcurs = dataEntity.getString("dfcursjson");
            lists.add(DimDefaultValueHelper.buildVo((DynamicObject)dataEntity, (String)defaultcurs, (boolean)true));
        }
        this.openNewPage(lists);
    }

    void openNewPage(List<DimDefaultValueVo> list) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("far_default_dim_edit");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("model", (Object)this.getCurModelId());
        showParameter.setCustomParam("modeltype", (Object)this.getDisModelType().getType());
        showParameter.setCustomParam("dimVos", (Object)JSONObject.toJSONString(list));
        showParameter.setCustomParam("dataset", (Object)this.getCurDateSet());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (Objects.nonNull(evt.getReturnData())) {
            this.refreshBillList();
        }
    }

    private void refreshEbBillList() {
        Long modelId = this.getCurModelId();
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.clearEntryState();
        this.getModel().deleteEntryData("entryentity");
        String dateSet = this.getCurDateSet();
        List allDims = EBDimensionHelper.getBudgetDyoByModelId((long)modelId, (String)dateSet, (String)"").values().stream().sorted(Comparator.comparingInt(org -> org.getInt("dseq"))).collect(Collectors.toList());
        if (allDims.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", allDims.size());
        int i = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DynamicObject dy : allDims) {
            DimDefaultValueVo vo = DimDefaultValueHelper.getEbDefaultValue((DynamicObject)dy, (Long)modelId, (DisModelTypeEnum)DisModelTypeEnum.EB, (String)dateSet);
            this.getModel().setValue("dimid", (Object)dy.getLong("id"), i);
            this.getModel().setValue("number", (Object)dy.getString("shortNumber"), i);
            this.getModel().setValue("name", (Object)(dy.getString("name") + "(" + dy.getString("shortNumber") + ")"), i);
            this.getModel().setValue("defaultvalue", (Object)vo.getDefaultValue(), i);
            List defaultCurs = vo.getDefaultCurs();
            ArrayList<DimMemberInfo> jsons = new ArrayList<DimMemberInfo>(12);
            String nima = this.buildCursEntity(vo, defaultCurs, jsons);
            this.getModel().setValue("defaultcurs", (Object)nima, i);
            this.getModel().setValue("dfcursjson", (Object)JSON.toJSONString(jsons), i);
            this.getModel().setValue("modifior", (Object)vo.getModifiorName(), i);
            this.getModel().setValue("membermodel", (Object)dy.getString("membermodel"), i);
            this.getModel().setValue("memberid", (Object)vo.getMemberId(), i);
            if (Objects.nonNull(vo.getModifyTime())) {
                this.getModel().setValue("modifytime", (Object)dateFormat.format(vo.getModifyTime()), i);
            }
            ++i;
        }
        this.getView().updateView("entryentity");
    }

    private void refreshBillList() {
        Long modelId = this.getCurModelId();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        if (Objects.isNull(modelInfo)) {
            return;
        }
        DisModelTypeEnum type = DisModelTypeEnum.getEnumByType((String)modelInfo.getModelType());
        this.setExtendsModelIdComboEdit(type, modelId);
        if (DisModelTypeEnum.EB.getType().equals(modelInfo.getModelType())) {
            this.refreshEbBillList();
            return;
        }
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.clearEntryState();
        this.getModel().deleteEntryData("entryentity");
        List allDims = modelStrategyEx.getDim().getDimList();
        if (allDims.size() == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", allDims.size());
        int i = 0;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (DimensionInfo dimensionInfo : allDims) {
            DimDefaultValueVo vo = DimDefaultValueHelper.getDefaultValue((String)dimensionInfo.getShortNumber(), (Long)modelId, (DisModelTypeEnum)type);
            this.getModel().setValue("dimid", (Object)dimensionInfo.getId(), i);
            this.getModel().setValue("number", (Object)dimensionInfo.getShortNumber(), i);
            this.getModel().setValue("name", (Object)(dimensionInfo.getName() + "(" + dimensionInfo.getShortNumber() + ")"), i);
            this.getModel().setValue("defaultvalue", (Object)vo.getDefaultValue(), i);
            List defaultCurs = vo.getDefaultCurs();
            ArrayList<DimMemberInfo> jsons = new ArrayList<DimMemberInfo>(12);
            String nima = this.buildCursEntity(vo, defaultCurs, jsons);
            this.getModel().setValue("defaultcurs", (Object)nima, i);
            this.getModel().setValue("dfcursjson", (Object)JSON.toJSONString(jsons), i);
            this.getModel().setValue("modifior", (Object)vo.getModifiorName(), i);
            this.getModel().setValue("membermodel", (Object)dimensionInfo.getEntityName(), i);
            this.getModel().setValue("memberid", (Object)vo.getMemberId(), i);
            if (Objects.nonNull(vo.getModifyTime())) {
                this.getModel().setValue("modifytime", (Object)dateFormat.format(vo.getModifyTime()), i);
            }
            ++i;
        }
    }

    private String buildCursEntity(DimDefaultValueVo vo, List<DimMemberInfo> defaultCurs, List<DimMemberInfo> jsons) {
        String nima = null;
        if (defaultCurs == null || defaultCurs.isEmpty()) {
            ArrayList<DimMemberInfo> dfCurs = new ArrayList<DimMemberInfo>();
            DimMemberInfo dimMemberInfo = new DimMemberInfo();
            dimMemberInfo.setId(vo.getMemberId());
            dimMemberInfo.setNumber(vo.getDefaultValue());
            dimMemberInfo.setRange(10);
            dfCurs.add(dimMemberInfo);
            nima = DimDefaultValueHelper.buildDfCursExpression(dfCurs);
            jsons.addAll(dfCurs);
        } else {
            nima = DimDefaultValueHelper.buildDfCursExpression(defaultCurs);
            jsons.addAll(defaultCurs);
        }
        return nima;
    }

    private Long getCurModelId() {
        Object model = this.getModel().getValue("model");
        if (Objects.isNull(model)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractBaseListPlugin_3", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        return ((DynamicObject)model).getLong("id");
    }

    private String getCurDateSet() {
        Object curExtendsmodelid = this.getModel().getValue(this.EXTENDSMODELID);
        if (Objects.isNull(curExtendsmodelid)) {
            curExtendsmodelid = "";
        }
        return curExtendsmodelid.toString();
    }

    private void setExtendsModelIdComboEdit(DisModelTypeEnum type, Long modelId) {
        ComboEdit extendsModelIdComboEdit = (ComboEdit)this.getControl(this.EXTENDSMODELID);
        if (DisModelTypeEnum.EB == type) {
            DynamicObject model = ModelStrategy.getStrategy((DisModelTypeEnum)DisModelTypeEnum.EB).getModel(modelId);
            List datasets = EbServiceHelper.getDataset((String)model.getString("shownumber"));
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            if (CollectionUtils.isEmpty((Collection)datasets)) {
                extendsModelIdComboEdit.setComboItems(items);
            }
            for (EbDataset data : datasets) {
                items.add(new ComboItem(new LocaleString(data.getName()), data.getNumber()));
            }
            extendsModelIdComboEdit.setComboItems(items);
        }
    }
}

