/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.dimension;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.LabelElement;
import kd.epm.far.business.common.control.MultiBaseEditElement;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.f7.base.BasedataEditMultiMemberFIDM;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.strategy.ModelStrategy;
import kd.epm.far.business.far.DimDefaultValueHelper;
import kd.epm.far.business.far.model.DimDefaultValueVo;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;
import kd.epm.far.formplugin.faranalysis.pivot.uitls.PivotServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class DimDefaultValuePlugin
extends AbstractBaseDMFormPlugin
implements DynamicPage {
    private static final String MUL_PREFIX = "Mul_";
    private static final String MUL_MS = "MUL_MS";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPanel();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners("btnok");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String opkey = ((Control)evt.getSource()).getKey();
        if (!Objects.equals(opkey, "btnok")) {
            return;
        }
        this.saveDimDefaultValue();
        this.returnDataToParent(true);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (Objects.isNull(actionId) || Objects.isNull(returnData)) {
            return;
        }
        if (actionId.startsWith(MUL_PREFIX.toLowerCase(Locale.ENGLISH))) {
            this.buildMulReturnData(returnData, actionId);
        }
    }

    public void buildMulReturnData(Object returnData, String actionId) {
        Object[] ids = null;
        Map<String, List<DimMemberInfo>> selectedMaps = this.getDimPageCacheMembers();
        ArrayList<DimMemberInfo> selectedMs = new ArrayList<DimMemberInfo>(12);
        if (returnData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection rDSelectedRows = (ListSelectedRowCollection)returnData;
            ids = rDSelectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList()).toArray();
            for (ListSelectedRow row : rDSelectedRows) {
                Map dataMap = row.getDataMap();
                if (dataMap == null) continue;
                DimMemberInfo dimMemberInfo = new DimMemberInfo();
                dimMemberInfo.setId(Long.valueOf(Long.parseLong(dataMap.getOrDefault("id", "0").toString())));
                dimMemberInfo.setNumber(String.valueOf(dataMap.getOrDefault("number", "")));
                dimMemberInfo.setName(String.valueOf(dataMap.getOrDefault("name", "")));
                dimMemberInfo.setRange(Integer.parseInt(dataMap.getOrDefault("scope", "10").toString()));
                selectedMs.add(dimMemberInfo);
            }
        } else {
            DynamicObjectCollection memberList = (DynamicObjectCollection)returnData;
            ids = memberList.stream().map(v -> v.getLong(4)).collect(Collectors.toList()).toArray();
            for (DynamicObject dy : memberList) {
                DimMemberInfo dimMemberInfo = new DimMemberInfo();
                dimMemberInfo.setId(Long.valueOf(dy.getLong("mid1")));
                dimMemberInfo.setNumber(dy.getString("mnum1"));
                dimMemberInfo.setName(dy.getString("mname1"));
                dimMemberInfo.setRange(dy.getInt("filltypevalue1"));
                selectedMs.add(dimMemberInfo);
            }
        }
        selectedMaps.put(actionId.replaceAll(MUL_PREFIX.toLowerCase(Locale.ENGLISH), "").toUpperCase(Locale.ENGLISH), selectedMs);
        this.getView().getPageCache().put(MUL_MS, JSON.toJSONString(selectedMaps));
        this.getModel().setValue(actionId, (Object)ids);
        this.getView().updateView(actionId.toLowerCase());
        this.getView().updateView();
    }

    private Map<String, List<DimMemberInfo>> getDimPageCacheMembers() {
        String dimMembersStr = this.getView().getPageCache().get(MUL_MS);
        Map<String, List<Object>> dimMembers = new HashMap<String, List<DimMemberInfo>>(12);
        if (StringUtils.isNotEmpty((CharSequence)dimMembersStr)) {
            dimMembers = (Map)JSON.parseObject((String)dimMembersStr, (TypeReference)new TypeReference<Map<String, List<DimMemberInfo>>>(){}, (Feature[])new Feature[0]);
        }
        return dimMembers;
    }

    private void saveDimDefaultValue() {
        List dimList = (List)JSONObject.parseObject((String)this.getPageCache().get("dimVos"), (TypeReference)new TypeReference<List<DimDefaultValueVo>>(){}, (Feature[])new Feature[0]);
        List dimDefaultValues = DimDefaultValueHelper.getDimDefaultValues((Long)this.getCurModelId(), (String)this.getCurDataSet());
        Map<String, DynamicObject> map = dimDefaultValues.stream().collect(Collectors.toMap(dy -> dy.getString("number"), v -> v, (k1, k2) -> k2));
        ArrayList addList = Lists.newArrayListWithCapacity((int)16);
        ArrayList addDimList = Lists.newArrayListWithCapacity((int)16);
        ArrayList updateList = Lists.newArrayListWithCapacity((int)16);
        ArrayList updateDimList = Lists.newArrayListWithCapacity((int)16);
        long currUserId = RequestContext.get().getCurrUserId();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(this.getCurModelId());
        String modeltype = modelStrategyEx.getModel().getModelInfo().getModelType();
        DisModelTypeEnum enumByType = DisModelTypeEnum.getEnumByType((String)modeltype);
        Date date = new Date();
        String curs = this.getView().getPageCache().get(MUL_MS);
        Map<String, List<DimMemberInfo>> cacheMembers = this.getDimPageCacheMembers();
        for (DimDefaultValueVo vo : dimList) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(vo.getNumber());
            if (value == null && (StringUtils.isEmpty((CharSequence)curs) || cacheMembers.isEmpty() || CollectionUtils.isEmpty((Collection)cacheMembers.get(vo.getNumber())))) continue;
            List<DimMemberInfo> dimMemberInfos = cacheMembers.get(vo.getNumber());
            DynamicObject dynamicObject = map.get(vo.getNumber());
            if (Objects.isNull(dynamicObject)) {
                this.addInsertDy(addList, currUserId, date, value, CollectionUtils.isNotEmpty((Collection)dimDefaultValues) ? JSON.toJSONString(dimMemberInfos) : null, vo.getNumber(), ModelStrategy.getStrategy((DisModelTypeEnum)enumByType).getDimDefaultValue(vo.getNumber()));
                addDimList.add(new Object[]{vo.getName()});
                continue;
            }
            boolean needSave = false;
            if (value != null && !Objects.equals(value.getLong("id"), dynamicObject.getLong("memberid"))) {
                dynamicObject.set("memberid", (Object)value.getLong("id"));
                dynamicObject.set("defaultvalue", (Object)value.getString("number"));
                needSave = true;
            }
            if (CollectionUtils.isNotEmpty((Collection)dimDefaultValues) && StringUtils.isNotEmpty((CharSequence)curs) && !StringUtils.equals((CharSequence)JSON.toJSONString(dimMemberInfos), (CharSequence)dynamicObject.getString("defaultcurs"))) {
                dynamicObject.set("defaultcurs", (Object)JSON.toJSONString(dimMemberInfos));
                needSave = true;
            }
            if (!needSave) continue;
            dynamicObject.set("modifytime", (Object)date);
            dynamicObject.set("modifior", (Object)RequestContext.get().getCurrUserId());
            updateList.add(dynamicObject);
            updateDimList.add(new Object[]{vo.getNumber()});
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (CollectionUtils.isNotEmpty((Collection)addList)) {
                    SaveServiceHelper.save((IDataEntityType)((DynamicObject)addList.get(0)).getDataEntityType(), (Object[])addList.toArray());
                    this.batchWriteOpLog(OperationResult.SUCCESS, addDimList);
                }
                if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                    BusinessDataServiceHelper.save((IDataEntityType)((DynamicObject)updateList.get(0)).getDataEntityType(), (Object[])updateList.toArray());
                    this.batchWriteOpLog(OperationResult.SUCCESS, updateDimList);
                }
                if (CollectionUtils.isNotEmpty((Collection)dimDefaultValues) && dimDefaultValues.size() != map.size()) {
                    Set<Object> removeIds = dimDefaultValues.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                    for (DynamicObject value : map.values()) {
                        removeIds.remove(value.getLong("id"));
                    }
                    if (CollectionUtils.isNotEmpty(removeIds)) {
                        DeleteServiceHelper.delete((IDataEntityType)((DynamicObject)dimDefaultValues.get(0)).getDataEntityType(), (Object[])removeIds.toArray(new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                this.batchWriteOpLog(OperationResult.FAILURE, updateDimList);
                tx.markRollback();
                throw new KDBizException(e.toString());
            }
        }
    }

    private void addInsertDy(List<DynamicObject> addList, long currUserId, Date date, DynamicObject value, String curs, String shortNumber, String defaultCur) {
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"far_default_dim_value");
        dy.set("modifior", (Object)currUserId);
        dy.set("modifytime", (Object)date);
        dy.set("number", (Object)shortNumber);
        dy.set("defaultvalue", (Object)(value != null ? value.getString("number") : defaultCur));
        dy.set("defaultcurs", (Object)curs);
        dy.set("memberid", value != null ? Long.valueOf(value.getLong("id")) : null);
        dy.set("model", (Object)this.getCurModelId());
        dy.set("dataset", (Object)this.getCurDataSet());
        addList.add(dy);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String dimKey = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        Long modelId = this.getCurModelId();
        List dimList = (List)JSONObject.parseObject((String)this.getPageCache().get("dimVos"), (TypeReference)new TypeReference<List<DimDefaultValueVo>>(){}, (Feature[])new Feature[0]);
        Long dimId = dimList.stream().filter(t -> dimKey.replace(MUL_PREFIX.toLowerCase(Locale.ENGLISH), "").equalsIgnoreCase(t.getNumber())).findFirst().get().getDimId();
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        qFilter.and("dimension", "=", (Object)dimId);
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }

    private void initPanel() {
        Area dimPanel = new Area("dimpanel");
        this.buildDimPanel(dimPanel);
        Page page = new Page();
        page.addArea(dimPanel);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
    }

    private void buildDimPanel(Area dimPanel) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List dims = (List)JSONObject.parseObject((String)((String)formShowParameter.getCustomParam("dimVos")), (TypeReference)new TypeReference<List<DimDefaultValueVo>>(){}, (Feature[])new Feature[0]);
        this.getPageCache().put("dimVos", JSONObject.toJSONString((Object)dims));
        for (DimDefaultValueVo vo : dims) {
            String df1 = ResManager.loadKDString((String)"%s-\u9ed8\u8ba4\u503c", (String)"DimDefaultValuePlugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]);
            String df2 = ResManager.loadKDString((String)"%s-\u8303\u56f4\u9ed8\u8ba4\u503c", (String)"DimDefaultValuePlugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]);
            BaseEditElement baseEditElement = this.createBaseEditElement(String.format(df1, vo.getName()), vo.getNumber(), vo.getEntityName());
            dimPanel.addElement((Element)baseEditElement);
            MultiBaseEditElement btM = (MultiBaseEditElement)PivotServiceHelper.createMultiBaseEditElement(String.format(df2, vo.getName()), MUL_PREFIX + vo.getNumber(), vo.getEntityName());
            ElementHelper.buildF7Style((Element)btM);
            btM.setStyle(this.getStyle());
            btM.setWidth(new LocaleString("270px"));
            btM.setMustInput(false);
            dimPanel.addElement((Element)btM);
        }
    }

    private Style getStyle() {
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setTop("10px");
        mg.setBottom("10px");
        mg.setRight("0px");
        mg.setLeft("20px");
        sl.setMargin(mg);
        return sl;
    }

    private LabelElement getLabelElement(String key, String name) {
        LabelElement labelElement = new LabelElement(key, name);
        labelElement.setWidth(new LocaleString("100%"));
        labelElement.setLabelWidth(new LocaleString("100%"));
        labelElement.setHeight(new LocaleString("20px"));
        labelElement.setFontSize(14);
        Style sl = new Style();
        Margin mg = new Margin();
        mg.setLeft("20px");
        sl.setMargin(mg);
        labelElement.setStyle(sl);
        return labelElement;
    }

    private BaseEditElement createBaseEditElement(String name, String sign, String entity) {
        BaseEditElement baseEdit = new BaseEditElement(name, sign, entity);
        ElementHelper.buildF7Style((Element)baseEdit);
        baseEdit.setStyle(this.getStyle());
        baseEdit.setMustInput(false);
        baseEdit.setWidth(new LocaleString("270px"));
        return baseEdit;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Control c = this.getView().getControl(e.getProperty().getName());
        if (c instanceof BasedataEditMultiMemberFIDM) {
            DynamicObjectCollection newValue = (DynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            DynamicObjectCollection oldValue = (DynamicObjectCollection)e.getChangeSet()[0].getOldValue();
            if (Objects.isNull(newValue) || newValue.isEmpty()) {
                this.getModel().setValue(key, (Object)oldValue);
            }
        } else {
            this.bcmProChange(e);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (Objects.isNull(this.getView())) {
            return;
        }
        if (Objects.isNull(this.getPage(this.getView()))) {
            return;
        }
        Element element = this.getPage(this.getView()).findElementBySign(e.getKey());
        if (element == null) {
            return;
        }
        List dimList = (List)JSONObject.parseObject((String)this.getPageCache().get("dimVos"), (TypeReference)new TypeReference<List<DimDefaultValueVo>>(){}, (Feature[])new Feature[0]);
        Optional<DimDefaultValueVo> first = dimList.stream().filter(t -> key.replaceAll(MUL_PREFIX.toLowerCase(Locale.ENGLISH), "").equalsIgnoreCase(t.getNumber())).findFirst();
        if (!first.isPresent()) {
            return;
        }
        DimDefaultValueVo dimDefaultValueVo = first.get();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long modelId = this.getCurModelId();
        String dataset = (String)formShowParameter.getCustomParam("dataset");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        DimensionInfo dim = DimensionUtils.getDimById((List)modelStrategyEx.getDim().getDimList(), (Long)dimDefaultValueVo.getDimId());
        if (element instanceof MultiBaseEditElement) {
            Map<String, List<DimMemberInfo>> cacheMembers = this.getDimPageCacheMembers();
            List selecteds = cacheMembers.getOrDefault(key.replaceAll(MUL_PREFIX.toLowerCase(Locale.ENGLISH), "").toUpperCase(Locale.ENGLISH), new ArrayList());
            MulBasedataEdit mulF7 = modelStrategyEx.getDimensionF7().openComMutilF7(this.getView(), selecteds, dim, dataset, (BeforeF7SelectListener)this, e.getKey(), this.getPluginName(), true);
            e.setControl((Control)mulF7);
        } else {
            BasedataEdit f7 = modelStrategyEx.getDimensionF7().createSingleMemberF7(this.getView(), (BeforeF7SelectListener)this, dim, e.getKey(), null, false, dataset);
            f7.setDisplayProp(dimDefaultValueVo.getName());
            e.setControl((Control)f7);
        }
    }

    private Long getCurModelId() {
        return (Long)this.getView().getFormShowParameter().getCustomParam("model");
    }

    private String getCurDataSet() {
        return (String)this.getView().getFormShowParameter().getCustomParam("dataset");
    }

    private void batchWriteOpLog(OperationResult result, List<Object[]> dimensionNameList) {
        super.batchWriteOpLogOrigin(OperationCategory.DIMENSION_DEFAULT, OperationName.EDIT, result, "far_default_dim_list", dimensionNameList);
    }
}

