/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.f7;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.control.Area;
import kd.epm.far.business.common.control.BaseEditElement;
import kd.epm.far.business.common.control.Element;
import kd.epm.far.business.common.control.Page;
import kd.epm.far.business.common.control.TextEditElement;
import kd.epm.far.business.common.f7.base.IF7Operator;
import kd.epm.far.business.common.f7.base.MutilF7DimsionUtils;
import kd.epm.far.business.common.f7.dto.MutilF7DimsionInfo;
import kd.epm.far.business.common.f7.dto.MutilF7MemberInfo;
import kd.epm.far.business.common.f7.dto.MutilF7MemberResult;
import kd.epm.far.business.common.helper.ElementHelper;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimMemberRange;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.formplugin.common.dynamic.DynamicPage;

public class MutipleMemberF7Helper {
    public static final String KEY_MUTILF7DIMSIONINFO_DATA = "key_mutilf7dimsioninfo_data";
    public static final String KEY_MUTILF7SEELCT_DIMNUMBER = "key_mutilf7seelct_dimnumber";
    public static final String SELECT_MEMBER_CLOSE = "select_member_close";
    public static final String MUTIL_SPLIT_CHAR = ",";

    public static void createDimensionPage(AbstractFormPlugin plugin, DynamicPage iPage, String contorlId, List<MutilF7DimsionInfo> dimsionInfos, PageEnum pageEnum) {
        Area area = new Area(contorlId);
        Page page = new Page();
        int index = 1;
        for (MutilF7DimsionInfo dimsionInfo : dimsionInfos) {
            TextEditElement baseEdit;
            String dimName = dimsionInfo.getDimensionInfo().getName();
            String entityName = dimsionInfo.getDimensionInfo().getEntityName();
            if (dimsionInfo.isMutil()) {
                baseEdit = new TextEditElement(dimName, dimsionInfo.getF7Sgin(), entityName);
                if (pageEnum == PageEnum.General) {
                    ElementHelper.buildF7StyleForGenrate((TextEditElement)baseEdit, (int)index);
                } else {
                    ElementHelper.buildF7StyleListForMutil((TextEditElement)baseEdit);
                }
                area.addElement((Element)baseEdit);
            } else {
                baseEdit = new BaseEditElement(dimName, dimsionInfo.getF7Sgin(), entityName);
                if (pageEnum == PageEnum.General) {
                    ElementHelper.buildF7StyleForGenrate((BaseEditElement)baseEdit, (int)index);
                } else {
                    ElementHelper.buildF7StyleList((Element)baseEdit);
                }
                area.addElement((Element)baseEdit);
            }
            ++index;
        }
        page.addArea(area);
        iPage.setPage(plugin.getView(), page);
        page.updatePage(plugin.getView());
        plugin.getPageCache().put(KEY_MUTILF7DIMSIONINFO_DATA, JSON.toJSONString(dimsionInfos));
    }

    public static void saveMutilF7DimsionInfos(AbstractFormPlugin plugin, List<MutilF7DimsionInfo> dimsionInfos) {
        if (dimsionInfos == null) {
            dimsionInfos = new ArrayList<MutilF7DimsionInfo>(100);
        }
        plugin.getPageCache().put(KEY_MUTILF7DIMSIONINFO_DATA, JSON.toJSONString(dimsionInfos));
    }

    public static List<MutilF7DimsionInfo> getMutilF7DimsionInfos(AbstractFormPlugin plugin) {
        List<Object> dimsionInfos = new ArrayList<MutilF7DimsionInfo>(100);
        String dataStr = plugin.getPageCache().get(KEY_MUTILF7DIMSIONINFO_DATA);
        if (StringUtils.isEmpty((String)dataStr)) {
            return dimsionInfos;
        }
        dimsionInfos = JSON.parseArray((String)dataStr, MutilF7DimsionInfo.class);
        return dimsionInfos;
    }

    public static void onGetControl(AbstractFormPlugin plugin, IFormView view, BeforeF7SelectListener beforeF7SelectListener, IDataModel dataModel, DynamicPage page, OnGetControlArgs e, Long dmModelId) {
        Element c;
        if (page.getPage(view) != null && (c = page.getPage(view).findElementBySign(e.getKey())) != null) {
            String f7sign = e.getKey();
            MutilF7DimsionInfo find = MutipleMemberF7Helper.findMultiDimInfoByF7Sign(plugin, f7sign);
            if (find == null) {
                return;
            }
            if (find.isMutil()) {
                TextEdit edit = new TextEdit();
                edit.setKey(e.getKey());
                edit.setModel(dataModel);
                edit.setView(view);
                edit.addClickListener((ClickListener)plugin);
                e.setControl((Control)edit);
            } else {
                BasedataEdit f7 = new ModelStrategyEx(dmModelId).getDimensionF7().createSingleMemberF7(view, beforeF7SelectListener, find.getDimensionInfo(), f7sign, null, false, "");
                e.setControl((Control)f7);
            }
        }
    }

    public static void createBeforeF7Select(AbstractFormPlugin plugin, BeforeF7SelectEvent beforeF7SelectEvent, Long dmModelId, List<QFilter> newFilters) {
        ModelInfo modelInfo = new ModelStrategyEx(dmModelId).getModel().getModelInfo();
        String f7Sign = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        MutilF7DimsionInfo find = MutipleMemberF7Helper.findMultiDimInfoByF7Sign(plugin, f7Sign);
        Long dimId = 0L;
        if (find != null) {
            dimId = find.getDimensionInfo().getId();
        }
        QFilter qFilter = new QFilter("model", "=", (Object)modelInfo.getModelId());
        qFilter.and("dimension", "=", (Object)dimId);
        ((IF7Operator)beforeF7SelectEvent.getSource()).setCustomFilter(qFilter);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(qFilter);
        if (newFilters != null && newFilters.size() > 0) {
            filterList.addAll(newFilters);
        }
        beforeF7SelectEvent.setCustomQFilters(filterList);
    }

    public static void showMultiF7(AbstractFormPlugin plugin, Long dmModelId, String dimNumber, boolean isShowRange) {
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos(plugin);
        MutilF7DimsionInfo find = MutilF7DimsionUtils.findMultiDimInfoByDimNumber(mutilF7DimsionInfos, (String)dimNumber);
        if (find == null) {
            return;
        }
        plugin.getPageCache().put(KEY_MUTILF7SEELCT_DIMNUMBER, dimNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, SELECT_MEMBER_CLOSE);
        ArrayList members = new ArrayList(find.getMemberInfos().size());
        for (DimMemberInfo memberInfo : find.getMemberInfos()) {
            LinkedHashMap<String, String> member = new LinkedHashMap<String, String>(2);
            member.put("number", memberInfo.getNumber());
            member.put("range", String.valueOf(memberInfo.getRange()));
            members.add(member);
        }
        new ModelStrategyEx(dmModelId).getDimensionF7().openMutilF7Ex(plugin, find.getDimensionInfo(), members, closeCallBack, isShowRange);
    }

    public static void setMemberNum(AbstractFormPlugin plugin, IDataModel dataModel, Long dmModelId, Object returnData) {
        if (returnData == null) {
            return;
        }
        String dimNumber = plugin.getPageCache().get(KEY_MUTILF7SEELCT_DIMNUMBER);
        if (StringUtils.isEmpty((String)dimNumber)) {
            return;
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        MutilF7MemberResult mutilF7MemberResult = modelStrategyEx.getDimensionF7().getMutilF7MemberList(plugin, returnData);
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos(plugin);
        MutilF7DimsionInfo f7DimsionInfo = MutilF7DimsionUtils.findMultiDimInfoByDimNumber(mutilF7DimsionInfos, (String)dimNumber);
        if (f7DimsionInfo == null) {
            return;
        }
        ArrayList<String> memberNames = new ArrayList<String>(mutilF7MemberResult.getMemberInfos().size());
        ArrayList<MutilF7MemberInfo> mutilF7MemberInfos = new ArrayList<MutilF7MemberInfo>(100);
        List memberRanges = modelStrategyEx.getDimMember().getMemberRanges(f7DimsionInfo.getDimensionInfo(), mutilF7MemberResult.getMemberInfos());
        for (DimMemberRange memberRange : memberRanges) {
            String memeberName = modelStrategyEx.getDimMember().getRangeName(memberRange.getSource());
            for (DimMemberInfo memberInfo : memberRange.getMemberInfos()) {
                MutilF7MemberInfo mutilF7MemberInfo = new MutilF7MemberInfo();
                mutilF7MemberInfo.setMember(memberInfo);
                mutilF7MemberInfo.setSouceMemeberId(memberRange.getSource().getId());
                mutilF7MemberInfo.setSouceMemeberName(memeberName);
                mutilF7MemberInfos.add(mutilF7MemberInfo);
            }
            memberNames.add(memeberName);
        }
        f7DimsionInfo.setNotRangeMemberInfos(mutilF7MemberInfos);
        f7DimsionInfo.setMemberInfos(mutilF7MemberResult.getMemberInfos());
        MutipleMemberF7Helper.saveMutilF7DimsionInfos(plugin, mutilF7DimsionInfos);
        dataModel.setValue(f7DimsionInfo.getF7Sgin(), (Object)String.join((CharSequence)MUTIL_SPLIT_CHAR, memberNames));
    }

    public static MutilF7DimsionInfo findMultiDimInfoByF7Sign(AbstractFormPlugin plugin, String f7sign) {
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos(plugin);
        MutilF7DimsionInfo find = mutilF7DimsionInfos.stream().filter(m -> f7sign.equalsIgnoreCase(m.getF7Sgin())).findFirst().orElse(null);
        return find;
    }

    public static List<MutilF7DimsionInfo> getRealMutilF7DimsionInfos(AbstractFormPlugin plugin, IDataModel dataModel, Long dmModelId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos(plugin);
        for (MutilF7DimsionInfo mutilF7DimsionInfo : mutilF7DimsionInfos) {
            DynamicObject memberDy;
            Object memberObject;
            if (mutilF7DimsionInfo.isMutil()) {
                memberObject = dataModel.getValue(mutilF7DimsionInfo.getF7Sgin());
                if (!(memberObject instanceof String)) continue;
                List txtStrs = Arrays.stream(memberObject.toString().split(MUTIL_SPLIT_CHAR)).collect(Collectors.toList());
                ArrayList<DimMemberInfo> sourceMembers = new ArrayList<DimMemberInfo>(mutilF7DimsionInfo.getMemberInfos().size());
                for (DimMemberInfo source : mutilF7DimsionInfo.getMemberInfos()) {
                    if (!TypeUtils.containsIgnore(txtStrs, (String)modelStrategyEx.getDimMember().getRangeName(source))) continue;
                    sourceMembers.add(source);
                }
                ArrayList<MutilF7MemberInfo> mutilF7MemberInfos = new ArrayList<MutilF7MemberInfo>(mutilF7DimsionInfo.getNotRangeMemberInfos().size());
                for (DimMemberInfo source : sourceMembers) {
                    for (MutilF7MemberInfo mem : mutilF7DimsionInfo.getNotRangeMemberInfos()) {
                        if (!mem.getSouceMemeberId().equals(source.getId())) continue;
                        mutilF7MemberInfos.add(mem);
                    }
                }
                mutilF7DimsionInfo.setNotRangeMemberInfos(mutilF7MemberInfos);
                mutilF7DimsionInfo.setMemberInfos(sourceMembers);
                continue;
            }
            memberObject = dataModel.getValue(mutilF7DimsionInfo.getF7Sgin());
            if (!(memberObject instanceof DynamicObject) || (memberDy = (DynamicObject)memberObject) == null) continue;
            DimMemberInfo memberInfo = new DimMemberInfo();
            memberInfo.setId(Long.valueOf(memberDy.getLong("id")));
            memberInfo.setNumber(memberDy.getString("number"));
            memberInfo.setName(memberDy.getString("name"));
            MutilF7MemberInfo mutilF7MemberInfo = new MutilF7MemberInfo();
            mutilF7MemberInfo.setMember(memberInfo);
            mutilF7MemberInfo.setSouceMemeberId(memberInfo.getId());
            mutilF7MemberInfo.setSouceMemeberName(memberInfo.getName());
            mutilF7DimsionInfo.setNotRangeMemberInfos(Collections.singletonList(mutilF7MemberInfo));
            mutilF7DimsionInfo.setMemberInfos(Collections.singletonList(memberInfo));
        }
        return mutilF7DimsionInfos;
    }

    public static void resetEmpty(AbstractFormPlugin plugin, IDataModel dataModel) {
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos(plugin);
        for (MutilF7DimsionInfo mutilF7DimsionInfo : mutilF7DimsionInfos) {
            if (dataModel.getValue(mutilF7DimsionInfo.getF7Sgin()) != null) {
                dataModel.setValue(mutilF7DimsionInfo.getF7Sgin(), null);
            }
            mutilF7DimsionInfo.setNotRangeMemberInfos(new ArrayList(10));
            mutilF7DimsionInfo.setMemberInfos(new ArrayList(10));
        }
        MutipleMemberF7Helper.saveMutilF7DimsionInfos(plugin, mutilF7DimsionInfos);
    }

    public static void clearMultiDimInfoByF7Sign(AbstractFormPlugin plugin, String f7sign) {
        List<MutilF7DimsionInfo> mutilF7DimsionInfos = MutipleMemberF7Helper.getMutilF7DimsionInfos(plugin);
        MutilF7DimsionInfo find = mutilF7DimsionInfos.stream().filter(m -> f7sign.equalsIgnoreCase(m.getF7Sgin())).findFirst().orElse(null);
        if (find != null && find.isMutil()) {
            find.setMemberInfos(new ArrayList(2));
            find.setNotRangeMemberInfos(new ArrayList(2));
            MutipleMemberF7Helper.saveMutilF7DimsionInfos(plugin, mutilF7DimsionInfos);
        }
    }

    public static enum PageEnum {
        General(0),
        ReportList(1);

        public int type = 0;

        private PageEnum(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

