/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.formplugin.common.f7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.f7.dto.FIDMF7MutipleInput;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.common.common.enums.RangeEnum;
import kd.epm.far.common.common.util.BCMTreeUtils;
import kd.epm.far.formplugin.common.base.plugin.AbstractBaseDMFormPlugin;
import kd.epm.far.formplugin.common.util.FormUtils;

public class MutipleMemberF7Plugin
extends AbstractBaseDMFormPlugin {
    private static final String CTL_DIMENSIONCOMBO = "dimensioncombo";
    private static final String CTL_MEMBER_TREEAP = "membertreeap";
    private static final String BTNOK = "btnok";
    private static final String CTL_ADDONEB = "addoneb";
    private static final String CTL_ADDALLB = "addallb";
    private static final String CTL_DELONEB = "deloneb";
    private static final String CTL_DELALLB = "delallb";
    protected static final String entryentity = "entryentity";
    protected static final String mnum = "mnum";
    protected static final String mname = "mname";
    protected static final String mid = "mid";
    protected static final String filltypevalue = "filltypevalue";
    protected static final String pid = "pid";
    private String selectFields = "id,id as memberid,name,number,dseq,parent,aggoprt,storageType,modifier.name as modifier,modifyTime,isleaf,level,copyfrom,longnumber,createtime,creator.name as creator ,description,model,dimension ";
    private String KEY_MEMBERLIST = "KEY_MEMBERLIST";

    private FIDMF7MutipleInput getFormInputParam() {
        FIDMF7MutipleInput input = (FIDMF7MutipleInput)DisclosureFormHelper.getFormInputParam((IFormView)this.getView(), FIDMF7MutipleInput.class, (Boolean)true);
        return input;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTNOK, CTL_ADDALLB, CTL_ADDONEB, CTL_DELALLB, CTL_DELONEB);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FIDMF7MutipleInput input = this.getFormInputParam();
        this.setDimensionCombo(input);
        this.buildDimEntryTree(input);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        TreeView tree = (TreeView)this.getControl(CTL_MEMBER_TREEAP);
        switch (key) {
            case "btnok": {
                this.exitAndReturn();
                break;
            }
            case "addoneb": {
                List ids = tree.getTreeState().getSelectedNodeId();
                if (ids == null || ids.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6210\u5458\u3002", (String)"MutipleMemberF7Plugin_1", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.move2right(ids);
                break;
            }
            case "addallb": {
                this.move2right(null);
                break;
            }
            case "deloneb": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                int[] rows = eg.getEntryState().getSelectedRows();
                if (rows.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"MutipleMemberF7Plugin_2", (String)"epm-far-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getModel().deleteEntryRows(entryentity, rows);
                break;
            }
            case "delallb": {
                this.getModel().deleteEntryData(entryentity);
            }
        }
    }

    private QFilter getOwnerFilters(FIDMF7MutipleInput input) {
        QFilter dimFilter = new QFilter("model", "=", (Object)input.getModelId());
        dimFilter.and("dimension", "=", (Object)input.getDimId());
        dimFilter.and("status", "!=", (Object)"A");
        return dimFilter;
    }

    private void setDimensionCombo(FIDMF7MutipleInput input) {
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl(CTL_DIMENSIONCOMBO);
        List<String[]> dimensionlist = this.getDimensionComData(input.getModelId());
        FormUtils.customDynamicEnum(dimensionlist, dimensioncombo);
        this.getModel().setValue(CTL_DIMENSIONCOMBO, (Object)input.getDseq());
    }

    private List<String[]> getDimensionComData(Long modelId) {
        List allDims = new ModelStrategyEx(modelId).getDim().getDimList();
        ArrayList<String[]> listDimension = new ArrayList<String[]>();
        if (allDims != null && allDims.size() > 0) {
            for (DimensionInfo task : allDims) {
                String[] dimensionMap = new String[4];
                dimensionMap[0] = task.getName();
                dimensionMap[1] = String.valueOf(task.getDseq());
                dimensionMap[2] = task.getEntityName();
                listDimension.add(dimensionMap);
            }
        }
        return listDimension;
    }

    private void buildDimEntryTree(FIDMF7MutipleInput input) {
        QFilter dimFilter = this.getOwnerFilters(input);
        DynamicObjectCollection members = this.getMember(input.getEntityName(), dimFilter.toArray(), this.selectFields);
        TreeView tree = (TreeView)this.getControl(CTL_MEMBER_TREEAP);
        tree.deleteAllNodes();
        List<Map<String, String>> memberList = this.getMemberList(members);
        this.setMemberListCache(memberList);
        TreeNode rootNode = new TreeNode();
        rootNode.setId("0");
        rootNode.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"MutipleMemberF7Plugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        String headId = memberList.isEmpty() ? "0" : memberList.get(0).get("parentid");
        BCMTreeUtils.setEntryNode((TreeNode)rootNode, memberList, (String)headId);
        if (rootNode == null) {
            rootNode = new TreeNode();
            rootNode.setId("0");
            rootNode.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"MutipleMemberF7Plugin_0", (String)"epm-far-formplugin", (Object[])new Object[0]));
        }
        tree.addNode(rootNode);
        BCMTreeUtils.spreadAllNode((TreeNode)rootNode);
    }

    protected List<Map<String, String>> getMemberList(DynamicObjectCollection members) {
        ArrayList<Map<String, String>> memberList = new ArrayList<Map<String, String>>(members.size());
        if (members != null && !members.isEmpty()) {
            for (DynamicObject doc : members) {
                HashMap<String, String> memberMap = new HashMap<String, String>(10);
                memberMap.put("id", doc.getString("id"));
                memberMap.put("number", doc.getString("number"));
                memberMap.put("realname", doc.getString("name"));
                memberMap.put("name", doc.getString("number") + "\n\n" + doc.getString("name"));
                memberMap.put("parentid", StringUtils.isEmpty((String)doc.getString("parent.id")) ? "0" : doc.getString("parent.id"));
                memberMap.put("storagetype", doc.getString("storagetype"));
                memberMap.put("level", doc.getString("level"));
                memberMap.put("dseq", doc.getString("dseq"));
                memberList.add(memberMap);
            }
        }
        return memberList;
    }

    private List getMemberListCache() {
        List memberList = new ArrayList(100);
        if (this.getPageCache().get(this.KEY_MEMBERLIST) == null) {
            return memberList;
        }
        memberList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(this.KEY_MEMBERLIST), List.class);
        return memberList;
    }

    private void setMemberListCache(List<Map<String, String>> memberList) {
        this.getPageCache().put(this.KEY_MEMBERLIST, SerializationUtils.toJsonString(memberList));
    }

    private DynamicObjectCollection getMember(String menberentityid, QFilter[] filters, String selectMemberFields) {
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)menberentityid, (String)selectMemberFields, (QFilter[])filters, (String)"level,dseq");
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        dynamicObjects.addAll(Arrays.asList(dys));
        return dynamicObjects;
    }

    protected void move2right(List<String> memberIds) {
        IDataModel model = this.getModel();
        List memberlist = this.getMemberListCache();
        if (memberIds != null && memberIds.size() > 0) {
            memberlist = memberlist.stream().filter(m -> memberIds.contains(m.get("id"))).collect(Collectors.toList());
        }
        if (memberlist.size() == 0) {
            return;
        }
        ArrayList<Map> newMembers = new ArrayList<Map>(100);
        DynamicObjectCollection hasSelectdoc = model.getEntryEntity(entryentity);
        for (Map member : memberlist) {
            boolean isExist = false;
            for (DynamicObject dt : hasSelectdoc) {
                if (!((String)member.get("id")).equals(dt.getString(mid))) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            newMembers.add(member);
        }
        if (newMembers.size() == 0) {
            return;
        }
        int index = 0;
        int size = 0;
        int[] rows = model.batchCreateNewEntryRow(entryentity, newMembers.size());
        for (Map mem : newMembers) {
            String realName = (String)mem.get("realname");
            model.setValue(mid, mem.get("id"), rows[index]);
            model.setValue(mnum, mem.get("number"), rows[index]);
            model.setValue(mname, (Object)realName, rows[index]);
            model.setValue(pid, mem.get("parentid"), rows[index]);
            model.setValue(filltypevalue, (Object)RangeEnum.VALUE_10.getValue(), rows[index++]);
        }
        for (int i = 1; i <= size; ++i) {
            model.deleteEntryRow(entryentity, rows[rows.length - i]);
        }
    }

    protected void exitAndReturn() {
        DynamicObjectCollection selectedRow = this.getModel().getEntryEntity(entryentity);
        if (selectedRow == null) {
            this.getView().close();
            return;
        }
        this.getView().setReturnData((Object)selectedRow);
        this.getView().returnDataToParent((Object)selectedRow);
        this.getView().close();
    }
}

